/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.FailedFileInfo;
import com.pg.domain.FileInfo;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MemoryStore;
import com.pg.service.UtilService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.SchedulerException;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.CollectionUtils;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class FailedFilesRetryJob
extends QuartzJobBean
implements Job {
    private static Logger logger = LogManager.getLogger(FailedFilesRetryJob.class);
    private UtilService utilService;

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"failedFilesRetryJobTrigger")) {
            logger.debug("FailedFilesRetryJob ........ disabled");
            return;
        }
        try {
            List jobs = arg0.getScheduler().getCurrentlyExecutingJobs();
            if (jobs != null && !jobs.isEmpty()) {
                for (JobExecutionContext job : jobs) {
                    if (!job.getTrigger().equals((Object)arg0.getTrigger()) || job.getJobInstance().equals((Object)this)) continue;
                    logger.debug("There's another instance running,SO skipping>>>>>>>>>>>>> : " + (Object)((Object)this));
                    return;
                }
            }
        }
        catch (SchedulerException e) {
            logger.debug("" + (Object)((Object)e));
            logger.error("" + e.getCause());
        }
        logger.debug("@@@@FailedFilesRetryJob  started ........................................... ");
        int cloudId = 1;
        Cloud cloud = this.utilService.getCloud(1);
        ArrayList<String> unMappedUsers = new ArrayList<String>();
        List values = MemoryStore.keys();
        for (Object obj : values) {
            String userName = obj.toString();
            if (!userName.startsWith("404_")) continue;
            unMappedUsers.add(userName);
        }
        try {
            block6: while (true) {
                List<FailedFileInfo> list;
                if (!CollectionUtils.isEmpty(list = this.getFailedFiles(cloudId, unMappedUsers))) {
                    Iterator<FailedFileInfo> iterator = list.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block6;
                        FailedFileInfo failedFileInfo = iterator.next();
                        logger.debug(" moving files back to backup job....");
                        FileInfo fileInfo = new FileInfo();
                        BeanUtils.copyProperties((Object)failedFileInfo, (Object)fileInfo);
                        fileInfo.setId(failedFileInfo.getId().toString());
                        if (!this.utilService.restoreQueue(fileInfo, cloud)) continue;
                        this.utilService.deleteFailedFile(cloudId, fileInfo.getId());
                    }
                }
                Thread.sleep(1800000L);
            }
        }
        catch (Exception e) {
            logger.debug("Exception ........" + e.getMessage());
            logger.debug("Exception ........" + e);
            logger.debug("@@@@FailedFilesRetryJob  completed .with executorFileThreadutil policy..................... ");
            return;
        }
    }

    private List<FailedFileInfo> getFailedFiles(int cloudId, List<String> unMappedUsers) {
        List<Object> list = new ArrayList<FailedFileInfo>();
        List users = this.utilService.getUnMappedUsersForOneDrive(cloudId);
        for (String user : users) {
            logger.debug(" check if the user is mapped ..... " + user);
            if (MemoryStore.get((String)("404_" + user)) != null || CollectionUtils.isEmpty(list = this.utilService.getFailedFiles(cloudId, user))) continue;
            return list;
        }
        return list;
    }
}

