/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.pcbd.domain.Cloud;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.UploadService;
import com.pg.service.UtilService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class AzureBlobCheckJob
extends QuartzJobBean
implements Job {
    private static Logger logger = LogManager.getLogger(AzureBlobCheckJob.class);
    private UploadService uploadService;
    private UtilService utilService;

    public void setUploadService(UploadService uploadService) {
        this.uploadService = uploadService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"azureBlobCheckJobTrigger")) {
            logger.debug("AzureBlobCheckJob ............. disabled");
            return;
        }
        logger.debug("@@@@AzureBlobCheckJob started ..... ");
        try {
            Cloud cloud = this.utilService.getCloud(1);
            this.uploadService.checkAzureBlobConnection(cloud);
            logger.debug(" AzureBlobCheckJob completed..........");
        }
        catch (Exception e) {
            logger.error(" exception in AzureBlobCheckJob......." + e.getMessage());
        }
    }
}

