/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.backup.service.BackupService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.DevicePolicyDetailsElement;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.element.ReportSchedulerElement;
import com.parablu.paracloud.element.UserElement;
import com.parablu.pc.timer.helper.SchedulerResponseHandler;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.ReportQueryElement;
import com.parablu.pcbd.domain.User;
import com.parablu.report.service.ReportService;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class sendIncompleteBackupHistoryReportTimer
extends QuartzJobBean {
    private static Logger logger = LogManager.getLogger(sendIncompleteBackupHistoryReportTimer.class);
    private LicenseService licenseService;
    private UserManagementService userManagementService;
    private CloudMailService cloudMailService;
    private ReportService reportService;
    private BackupService backupService;
    private String noOfDays;
    private int cloudId;
    private String cloudName;
    private String currentDate = LocalDate.now().toString();
    private DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private Date date = new Date();
    private String endDate = this.dateFormat.format(this.date);

    public void setNoOfDays(String noOfDays) {
        this.noOfDays = noOfDays;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setCloudMailService(CloudMailService cloudMailService) {
        this.cloudMailService = cloudMailService;
    }

    public void setBackupService(BackupService backupService) {
        this.backupService = backupService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"sendIncompleteBackupHistoryReportTimer")) {
            logger.debug("sendIncompleteBackupHistoryReportTimer ........... disbled");
            return;
        }
        logger.debug("   start of job sendIncompleteBackupHistoryReportTimer .... ");
        List clouds = this.licenseService.getClouds();
        for (Cloud cloud : clouds) {
            this.cloudId = cloud.getCloudId();
            this.cloudName = cloud.getCloudName();
            ReportQueryElement reportQueryElement = new ReportQueryElement();
            ReportSchedulerElement reportConfigBySchedulerName = null;
            String productType = "BACKUP";
            try {
                String schedulerId = arg0.getJobDetail().getDescription();
                logger.debug("schedulerId.... " + schedulerId);
                reportConfigBySchedulerName = this.reportService.getReportConfigById(this.cloudId, schedulerId);
                if (reportConfigBySchedulerName != null) {
                    BeanUtils.copyProperties((Object)reportQueryElement, (Object)reportConfigBySchedulerName);
                }
                if (StringUtils.isNotEmpty((String)reportQueryElement.getProductType())) {
                    productType = reportQueryElement.getProductType();
                }
                List<User> users = SchedulerResponseHandler.getValidUsers(reportConfigBySchedulerName, reportQueryElement, cloud, this.userManagementService);
                int startDate = 0;
                reportQueryElement.setNoOfDays(7);
                startDate = reportQueryElement.getNoOfDays();
                logger.debug("inside get report....startDate........" + reportQueryElement.getReason());
                logger.debug("inside get report....startDate........" + reportConfigBySchedulerName.getReason());
                Object response = null;
                String reason = reportQueryElement.getReason();
                List list = new ArrayList();
                ArrayList<DevicePolicyDetailsElement> notHeardList = new ArrayList<DevicePolicyDetailsElement>();
                File file = new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/IncompleteBackupHistory.xlsx");
                if (file.exists()) {
                    file.delete();
                }
                if (!StringUtils.isEmpty((String)reason) && reason.equalsIgnoreCase("NotHeardDevices")) {
                    reportQueryElement.setNoOfDays(7);
                    if (this.reportService.generateReportForAgentLastServerConectionInComplete(cloud, reportQueryElement)) {
                        logger.debug("report creation successs....");
                    } else {
                        this.reportService.CreateEmptyFile(file);
                    }
                } else if (!StringUtils.isEmpty((String)reason) && reason.equalsIgnoreCase("UsersWithoutAgent")) {
                    List userList = this.userManagementService.getAllUsersWithoutdevice(this.cloudId, 1, reportQueryElement.getPolicyNames(), true, productType);
                    userList.removeAll(Collections.singleton(null));
                    Collections.sort(userList, new Comparator<UserElement>(){

                        @Override
                        public int compare(UserElement u1, UserElement u2) {
                            if (u1 == null || u2 == null || u1.getUserName() == null || u2.getUserName() == null) {
                                return -1;
                            }
                            return new CompareToBuilder().append((Object)sendIncompleteBackupHistoryReportTimer.getStatus(u1.isActive()), (Object)sendIncompleteBackupHistoryReportTimer.getStatus(u2.isActive())).append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
                        }
                    });
                    for (UserElement ue : userList) {
                        DevicePolicyDetailsElement backupActivityHistoryElement = new DevicePolicyDetailsElement();
                        backupActivityHistoryElement.setUserName(ue.getUserName());
                        backupActivityHistoryElement.setDeviceName("-");
                        notHeardList.add(backupActivityHistoryElement);
                    }
                    if (this.reportService.generateReportForUserWitoutAgentInComplete(cloud, notHeardList, reportQueryElement)) {
                        logger.debug("report creation successs....");
                    } else {
                        this.reportService.CreateEmptyFile(file);
                    }
                } else if (!StringUtils.isEmpty((String)reason)) {
                    list = this.backupService.getAllBackupBatchWthPagination(cloud, this.cloudName, 1, reportQueryElement, false);
                    if (this.reportService.createExcelIncompleteBkpHistory(cloud, list, reportQueryElement)) {
                        logger.debug("report creation successs....");
                    } else {
                        this.reportService.CreateEmptyFile(file);
                    }
                }
                int userCount = users.size();
                int userProccessed = 0;
                boolean deleteAttachment = false;
                for (User user : users) {
                    if (userCount == ++userProccessed) {
                        deleteAttachment = true;
                    }
                    this.sendmail(user, reportConfigBySchedulerName, deleteAttachment);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.debug("ssssssssss" + e);
                logger.error("ssssssssssss" + e.getCause());
                logger.error("ssssssssssss", (Throwable)e);
            }
        }
    }

    private void sendmail(User user, ReportSchedulerElement reportConfigBySchedulerName, boolean deleteAttachment) {
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction("incomplete-backup-history-report");
        EmailRecipent emailRecipent = new EmailRecipent();
        emailRecipent.setUserName(user.getUserName());
        emailRecipent.setEmail(user.getEmailId());
        email.setActionBy(user.getUserName());
        email.setToUser(true);
        email.setStartDate(reportConfigBySchedulerName.getDisplayName());
        logger.debug("........." + email.getStartDate());
        String fileName = "IncompleteBackupHistory.xlsx";
        email.setAttachFileName(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/" + fileName);
        email.setDeleteAttachment(deleteAttachment);
        logger.debug("............");
        emailRecipents.add(emailRecipent);
        if (!emailRecipents.isEmpty()) {
            logger.debug(" @@@ Before sending mail ");
            email.setRecipents(emailRecipents);
            try {
                this.cloudMailService.sendMail(email);
            }
            catch (Exception e) {
                logger.debug("" + e);
                logger.error("Error in Sending Mail");
            }
            logger.error("after sending mail");
        }
    }

    private static String getStatus(boolean val) {
        if (val) {
            return "Active";
        }
        return "Blocked";
    }
}

