/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.mt.service.LdapService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.CollectionUtils;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class UsersSyncFromADTimer
extends QuartzJobBean {
    private Logger logger = LogManager.getLogger(UsersSyncFromADTimer.class);
    private LicenseService licenseService;
    private UserManagementService managementService;
    private LdapService ldapService;

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setManagementService(UserManagementService managementService) {
        this.managementService = managementService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"autoUserSyncFromADTimerTrigger")) {
            this.logger.debug("UsersSyncFromADTimer ............. disabled");
            return;
        }
        this.logger.debug("   start of job UsersSyncFromADTimer .... ");
        List clouds = this.licenseService.getClouds();
        for (Cloud cloud : clouds) {
            boolean isLdapEnabledForCloud = this.isLdapEnabledForCloud(cloud);
            if (isLdapEnabledForCloud) {
                this.managementService.syncExistingUsersAttributes(cloud);
                this.ldapService.autoMigrateUsersFormAD(cloud);
                continue;
            }
            this.logger.debug("Ad is not enabled...");
        }
        this.logger.debug("   end of job UsersSyncFromADTimer .... ");
    }

    private boolean isLdapEnabledForCloud(Cloud cloud) {
        boolean isLdapEnabled = false;
        List list = cloud.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (!"LDAP Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isLdapEnabled = true;
                break;
            }
        }
        return isLdapEnabled;
    }

    public void setLdapService(LdapService ldapService) {
        this.ldapService = ldapService;
    }
}

