/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.google.gson.JsonPrimitive;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.logger.LoggerLevel;
import com.microsoft.graph.models.Drive;
import com.microsoft.graph.models.DriveItem;
import com.microsoft.graph.models.DriveItemCopyParameterSet;
import com.microsoft.graph.models.DriveItemDeltaParameterSet;
import com.microsoft.graph.models.Folder;
import com.microsoft.graph.models.ItemReference;
import com.microsoft.graph.models.ListInfo;
import com.microsoft.graph.models.Site;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.DriveCollectionPage;
import com.microsoft.graph.requests.DriveCollectionRequest;
import com.microsoft.graph.requests.DriveItemCollectionPage;
import com.microsoft.graph.requests.DriveItemCollectionRequest;
import com.microsoft.graph.requests.DriveItemDeltaCollectionPage;
import com.microsoft.graph.requests.DriveItemDeltaCollectionRequest;
import com.microsoft.graph.requests.DriveItemDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.DriveRequestBuilder;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.ListCollectionRequest;
import com.microsoft.graph.requests.SiteCollectionPage;
import com.microsoft.graph.requests.SiteCollectionRequest;
import com.microsoft.graph.requests.SiteCollectionRequestBuilder;
import com.microsoft.graph.requests.UserCollectionPage;
import com.microsoft.graph.requests.UserCollectionRequest;
import com.microsoft.graph.requests.UserRequestBuilder;
import com.parablu.bluvault.udc.service.PciAuthorizationTokensService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.helper.utils.MD5Generator;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.User;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import okhttp3.Request;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.SchedulerException;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class UserOneDriveDataMigrationJob
extends QuartzJobBean
implements Job {
    private static Logger logger = LogManager.getLogger(UserOneDriveDataMigrationJob.class);
    private static List<User> usersWithoutDeviceList = null;
    private Set<String> userUnderProcess = new HashSet<String>();
    private Set<String> usersUnderProcess = new HashSet<String>();
    int noOfUsers = 0;
    AtomicInteger noOfUsersRegistered = new AtomicInteger(0);
    private LicenseService licenseService;
    private UserManagementService userManagementService;
    private PciAuthorizationTokensService pciAuthorizationTokensService;

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setPciAuthorizationTokensService(PciAuthorizationTokensService pciAuthorizationTokensService) {
        this.pciAuthorizationTokensService = pciAuthorizationTokensService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        try {
            List jobs = arg0.getScheduler().getCurrentlyExecutingJobs();
            if (jobs != null && !jobs.isEmpty()) {
                for (JobExecutionContext job : jobs) {
                    if (!job.getTrigger().equals((Object)arg0.getTrigger()) || job.getJobInstance().equals((Object)this)) continue;
                    logger.debug("There's another instance running,SO skipping>>>>>>>>>>>>> : " + (Object)((Object)this));
                    return;
                }
            }
        }
        catch (SchedulerException e) {
            logger.debug("" + (Object)((Object)e));
            logger.error("" + e.getCause());
        }
        List clouds = this.licenseService.getClouds();
        Cloud cloud = clouds.stream().findFirst().orElse(null);
        try {
            boolean muxedEnabled = false;
            if (StringUtils.isNotEmpty((String)PCHelperConstant.getOneDriveBackupType()) && PCHelperConstant.getOneDriveBackupType().equalsIgnoreCase("MUX")) {
                muxedEnabled = true;
            }
            logger.debug("@@@@UserOneDriveDataMigrationJob started ..... " + muxedEnabled);
            if (muxedEnabled) {
                logger.error("...mux is enabled so data migration is not allowed.....");
            }
            ThreadPoolExecutor executor = null;
            long threadSize = 1L;
            logger.debug(" threads val........" + threadSize);
            int threadSizeVal = (int)threadSize;
            executor = (ThreadPoolExecutor)Executors.newCachedThreadPool();
            executor.setMaximumPoolSize(threadSizeVal);
            executor.setKeepAliveTime(10L, TimeUnit.SECONDS);
            ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
            usersWithoutDeviceList = this.userManagementService.getUsersForDataMigration(cloud.getCloudId());
            this.migrateUsers(cloud, executor, pool);
            logger.debug(" exit upload part..........");
        }
        catch (Exception e) {
            logger.error(" exception in UserDriveRegistryJob ......." + e.getMessage());
            logger.trace("exception in UserDriveRegistryJob ......." + e);
        }
        logger.debug("@@@@UserOneDriveDataMigrationJob ended ..... ");
    }

    private void migrateUsers(Cloud cloud, ExecutorService executor, CompletionService<String> pool) {
        Runnable uploadJob = () -> this.migrate(cloud, executor, pool);
        pool.submit(uploadJob, "");
    }

    private void migrate(Cloud cloud, ExecutorService executor, CompletionService<String> pool) {
        User user = this.getUserForMigration(cloud);
        try {
            if (user != null) {
                logger.debug("... start processing user.... " + user.getUserName());
                this.migrateDataForUser(user, cloud);
                logger.debug(user.getUserName() + " %%%%%%% user process completed completed..." + user.getEmailId());
            }
        }
        catch (Exception e) {
            logger.error("exception inside UserOneDriveDataMigrationJob .... " + e.getMessage());
            logger.trace("exception inside UserOneDriveDataMigrationJob ...." + e);
        }
        if (user == null) {
            logger.debug("no users to check for device so wait for 10 minutes and then retry>>>>");
            try {
                Thread.sleep(600000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private synchronized User getUserForMigration(Cloud cloud) {
        if (CollectionUtils.isEmpty(usersWithoutDeviceList) && CollectionUtils.isEmpty(usersWithoutDeviceList = this.userManagementService.getUsersForDataMigration(cloud.getCloudId()))) {
            return null;
        }
        User user = usersWithoutDeviceList.get(0);
        if (user != null) {
            if (this.userUnderProcess.contains(user.getUserName())) {
                usersWithoutDeviceList.remove(user);
                return this.getUserForMigration(cloud);
            }
            usersWithoutDeviceList.remove(user);
            this.userUnderProcess.add(user.getUserName());
        }
        logger.debug("...after list size....." + usersWithoutDeviceList.size());
        return user;
    }

    public void migrateDataForUser(User user, Cloud cloud) {
        try {
            DriveItemCollectionPage iDriveItemCollectionPage;
            DriveItemDeltaCollectionRequestBuilder nextPage;
            String convertedString;
            String userName = user.getUserName();
            GraphServiceClient<Request> graphClient = this.getGraphClient();
            logger.debug("Processing  " + userName);
            String sourceOneDriveId = user.getEmailId();
            if (!StringUtils.isEmpty((String)user.getOdbLoginId())) {
                sourceOneDriveId = user.getOdbLoginId();
            }
            String destOneDriveId = user.getDestOdbLoginId();
            logger.debug("...user source and dest...." + sourceOneDriveId + ";;;;" + destOneDriveId);
            String sourcepdIdd = UserOneDriveDataMigrationJob.getPBDriveId(sourceOneDriveId, graphClient);
            String destpdIdd = UserOneDriveDataMigrationJob.getPBDriveId(destOneDriveId, graphClient);
            if (StringUtils.isEmpty((String)sourcepdIdd)) {
                logger.debug(sourceOneDriveId + ".....source driveid is null..." + sourcepdIdd);
            }
            if (StringUtils.isEmpty((String)destpdIdd)) {
                logger.debug(destOneDriveId + ".....dest driveid is null..." + destpdIdd);
            }
            if (StringUtils.isEmpty((String)sourcepdIdd) || StringUtils.isEmpty((String)destpdIdd)) {
                logger.error("...drive is not available...." + sourcepdIdd + "...." + destpdIdd);
                return;
            }
            HashSet<String> pathsToCreate = new HashSet<String>();
            graphClient.getLogger().setLoggingLevel(LoggerLevel.ERROR);
            String migratedFolderName = MD5Generator.generateMD5OfString((String)user.getEmailId());
            Long l = ByteBuffer.wrap(migratedFolderName.toString().getBytes()).getLong();
            migratedFolderName = convertedString = Long.toString(l, 36);
            logger.debug(migratedFolderName + "......$#$#$ migr-started for user ...." + user.getUserName());
            DriveRequestBuilder drives = graphClient.drives(sourcepdIdd);
            DriveItemDeltaCollectionPage deltaPage = (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)graphClient.drives(sourcepdIdd).root().delta().buildRequest(new Option[0])).get();
            boolean isNextPageExists = false;
            List currentPage = null;
            ArrayList listItems = new ArrayList();
            int i = 0;
            do {
                String deltaToken = "";
                String deltaLink = "";
                currentPage = deltaPage.getCurrentPage();
                listItems.addAll(currentPage);
                logger.debug(listItems.size() + " ...iteratingloop.... ");
                nextPage = (DriveItemDeltaCollectionRequestBuilder)deltaPage.getNextPage();
                if (StringUtils.isEmpty((String)deltaPage.deltaLink())) {
                    deltaLink = nextPage.getRequestUrl().replaceFirst(graphClient.getServiceRoot(), "");
                }
                deltaToken = UserOneDriveDataMigrationJob.getDeltaToken(deltaLink);
                DriveItemDeltaParameterSet paramset = DriveItemDeltaParameterSet.newBuilder().withToken(deltaToken).build();
                deltaPage = (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)drives.root().delta(paramset).buildRequest(new Option[0])).get();
            } while (++i != 2 && currentPage.size() > 0 && nextPage != null && (isNextPageExists = true));
            int childCount = 0;
            String folderPat = "";
            HashSet<String> folderSet = new HashSet<String>();
            ArrayList<DriveItem> fileListItems = new ArrayList<DriveItem>();
            for (DriveItem item2 : listItems) {
                if (item2.name.equalsIgnoreCase("root")) continue;
                if (item2.folder != null) {
                    Folder folder = item2.folder;
                    logger.debug(item2.name + ".....val/..." + folder.childCount);
                    folderPat = item2.name;
                    childCount = folder.childCount;
                    if (folder.childCount == 0) {
                        graphClient.drives(sourcepdIdd).items(item2.id).buildRequest(new Option[0]).delete();
                        continue;
                    }
                    folderSet.add(folderPat);
                    continue;
                }
                String parentPath = StringUtils.substringAfterLast((String)item2.parentReference.path, (String)"root:");
                fileListItems.add(item2);
                pathsToCreate.add(parentPath);
            }
            logger.debug("...list items..." + listItems.size());
            boolean checkAllFilesMoved = false;
            if (listItems.size() == 1 && (iDriveItemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)graphClient.drives(sourcepdIdd).root().children().buildRequest(new Option[0])).get()) != null && iDriveItemCollectionPage.getCurrentPage().size() == 0) {
                logger.debug("... empty...");
                checkAllFilesMoved = true;
            }
            if (checkAllFilesMoved) {
                this.userManagementService.updateMigrationStatusAndFolderName(cloud.getCloudId(), user.getUserName(), migratedFolderName);
                logger.debug("...migrated user data ...");
                return;
            }
            boolean j = false;
            String migratedFolderId = UserOneDriveDataMigrationJob.createOrGetMigrateFolderId(graphClient, destpdIdd, migratedFolderName);
            if (!CollectionUtils.isEmpty(pathsToCreate)) {
                for (String path : pathsToCreate) {
                    String[] arr = path.split("/");
                    String userNameFold = "";
                    String folderPath = "";
                    for (String arrva : arr) {
                        if (StringUtils.isEmpty((String)arrva)) continue;
                        if (StringUtils.isEmpty((String)userNameFold)) {
                            userNameFold = arrva;
                            continue;
                        }
                        folderPath = arrva;
                    }
                    logger.debug(migratedFolderId + "...folderstocreate...." + path);
                    String userFolderId = UserOneDriveDataMigrationJob.createOrGetUserFolderId(graphClient, destpdIdd, migratedFolderName, userNameFold, migratedFolderId);
                    UserOneDriveDataMigrationJob.createOrGetUserPathFolder(graphClient, userFolderId, destpdIdd, migratedFolderName, path, userNameFold, folderPath);
                }
            }
            String migratedFolName = migratedFolderName;
            String migratedFolderIdStr = migratedFolderId;
            String sourceOneDriveIdStr = sourceOneDriveId;
            String folderPatOr = folderPat;
            int childrenCount = childCount;
            ((Stream)fileListItems.stream().parallel()).forEach(item -> this.processItem((DriveItem)item, graphClient, destpdIdd, migratedFolName, migratedFolderIdStr, sourceOneDriveIdStr, destOneDriveId, sourcepdIdd, folderPatOr, childrenCount));
            if (user != null && StringUtils.isNotEmpty((String)user.getUserName())) {
                this.usersUnderProcess.remove(user.getUserName());
            }
            logger.debug("...completed iteration for user...." + user.getUserName());
        }
        catch (GraphServiceException e) {
            if (e.getResponseCode() == 401) {
                logger.debug("inside 401...");
                logger.error(" ... token expired so try after 1 min ... ");
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException graphClient) {
                    // empty catch block
                }
                this.migrateDataForUser(user, cloud);
            }
            if (e.getResponseCode() == 429) {
                logger.debug("....error code  429 retry after 2 mins....." + e.getResponseCode());
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
            this.migrateDataForUser(user, cloud);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.trace("" + e);
            logger.error("Exception inside UserOneDriveDataMigrationJob Processor PooledConnectionFactory !" + e.getMessage());
        }
    }

    private static String getDeltaToken(String url1) {
        url1 = url1.substring(url1.lastIndexOf(61) + 1);
        url1 = url1.replace("'", "");
        url1 = url1.replace(")", "");
        return url1;
    }

    private static void sleep1() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static boolean isPBDrive(String webUrl) {
        boolean pbDrive = false;
        try {
            String docLibraryName = webUrl.substring(webUrl.lastIndexOf("/") + 1);
            if (!StringUtils.isEmpty((String)docLibraryName) && docLibraryName.equalsIgnoreCase("PB")) {
                pbDrive = true;
            }
        }
        catch (Exception e) {
            logger.error(webUrl + "...unable to get drive .... " + e.getMessage());
            pbDrive = false;
        }
        return pbDrive;
    }

    private static String getPBDriveId(String odbLoginId, GraphServiceClient<Request> graphClient) {
        com.microsoft.graph.models.User userFound = UserOneDriveDataMigrationJob.user(odbLoginId, graphClient);
        if (userFound == null) {
            logger.error(".... user not found ..." + odbLoginId);
            return "";
        }
        UserRequestBuilder users = graphClient.users(userFound.id);
        DriveCollectionRequest buildRequests = (DriveCollectionRequest)users.drives().buildRequest(new Option[0]);
        DriveCollectionPage DriveCollectionPages = (DriveCollectionPage)buildRequests.get();
        String sourcepdIdd = "";
        for (Drive drive : DriveCollectionPages.getCurrentPage()) {
            if (!UserOneDriveDataMigrationJob.isPBDrive(drive.webUrl)) continue;
            sourcepdIdd = drive.id;
        }
        if (StringUtils.isEmpty((String)sourcepdIdd)) {
            logger.debug(".....trytocreate pb for email...." + odbLoginId);
            UserOneDriveDataMigrationJob.createDriveInsideList(graphClient, odbLoginId, userFound.id);
            buildRequests = (DriveCollectionRequest)users.drives().buildRequest(new Option[0]);
            DriveCollectionPages = (DriveCollectionPage)buildRequests.get();
            sourcepdIdd = "";
            for (Drive drive : DriveCollectionPages.getCurrentPage()) {
                if (!UserOneDriveDataMigrationJob.isPBDrive(drive.webUrl)) continue;
                sourcepdIdd = drive.id;
            }
        }
        return sourcepdIdd;
    }

    private static void createDriveInsideList(GraphServiceClient<Request> graphClient, String emailId, String userId) {
        SiteCollectionPage siteCollectionPage = (SiteCollectionPage)((SiteCollectionRequest)graphClient.sites().buildRequest(new Option[0])).get();
        String siteId = "";
        List currentPageVal = null;
        SiteCollectionRequestBuilder nextPage = (SiteCollectionRequestBuilder)siteCollectionPage.getNextPage();
        String url = PCHelperConstant.getPersonalSite((String)PCHelperConstant.getMSSharePointUrl(), (String)emailId);
        ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
        requestOptions.add(new QueryOption("$select", (Object)"mySite"));
        com.microsoft.graph.models.User user = graphClient.users(userId).buildRequest(requestOptions).get();
        if (StringUtils.isEmpty((String)user.mySite)) {
            logger.error("...site not available.....");
            return;
        }
        url = user.mySite;
        if (user.mySite.endsWith("/")) {
            int lastIndex = url.lastIndexOf(47);
            url = url.substring(0, lastIndex);
        }
        try {
            do {
                currentPageVal = siteCollectionPage.getCurrentPage();
                for (Site site : siteCollectionPage.getCurrentPage()) {
                    if (StringUtils.isEmpty((String)site.webUrl) || !site.webUrl.equalsIgnoreCase(url)) continue;
                    siteId = site.id;
                    logger.debug(site.webUrl + "..foundsite..." + siteId);
                    break;
                }
                if ((nextPage = (SiteCollectionRequestBuilder)siteCollectionPage.getNextPage()) == null) continue;
                siteCollectionPage = (SiteCollectionPage)((SiteCollectionRequest)nextPage.buildRequest(new Option[0])).get();
            } while (StringUtils.isEmpty((String)siteId) && currentPageVal.size() > 0 && nextPage != null && siteCollectionPage != null && nextPage != null);
            if (StringUtils.isEmpty((String)siteId)) {
                logger.error("...site not available.....");
                return;
            }
            Site site = graphClient.sites(siteId).buildRequest(new Option[0]).get();
            logger.debug("..before creating.." + site.name + "...." + site.webUrl);
            com.microsoft.graph.models.List list = new com.microsoft.graph.models.List();
            list.displayName = "PB";
            list.description = "MY Description";
            ListInfo listInfo = new ListInfo();
            listInfo.template = "documentLibrary";
            list.list = listInfo;
            ((ListCollectionRequest)graphClient.sites(siteId).lists().buildRequest(new Option[0])).post(list);
        }
        catch (GraphServiceException ee) {
            logger.error("....graph exception trying to create PB library...." + ee.getMessage());
        }
        catch (Exception e) {
            logger.error("....exception trying to create PB library...." + e.getMessage());
        }
    }

    private static com.microsoft.graph.models.User user(String odbLoginId, GraphServiceClient<Request> graphClient) {
        com.microsoft.graph.models.User userObj;
        com.microsoft.graph.models.User userFound = null;
        ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
        logger.debug("....getuser from azure...." + odbLoginId);
        requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + odbLoginId + "'")));
        UserCollectionPage iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
        Iterator iterator = iUserCollectionPage.getCurrentPage().iterator();
        if (iterator.hasNext()) {
            userObj = (com.microsoft.graph.models.User)iterator.next();
            logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
            userFound = userObj;
        }
        if (userFound == null) {
            requestOptions = new ArrayList();
            requestOptions.add(new QueryOption("$filter", (Object)("userPrincipalName eq '" + odbLoginId + "'")));
            iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
            iterator = iUserCollectionPage.getCurrentPage().iterator();
            if (iterator.hasNext()) {
                userObj = (com.microsoft.graph.models.User)iterator.next();
                logger.debug(userObj.userPrincipalName + "... vals..." + userObj.displayName);
                userFound = userObj;
            }
        }
        if (userFound == null) {
            for (com.microsoft.graph.models.User user : iUserCollectionPage.getCurrentPage()) {
                if (!odbLoginId.equalsIgnoreCase(user.mail)) continue;
                userFound = user;
                break;
            }
        }
        return userFound;
    }

    public GraphServiceClient<Request> getGraphClient() {
        String authorityHost = "https://login.microsoftonline.com";
        logger.debug(PCHelperConstant.getMSTenantId() + "...helper constant ...." + PCHelperConstant.getMSClientId());
        ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(PCHelperConstant.getMSClientId())).clientSecret(PCHelperConstant.getMSClientSecret()).tenantId(PCHelperConstant.getMSTenantId())).authorityHost(authorityHost)).build();
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("https://graph.microsoft.com/.default");
        TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
        GraphServiceClient graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)tokenCredAuthProvider).buildClient();
        return graphClient;
    }

    private void processItem(DriveItem item, GraphServiceClient<Request> graphClient, String destpdIdd, String migratedFolderName, String migratedFolderId, String sourceOneDriveId, String destOneDriveId, String sourcepdIdd, String folderPat, int childCount) {
        String userPathFoldId;
        String parentPath;
        block9: {
            if (item.name.equalsIgnoreCase("root") || item.folder != null) {
                return;
            }
            parentPath = StringUtils.substringAfterLast((String)item.parentReference.path, (String)"root:");
            if (StringUtils.isEmpty((String)parentPath)) {
                return;
            }
            String[] arr = parentPath.split("/");
            String userNameFold = "";
            String folderPath = "";
            for (String arrva : arr) {
                if (StringUtils.isEmpty((String)arrva)) continue;
                if (StringUtils.isEmpty((String)userNameFold)) {
                    userNameFold = arrva;
                    continue;
                }
                folderPath = arrva;
            }
            DriveItem driveItemParent = null;
            String userFolderId = "";
            userPathFoldId = "";
            try {
                logger.debug("...before getting dest id..." + destpdIdd + "..." + migratedFolderName + "...." + parentPath);
                driveItemParent = (DriveItem)graphClient.customRequest("/drives/" + destpdIdd + "/root:/" + migratedFolderName + parentPath, DriveItem.class).buildRequest(new Option[0]).get();
                userPathFoldId = driveItemParent.id;
                logger.debug("...after getting userPAth folder id ..." + userPathFoldId);
            }
            catch (GraphServiceException e) {
                logger.debug("...failed  getting dest id......" + e.getResponseCode());
                if (e.getResponseCode() == 429) {
                    logger.debug("....error code  429 retry after 2 mins....." + e.getResponseCode());
                    try {
                        Thread.sleep(120000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    this.processItem(driveItemParent, graphClient, destpdIdd, migratedFolderName, migratedFolderId, sourceOneDriveId, destOneDriveId, sourcepdIdd, folderPat, childCount);
                }
                if (e.getResponseCode() != 404) break block9;
                logger.debug("...unable to create folders...." + e.getMessage());
            }
        }
        this.copyAndDeleteItems(graphClient, sourceOneDriveId, destOneDriveId, sourcepdIdd, destpdIdd, item, parentPath, userPathFoldId, folderPat, childCount);
    }

    private static String createOrGetMigrateFolderId(GraphServiceClient<Request> graphClient, String destpdIdd, String migratedFolderName) {
        String migrateFolderId;
        block4: {
            DriveItem migrateParent = null;
            migrateFolderId = "";
            try {
                migrateParent = (DriveItem)graphClient.customRequest("/drives/" + destpdIdd + "/root:/" + migratedFolderName, DriveItem.class).buildRequest(new Option[0]).get();
                migrateFolderId = migrateParent.id;
            }
            catch (GraphServiceException ee) {
                Folder folderval;
                if (ee.getResponseCode() != 404) break block4;
                logger.debug(migratedFolderName + "...migrated folder does not exist so create... " + destpdIdd);
                DriveItem userFolderItem = new DriveItem();
                userFolderItem.name = migratedFolderName;
                userFolderItem.folder = folderval = new Folder();
                userFolderItem.additionalDataManager().put((Object)"@microsoft.graph.conflictBehavior", (Object)new JsonPrimitive("fail"));
                migrateParent = ((DriveItemCollectionRequest)graphClient.drives(destpdIdd).items().buildRequest(new Option[0])).post(userFolderItem);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                migrateParent = (DriveItem)graphClient.customRequest("/drives/" + destpdIdd + "/root:/" + migratedFolderName, DriveItem.class).buildRequest(new Option[0]).get();
                migrateFolderId = migrateParent.id;
            }
        }
        return migrateFolderId;
    }

    private static String createOrGetUserPathFolder(GraphServiceClient<Request> graphClient, String userFolderId, String destpdIdd, String migratedFolderName, String parentPath, String userNameFold, String folderPath) {
        String userPathFoldId;
        block4: {
            DriveItem userPathFoldParent = null;
            userPathFoldId = "";
            try {
                userPathFoldParent = (DriveItem)graphClient.customRequest("/drives/" + destpdIdd + "/root:/" + migratedFolderName + parentPath, DriveItem.class).buildRequest(new Option[0]).get();
                userPathFoldId = userPathFoldParent.id;
            }
            catch (GraphServiceException ee) {
                Folder folderval;
                if (ee.getResponseCode() != 404) break block4;
                logger.debug(migratedFolderName + userNameFold + "...userPathFold does not exist so create... " + folderPath);
                DriveItem userPathItem = new DriveItem();
                userPathItem.name = folderPath;
                userPathItem.folder = folderval = new Folder();
                userPathItem.additionalDataManager().put((Object)"@microsoft.graph.conflictBehavior", (Object)new JsonPrimitive("fail"));
                userPathFoldParent = ((DriveItemCollectionRequest)graphClient.drives(destpdIdd).items(userFolderId).children().buildRequest(new Option[0])).post(userPathItem);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                userPathFoldParent = (DriveItem)graphClient.customRequest("/drives/" + destpdIdd + "/root:/" + migratedFolderName + "/" + userNameFold, DriveItem.class).buildRequest(new Option[0]).get();
                userPathFoldId = userPathFoldParent.id;
            }
        }
        logger.debug(".... user path folder created or got...." + userPathFoldId);
        return userPathFoldId;
    }

    private static String createOrGetUserFolderId(GraphServiceClient<Request> graphClient, String destpdIdd, String migratedFolderName, String userNameFold, String migrateFolderId) {
        String userFolderId;
        block4: {
            DriveItem userNameFoldParent = null;
            userFolderId = "";
            try {
                userNameFoldParent = (DriveItem)graphClient.customRequest("/drives/" + destpdIdd + "/root:/" + migratedFolderName + "/" + userNameFold, DriveItem.class).buildRequest(new Option[0]).get();
                userFolderId = userNameFoldParent.id;
            }
            catch (GraphServiceException ee) {
                Folder folderval;
                if (ee.getResponseCode() != 404) break block4;
                logger.debug(migratedFolderName + "...username folder does not exist so create... " + userNameFold);
                DriveItem userFolderItem = new DriveItem();
                userFolderItem.name = userNameFold;
                userFolderItem.folder = folderval = new Folder();
                userFolderItem.additionalDataManager().put((Object)"@microsoft.graph.conflictBehavior", (Object)new JsonPrimitive("fail"));
                userNameFoldParent = ((DriveItemCollectionRequest)graphClient.drives(destpdIdd).items(migrateFolderId).children().buildRequest(new Option[0])).post(userFolderItem);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                userNameFoldParent = (DriveItem)graphClient.customRequest("/drives/" + destpdIdd + "/root:/" + migratedFolderName + "/" + userNameFold, DriveItem.class).buildRequest(new Option[0]).get();
                userFolderId = userNameFoldParent.id;
            }
        }
        logger.debug(".... user folder created or got...." + userFolderId);
        return userFolderId;
    }

    private void copyAndDeleteItems(GraphServiceClient<Request> graphClient, String sourceOneDriveId, String destOneDriveId, String sourcepdIdd, String destpdIdd, DriveItem item, String parentPath, String userPathFoldId, String folderPat, int childrenCount) {
        try {
            logger.debug(userPathFoldId + "...before start check folder exists ... ");
            DriveItem folderITe = graphClient.drives(destpdIdd).items(userPathFoldId).buildRequest(new Option[0]).get();
            logger.debug(folderITe.name + "......start copy ......" + sourceOneDriveId + "...." + destOneDriveId + "...." + item.name);
            ItemReference parentReference = new ItemReference();
            parentReference.driveId = destpdIdd;
            parentReference.id = userPathFoldId;
            DriveItemCopyParameterSet copyParameterSet = DriveItemCopyParameterSet.newBuilder().withName(item.name).withParentReference(parentReference).build();
            DriveItem post = graphClient.drives(sourcepdIdd).items(item.id).copy(copyParameterSet).buildRequest(new Option[0]).post();
            Thread.sleep(4000L);
            logger.debug(post.id + "... copied..." + parentPath + "..." + item.name);
            graphClient.drives(sourcepdIdd).items(item.id).buildRequest(new Option[0]).delete();
            logger.debug(childrenCount + "... deleted" + folderPat + "..." + item.name);
        }
        catch (GraphServiceException e) {
            logger.debug("...failed5.." + e.getResponseCode());
            if (e.getResponseCode() == 409) {
                logger.error("409...so block deleting...");
            }
            if (e.getResponseCode() == 504) {
                UserOneDriveDataMigrationJob.sleep1();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(".... exception......" + e.getMessage());
        }
    }
}

