/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.models.User;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.MailFolderCollectionRequestBuilder;
import com.microsoft.graph.requests.MailFolderDeltaCollectionPage;
import com.microsoft.graph.requests.MailFolderDeltaCollectionRequest;
import com.microsoft.graph.requests.MailFolderDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.UserCollectionPage;
import com.microsoft.graph.requests.UserCollectionRequest;
import com.microsoft.graph.requests.UserRequestBuilder;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.bluvault.udc.service.PciAuthorizationTokensService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.helper.utils.MD5Generator;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.element.DeviceElement;
import com.parablu.pc.timer.helper.Graph;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import okhttp3.Request;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class UserMailDriveRegistryJob
extends QuartzJobBean
implements Job {
    private static Logger logger = LogManager.getLogger(UserMailDriveRegistryJob.class);
    private LicenseService licenseService;
    private UserManagementService userManagementService;
    @Autowired
    private DeviceManagementService deviceManagementService;
    private PciAuthorizationTokensService pciAuthorizationTokensService;

    public void setPciAuthorizationTokensService(PciAuthorizationTokensService pciAuthorizationTokensService) {
        this.pciAuthorizationTokensService = pciAuthorizationTokensService;
    }

    public void setDeviceManagementService(DeviceManagementService deviceManagementService) {
        this.deviceManagementService = deviceManagementService;
    }

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        try {
            List jobs = arg0.getScheduler().getCurrentlyExecutingJobs();
            if (jobs != null && !jobs.isEmpty()) {
                for (JobExecutionContext job : jobs) {
                    if (!job.getTrigger().equals((Object)arg0.getTrigger()) || job.getJobInstance().equals((Object)this)) continue;
                    logger.debug("There's another instance running,SO skipping>>>>>>>>>>>>> : " + (Object)((Object)this));
                    return;
                }
            }
        }
        catch (SchedulerException e) {
            logger.debug("" + (Object)((Object)e));
            logger.error("" + e.getCause());
        }
        List clouds = this.licenseService.getClouds();
        Cloud cloud = clouds.stream().findFirst().orElse(null);
        boolean isExchangeBackupEnabled = this.isExchangeBackupEnabled(cloud);
        if (isExchangeBackupEnabled) {
            try {
                logger.debug("@@@@UserDriveRegistryJob started ...");
                this.registerDevices(cloud);
                logger.debug(" exit upload part..........");
            }
            catch (Exception e) {
                logger.error(" exception in UserDriveRegistryJob ......." + e.getMessage());
                logger.trace("exception in UserDriveRegistryJob ......." + e);
            }
            logger.debug("@@@@UserDriveRegistryJob started ..... ");
        }
    }

    private boolean isExchangeBackupEnabled(Cloud cl) {
        boolean isExpiredFileDeleteEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"Exchange Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isExpiredFileDeleteEnabled = true;
                break;
            }
        }
        return isExpiredFileDeleteEnabled;
    }

    private void registerDevices(Cloud cloud) {
        List usersWithoutDeviceList = this.userManagementService.getUsersWithoutOutlookDevices(cloud.getCloudId());
        if (!CollectionUtils.isEmpty((Collection)usersWithoutDeviceList)) {
            for (com.parablu.pcbd.domain.User user : usersWithoutDeviceList) {
                try {
                    if (user == null) continue;
                    String emailId = user.getEmailId();
                    String deviceName = emailId + " (Microsoft Exchange)";
                    Device device = this.deviceManagementService.getDeviceByName(cloud.getCloudId(), cloud.getCloudName(), deviceName);
                    if (device == null) {
                        logger.debug("... start processing user.... " + user.getUserName());
                        this.processMessage(user, cloud);
                        logger.debug(user.getUserName() + " %%%%%%% user process completed completed..." + user.getEmailId());
                        continue;
                    }
                    logger.debug("..device already registered for diff user check for same usermail or odbloginid...." + emailId);
                }
                catch (Exception e) {
                    logger.error("exception inside BackupUploadJob .... " + e.getMessage());
                    logger.trace("exception inside BackupUploadJob ...." + e);
                }
            }
        }
        logger.debug("no users to check for device so wait and then retry>>>>");
    }

    public void processMessage(com.parablu.pcbd.domain.User user, Cloud cloud) {
        try {
            String userName = user.getUserName();
            String emailId = user.getEmailId();
            logger.debug("Processing1 " + userName);
            Graph graph = Graph.getInstance();
            GraphServiceClient<Request> graphClient = graph.getGraphClient();
            ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
            requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + emailId + "'")));
            UserCollectionPage iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
            String userId = "";
            for (User userObj : iUserCollectionPage.getCurrentPage()) {
                logger.debug(userObj.userPrincipalName + "... val22s..." + userObj.givenName);
                userId = userObj.id;
            }
            if (StringUtils.isEmpty((String)userId)) {
                logger.error(emailId + "...user with mail not found ...." + userName);
                this.userManagementService.updateMailBoxFailStatus(cloud.getCloudId(), userName, true);
                return;
            }
            try {
                logger.debug(".... befoer registering ...");
                UserRequestBuilder users = graphClient.users(userId);
                MailFolderCollectionRequestBuilder mailFolders = users.mailFolders();
                logger.debug(".... befoer registering1ss ...");
                MailFolderDeltaCollectionPage deltaPage = (MailFolderDeltaCollectionPage)((MailFolderDeltaCollectionRequest)mailFolders.delta().buildRequest(new Option[0])).get();
                String deltaLink = "";
                String deltaToken = "";
                boolean isNextPageExists = false;
                List mailcurrentPage = null;
                ArrayList listFolderItems = new ArrayList();
                int i = 0;
                do {
                    mailcurrentPage = deltaPage.getCurrentPage();
                    listFolderItems.addAll(mailcurrentPage);
                    deltaLink = deltaPage.deltaLink();
                    if (deltaLink == null) {
                        deltaLink = ((MailFolderDeltaCollectionRequestBuilder)deltaPage.getNextPage()).getRequestUrl().replaceFirst(graphClient.getServiceRoot(), "");
                    }
                    deltaToken = UserMailDriveRegistryJob.getDeltaToken(deltaLink);
                    if (deltaPage.getNextPage() == null) break;
                    deltaPage = (MailFolderDeltaCollectionPage)((MailFolderDeltaCollectionRequest)((MailFolderDeltaCollectionRequestBuilder)deltaPage.getNextPage()).buildRequest(new Option[0])).get();
                    ++i;
                } while (mailcurrentPage.size() > 0 && (isNextPageExists = true));
                logger.debug(".... befoer registering12 ...");
                logger.debug(".... befoer registering12 ...");
            }
            catch (GraphServiceException e) {
                logger.debug(".....exception ... " + e.getResponseCode());
                if (e.getResponseCode() == 404 || e.getResponseCode() == 403) {
                    logger.debug("....ssss " + userId);
                    this.userManagementService.updateMailBoxFailStatus(cloud.getCloudId(), userName, true);
                }
                return;
            }
            DeviceElement deviceElement = new DeviceElement();
            String md5 = MD5Generator.generateMD5OfString((String)(user.getEmailId() + userId));
            deviceElement.setDeviceUUID(md5);
            deviceElement.setDeviceName("Microsoft Exchange");
            deviceElement.setUserName(userName);
            boolean isRegistered = this.deviceManagementService.registerOutlookBkpDevice(cloud, deviceElement);
            if (isRegistered) {
                this.userManagementService.updateMailBoxFailStatus(cloud.getCloudId(), userName, false);
                String deviceName = deviceElement.getUserName() + " (" + deviceElement.getDeviceName() + ")";
                this.deviceManagementService.saveStatisticToDatabase(cloud.getCloudId(), cloud.getCloudName(), "Office 365 user " + userName + " registered for Microsoft Exchange", userName, "", deviceName, System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception inside BackupUploadJob Processor PooledConnectionFactory !" + e.getMessage());
        }
    }

    private static String getDeltaToken(String url1) {
        url1 = url1.substring(url1.lastIndexOf(61) + 1);
        url1 = url1.replace("'", "");
        url1 = url1.replace(")", "");
        return url1;
    }
}

