/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.models.Drive;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.UserCollectionPage;
import com.microsoft.graph.requests.UserCollectionRequest;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.bluvault.udc.service.PciAuthorizationTokensService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.helper.utils.MD5Generator;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.DeviceElement;
import com.parablu.pc.timer.helper.Graph;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.MSAppSetting;
import com.parablu.pcbd.domain.O365BlackListUser;
import com.parablu.pcbd.domain.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import okhttp3.Request;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class UserDriveRegistryJob
extends QuartzJobBean
implements Job {
    private static Logger logger = LogManager.getLogger(UserDriveRegistryJob.class);
    private LicenseService licenseService;
    private UserManagementService userManagementService;
    private PciAuthorizationTokensService pciAuthorizationTokensService;
    @Autowired
    private DeviceManagementService deviceManagementService;

    public void setDeviceManagementService(DeviceManagementService deviceManagementService) {
        this.deviceManagementService = deviceManagementService;
    }

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setPciAuthorizationTokensService(PciAuthorizationTokensService pciAuthorizationTokensService) {
        this.pciAuthorizationTokensService = pciAuthorizationTokensService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        try {
            List jobs = arg0.getScheduler().getCurrentlyExecutingJobs();
            if (jobs != null && !jobs.isEmpty()) {
                for (JobExecutionContext job : jobs) {
                    if (!job.getTrigger().equals((Object)arg0.getTrigger()) || job.getJobInstance().equals((Object)this)) continue;
                    logger.debug("There's another instance running,SO skipping>>>>>>>>>>>>> : " + (Object)((Object)this));
                    return;
                }
            }
        }
        catch (SchedulerException e) {
            logger.debug("" + (Object)((Object)e));
            logger.error("" + e.getCause());
        }
        List clouds = this.licenseService.getClouds();
        Cloud cloud = clouds.stream().findFirst().orElse(null);
        boolean isOneDriveForBusinessBackupEnabled = this.isOneDriveForBusinessBackupEnabled(cloud);
        if (isOneDriveForBusinessBackupEnabled) {
            try {
                logger.debug("@@@@UserDriveRegistryJob started ..... ");
                this.registerDevices(cloud);
                logger.debug(" exit upload part..........");
            }
            catch (Exception e) {
                logger.error(" exception in UserDriveRegistryJob ......." + e.getMessage());
                logger.trace("exception in UserDriveRegistryJob ......." + e);
            }
            logger.debug("@@@@UserDriveRegistryJob started ..... ");
        }
    }

    private boolean isOneDriveForBusinessBackupEnabled(Cloud cl) {
        boolean isExpiredFileDeleteEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"OneDrive Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isExpiredFileDeleteEnabled = true;
                break;
            }
        }
        return isExpiredFileDeleteEnabled;
    }

    private void registerDevices(Cloud cloud) {
        List usersWithoutDeviceList = this.userManagementService.getUsersWithoutDevices(cloud.getCloudId());
        if (!CollectionUtils.isEmpty((Collection)usersWithoutDeviceList)) {
            for (User user : usersWithoutDeviceList) {
                try {
                    if (user == null) continue;
                    String emailId = user.getEmailId();
                    String deviceName = emailId + " (Microsoft OneDrive)";
                    Device device = this.deviceManagementService.getDeviceByName(cloud.getCloudId(), cloud.getCloudName(), deviceName);
                    if (device == null) {
                        this.processMessage(user, cloud);
                        logger.debug(user.getUserName() + " %%%%%%% user process completed completed..." + user.getEmailId());
                        continue;
                    }
                    BaseController.printLogs((String)("..device already registered for diff user check for same usermail or odbloginid...." + emailId), (boolean)PCHelperConstant.isBrevityLogging());
                }
                catch (Exception e) {
                    logger.error("exception inside BackupUploadJob .... " + e.getMessage());
                    logger.trace("exception inside BackupUploadJob ...." + e);
                }
            }
        }
    }

    public void processMessage(User user, Cloud cloud) {
        try {
            String userName = user.getUserName();
            BaseController.printLogs((String)("Processing1 " + userName), (boolean)PCHelperConstant.isBrevityLogging());
            Drive drive = this.getDriveForUser(cloud, user);
            if (!StringUtils.isEmpty((String)user.getAadLoginId()) && drive == null) {
                userName = user.getAadLoginId();
                drive = this.getDriveForUser(cloud, user);
            }
            if (drive != null) {
                DeviceElement deviceElement = new DeviceElement();
                String md5 = MD5Generator.generateMD5OfString((String)(user.getEmailId() + drive.id));
                deviceElement.setDeviceUUID(md5);
                deviceElement.setDeviceName("Microsoft OneDrive");
                deviceElement.setUserName(userName);
                boolean isRegistered = this.deviceManagementService.registerOneDriveBkpDevice(cloud, deviceElement);
                if (isRegistered) {
                    String deviceName = deviceElement.getUserName() + " (" + deviceElement.getDeviceName() + ")";
                    this.deviceManagementService.saveStatisticToDatabase(cloud.getCloudId(), cloud.getCloudName(), "Office 365 user " + userName + " registered for OneDrive for Business backup", userName, "", deviceName, System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
                }
            } else {
                logger.error(".......... drive not available for user .... " + userName);
                O365BlackListUser o365BlackListUser = new O365BlackListUser();
                o365BlackListUser.setUserName(userName);
                o365BlackListUser.setResponseCode("404");
                o365BlackListUser.setLocalHost(PCHelperConstant.getPropertyValueComponentName());
                this.deviceManagementService.saveO365BlackListUser(cloud.getCloudId(), o365BlackListUser);
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception inside BackupUploadJob Processor PooledConnectionFactory !" + e.getMessage());
        }
    }

    private Drive getDriveForUser(Cloud cloud, User user) {
        String userName = user.getUserName();
        Drive drive = null;
        try {
            String emailId = user.getEmailId();
            Graph graph = Graph.getInstance();
            GraphServiceClient<Request> graphClient = graph.getGraphClient();
            ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
            requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + emailId + "'")));
            UserCollectionPage iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
            String userId = "";
            for (com.microsoft.graph.models.User userObj : iUserCollectionPage.getCurrentPage()) {
                logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                userId = userObj.id;
            }
            logger.debug(userId + ".. get drive1 for user given name.... " + userName);
            drive = UserDriveRegistryJob.getDrive(graphClient, userId);
            if (drive != null) {
                logger.debug(userName + "....drive id for user ... " + drive.id);
            }
        }
        catch (GraphServiceException e) {
            logger.error(" ... error trying to get token ..." + e.getResponseCode());
            if (e.getResponseCode() == 401) {
                logger.debug("..sleep for 90 sec...");
                try {
                    Thread.sleep(90000L);
                    drive = this.getDriveForUser(cloud, user);
                }
                catch (InterruptedException interruptedException) {}
            } else if (e.getResponseCode() == 404) {
                logger.error("... not able to access resource check right user token is mapped .... " + userName);
            }
        }
        catch (Exception ee) {
            logger.error(".... exception......" + ee.getMessage());
        }
        return drive;
    }

    private static Drive getDrive(GraphServiceClient<Request> graphClient, String userId) {
        Drive drive = graphClient.users(userId).drive().buildRequest(new Option[0]).get();
        return drive;
    }

    private GraphServiceClient<Request> getGraphClient(int cloudId) {
        MSAppSetting msAppSetting = this.pciAuthorizationTokensService.getMSAppSettingsDetails(cloudId);
        if (msAppSetting == null) {
            return null;
        }
        String authorityHost = "https://login.microsoftonline.com";
        ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(msAppSetting.getClientId())).clientSecret(msAppSetting.getClientSecretKey()).tenantId(msAppSetting.getTenantId())).authorityHost(authorityHost)).build();
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("https://graph.microsoft.com/.default");
        TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
        GraphServiceClient graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)tokenCredAuthProvider).buildClient();
        return graphClient;
    }

    protected GraphServiceClient<Request> getGraphClient(String accessToken) {
        Graph graph = Graph.getInstance();
        GraphServiceClient<Request> graphClient = graph.getGraphClient();
        return graphClient;
    }
}

