/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.settings.service.SupportService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.report.service.ReportService;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.CollectionUtils;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class SupportLogsCleanerTimer
extends QuartzJobBean {
    private static Logger logger = LogManager.getLogger(SupportLogsCleanerTimer.class);
    private SupportService supportService;
    private LicenseService licenseService;
    private ReportService reportService;
    public static final String NOOFDAYS = "noOfDays";

    public LicenseService getLicenseService() {
        return this.licenseService;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public ReportService getReportService() {
        return this.reportService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setSupportService(SupportService supportService) {
        this.supportService = supportService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"supportLogsCleaner")) {
            logger.debug("SupportLogsCleanerTimer ............ disabled");
            return;
        }
        String numberOfDays = "30";
        List clouds = this.licenseService.getClouds();
        Cloud cloud = (Cloud)clouds.get(0);
        Map reportConfigProperties = this.reportService.getReportConfig(cloud.getCloudId(), "supportLogsCleaner");
        logger.debug("sreeee" + numberOfDays);
        if (!CollectionUtils.isEmpty((Map)reportConfigProperties)) {
            logger.debug("sreeee" + numberOfDays);
            String numberOfDaysFromDb = reportConfigProperties.get(NOOFDAYS).toString();
            if (StringUtils.isNotEmpty((String)numberOfDaysFromDb)) {
                logger.debug("sreeee" + numberOfDaysFromDb);
                numberOfDays = numberOfDaysFromDb;
            }
        }
        logger.debug("Job started cleaning the old support logs older than : " + numberOfDays);
        if (!StringUtils.isEmpty((String)numberOfDays) || StringUtils.isNumeric((String)numberOfDays)) {
            logger.debug("Job started cleaning the old support logs older than : " + numberOfDays);
            this.supportService.deleteOldSupportLogs(Integer.parseInt(numberOfDays));
        }
    }
}

