/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.element.ReportSchedulerElement;
import com.parablu.pc.timer.helper.SchedulerResponseHandler;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.ReportQueryElement;
import com.parablu.pcbd.domain.User;
import com.parablu.report.service.ReportService;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class SendRestoreHistoryReportTimer
extends QuartzJobBean {
    private static Logger logger = LogManager.getLogger(SendRestoreHistoryReportTimer.class);
    private LicenseService licenseService;
    private UserManagementService userManagementService;
    private CloudMailService cloudMailService;
    private ReportService reportService;
    private String noOfDays;
    private int cloudId;
    private String cloudName;
    private String currentDate = LocalDate.now().toString();
    private DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private static final String YYYY_MM_DD = "MM/dd/yyyy";
    private Date date = new Date();
    private String endDate = this.dateFormat.format(this.date);

    public void setNoOfDays(String noOfDays) {
        this.noOfDays = noOfDays;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setCloudMailService(CloudMailService cloudMailService) {
        this.cloudMailService = cloudMailService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"sendRestoreHistoryReport")) {
            logger.debug("SendRestoreHistoryReportTimer ............. disabled");
            return;
        }
        logger.debug("   start of job SendRestoreHistoryReportTimer .... ");
        List clouds = this.licenseService.getClouds();
        for (Cloud cloud : clouds) {
            this.cloudId = cloud.getCloudId();
            this.cloudName = cloud.getCloudName();
            ReportQueryElement queryElement = new ReportQueryElement();
            ReportSchedulerElement reportConfigBySchedulerName = null;
            try {
                String schedulerId = arg0.getJobDetail().getDescription();
                logger.debug("schedulerId.... " + schedulerId);
                reportConfigBySchedulerName = this.reportService.getReportConfigById(this.cloudId, schedulerId);
                if (reportConfigBySchedulerName != null) {
                    BeanUtils.copyProperties((Object)queryElement, (Object)reportConfigBySchedulerName);
                }
            }
            catch (Exception e) {
                logger.debug("" + e);
                logger.error("" + e.getCause());
            }
            int startDays = 0;
            startDays = reportConfigBySchedulerName.getNoOfDays();
            logger.debug("inside get report....startDate........" + startDays);
            if (startDays != 0) {
                Calendar cal = Calendar.getInstance();
                SimpleDateFormat dateFormat = new SimpleDateFormat(YYYY_MM_DD);
                cal.add(5, -startDays);
                String startDate = dateFormat.format(cal.getTime());
                reportConfigBySchedulerName.setEndDate(this.endDate);
                reportConfigBySchedulerName.setStartDate(startDate);
                queryElement.setStartDate(startDate);
                queryElement.setEndDate(this.endDate);
                logger.debug("inside get report....startDate........" + this.endDate);
                logger.debug("inside get report....startDate........" + startDate);
            }
            List<User> users = SchedulerResponseHandler.getValidUsers(reportConfigBySchedulerName, queryElement, cloud, this.userManagementService);
            boolean createRestoreHistoryElement = this.reportService.createRestoreHistoryElement(cloud, queryElement);
            if (createRestoreHistoryElement) {
                int userCount = users.size();
                int userProccessed = 0;
                boolean deleteAttachment = false;
                for (User user : users) {
                    if (userCount == ++userProccessed) {
                        deleteAttachment = true;
                    }
                    this.sendEmail(user, reportConfigBySchedulerName, deleteAttachment);
                }
                continue;
            }
            logger.debug("..........no data for given dates.............");
        }
    }

    private void sendEmail(User user, ReportSchedulerElement reportConfigBySchedulerName, boolean deleteAttachment) {
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction("restore-history-report");
        EmailRecipent emailRecipent = new EmailRecipent();
        emailRecipent.setUserName(user.getUserName());
        emailRecipent.setEmail(user.getEmailId());
        email.setActionBy(user.getUserName());
        email.setToUser(true);
        String fileName = "RestoreHistory.xlsx";
        if (!StringUtils.isEmpty((String)reportConfigBySchedulerName.getDisplayName())) {
            fileName = "RestoreHistory_From_Scheduler_" + reportConfigBySchedulerName.getDisplayName() + ".xlsx";
        }
        email.setAttachFileName(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/bkpOverview/" + fileName);
        email.setDeleteAttachment(deleteAttachment);
        email.setStartDate(reportConfigBySchedulerName.getDisplayName());
        emailRecipents.add(emailRecipent);
        if (!emailRecipents.isEmpty()) {
            logger.debug(" @@@ Before sending mail ");
            email.setRecipents(emailRecipents);
            try {
                this.cloudMailService.sendMail(email);
            }
            catch (Exception e) {
                logger.debug("" + e);
                logger.error("Error in Sending Mail");
            }
            logger.error("after sending mail");
        }
    }
}

