/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.element.ReportSchedulerElement;
import com.parablu.paracloud.element.productOverviewElement;
import com.parablu.pc.controller.bp.GroupPolicyReportController;
import com.parablu.pc.timer.helper.SchedulerResponseHandler;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.ReportQueryElement;
import com.parablu.pcbd.domain.User;
import com.parablu.report.service.ReportService;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class SendProductOverviewReportTimer
extends QuartzJobBean {
    private static Logger logger = LoggerFactory.getLogger(SendProductOverviewReportTimer.class);
    private LicenseService licenseService;
    private UserManagementService userManagementService;
    private CloudMailService cloudMailService;
    private ReportService reportService;
    private int cloudId;
    private String cloudName;
    private String currentDate = LocalDate.now().toString();
    private static final String YYYY_MM_DD = "MM/dd/yyyy";
    private DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private Date date = new Date();
    private String endDate = this.dateFormat.format(this.date);
    private GroupPolicyReportController groupPolicyReportController;

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setCloudMailService(CloudMailService cloudMailService) {
        this.cloudMailService = cloudMailService;
    }

    public void setGroupPolicyReportController(GroupPolicyReportController groupPolicyReportController) {
        this.groupPolicyReportController = groupPolicyReportController;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"sendProductOverviewReportTimer")) {
            logger.debug("sendProductOverviewReportTimer .............. disabled");
            return;
        }
        logger.debug("   start of job SendBakcupOverviewReportTimer .... ");
        List clouds = this.licenseService.getClouds();
        for (Cloud cloud : clouds) {
            this.cloudId = cloud.getCloudId();
            this.cloudName = cloud.getCloudName();
            ReportQueryElement reportQueryElement = new ReportQueryElement();
            ReportSchedulerElement reportConfigBySchedulerName = null;
            try {
                String schedulerId = arg0.getJobDetail().getDescription();
                logger.debug("schedulerId.... " + schedulerId);
                reportConfigBySchedulerName = this.reportService.getReportConfigById(this.cloudId, schedulerId);
                if (reportConfigBySchedulerName != null) {
                    BeanUtils.copyProperties((Object)reportQueryElement, (Object)reportConfigBySchedulerName);
                }
            }
            catch (Exception e) {
                logger.debug("" + e);
                logger.error("" + e.getCause());
            }
            List<User> users = SchedulerResponseHandler.getValidUsers(reportConfigBySchedulerName, reportQueryElement, cloud, this.userManagementService);
            boolean isODBBackupEnabled = SendProductOverviewReportTimer.isODBBackupEnabled(cloud.getCloudCustomisableDetails());
            boolean isExchangeBackupEnabled = SendProductOverviewReportTimer.isExchangeBackupEnabled(cloud.getCloudCustomisableDetails());
            int startDate = 0;
            startDate = reportQueryElement.getNoOfDays();
            logger.debug("inside get report....startDate........" + startDate);
            if (startDate != 0) {
                Calendar cal = Calendar.getInstance();
                SimpleDateFormat dateFormat = new SimpleDateFormat(YYYY_MM_DD);
                cal.add(5, -startDate);
                String startTime = dateFormat.format(cal.getTime());
                reportQueryElement.setEndDate(this.endDate);
                reportQueryElement.setStartDate(startTime);
                logger.debug("inside get report....startDate........" + this.endDate);
                logger.debug("inside get report....startDate........" + startTime);
            }
            HttpServletResponse response = null;
            productOverviewElement productOverviewElement2 = this.groupPolicyReportController.getProductOverviewElement(reportQueryElement, response, this.cloudName, "", cloud, this.cloudId, cloud.getLicenseKeyFileName(), isODBBackupEnabled, isExchangeBackupEnabled, null);
            this.reportService.createExcelForProductOverview(cloud, reportQueryElement, productOverviewElement2);
            int userCount = users.size();
            int userProccessed = 0;
            boolean deleteAttachment = false;
            for (User user : users) {
                if (userCount == ++userProccessed) {
                    deleteAttachment = true;
                }
                this.sendmail(user, reportConfigBySchedulerName, deleteAttachment);
            }
        }
    }

    private void sendmail(User user, ReportSchedulerElement reportConfigBySchedulerName, boolean deleteAttachment) {
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction("product-overview-report");
        EmailRecipent emailRecipent = new EmailRecipent();
        emailRecipent.setUserName(user.getUserName());
        emailRecipent.setEmail(user.getEmailId());
        email.setActionBy(user.getUserName());
        email.setToUser(true);
        email.setStartDate(reportConfigBySchedulerName.getDisplayName());
        logger.debug("........." + email.getStartDate());
        String fileName = "Product_OverviewStatus.xlsx";
        email.setAttachFileName(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/bkpOverview/" + fileName);
        email.setDeleteAttachment(deleteAttachment);
        logger.debug("............");
        emailRecipents.add(emailRecipent);
        if (!emailRecipents.isEmpty()) {
            logger.debug(" @@@ Before sending mail ");
            email.setRecipents(emailRecipents);
            try {
                this.cloudMailService.sendMail(email);
            }
            catch (Exception e) {
                logger.debug("" + e);
                logger.error("Error in Sending Mail");
            }
            logger.error("after sending mail");
        }
    }

    private static boolean isODBBackupEnabled(List<CloudCustomisableDetails> list) {
        boolean isODBUserLevelAcctEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!"OneDrive Backup Enabled".equals(customisableDetails.getName())) continue;
            isODBUserLevelAcctEnabled = true;
            break;
        }
        return isODBUserLevelAcctEnabled;
    }

    private static boolean isExchangeBackupEnabled(List<CloudCustomisableDetails> list) {
        boolean isExchangeBackupEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!"Exchange Backup Enabled".equals(customisableDetails.getName())) continue;
            isExchangeBackupEnabled = true;
            break;
        }
        return isExchangeBackupEnabled;
    }
}

