/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.element.ReportSchedulerElement;
import com.parablu.pc.timer.helper.SchedulerResponseHandler;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.ReportQueryElement;
import com.parablu.pcbd.domain.User;
import com.parablu.report.service.ReportService;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class SendNoBackupReport
extends QuartzJobBean {
    private static Logger logger = LogManager.getLogger(SendNoBackupReport.class);
    private LicenseService licenseService;
    private UserManagementService userManagementService;
    private CloudMailService cloudMailService;
    private ReportService reportService;
    private int noOfDays;
    int cloudId;
    String cloudName;
    String currentDate = LocalDate.now().toString();

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setCloudMailService(CloudMailService cloudMailService) {
        this.cloudMailService = cloudMailService;
    }

    public void setNoOfDays(int noOfDays) {
        this.noOfDays = noOfDays;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"noBackupReportTrigger")) {
            logger.debug("SendNoBackupReport ........... disabled");
            return;
        }
        logger.debug("   start of job Sending No Backup report .... ");
        List clouds = this.licenseService.getClouds();
        Cloud cloud = (Cloud)clouds.get(0);
        this.cloudId = cloud.getCloudId();
        this.cloudName = cloud.getCloudName();
        ReportQueryElement queryElement = new ReportQueryElement();
        queryElement.setNoOfDays(this.noOfDays);
        ReportSchedulerElement reportConfigBySchedulerName = null;
        try {
            String schedulerId = arg0.getJobDetail().getDescription();
            logger.debug("schedulerId.... " + schedulerId);
            reportConfigBySchedulerName = this.reportService.getReportConfigById(this.cloudId, schedulerId);
            if (reportConfigBySchedulerName != null) {
                BeanUtils.copyProperties((Object)queryElement, (Object)reportConfigBySchedulerName);
            }
        }
        catch (Exception e) {
            logger.debug("" + e);
            logger.error("" + e.getCause());
        }
        List<User> users = SchedulerResponseHandler.getValidUsers(reportConfigBySchedulerName, queryElement, cloud, this.userManagementService);
        this.reportService.createExcelForNoBackup(cloud, this.cloudName, queryElement, null, reportConfigBySchedulerName.isSystemsProtected());
        int userCount = users.size();
        int userProccessed = 0;
        boolean deleteAttachment = false;
        for (User user : users) {
            if (userCount == ++userProccessed) {
                deleteAttachment = true;
            }
            this.sendEmail(user, reportConfigBySchedulerName, deleteAttachment);
        }
    }

    private void sendEmail(User user, ReportSchedulerElement reportConfigBySchedulerName, boolean deleteAttachment) {
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction("no-backup-report");
        EmailRecipent emailRecipent = new EmailRecipent();
        emailRecipent.setUserName(user.getUserName());
        emailRecipent.setEmail(user.getEmailId());
        email.setActionBy(user.getUserName());
        email.setToUser(true);
        String fileName = "SystemNotProtected";
        if (!reportConfigBySchedulerName.isSystemsProtected()) {
            fileName = "UsersWithoutAnySystemsProtected";
        }
        if (!StringUtils.isEmpty((String)reportConfigBySchedulerName.getDisplayName())) {
            fileName = fileName + "_From_Scheduler_" + reportConfigBySchedulerName.getDisplayName();
        }
        fileName = fileName + ".xlsx";
        email.setAttachFileName(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/" + fileName);
        email.setDeleteAttachment(deleteAttachment);
        email.setStartDate(reportConfigBySchedulerName.getDisplayName());
        emailRecipents.add(emailRecipent);
        if (!emailRecipents.isEmpty()) {
            email.setRecipents(emailRecipents);
            try {
                this.cloudMailService.sendMail(email);
            }
            catch (Exception e) {
                logger.debug("" + e);
                logger.error("Error in Sending Mail");
            }
            logger.error("after sending mail");
        }
    }
}

