/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.udc.service.MiniCloudAccessControlService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.element.MiniCloudElement;
import com.parablu.paracloud.element.MiniCloudElementList;
import com.parablu.paracloud.element.ReportSchedulerElement;
import com.parablu.pc.timer.helper.SchedulerResponseHandler;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.MiniCloud;
import com.parablu.pcbd.domain.ReportQueryElement;
import com.parablu.pcbd.domain.User;
import com.parablu.report.service.ReportService;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class SendMinicloudReportTimer
extends QuartzJobBean {
    private static Logger logger = LogManager.getLogger(SendMinicloudReportTimer.class);
    private LicenseService licenseService;
    private AuditHistoryService auditHistoryService;
    private UserManagementService userManagementService;
    private ReportService reportService;
    private CloudMailService cloudMailService;
    private MiniCloudAccessControlService miniCloudAccessControlService;
    private int cloudId;
    private String cloudName;
    private DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private static final String YYYY_MM_DD = "MM/dd/yyyy";
    private Date date = new Date();
    private String endDate = this.dateFormat.format(this.date);
    String startTime;

    public void setAuditHistoryService(AuditHistoryService auditHistoryService) {
        this.auditHistoryService = auditHistoryService;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setMiniCloudAccessControlService(MiniCloudAccessControlService miniCloudAccessControlService) {
        this.miniCloudAccessControlService = miniCloudAccessControlService;
    }

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setCloudMailService(CloudMailService cloudMailService) {
        this.cloudMailService = cloudMailService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"sendMinicloudReportTimer")) {
            logger.debug("sendMinicloudReportTimer ........ disabled");
            return;
        }
        List clouds = this.licenseService.getClouds();
        logger.debug("sendMinicloudReportTimer ........ Enabled");
        Cloud cloud = (Cloud)clouds.get(0);
        this.cloudId = cloud.getCloudId();
        this.cloudName = cloud.getCloudName();
        ReportSchedulerElement reportConfigBySchedulerName = null;
        ReportQueryElement reportQueryElement = new ReportQueryElement();
        try {
            String schedulerId = arg0.getJobDetail().getDescription();
            logger.debug("schedulerId.... " + schedulerId);
            reportConfigBySchedulerName = this.reportService.getReportConfigById(cloud.getCloudId(), schedulerId);
            if (reportConfigBySchedulerName != null) {
                BeanUtils.copyProperties((Object)reportQueryElement, (Object)reportConfigBySchedulerName);
            }
        }
        catch (Exception e) {
            logger.debug("" + e);
            logger.error("" + e.getCause());
        }
        int startDate = 0;
        startDate = reportQueryElement.getNoOfDays();
        logger.debug("inside get report....startDate........" + startDate);
        if (startDate != 0) {
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat dateFormat = new SimpleDateFormat(YYYY_MM_DD);
            cal.add(5, -startDate);
            this.startTime = dateFormat.format(cal.getTime());
            reportQueryElement.setEndDate(this.endDate);
            reportQueryElement.setStartDate(this.startTime);
            logger.debug("inside get report....startDate........" + this.endDate);
            logger.debug("inside get report....startDate........" + this.startTime);
        }
        try {
            HashSet<User> users = new HashSet<User>();
            String mcNameStr = reportQueryElement.getMiniCloudList();
            List<User> validUsers = SchedulerResponseHandler.getValidUsers(reportConfigBySchedulerName, reportQueryElement, cloud, this.userManagementService);
            if (!StringUtils.isEmpty((String)mcNameStr)) {
                String[] mcNamesArr;
                for (String mcNames : mcNamesArr = mcNameStr.split(",")) {
                    users = new HashSet();
                    ArrayList<String> mcList = new ArrayList<String>();
                    String mcname = mcNames.trim();
                    if (StringUtils.isEmpty((String)mcname)) continue;
                    MiniCloud mcElement = this.miniCloudAccessControlService.getMiniCloudByName(this.cloudId, mcname);
                    boolean sendMail = this.isMinicloudNotExpired(mcElement.getMcDisableDate());
                    if (sendMail) {
                        users.addAll(this.miniCloudAccessControlService.getAllUserForMiniCloud(this.cloudId, this.cloudName, mcname));
                        users.addAll(validUsers);
                        if (mcname.startsWith("_mc_")) {
                            mcname = mcname.replaceFirst("_mc_", "");
                        }
                        mcList.add(mcname);
                        logger.debug(mcname + "......before unique..." + users.size());
                        String fileName = this.getAttachmentName(reportConfigBySchedulerName, mcname);
                        this.createAudithistoryAndSendMail(reportConfigBySchedulerName, users, mcList, fileName);
                        continue;
                    }
                    logger.debug("mc disabled................");
                }
            } else {
                MiniCloudElementList mcElementList = this.miniCloudAccessControlService.getAllMiniClouds(this.cloudId, this.cloudName);
                List mcElements = mcElementList.getMiniClouds();
                for (MiniCloudElement mcElement : mcElements) {
                    boolean sendMail = this.isMinicloudNotExpired(mcElement.getMcDisableDate());
                    if (sendMail) {
                        users = new HashSet();
                        String mcname = mcElement.getMiniCloudName();
                        ArrayList<String> mcList = new ArrayList<String>();
                        users.addAll(this.miniCloudAccessControlService.getAllUserForMiniCloud(this.cloudId, this.cloudName, mcElement.getMiniCloudName()));
                        users.addAll(validUsers);
                        if (mcname.startsWith("_mc_")) {
                            mcname = mcname.replaceFirst("_mc_", "");
                        }
                        mcList.add(mcname);
                        logger.debug(mcname + "......before unique..." + users.size());
                        String fileName = this.getAttachmentName(reportConfigBySchedulerName, mcname);
                        this.createAudithistoryAndSendMail(reportConfigBySchedulerName, users, mcList, fileName);
                        continue;
                    }
                    logger.debug("mc disabled................");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("..exception inside ah create excel..." + e.getMessage());
            logger.error("..exception inside ah create excel...", (Throwable)e);
        }
        logger.debug("end of calling createAuditHistoryExcel ...");
    }

    private boolean isMinicloudNotExpired(String mcDisableDate) {
        boolean sendMail = true;
        if (!StringUtils.isEmpty((String)mcDisableDate)) {
            long milliseconds = 0L;
            SimpleDateFormat f = new SimpleDateFormat("dd-MMM-yyyy");
            try {
                Date d = f.parse(mcDisableDate);
                milliseconds = d.getTime();
            }
            catch (ParseException e) {
                logger.trace("parse exception..." + e);
                logger.error(" exception val.." + e.getMessage());
            }
            Date date = new Date(milliseconds);
            DateTime validityPeriod = new DateTime((Object)date);
            DateTime currentDateTime = new DateTime();
            long difference = SendMinicloudReportTimer.removeTime(validityPeriod.toDate()).getTime() - SendMinicloudReportTimer.removeTime(currentDateTime.toDate()).getTime();
            int daysDiff = (int)(difference / 86400000L);
            if (daysDiff < 0) {
                sendMail = false;
            }
        }
        return sendMail;
    }

    public static Date removeTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private String getAttachmentName(ReportSchedulerElement reportConfigBySchedulerName, String mcname) {
        String fileName = "MiniCloud_AuditHistory.xlsx";
        if (!StringUtils.isEmpty((String)reportConfigBySchedulerName.getDisplayName())) {
            fileName = "MC_" + mcname + "_AuditHistory_From_Scheduler_" + reportConfigBySchedulerName.getDisplayName() + ".xlsx";
        }
        return fileName;
    }

    private void createAudithistoryAndSendMail(ReportSchedulerElement reportConfigBySchedulerName, Set<User> users, List<String> mcList, String fileName) {
        boolean createRestoreHistoryElement = this.reportService.createAuditHistoryExcel(this.cloudId, mcList, this.startTime, this.endDate, fileName, true);
        int userCount = users.size();
        int userProccessed = 0;
        boolean deleteAttachment = false;
        if (createRestoreHistoryElement) {
            for (User user : users) {
                if (userCount == ++userProccessed) {
                    deleteAttachment = true;
                }
                this.sendEmail(user, reportConfigBySchedulerName, deleteAttachment, fileName);
            }
        }
    }

    private void sendEmail(User user, ReportSchedulerElement reportConfigBySchedulerName, boolean deleteAttachment, String fileName) {
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction("minicloud-history-report");
        EmailRecipent emailRecipent = new EmailRecipent();
        emailRecipent.setUserName(user.getUserName());
        emailRecipent.setEmail(user.getEmailId());
        email.setActionBy(user.getUserName());
        email.setToUser(true);
        email.setAttachFileName(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/" + fileName);
        email.setDeleteAttachment(deleteAttachment);
        email.setStartDate(reportConfigBySchedulerName.getDisplayName());
        emailRecipents.add(emailRecipent);
        if (!emailRecipents.isEmpty()) {
            logger.debug(" @@@ Before sending mail ");
            email.setRecipents(emailRecipents);
            try {
                this.cloudMailService.sendMail(email);
            }
            catch (Exception e) {
                logger.debug("" + e);
                logger.error("Error in Sending Mail");
            }
            logger.debug("...after sending mail......");
        }
    }
}

