/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.element.ReportSchedulerElement;
import com.parablu.pc.timer.helper.SchedulerResponseHandler;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.ReportQueryElement;
import com.parablu.pcbd.domain.User;
import com.parablu.report.service.ReportService;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class SendFailedBackupHistoryTimer
extends QuartzJobBean {
    private static Logger logger = LogManager.getLogger(SendFailedBackupHistoryTimer.class);
    private LicenseService licenseService;
    private UserManagementService userManagementService;
    private CloudMailService cloudMailService;
    private ReportService reportService;
    private String noOfDays;
    private int cloudId;
    private String cloudName;
    private String currentDate = LocalDate.now().toString();
    private DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private static final String YYYY_MM_DD = "MM/dd/yyyy";
    private Date date = new Date();
    private String endDate = this.dateFormat.format(this.date);

    public void setNoOfDays(String noOfDays) {
        this.noOfDays = noOfDays;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setCloudMailService(CloudMailService cloudMailService) {
        this.cloudMailService = cloudMailService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"sendFailedBackupHistory")) {
            logger.debug("SendFailedBackupHistoryTimer .............. disabled");
            return;
        }
        logger.debug("   start of job SendFailedBackupHistoryTimer .... ");
        List clouds = this.licenseService.getClouds();
        for (Cloud cloud : clouds) {
            this.cloudId = cloud.getCloudId();
            this.cloudName = cloud.getCloudName();
            ReportSchedulerElement reportConfigBySchedulerName = null;
            ReportQueryElement reportQueryElement = new ReportQueryElement();
            try {
                String schedulerId = arg0.getJobDetail().getDescription();
                logger.debug("schedulerId.... " + schedulerId);
                reportConfigBySchedulerName = this.reportService.getReportConfigById(this.cloudId, schedulerId);
                if (reportConfigBySchedulerName != null) {
                    BeanUtils.copyProperties((Object)reportQueryElement, (Object)reportConfigBySchedulerName);
                }
            }
            catch (Exception e) {
                logger.debug("" + e);
                logger.error("" + e.getCause());
            }
            int startDate = 0;
            startDate = reportQueryElement.getNoOfDays();
            logger.debug("inside get report....startDate........" + startDate);
            if (startDate != 0) {
                Calendar cal = Calendar.getInstance();
                SimpleDateFormat dateFormat = new SimpleDateFormat(YYYY_MM_DD);
                cal.add(5, -startDate);
                String startTime = dateFormat.format(cal.getTime());
                reportQueryElement.setEndDate(this.endDate);
                reportQueryElement.setStartDate(startTime);
                logger.debug("inside get report....startDate........" + this.endDate);
                logger.debug("inside get report....startDate........" + startTime);
            }
            List<User> users = SchedulerResponseHandler.getValidUsers(reportConfigBySchedulerName, reportQueryElement, cloud, this.userManagementService);
            this.reportService.createFailedNotificationHistoryElement(cloud, reportQueryElement);
            int userCount = users.size();
            int userProccessed = 0;
            boolean deleteAttachment = false;
            for (User user : users) {
                if (userCount == ++userProccessed) {
                    deleteAttachment = true;
                }
                this.sendEmail(user, reportConfigBySchedulerName, deleteAttachment);
            }
        }
    }

    private void sendEmail(User user, ReportSchedulerElement reportConfigBySchedulerName, boolean deleteAttachment) {
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction("failed-backup-report");
        EmailRecipent emailRecipent = new EmailRecipent();
        emailRecipent.setUserName(user.getUserName());
        emailRecipent.setEmail(user.getEmailId());
        email.setActionBy(user.getUserName());
        email.setAttachFileName(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/bkpOverview/FailedBackupHistory.xlsx");
        email.setStartDate(this.currentDate);
        email.setToUser(true);
        String fileName = "FailedBackupHistory.xlsx";
        if (!StringUtils.isEmpty((String)reportConfigBySchedulerName.getDisplayName())) {
            fileName = "FailedBackupHistory_From_Scheduler_" + reportConfigBySchedulerName.getDisplayName() + ".xlsx";
        }
        email.setAttachFileName(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/bkpOverview/" + fileName);
        email.setDeleteAttachment(deleteAttachment);
        email.setStartDate(reportConfigBySchedulerName.getDisplayName());
        emailRecipents.add(emailRecipent);
        if (!emailRecipents.isEmpty()) {
            logger.debug(" @@@ Before sending mail ");
            email.setRecipents(emailRecipents);
            try {
                this.cloudMailService.sendMail(email);
            }
            catch (Exception e) {
                logger.debug("" + e);
                logger.error("Error in Sending Mail");
            }
            logger.error("after sending mail");
        }
    }
}

