/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.User;
import com.parablu.report.service.ReportService;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.CollectionUtils;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class SendAuditHistoryReportTimer
extends QuartzJobBean {
    private static Logger logger = LogManager.getLogger(SendAuditHistoryReportTimer.class);
    public static final String USERNAME = "username";
    public static final String NOOFDAYS = "noOfDays";
    private LicenseService licenseService;
    private UserManagementService userManagementService;
    private CloudMailService cloudMailService;
    private ReportService reportService;
    private int cloudId;
    private String cloudName;
    private String currentDate = LocalDate.now().toString();
    private DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private Date date = new Date();
    private String endDate = this.dateFormat.format(this.date);

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setCloudMailService(CloudMailService cloudMailService) {
        this.cloudMailService = cloudMailService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"sendAuditHistoryReport")) {
            logger.debug("SendAuditHistoryReportTimer .............. disabled");
            return;
        }
        logger.debug("start of job sendAuditHistoryReportTimer .... ");
        String startDate = "";
        List clouds = this.licenseService.getClouds();
        for (Cloud cloud : clouds) {
            this.cloudId = cloud.getCloudId();
            this.cloudName = cloud.getCloudName();
            try {
                Map reportConfigProperties = this.reportService.getReportConfig(cloud.getCloudId(), "sendAuditHistory");
                if (CollectionUtils.isEmpty((Map)reportConfigProperties)) continue;
                startDate = reportConfigProperties.get(NOOFDAYS).toString();
                if (!StringUtils.isEmpty((String)startDate) || StringUtils.isNumeric((String)startDate)) {
                    logger.debug("cloudName and cloudID" + this.cloudName + " " + this.cloudId);
                    List adminList = this.userManagementService.getAllAdmins(this.cloudId, this.cloudName);
                    String username = reportConfigProperties.get(USERNAME).toString();
                    if (!StringUtils.isEmpty((String)username)) {
                        boolean isExcelWriteSuccess;
                        String strSpaceRemoval = reportConfigProperties.get(USERNAME).toString().replace(" ", "");
                        if (StringUtils.isEmpty((String)strSpaceRemoval)) continue;
                        List<String> userNames = Arrays.asList(strSpaceRemoval.split(","));
                        if (userNames.size() == 1 && "ALL".equalsIgnoreCase(username.trim())) {
                            userNames = new ArrayList<String>();
                            List usersList = this.userManagementService.getAllActiveUsers(this.cloudId);
                            userNames = usersList.parallelStream().map(user -> user.getUserName()).collect(Collectors.toList());
                        }
                        if (isExcelWriteSuccess = this.reportService.createExcelForAuditHistory(this.cloudId, userNames, startDate, this.endDate)) {
                            logger.debug("Excel Write Success ...send mail");
                            this.sendmail(adminList);
                            continue;
                        }
                        logger.debug("Excel Write unSuccess ...Don't send mail");
                        continue;
                    }
                    logger.debug("username not found");
                    continue;
                }
                logger.debug("Number of days not found");
            }
            catch (Exception e) {
                logger.debug("Exception " + e);
                logger.trace("Exception " + e);
                logger.error("EXCEPTION " + e.getMessage());
            }
        }
    }

    private void sendmail(List<User> adminList) {
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        EmailRecipent emailRecipent = new EmailRecipent();
        email.setAction("audit-history-report");
        email.setAttachFileName(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/Audit_OverviewStatus.xlsx");
        email.setStartDate(this.currentDate);
        for (User admin : adminList) {
            if (!admin.isActive()) continue;
            email.setActionBy(admin.getUserName());
            emailRecipent = new EmailRecipent();
            emailRecipent.setUserName(admin.getUserName());
            emailRecipent.setEmail(admin.getEmailId());
            emailRecipents.add(emailRecipent);
        }
        if (!emailRecipents.isEmpty()) {
            logger.debug(" @@@ Before sending mail ");
            email.setRecipents(emailRecipents);
            this.cloudMailService.sendMail(email);
        }
    }
}

