/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.ah.service.PushNotificationService;
import com.parablu.bluvault.backup.service.BackupDataCleanerService;
import com.parablu.bluvault.backup.service.BackupService;
import com.parablu.bluvault.settings.service.SettingsService;
import com.parablu.bluvault.settings.service.SupportService;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.AADManagementService;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.bluvault.udc.service.MiniCloudAccessControlService;
import com.parablu.bluvault.udc.service.PciAuthorizationTokensService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.ReportSchedulerElement;
import com.parablu.pc.controller.bp.GroupPolicyReportController;
import com.parablu.pc.timer.AADTokenExpiryTimer;
import com.parablu.pc.timer.AgentToServerConectionReportTimer;
import com.parablu.pc.timer.AutoBlockSoftBlockedUsersTimer;
import com.parablu.pc.timer.AutoDeleteUserTimer;
import com.parablu.pc.timer.AutoDeviceBlockerTimer;
import com.parablu.pc.timer.BackupBatchCleanTimer;
import com.parablu.pc.timer.CheckLicenceExpiryTimer;
import com.parablu.pc.timer.CloudOverviewNewTimer;
import com.parablu.pc.timer.CloudOverviewTimer;
import com.parablu.pc.timer.CrawlStatusCleanerTimer;
import com.parablu.pc.timer.DeleteBackupFilesByPolicy;
import com.parablu.pc.timer.DeleteSyncOverviewTimer;
import com.parablu.pc.timer.FileShareLinkExpiryTimer;
import com.parablu.pc.timer.FileSharingCleanerTimer;
import com.parablu.pc.timer.LicenseKeyTamperTimer;
import com.parablu.pc.timer.MiniCloudExpiryTimer;
import com.parablu.pc.timer.O365TokenExpiryTimer;
import com.parablu.pc.timer.Office365TokenExpiryTimer;
import com.parablu.pc.timer.SendAuditHistoryReportTimer;
import com.parablu.pc.timer.SendBackupHistoryTimer;
import com.parablu.pc.timer.SendBackupSummeryReport;
import com.parablu.pc.timer.SendBakcupOverviewReportTimer;
import com.parablu.pc.timer.SendFailedBackupHistoryTimer;
import com.parablu.pc.timer.SendMinicloudReportTimer;
import com.parablu.pc.timer.SendNoBackupReport;
import com.parablu.pc.timer.SendProductOverviewReportTimer;
import com.parablu.pc.timer.SendRestoreHistoryReportTimer;
import com.parablu.pc.timer.SendStorageUtilizationReportTimerNew;
import com.parablu.pc.timer.SupportLogsCleanerTimer;
import com.parablu.pc.timer.UnusualAuditHistoryCleanerTimer;
import com.parablu.pc.timer.sendIncompleteBackupHistoryReportTimer;
import com.parablu.psc.service.UserAndDeviceStatisticService;
import com.parablu.report.service.ReportService;
import com.parablu.rf.delegate.CrawlDelegateServiceAsync;
import com.parablu.rf.service.BackupBatchService;
import com.parablu.rf.service.ResourceFunnelDatabaseReadAndWriteService;
import com.parablu.share.service.SharedFileImageService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.springframework.context.annotation.ImportResource;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.CollectionUtils;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
@ImportResource(value={"classpath:/resources/configuration/spring-config/scheduler-context.xml", "classpath:/resources/configuration/spring-config/security-broker-scheduler-context.xml"})
public class SchedulerTimerTriger
extends QuartzJobBean {
    private static Logger logger = LogManager.getLogger(SchedulerTimerTriger.class);
    private LicenseService licenseService;
    private BackupDataCleanerService backupDataCleanerService;
    private BackupBatchService backupBatchService;
    private ReportService reportService;
    private UserManagementService userManagementService;
    private AADManagementService aadManagementService;
    private PushNotificationService pushNotificationService;
    private CloudMailService cloudMailService;
    private PciAuthorizationTokensService pciAuthorizationTokensService;
    private UserAndDeviceStatisticService userAndDeviceStatisticService;
    private SupportService supportService;
    private DeviceManagementService deviceManagementService;
    private GroupPolicyReportController groupPolicyReportController;
    private SharedFileImageService sharedFileImageService;
    private MiniCloudAccessControlService miniCloudAccessControlService;
    private ResourceFunnelDatabaseReadAndWriteService resourceFunnelDatabaseReadAndWriteService;
    private BackupService backupService;
    private CrawlDelegateServiceAsync crawlDelegateServiceAsync;
    private static final String REPORT_SCHEDULER = "report_scheduler";
    private SettingsService settingsService;
    private AuditHistoryService auditHistoryService;

    public void setResourceFunnelDatabaseReadAndWriteService(ResourceFunnelDatabaseReadAndWriteService resourceFunnelDatabaseReadAndWriteService) {
        this.resourceFunnelDatabaseReadAndWriteService = resourceFunnelDatabaseReadAndWriteService;
    }

    public MiniCloudAccessControlService getMiniCloudAccessControlService() {
        return this.miniCloudAccessControlService;
    }

    public void setMiniCloudAccessControlService(MiniCloudAccessControlService miniCloudAccessControlService) {
        this.miniCloudAccessControlService = miniCloudAccessControlService;
    }

    public CrawlDelegateServiceAsync getCrawlDelegateServiceAsync() {
        return this.crawlDelegateServiceAsync;
    }

    public void setCrawlDelegateServiceAsync(CrawlDelegateServiceAsync crawlDelegateServiceAsync) {
        this.crawlDelegateServiceAsync = crawlDelegateServiceAsync;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        try {
            List jobs = arg0.getScheduler().getCurrentlyExecutingJobs();
            if (jobs != null && !jobs.isEmpty()) {
                for (JobExecutionContext job : jobs) {
                    if (!job.getTrigger().equals((Object)arg0.getTrigger()) || job.getJobInstance().equals((Object)this)) continue;
                    logger.debug("There's another instance running,SO skipping>>>>>>>>>>>>> : " + (Object)((Object)this));
                    return;
                }
            }
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            logger.debug("Exception" + (Object)((Object)e));
            logger.error("Exception" + e.getCause());
        }
        Scheduler scheduler = arg0.getScheduler();
        HashMap<String, Class> jobDetails = new HashMap<String, Class>();
        this.loadAllJobClass(jobDetails);
        ArrayList jobNames = new ArrayList();
        jobNames.addAll(jobDetails.keySet());
        HashMap<String, Long> currentlyRunningIds = new HashMap<String, Long>();
        while (true) {
            List allReportConfig = this.reportService.getReportSchedulerNames(1, jobNames);
            ArrayList jobsToStop = new ArrayList();
            if (!CollectionUtils.isEmpty(currentlyRunningIds.keySet())) {
                jobsToStop.addAll(currentlyRunningIds.keySet());
            }
            if (!CollectionUtils.isEmpty((Collection)allReportConfig)) {
                for (Map.Entry jobDetailsEntry : jobDetails.entrySet()) {
                    List reportConfigBySchedulerName = allReportConfig.stream().filter(rep -> rep != null && !StringUtils.isEmpty((String)rep.getSchedulerName()) && rep.getSchedulerName().equalsIgnoreCase((String)jobDetailsEntry.getKey())).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(reportConfigBySchedulerName)) continue;
                    for (ReportSchedulerElement element : reportConfigBySchedulerName) {
                        long modfiedTime;
                        if (!currentlyRunningIds.keySet().contains(element.getId())) {
                            logger.debug("Id not present in currentlyRunningIds so start the job for " + element.getId());
                            this.resheduleJob((Class)jobDetailsEntry.getValue(), element.getCronExprestion(), element.getId(), scheduler);
                            modfiedTime = this.getModifiedTime(element);
                            currentlyRunningIds.put(element.getId(), modfiedTime);
                            continue;
                        }
                        logger.debug("Id is present in currentlyRunningIds so check modified time " + element.getId());
                        modfiedTime = this.getModifiedTime(element);
                        Long modfiedTimeInCurrentlyRunningIds = (Long)currentlyRunningIds.get(element.getId());
                        if (modfiedTime != modfiedTimeInCurrentlyRunningIds) {
                            logger.debug("Modified time is changed so reschedule the job..modfiedTime" + modfiedTime + "..modfiedTimeInCurrentlyRunningIds.." + modfiedTimeInCurrentlyRunningIds);
                            this.deleteJob(element.getId(), scheduler);
                            this.resheduleJob((Class)jobDetailsEntry.getValue(), element.getCronExprestion(), element.getId(), scheduler);
                            currentlyRunningIds.put(element.getId(), modfiedTime);
                            continue;
                        }
                        BaseController.printLogs((String)"modified time is not changed so no change needed...", (boolean)PCHelperConstant.isBrevityLogging());
                    }
                }
            }
            jobsToStop.removeAll(currentlyRunningIds.keySet());
            if (!CollectionUtils.isEmpty(jobsToStop)) {
                logger.debug("...jobsToStop..." + jobsToStop.size());
                for (String id : jobsToStop) {
                    logger.debug(".......deleting....." + id);
                    this.deleteJob(id, scheduler);
                }
            }
            try {
                logger.debug("sleep 15 sec ");
                Thread.currentThread();
                Thread.sleep(TimeUnit.SECONDS.toMillis(15L));
                logger.debug("wake up");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(" exception in BlukryptJobStopHandle......." + e.getMessage());
                logger.trace("exception in BlukryptJobStopHandle......." + e);
                continue;
            }
            break;
        }
    }

    private void loadAllJobClass(Map<String, Class> jobDetails) {
        jobDetails.put("sendStorageUtilizationReportTimer", SendStorageUtilizationReportTimerNew.class);
        jobDetails.put("sendBackupHistoryReportTimer", SendBackupHistoryTimer.class);
        jobDetails.put("sendBackupOverviewReportTimer", SendBakcupOverviewReportTimer.class);
        jobDetails.put("sendFailedBackupHistoryReportTimer", SendFailedBackupHistoryTimer.class);
        jobDetails.put("sendSystemwithoutBkpReportTimer", SendNoBackupReport.class);
        jobDetails.put("sendRestoreHistoryReportTimer", SendRestoreHistoryReportTimer.class);
        jobDetails.put("sendDeviceHeartbeatReportTimer", AgentToServerConectionReportTimer.class);
        jobDetails.put("sendBkpSummeryReportTimer", SendBackupSummeryReport.class);
        jobDetails.put("tokenExpiryTriggeredOn", Office365TokenExpiryTimer.class);
        jobDetails.put("sendCloudOverviewTriggeredOn", CloudOverviewTimer.class);
        jobDetails.put("supportLogsCleanerTriggeredOn", SupportLogsCleanerTimer.class);
        jobDetails.put("sendAuditHistoryReportTriggeredOn", SendAuditHistoryReportTimer.class);
        jobDetails.put("checkLicenceExpiryTriggeredOn", CheckLicenceExpiryTimer.class);
        jobDetails.put("checkLicenceExpiryTriggeredOn", CheckLicenceExpiryTimer.class);
        jobDetails.put("deleteSyncOverviewTriggeredOn", DeleteSyncOverviewTimer.class);
        jobDetails.put("backupBatchCleanerTriggeredOn", BackupBatchCleanTimer.class);
        jobDetails.put("aadTokenExpiryTriggeredOn", AADTokenExpiryTimer.class);
        jobDetails.put("deleteBackupFileByPolicyDataTriggeredOn", DeleteBackupFilesByPolicy.class);
        jobDetails.put("autoBlockDeviceByPolicyDataTriggeredOn", AutoDeviceBlockerTimer.class);
        jobDetails.put("fileShareLinkExpiryTriggeredOn", FileShareLinkExpiryTimer.class);
        jobDetails.put("fileShareCleaningExpiryTriggeredOn", FileSharingCleanerTimer.class);
        jobDetails.put("miniCloudExpiryTriggeredOn", MiniCloudExpiryTimer.class);
        jobDetails.put("licenseKeyTamperTimerTriggeredOn", LicenseKeyTamperTimer.class);
        jobDetails.put("o365tokenExpiryNotificationJob", O365TokenExpiryTimer.class);
        jobDetails.put("autoDeleteUserTimerTriggeredOn", AutoDeleteUserTimer.class);
        jobDetails.put("sendProductOverviewReportTimer", SendProductOverviewReportTimer.class);
        jobDetails.put("sendIncompleteBackupHistoryReportTimer", sendIncompleteBackupHistoryReportTimer.class);
        jobDetails.put("CloudOverviewNewTimer", CloudOverviewNewTimer.class);
        jobDetails.put("AutoBlockSoftBlockedUsersTimer", AutoBlockSoftBlockedUsersTimer.class);
        jobDetails.put("crawlStatusCleanerTriggeredOn", CrawlStatusCleanerTimer.class);
        jobDetails.put("UnusualAuditHistoryCleanerTimer", UnusualAuditHistoryCleanerTimer.class);
        jobDetails.put("sendMinicloudReportTimer", SendMinicloudReportTimer.class);
    }

    private long getModifiedTime(ReportSchedulerElement element) {
        long modfiedTime = 0L;
        if (element.getModifiedTimestamp() != 0L) {
            modfiedTime = element.getModifiedTimestamp();
        } else if (element.getCreatedTimestamp() != 0L) {
            modfiedTime = element.getCreatedTimestamp();
        }
        return modfiedTime;
    }

    private void deleteJob(String Id, Scheduler scheduler) {
        try {
            JobDetail jobDetail = scheduler.getJobDetail(new JobKey(Id));
            if (jobDetail != null) {
                boolean deleteJob = scheduler.deleteJob(new JobKey(Id));
                logger.debug("......deleteJob........" + deleteJob);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug("" + e);
            logger.error("" + e.getCause());
        }
    }

    private void resheduleJob(Class c, String cron, String Id, Scheduler scheduler) {
        try {
            Trigger trigger1 = TriggerBuilder.newTrigger().withIdentity(c.getName(), Id).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).withDescription(Id).build();
            logger.debug("clas......." + c.getName());
            JobDataMap newJobDataMap = new JobDataMap();
            if (c.getName().contains("SendStorageUtilizationReportTimerNew")) {
                newJobDataMap = this.getStorageReportDataMap();
            } else if (c.getName().contains("SendBackupHistoryTimer")) {
                newJobDataMap = this.getBkpHistoryReportDataMap();
            } else if (c.getName().contains("SendBakcupOverviewReportTimer")) {
                newJobDataMap = this.getBakcupOverviewReportTimerDataMap();
            } else if (c.getName().contains("SendFailedBackupHistoryTimer")) {
                newJobDataMap = this.getFailedBackupHistoryReportTimerDataMap();
            } else if (c.getName().contains("SendNoBackupReport")) {
                newJobDataMap = this.getSendNoBackupReportTimerDataMap();
            } else if (c.getName().contains("SendRestoreHistoryReportTimer")) {
                newJobDataMap = this.getRestoreHistoryReportTimerDataMap();
            } else if (c.getName().contains("AgentToServerConectionReportTimer")) {
                newJobDataMap = this.getAgentToServerConectionReportTimerDataMap();
            } else if (c.getName().contains("SendBackupSummeryReport")) {
                newJobDataMap = this.getAgentToServerConectionReportTimerDataMap();
            } else if (c.getName().contains("Office365TokenExpiryTimer")) {
                newJobDataMap = this.getTokenExpiryTriggeredDataMap();
            } else if (c.getName().contains("CloudOverviewTimer")) {
                newJobDataMap = this.getSendCloudOverviewTriggeredDataMap();
            } else if (c.getName().contains("SupportLogsCleanerTimer")) {
                newJobDataMap = this.getSupportLogsCleanerTriggeredOnDataMap();
            } else if (c.getName().contains("SendAuditHistoryReportTimer")) {
                newJobDataMap = this.getSendAuditHistoryReportTriggeredOnDataMap();
            } else if (c.getName().contains("CheckLicenceExpiryTimer")) {
                newJobDataMap = this.getLicenceExpiryTriggeredOnDataMap();
            } else if (c.getName().contains("CheckLicenceExpiryTimer")) {
                newJobDataMap = this.getLicenceExpiryTriggeredOnDataMap();
            } else if (c.getName().contains("deleteSyncOverviewTriggeredOn")) {
                newJobDataMap = this.getDeleteSyncOverviewTriggeredOnDataMap();
            } else if (c.getName().contains("BackupBatchCleanTimer")) {
                newJobDataMap = this.getbackupBatchCleanerTriggeredOnDataMap();
            } else if (c.getName().contains("AADTokenExpiryTimer")) {
                newJobDataMap = this.getAADTokenExpiryTriggeredOnDataMap();
            } else if (c.getName().contains("DeleteBackupFilesByPolicy")) {
                newJobDataMap = this.getDeleteBackupFileByPolicyDataTriggeredOnDataMap();
            } else if (c.getName().contains("FileShareLinkExpiryTimer")) {
                newJobDataMap = this.getFileShareLinkExpiryTriggeredOnDataMap();
            } else if (c.getName().contains("FileSharingCleanerTimer")) {
                newJobDataMap = this.getFileShareCleaningExpiryTriggeredOnDataMap();
            } else if (c.getName().contains("MiniCloudExpiryTimer")) {
                newJobDataMap = this.getMiniCloudExpiryTriggeredOnDataMap();
            } else if (c.getName().contains("AutoDeviceBlockerTimer")) {
                newJobDataMap = this.getAutoBlockDeviceByPolicyDataTriggeredOnDataMap();
            } else if (c.getName().contains("LicenseKeyTamperTimer")) {
                newJobDataMap = this.getLicenseKeyTamperTimerTriggeredOnDataMap();
            } else if (c.getName().contains("O365TokenExpiryTimer")) {
                newJobDataMap = this.getO365TokenExpiryTimerTriggeredOnDataMap();
            } else if (c.getName().contains("AutoDeleteUserTimer")) {
                newJobDataMap = this.getAutoDeleteUserTimerTriggeredOnDataMap();
            } else if (c.getName().contains("SendProductOverviewReportTimer")) {
                newJobDataMap = this.getSendProductOverviewTimerTriggeredOnDataMap();
            } else if (c.getName().contains("sendIncompleteBackupHistoryReportTimer")) {
                newJobDataMap = this.getsendIncompleteBackupHistoryTimerTriggeredOnDataMap();
            } else if (c.getName().contains("CloudOverviewNewTimer")) {
                newJobDataMap = this.getSendCloudOverviewNewTimerTriggeredDataMap();
            } else if (c.getName().contains("AutoBlockSoftBlockedUsersTimer")) {
                newJobDataMap = this.getAutoBlockSoftBlockedUsersTimeredDataMap();
            } else if (c.getName().contains("CrawlStatusCleanerTimer")) {
                newJobDataMap = this.getCrawlStatusCleanerTriggeredOnDataMap();
            } else if (c.getName().contains("UnusualAuditHistoryCleanerTimer")) {
                newJobDataMap = this.getUnusualAuditHistoryCleanerTimeredDataMap();
            } else if (c.getName().contains("SendMinicloudReportTimer")) {
                newJobDataMap = this.getsendMinicloudReportTimeredDataMap();
            }
            JobDetail jobDetail = JobBuilder.newJob((Class)c).withIdentity(Id).withDescription(Id).usingJobData(newJobDataMap).build();
            scheduler.start();
            scheduler.scheduleJob(jobDetail, trigger1);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug("Exception..." + e);
            logger.error("Exception..." + e.getCause());
        }
    }

    private JobDataMap getCrawlStatusCleanerTriggeredOnDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        newJobDataMap.put("crawlDelegateServiceAsync", (Object)this.getCrawlDelegateServiceAsync());
        return newJobDataMap;
    }

    private JobDataMap getStorageReportDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        newJobDataMap.put("cloudMailService", (Object)this.cloudMailService);
        newJobDataMap.put("reportService", (Object)this.reportService);
        newJobDataMap.put("userManagementService", (Object)this.userManagementService);
        return newJobDataMap;
    }

    private JobDataMap getBkpHistoryReportDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        newJobDataMap.put("cloudMailService", (Object)this.cloudMailService);
        newJobDataMap.put("reportService", (Object)this.reportService);
        newJobDataMap.put("userManagementService", (Object)this.userManagementService);
        newJobDataMap.put("noOfDays", 7);
        return newJobDataMap;
    }

    private JobDataMap getFailedBackupHistoryReportTimerDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        newJobDataMap.put("cloudMailService", (Object)this.cloudMailService);
        newJobDataMap.put("reportService", (Object)this.reportService);
        newJobDataMap.put("userManagementService", (Object)this.userManagementService);
        newJobDataMap.put("noOfDays", 7);
        return newJobDataMap;
    }

    private JobDataMap getSendNoBackupReportTimerDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        newJobDataMap.put("cloudMailService", (Object)this.cloudMailService);
        newJobDataMap.put("reportService", (Object)this.reportService);
        newJobDataMap.put("userManagementService", (Object)this.userManagementService);
        newJobDataMap.put("noOfDays", 7);
        return newJobDataMap;
    }

    private JobDataMap getFileShareCleaningExpiryTriggeredOnDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("sharedFileImageService", (Object)this.sharedFileImageService);
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        newJobDataMap.put("miniCloudAccessControlService", (Object)this.miniCloudAccessControlService);
        newJobDataMap.put("resourceFunnelDatabaseReadAndWriteService", (Object)this.resourceFunnelDatabaseReadAndWriteService);
        return newJobDataMap;
    }

    private JobDataMap getRestoreHistoryReportTimerDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        newJobDataMap.put("cloudMailService", (Object)this.cloudMailService);
        newJobDataMap.put("reportService", (Object)this.reportService);
        newJobDataMap.put("userManagementService", (Object)this.userManagementService);
        newJobDataMap.put("noOfDays", 7);
        return newJobDataMap;
    }

    private JobDataMap getAgentToServerConectionReportTimerDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        newJobDataMap.put("cloudMailService", (Object)this.cloudMailService);
        newJobDataMap.put("reportService", (Object)this.reportService);
        newJobDataMap.put("userManagementService", (Object)this.userManagementService);
        newJobDataMap.put("noOfDays", 7);
        return newJobDataMap;
    }

    private JobDataMap getBakcupOverviewReportTimerDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        newJobDataMap.put("cloudMailService", (Object)this.cloudMailService);
        newJobDataMap.put("reportService", (Object)this.reportService);
        newJobDataMap.put("userManagementService", (Object)this.userManagementService);
        newJobDataMap.put("backupService", (Object)this.backupService);
        newJobDataMap.put("userAndDeviceStatisticService", (Object)this.userAndDeviceStatisticService);
        return newJobDataMap;
    }

    private JobDataMap getTokenExpiryTriggeredDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("pushNotificationService", (Object)this.pushNotificationService);
        newJobDataMap.put("userManagementService", (Object)this.userManagementService);
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        newJobDataMap.put("cloudMailService", (Object)this.cloudMailService);
        newJobDataMap.put("pciAuthorizationTokensService", (Object)this.pciAuthorizationTokensService);
        return newJobDataMap;
    }

    private JobDataMap getSendCloudOverviewTriggeredDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("userManagementService", (Object)this.userManagementService);
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        newJobDataMap.put("cloudMailService", (Object)this.cloudMailService);
        newJobDataMap.put("reportService", (Object)this.reportService);
        newJobDataMap.put("userAndDeviceStatisticService", (Object)this.userAndDeviceStatisticService);
        return newJobDataMap;
    }

    private JobDataMap getSendCloudOverviewNewTimerTriggeredDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("userManagementService", (Object)this.userManagementService);
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        newJobDataMap.put("cloudMailService", (Object)this.cloudMailService);
        newJobDataMap.put("reportService", (Object)this.reportService);
        newJobDataMap.put("backupService", (Object)this.backupService);
        newJobDataMap.put("userAndDeviceStatisticService", (Object)this.userAndDeviceStatisticService);
        return newJobDataMap;
    }

    private JobDataMap getAutoBlockSoftBlockedUsersTimeredDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("userManagementService", (Object)this.userManagementService);
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        return newJobDataMap;
    }

    private JobDataMap getUnusualAuditHistoryCleanerTimeredDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("auditHistoryService", (Object)this.auditHistoryService);
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        return newJobDataMap;
    }

    private JobDataMap getsendMinicloudReportTimeredDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("auditHistoryService", (Object)this.auditHistoryService);
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        newJobDataMap.put("reportService", (Object)this.reportService);
        newJobDataMap.put("userManagementService", (Object)this.userManagementService);
        newJobDataMap.put("cloudMailService", (Object)this.cloudMailService);
        newJobDataMap.put("miniCloudAccessControlService", (Object)this.miniCloudAccessControlService);
        return newJobDataMap;
    }

    private JobDataMap getSupportLogsCleanerTriggeredOnDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("supportService", (Object)this.supportService);
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        newJobDataMap.put("reportService", (Object)this.reportService);
        newJobDataMap.put("noOfDays", "7");
        return newJobDataMap;
    }

    private JobDataMap getSendAuditHistoryReportTriggeredOnDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("userManagementService", (Object)this.userManagementService);
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        newJobDataMap.put("cloudMailService", (Object)this.cloudMailService);
        newJobDataMap.put("reportService", (Object)this.reportService);
        return newJobDataMap;
    }

    private JobDataMap getLicenceExpiryTriggeredOnDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("userManagementService", (Object)this.userManagementService);
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        newJobDataMap.put("cloudMailService", (Object)this.cloudMailService);
        newJobDataMap.put("reportService", (Object)this.reportService);
        return newJobDataMap;
    }

    private JobDataMap getDeleteSyncOverviewTriggeredOnDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("userManagementService", (Object)this.userManagementService);
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        return newJobDataMap;
    }

    private JobDataMap getbackupBatchCleanerTriggeredOnDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("deviceManagementService", (Object)this.deviceManagementService);
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        newJobDataMap.put("backupBatchService", (Object)this.backupBatchService);
        newJobDataMap.put("noOfBackupBatchToKeep", 365);
        return newJobDataMap;
    }

    private JobDataMap getAADTokenExpiryTriggeredOnDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("userManagementService", (Object)this.userManagementService);
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        newJobDataMap.put("aadManagementService", (Object)this.aadManagementService);
        newJobDataMap.put("cloudMailService", (Object)this.cloudMailService);
        return newJobDataMap;
    }

    private JobDataMap getFileShareLinkExpiryTriggeredOnDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("sharedFileImageService", (Object)this.sharedFileImageService);
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        newJobDataMap.put("reportService", (Object)this.reportService);
        newJobDataMap.put("cloudMailService", (Object)this.cloudMailService);
        newJobDataMap.put("userManagementService", (Object)this.userManagementService);
        return newJobDataMap;
    }

    private JobDataMap getDeleteBackupFileByPolicyDataTriggeredOnDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        newJobDataMap.put("backupDataCleanerService", (Object)this.backupDataCleanerService);
        return newJobDataMap;
    }

    private JobDataMap getAutoBlockDeviceByPolicyDataTriggeredOnDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        newJobDataMap.put("userManagementService", (Object)this.userManagementService);
        return newJobDataMap;
    }

    private JobDataMap getLicenseKeyTamperTimerTriggeredOnDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        newJobDataMap.put("settingsService", (Object)this.settingsService);
        newJobDataMap.put("auditHistoryService", (Object)this.auditHistoryService);
        return newJobDataMap;
    }

    private JobDataMap getAutoDeleteUserTimerTriggeredOnDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        newJobDataMap.put("userManagementService", (Object)this.userManagementService);
        return newJobDataMap;
    }

    private JobDataMap getsendIncompleteBackupHistoryTimerTriggeredOnDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        newJobDataMap.put("cloudMailService", (Object)this.cloudMailService);
        newJobDataMap.put("reportService", (Object)this.reportService);
        newJobDataMap.put("userManagementService", (Object)this.userManagementService);
        newJobDataMap.put("groupPolicyReportController", (Object)this.groupPolicyReportController);
        newJobDataMap.put("backupService", (Object)this.backupService);
        return newJobDataMap;
    }

    private JobDataMap getSendProductOverviewTimerTriggeredOnDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        newJobDataMap.put("cloudMailService", (Object)this.cloudMailService);
        newJobDataMap.put("reportService", (Object)this.reportService);
        newJobDataMap.put("userManagementService", (Object)this.userManagementService);
        newJobDataMap.put("groupPolicyReportController", (Object)this.groupPolicyReportController);
        return newJobDataMap;
    }

    private JobDataMap getO365TokenExpiryTimerTriggeredOnDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        newJobDataMap.put("pciAuthorizationTokensService", (Object)this.pciAuthorizationTokensService);
        newJobDataMap.put("userManagementService", (Object)this.userManagementService);
        newJobDataMap.put("cloudMailService", (Object)this.cloudMailService);
        newJobDataMap.put("pushNotificationService", (Object)this.pushNotificationService);
        return newJobDataMap;
    }

    private JobDataMap getMiniCloudExpiryTriggeredOnDataMap() {
        JobDataMap newJobDataMap = new JobDataMap();
        newJobDataMap.put("miniCloudAccessControlService", (Object)this.miniCloudAccessControlService);
        newJobDataMap.put("licenseService", (Object)this.licenseService);
        newJobDataMap.put("reportService", (Object)this.reportService);
        newJobDataMap.put("cloudMailService", (Object)this.cloudMailService);
        newJobDataMap.put("userManagementService", (Object)this.userManagementService);
        return newJobDataMap;
    }

    public LicenseService getLicenseService() {
        return this.licenseService;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public ReportService getReportService() {
        return this.reportService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        SchedulerTimerTriger.logger = logger;
    }

    public UserManagementService getUserManagementService() {
        return this.userManagementService;
    }

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public CloudMailService getCloudMailService() {
        return this.cloudMailService;
    }

    public void setCloudMailService(CloudMailService cloudMailService) {
        this.cloudMailService = cloudMailService;
    }

    public static String getReportScheduler() {
        return REPORT_SCHEDULER;
    }

    public PushNotificationService getPushNotificationService() {
        return this.pushNotificationService;
    }

    public void setPushNotificationService(PushNotificationService pushNotificationService) {
        this.pushNotificationService = pushNotificationService;
    }

    public PciAuthorizationTokensService getPciAuthorizationTokensService() {
        return this.pciAuthorizationTokensService;
    }

    public void setPciAuthorizationTokensService(PciAuthorizationTokensService pciAuthorizationTokensService) {
        this.pciAuthorizationTokensService = pciAuthorizationTokensService;
    }

    public UserAndDeviceStatisticService getUserAndDeviceStatisticService() {
        return this.userAndDeviceStatisticService;
    }

    public void setUserAndDeviceStatisticService(UserAndDeviceStatisticService userAndDeviceStatisticService) {
        this.userAndDeviceStatisticService = userAndDeviceStatisticService;
    }

    public SupportService getSupportService() {
        return this.supportService;
    }

    public void setSupportService(SupportService supportService) {
        this.supportService = supportService;
    }

    public BackupBatchService getBackupBatchService() {
        return this.backupBatchService;
    }

    public void setBackupBatchService(BackupBatchService backupBatchService) {
        this.backupBatchService = backupBatchService;
    }

    public BackupDataCleanerService getBackupDataCleanerService() {
        return this.backupDataCleanerService;
    }

    public void setBackupDataCleanerService(BackupDataCleanerService backupDataCleanerService) {
        this.backupDataCleanerService = backupDataCleanerService;
    }

    public AADManagementService getAadManagementService() {
        return this.aadManagementService;
    }

    public void setAadManagementService(AADManagementService aadManagementService) {
        this.aadManagementService = aadManagementService;
    }

    public SettingsService getSettingsService() {
        return this.settingsService;
    }

    public void setSettingsService(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    public AuditHistoryService getAuditHistoryService() {
        return this.auditHistoryService;
    }

    public void setAuditHistoryService(AuditHistoryService auditHistoryService) {
        this.auditHistoryService = auditHistoryService;
    }

    public DeviceManagementService getDeviceManagementService() {
        return this.deviceManagementService;
    }

    public void setDeviceManagementService(DeviceManagementService deviceManagementService) {
        this.deviceManagementService = deviceManagementService;
    }

    public SharedFileImageService getSharedFileImageService() {
        return this.sharedFileImageService;
    }

    public void setSharedFileImageService(SharedFileImageService sharedFileImageService) {
        this.sharedFileImageService = sharedFileImageService;
    }

    public GroupPolicyReportController getGroupPolicyReportController() {
        return this.groupPolicyReportController;
    }

    public void setGroupPolicyReportController(GroupPolicyReportController groupPolicyReportController) {
        this.groupPolicyReportController = groupPolicyReportController;
    }

    public BackupService getBackupService() {
        return this.backupService;
    }

    public void setBackupService(BackupService backupService) {
        this.backupService = backupService;
    }

    public static enum JOB_CLASS {
        sendStorageUtilizationReportTimer,
        sendBackupOverviewReportTimer,
        sendBackupHistoryReportTimer,
        sendFailedBackupHistoryReportTimer,
        sendSystemwithoutBkpReportTimer,
        sendRestoreHistoryReportTimer,
        sendDeviceHeartbeatReportTimer,
        sendBkpSummeryReportTimer,
        tokenExpiryTriggeredOn,
        sendCloudOverviewTriggeredOn,
        supportLogsCleanerTriggeredOn,
        sendAuditHistoryReportTriggeredOn,
        checkLicenceExpiryTriggeredOn,
        deleteSyncOverviewTriggeredOn,
        backupBatchCleanerTriggeredOn,
        licenseKeyTamperTimerTriggeredOn,
        o365tokenExpiryNotificationJob,
        autoDeleteUserTimerTriggeredOn,
        sendProductOverviewReportTimer,
        sendIncompleteBackupHistoryReportTimer,
        CloudOverviewNewTimer,
        AutoBlockSoftBlockedUsersTimer,
        UnusualAuditHistoryCleanerTimer,
        sendMinicloudReportTimer;

    }
}

