/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.microsoft.graph.requests.GraphServiceClient;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.helper.utils.MD5Generator;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.DeviceElement;
import com.parablu.pc.timer.helper.Graph;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.O365BlackListUser;
import com.parablu.pcbd.domain.SharePointProperties;
import com.parablu.pcbd.domain.User;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import okhttp3.Request;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class SPDeviceRegistryJob
extends QuartzJobBean
implements Job {
    private static Logger logger = LogManager.getLogger(SPDeviceRegistryJob.class);
    private LicenseService licenseService;
    private UserManagementService userManagementService;
    @Autowired
    private DeviceManagementService deviceManagementService;

    public void setDeviceManagementService(DeviceManagementService deviceManagementService) {
        this.deviceManagementService = deviceManagementService;
    }

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        logger.debug("@@@@SPDeviceRegistryJob started ..... ");
        try {
            List jobs = arg0.getScheduler().getCurrentlyExecutingJobs();
            if (jobs != null && !jobs.isEmpty()) {
                for (JobExecutionContext job : jobs) {
                    if (!job.getTrigger().equals((Object)arg0.getTrigger()) || job.getJobInstance().equals((Object)this)) continue;
                    logger.debug("There's another instance running,SO skipping>>>>>>>>>>>>> : " + (Object)((Object)this));
                    return;
                }
            }
        }
        catch (SchedulerException e) {
            logger.debug("" + (Object)((Object)e));
            logger.error("" + e.getCause());
        }
        List clouds = this.licenseService.getClouds();
        Cloud cloud = clouds.stream().findFirst().orElse(null);
        boolean isSharePointBackupEnabled = this.isSharePointBackupEnabled(cloud);
        if (isSharePointBackupEnabled) {
            try {
                logger.debug("@@@@SPDeviceRegistryJob started ..... ");
                this.registerDevices(cloud);
                logger.debug(" exit upload part..........");
            }
            catch (Exception e) {
                logger.error(" exception in SPDeviceRegistryJob ......." + e.getMessage());
                logger.trace("exception in SPDeviceRegistryJob ......." + e);
            }
            logger.debug("@@@@SPDeviceRegistryJob ended ..... ");
        }
    }

    private boolean isSharePointBackupEnabled(Cloud cl) {
        boolean isSharePointBackupEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"Sharepoint Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isSharePointBackupEnabled = true;
                break;
            }
        }
        return isSharePointBackupEnabled;
    }

    private void registerDevices(Cloud cloud) {
        List usersWithoutDeviceList = this.userManagementService.getSitesWithoutDevices(cloud.getCloudId());
        SharePointProperties sharePointProperties = this.userManagementService.getSharePointProperties(cloud.getCloudId());
        if (!CollectionUtils.isEmpty((Collection)usersWithoutDeviceList) && sharePointProperties != null) {
            for (User user : usersWithoutDeviceList) {
                try {
                    if (user == null) continue;
                    String userName = user.getUserName();
                    logger.debug("...policy and user..." + user.getUserName() + "...." + sharePointProperties.getDefaultSPPolicyName());
                    user.setSpPolicyName(sharePointProperties.getDefaultSPPolicyName());
                    this.userManagementService.createSite(cloud.getCloudId(), user);
                    String deviceName = userName + " (Microsoft SharePoint)";
                    Device device = this.deviceManagementService.getDeviceByName(cloud.getCloudId(), cloud.getCloudName(), deviceName);
                    if (device == null) {
                        this.registerDeviceForUserSite(user, cloud);
                        logger.debug(user.getUserName() + " %%%%%%% user process completed completed..." + user.getEmailId());
                        continue;
                    }
                    BaseController.printLogs((String)("..device already registered for diff user check for same usermail or odbloginid...." + userName), (boolean)PCHelperConstant.isBrevityLogging());
                }
                catch (Exception e) {
                    logger.error("exception inside BackupUploadJob .... " + e.getMessage());
                    logger.trace("exception inside BackupUploadJob ...." + e);
                }
            }
        }
    }

    public void registerDeviceForUserSite(User user, Cloud cloud) {
        try {
            String userName = user.getUserName();
            BaseController.printLogs((String)("Processing1 " + userName), (boolean)PCHelperConstant.isBrevityLogging());
            if (!StringUtils.isEmpty((String)user.getSiteId())) {
                DeviceElement deviceElement = new DeviceElement();
                String deviceUUID = MD5Generator.generateMD5OfString((String)user.getSiteId());
                deviceElement.setDeviceUUID(deviceUUID);
                deviceElement.setDeviceName("Microsoft SharePoint");
                deviceElement.setUserName(userName);
                boolean isRegistered = this.deviceManagementService.registerSharepointBkpDevice(cloud, deviceElement);
                if (isRegistered) {
                    String deviceName = deviceElement.getUserName() + " (" + deviceElement.getDeviceName() + ")";
                    this.deviceManagementService.saveStatisticToDatabase(cloud.getCloudId(), cloud.getCloudName(), "Office 365 user " + userName + " registered for SharePoint", userName, "", deviceName, System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
                }
            } else {
                logger.error(".......... drive not available for user .... " + userName);
                O365BlackListUser o365BlackListUser = new O365BlackListUser();
                o365BlackListUser.setUserName(userName);
                o365BlackListUser.setResponseCode("404");
                o365BlackListUser.setLocalHost(PCHelperConstant.getPropertyValueComponentName());
                this.deviceManagementService.saveO365BlackListUser(cloud.getCloudId(), o365BlackListUser);
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception inside BackupUploadJob Processor PooledConnectionFactory !" + e.getMessage());
        }
    }

    protected GraphServiceClient<Request> getGraphClient(String accessToken) {
        Graph graph = Graph.getInstance();
        GraphServiceClient<Request> graphClient = graph.getGraphClient();
        return graphClient;
    }
}

