/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.ah.service.PushNotificationService;
import com.parablu.bluvault.udc.service.PciAuthorizationTokensService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.constant.ParaMailHelperConstant;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.element.UserElement;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.PciAuthorizationTokens;
import com.parablu.pcbd.domain.User;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.StatefulJob;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class Office365TokenExpiryTimer
extends QuartzJobBean
implements StatefulJob {
    private static Logger logger = LogManager.getLogger(Office365TokenExpiryTimer.class);
    private PciAuthorizationTokensService pciAuthorizationTokensService;
    private LicenseService licenseService;
    private UserManagementService userManagementService;
    private CloudMailService cloudMailService;
    private PushNotificationService pushNotificationService;

    public void setPushNotificationService(PushNotificationService pushNotificationService) {
        this.pushNotificationService = pushNotificationService;
    }

    public void setPciAuthorizationTokensService(PciAuthorizationTokensService pciAuthorizationTokensService) {
        this.pciAuthorizationTokensService = pciAuthorizationTokensService;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setCloudMailService(CloudMailService cloudMailService) {
        this.cloudMailService = cloudMailService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"tokenExpiryTrigger")) {
            logger.debug("Office365TokenExpiryTimer ................ disabled");
            return;
        }
        List clouds = this.licenseService.getClouds();
        for (Cloud cloud : clouds) {
            int cloudId = cloud.getCloudId();
            List users = this.userManagementService.getAllUsersDetails(cloudId, cloud.getCloudName(), false);
            for (User user : users) {
                PciAuthorizationTokens pciAuthorizationTokens = this.pciAuthorizationTokensService.getPciAuthorizationTokensForUserId(cloudId, cloud.getCloudName(), user.getUserId());
                if (pciAuthorizationTokens == null) continue;
                logger.debug(this.pciAuthorizationTokensService + "@@@TOKEN EXPIRY for USER ..." + user.getUserName());
                String accessToken = this.pciAuthorizationTokensService.getAccessTokenForOffice365(cloudId, cloud.getCloudName(), pciAuthorizationTokens);
                if (!StringUtils.isEmpty((String)accessToken)) continue;
                this.sendMailAndNotification(cloud, cloudId, user);
            }
        }
    }

    private void sendMailAndNotification(Cloud cloud, int cloudId, User user) {
        logger.debug("@@@TOKEN EXPIRY trigger email latest ..." + user.getUserName());
        logger.debug("Before going to save notification$$$$" + this.pushNotificationService);
        try {
            this.pushNotificationService.saveNotificationToDatabase(cloud.getCloudId(), cloud.getCloudName(), 0, user.getUserName().toLowerCase());
        }
        catch (Exception e) {
            logger.trace("Exception  " + e.getMessage());
            logger.error("Exception  " + e);
        }
        UserElement ue = this.userManagementService.getUserInfo(cloudId, cloud.getCloudName(), user.getUserName());
        this.sendEmail(ue, cloud);
    }

    private void sendEmail(UserElement userElement, Cloud cloud) {
        String cloudName = cloud.getCloudName();
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction("token-expired");
        EmailRecipent emailRecipent = new EmailRecipent();
        emailRecipent.setUserName(userElement.getUserName());
        emailRecipent.setEmail(userElement.getEmailId());
        email.setActionBy(userElement.getUserName());
        String login = "odbrelogin";
        if (this.isGDEnabled(cloud.getCloudCustomisableDetails()) || this.isGDServiceAcctEnabled(cloud.getCloudCustomisableDetails())) {
            login = "googleOAuth";
        }
        logger.debug(".........auth.........." + login);
        String url = ParaMailHelperConstant.getPropertyFileValueParacloudUrl() + "/portal/" + login + "?cloudName=" + cloudName + "&uEmail=" + userElement.getEmailId() + "&isODBLogin=true&uName=" + userElement.getUserName();
        email.setDownloadLink(url);
        email.setStartDate(this.getDate(System.currentTimeMillis()));
        emailRecipents.add(emailRecipent);
        if (!emailRecipents.isEmpty()) {
            logger.debug(" @@@ Before sending mail ");
            email.setRecipents(emailRecipents);
            this.cloudMailService.sendMail(email);
        }
    }

    private boolean isGDEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isGDEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"Google Drive Enabled".equalsIgnoreCase(license.getName())) continue;
            isGDEnabled = true;
            break;
        }
        return isGDEnabled;
    }

    private boolean isGDServiceAcctEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isGDServiceAcctEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"GD Service Account Enabled".equalsIgnoreCase(license.getName())) continue;
            isGDServiceAcctEnabled = true;
            break;
        }
        return isGDServiceAcctEnabled;
    }

    private String getDate(long dateVal) {
        Date date = new Date(dateVal);
        SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        return df2.format(date);
    }
}

