/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.ah.service.PushNotificationService;
import com.parablu.bluvault.udc.service.PciAuthorizationTokensService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.ParaMailHelperConstant;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.MSGTokens;
import com.parablu.pcbd.domain.User;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.StatefulJob;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class O365TokenExpiryTimer
extends QuartzJobBean
implements StatefulJob {
    private static Logger logger = LogManager.getLogger(O365TokenExpiryTimer.class);
    private PciAuthorizationTokensService pciAuthorizationTokensService;
    private LicenseService licenseService;
    private UserManagementService userManagementService;
    private CloudMailService cloudMailService;
    private PushNotificationService pushNotificationService;

    public void setPushNotificationService(PushNotificationService pushNotificationService) {
        this.pushNotificationService = pushNotificationService;
    }

    public void setPciAuthorizationTokensService(PciAuthorizationTokensService pciAuthorizationTokensService) {
        this.pciAuthorizationTokensService = pciAuthorizationTokensService;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setCloudMailService(CloudMailService cloudMailService) {
        this.cloudMailService = cloudMailService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        List clouds = this.licenseService.getClouds();
        for (Cloud cloud : clouds) {
            int cloudId = cloud.getCloudId();
            logger.debug(".. for cloud... " + cloud.getCloudName());
            List users = this.userManagementService.getAllUsersDetails(cloudId, cloud.getCloudName(), false);
            for (User user : users) {
                MSGTokens msgTokens = this.pciAuthorizationTokensService.getMSGTokensForUserId(cloudId, user.getUserId());
                if (msgTokens == null) continue;
                logger.debug("@@@O365TOKEN EXPIRY for USER ..." + user.getUserName());
                boolean tokenUpdated = this.pciAuthorizationTokensService.updateTokenForODBBackup(cloudId);
                logger.debug(tokenUpdated + "...@@@TOKEN EXPIRY for USER ..." + user.getUserName());
                if (tokenUpdated) continue;
                this.sendMailAndNotification(cloud, cloudId, user);
            }
        }
    }

    private void sendMailAndNotification(Cloud cloud, int cloudId, User user) {
        logger.debug("@@@ o365 TOKEN EXPIRY trigger email latest ..." + user.getUserName());
        logger.debug("Before going to save notification$$$$" + this.pushNotificationService);
        try {
            this.pushNotificationService.saveNotificationToDatabase(cloud.getCloudId(), cloud.getCloudName(), 16, user.getUserName().toLowerCase());
        }
        catch (Exception e) {
            logger.trace("Exception  " + e.getMessage());
            logger.error("Exception  " + e);
        }
        this.sendEmail(user, cloud);
    }

    private void sendEmail(User userElement, Cloud cloud) {
        String cloudName = cloud.getCloudName();
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction("o365token-expired");
        EmailRecipent emailRecipent = new EmailRecipent();
        emailRecipent.setUserName(userElement.getUserName());
        emailRecipent.setEmail(userElement.getEmailId());
        email.setActionBy(userElement.getUserName());
        String login = "o365login";
        logger.debug(".........auth.........." + login);
        String url = ParaMailHelperConstant.getPropertyFileValueParacloudUrl() + "/portal/" + login + "?cloudName=" + cloudName + "&uEmail=" + userElement.getEmailId() + "&isODBLogin=true&uName=" + userElement.getUserName();
        email.setDownloadLink(url);
        email.setStartDate(this.getDate(System.currentTimeMillis()));
        emailRecipents.add(emailRecipent);
        if (!emailRecipents.isEmpty()) {
            logger.debug(" @@@ Before sending mail ");
            email.setRecipents(emailRecipents);
            this.cloudMailService.sendMail(email);
        }
    }

    private String getDate(long dateVal) {
        Date date = new Date(dateVal);
        SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        return df2.format(date);
    }
}

