/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.udc.service.MiniCloudAccessControlService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.element.MiniCloudElement;
import com.parablu.paracloud.element.MiniCloudElementList;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.User;
import com.parablu.report.service.ReportService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.joda.time.DateTime;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.CollectionUtils;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class MiniCloudExpiryTimer
extends QuartzJobBean {
    public static final String EMAIL_IDS = "emailIds";
    private Logger logger = LogManager.getLogger(MiniCloudExpiryTimer.class);
    private static final String EXCEPTION = "Exception :";
    private MiniCloudAccessControlService miniCloudAccessControlService;
    private LicenseService licenseService;
    private CloudMailService cloudMailService;
    private ReportService reportService;
    private UserManagementService userManagementService;

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setCloudMailService(CloudMailService cloudMailService) {
        this.cloudMailService = cloudMailService;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public MiniCloudAccessControlService getMiniCloudAccessControlService() {
        return this.miniCloudAccessControlService;
    }

    public void setMiniCloudAccessControlService(MiniCloudAccessControlService miniCloudAccessControlService) {
        this.miniCloudAccessControlService = miniCloudAccessControlService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        block12: {
            if (!PCHelperConstant.isJobEnabled((String)"miniCloudExpiryTrigger")) {
                this.logger.debug("MiniCloudExpiryTimer ............... disabled");
                return;
            }
            this.logger.debug("   start of job to check for MiniCloudExpiryTimer .... ");
            try {
                List clouds = this.licenseService.getClouds();
                if (!CollectionUtils.isEmpty((Collection)clouds)) {
                    for (Cloud cloud : clouds) {
                        int cloudId = cloud.getCloudId();
                        MiniCloudElementList allMiniClouds = this.miniCloudAccessControlService.getAllMiniClouds(cloudId, cloud.getCloudName());
                        if (allMiniClouds == null || CollectionUtils.isEmpty((Collection)allMiniClouds.getMiniClouds())) continue;
                        Map reportConfigProperties = this.reportService.getReportConfig(cloudId, "miniCloudExpiry");
                        for (MiniCloudElement miniCloudElement : allMiniClouds.getMiniClouds()) {
                            if (StringUtils.isEmpty((String)miniCloudElement.getMcDisableDate())) continue;
                            long milliseconds = 0L;
                            SimpleDateFormat f = new SimpleDateFormat("dd-MMM-yyyy");
                            try {
                                Date d = f.parse(miniCloudElement.getMcDisableDate());
                                milliseconds = d.getTime();
                            }
                            catch (ParseException e) {
                                this.logger.trace("parse exception..." + e);
                                this.logger.error(" exception val.." + e.getMessage());
                            }
                            this.logger.debug("......minicloud disable on....." + miniCloudElement.getMcDisableDate() + "...." + milliseconds);
                            Date date = new Date(milliseconds);
                            DateTime validityPeriod = new DateTime((Object)date);
                            DateTime currentDateTime = new DateTime();
                            long difference = MiniCloudExpiryTimer.removeTime(validityPeriod.toDate()).getTime() - MiniCloudExpiryTimer.removeTime(currentDateTime.toDate()).getTime();
                            int daysDiff = (int)(difference / 86400000L);
                            this.logger.debug(miniCloudElement.getMiniCloudName() + "...Days Difference for share.. " + daysDiff);
                            if (reportConfigProperties.get("days") != null) {
                                ArrayList<Integer> compareDay = this.getIntegerArray(reportConfigProperties.get("days").toString());
                                if (daysDiff >= 0 && compareDay.contains(daysDiff)) {
                                    List usersForMC = this.miniCloudAccessControlService.getAllUserForMiniCloud(cloudId, cloud.getCloudName(), miniCloudElement.getMiniCloudName());
                                    if (CollectionUtils.isEmpty((Collection)usersForMC)) continue;
                                    ArrayList<String> emailIds = new ArrayList<String>();
                                    for (User user : usersForMC) {
                                        emailIds.add(user.getEmailId());
                                    }
                                    this.sendmail(cloud, emailIds, date, miniCloudElement.getMiniCloudName());
                                    continue;
                                }
                                if (daysDiff >= 0) continue;
                                this.logger.debug("..removing access for minicloud...." + miniCloudElement.getMiniCloudName());
                                ObjectId ownerId = null;
                                List usersForMC = this.miniCloudAccessControlService.getAllUserForMiniCloud(cloudId, cloud.getCloudName(), miniCloudElement.getMiniCloudName());
                                if (CollectionUtils.isEmpty((Collection)usersForMC)) continue;
                                for (User user : usersForMC) {
                                    if (user == null || !user.getUserName().equalsIgnoreCase(miniCloudElement.getOwner())) continue;
                                    ownerId = user.getUserId();
                                    break;
                                }
                                this.miniCloudAccessControlService.deleteUserAccessForMinicloudExceptOwner(cloudId, new ObjectId(miniCloudElement.getId()), ownerId, cloud.getCloudName(), miniCloudElement.getMiniCloudName());
                                continue;
                            }
                            this.logger.debug("... miniCloudExpiry reportConfig is empty  specify days .... ");
                        }
                    }
                    break block12;
                }
                this.logger.debug("   cloud is empty .... ");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.trace(EXCEPTION + e);
                this.logger.error(EXCEPTION + e.getMessage());
            }
        }
    }

    private ArrayList<Integer> getIntegerArray(String string) {
        List<String> stringArray = Arrays.asList(string.split(","));
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String stringValue : stringArray) {
            try {
                result.add(Integer.parseInt(stringValue));
            }
            catch (NumberFormatException e) {
                this.logger.trace(EXCEPTION + e);
                this.logger.error(EXCEPTION + e.getMessage());
            }
        }
        return result;
    }

    private void sendmail(Cloud cloud, List<String> userMailIds, Date validityPeriod, String miniCloudName) {
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        if (!StringUtils.isEmpty((String)miniCloudName) && miniCloudName.startsWith("_mc_")) {
            miniCloudName = miniCloudName.replaceFirst("_mc_", "");
        }
        email.setFileName(miniCloudName);
        email.setAction("minicloud-expiry-notification");
        email.setClientMailName(PCHelperConstant.getClientMailName());
        email.setCloudName(cloud.getCloudName());
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
        sdf.setTimeZone(TimeZone.getTimeZone("IST"));
        email.setStartDate(sdf.format(validityPeriod));
        email.setIndividualMail(true);
        for (String userEmail : userMailIds) {
            EmailRecipent emailRecipent = new EmailRecipent();
            User user = this.userManagementService.getUserDetailsForEmail(cloud.getCloudId(), userEmail);
            if (user != null) {
                emailRecipent.setUserName(user.getUserName());
            }
            emailRecipent.setEmail(userEmail);
            emailRecipents.add(emailRecipent);
        }
        this.logger.debug(" @@@ Before sending mail with user minicloud-expiry-notification ");
        email.setRecipents(emailRecipents);
        this.cloudMailService.sendMail(email);
    }

    public static Date removeTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }
}

