/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.microsoft.graph.requests.GraphServiceClient;
import com.parablu.bluvault.udc.service.MiniCloudAccessControlService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.helper.constant.GeneralHelperConstant;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.MiniCloudElement;
import com.parablu.paracloud.element.MiniCloudElementList;
import com.parablu.pc.timer.helper.Graph;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.MiniCloud;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import okhttp3.Request;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class MCSizeCheckJob
extends QuartzJobBean
implements Job {
    private static Logger logger = LogManager.getLogger(MCSizeCheckJob.class);
    private LicenseService licenseService;
    private MiniCloudAccessControlService miniCloudAccessControlService;

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public MiniCloudAccessControlService getMiniCloudAccessControlService() {
        return this.miniCloudAccessControlService;
    }

    public void setMiniCloudAccessControlService(MiniCloudAccessControlService miniCloudAccessControlService) {
        this.miniCloudAccessControlService = miniCloudAccessControlService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"mCSizeCheckJobTrigger")) {
            logger.debug("mCSizeCheckJobTrigger ........... disabled");
            return;
        }
        logger.debug("@@@@MCSizeCheckJob started ..... ");
        List clouds = this.licenseService.getClouds();
        Cloud cloud = clouds.stream().findFirst().orElse(null);
        logger.debug("@@@@MCSizeCheckJob started flag ..... ");
        int cloudId = cloud.getCloudId();
        MiniCloudElementList allMiniClouds = this.miniCloudAccessControlService.getAllMiniClouds(cloudId, cloud.getCloudName());
        if (allMiniClouds != null && !CollectionUtils.isEmpty((Collection)allMiniClouds.getMiniClouds())) {
            try {
                logger.debug("@@@@MCSizeCheckJob started ..... ");
                for (MiniCloudElement miniCloudElement : allMiniClouds.getMiniClouds()) {
                    MiniCloud miniCloud = this.miniCloudAccessControlService.getMiniCloudByName(cloudId, miniCloudElement.getMiniCloudName());
                    long folderSize = 0L;
                    if (!StringUtils.isEmpty((String)miniCloudElement.getMiniCloudName())) {
                        int mcQuota;
                        logger.debug("..........filepath..." + miniCloudElement.getMiniCloudName());
                        ArrayList<BackUpImage> syncFolderList = new ArrayList<BackUpImage>();
                        BackUpImage syncFile = this.miniCloudAccessControlService.getBackUpImageForMC(cloudId, miniCloud.getMiniCloudName(), miniCloud);
                        if (syncFile != null) {
                            syncFolderList.add(syncFile);
                        }
                        ArrayList<BackUpImage> syncFileFolderRecursion = new ArrayList<BackUpImage>();
                        String filePath = "ParaBlu";
                        this.syncFileFolderRecursion(filePath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + miniCloudElement.getMiniCloudName(), cloudId, syncFileFolderRecursion, miniCloud);
                        syncFolderList.addAll(syncFileFolderRecursion);
                        if (!CollectionUtils.isEmpty(syncFolderList)) {
                            HashSet<String> pathSet = new HashSet<String>();
                            for (BackUpImage backUpImage : syncFolderList) {
                                String path = backUpImage.getDevicePath() + "/" + backUpImage.getFileName();
                                pathSet.add(path);
                            }
                            for (String path : pathSet) {
                                ArrayList<BackUpImage> restoreFilesList = new ArrayList<BackUpImage>();
                                List files = this.miniCloudAccessControlService.getAllChildFilesOfFolderMC(cloudId, "", path, false, miniCloud);
                                restoreFilesList.addAll(files);
                                long folderSpaceSize = this.restoreSyncFolder(cloud, restoreFilesList);
                                logger.debug("...path and size..." + path + "...." + folderSpaceSize + "..." + (folderSize += folderSpaceSize));
                            }
                        }
                        if ((mcQuota = miniCloudElement.getMcQuota()) > 0 && folderSize > (long)(mcQuota * 0x100000)) {
                            logger.debug("...disaallow for upload...." + mcQuota * 0x100000 + "....quota..." + folderSize);
                            this.miniCloudAccessControlService.updateMiniCloudforQuota(cloudId, miniCloudElement.getMiniCloudName(), false);
                        } else {
                            logger.debug("...allowed for upload...." + mcQuota * 0x100000 + "....quota..." + folderSize);
                            this.miniCloudAccessControlService.updateMiniCloudforQuota(cloudId, miniCloudElement.getMiniCloudName(), true);
                        }
                    }
                    logger.debug("...overall size for minicloud.." + miniCloudElement.getMiniCloudName() + "..size.." + folderSize);
                }
                logger.debug("@@@@MCSizeCheckJob ended ..... ");
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(" exception in MCSizeCheckJob ......." + e.getMessage());
                logger.trace("exception in MCSizeCheckJob ......." + e);
            }
            logger.debug("@@@@MCSizeCheckJob started ..... ");
        }
        try {
            logger.debug("...wait for 5 mins and retry...");
            Thread.sleep(300000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private long restoreSyncFolder(Cloud cloud, List<BackUpImage> restoreFilesList) {
        long folderSize = 0L;
        for (BackUpImage backUpImage : restoreFilesList) {
            if (backUpImage == null || backUpImage.getSize() == 0L) continue;
            folderSize += backUpImage.getSize();
        }
        return folderSize;
    }

    private void syncFileFolderRecursion(String filePath, int cloudId, List<BackUpImage> syncFileFolderRecursion, MiniCloud miniCloud) {
        List syncFilesTemp = this.miniCloudAccessControlService.getAllChildFilesOfFolderMC(cloudId, "", filePath, true, miniCloud);
        syncFileFolderRecursion.addAll(syncFilesTemp);
        if (!CollectionUtils.isEmpty((Collection)syncFilesTemp)) {
            Stream stream = syncFilesTemp.parallelStream();
            stream.forEach(syncFile -> {
                String devicePath = syncFile.getDevicePath() + "/" + syncFile.getFileName();
                if (StringUtils.isEmpty((String)syncFile.getDevicePath())) {
                    devicePath = syncFile.getFileName();
                }
                this.syncFileFolderRecursion(devicePath, cloudId, syncFileFolderRecursion, miniCloud);
            });
        }
    }

    protected GraphServiceClient<Request> getGraphClient(String accessToken) {
        Graph graph = Graph.getInstance();
        GraphServiceClient<Request> graphClient = graph.getGraphClient();
        return graphClient;
    }
}

