/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.MiniCloudAccessControlService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.SharedFileImage;
import com.parablu.rf.service.ResourceFunnelDatabaseReadAndWriteService;
import com.parablu.share.service.SharedFileImageService;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.CollectionUtils;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class FileSharingCleanerTimer
extends QuartzJobBean {
    private static Logger logger = LogManager.getLogger(FileSharingCleanerTimer.class);
    private SharedFileImageService sharedFileImageService;
    private ResourceFunnelDatabaseReadAndWriteService resourceFunnelDatabaseReadAndWriteService;
    private LicenseService licenseService;
    private MiniCloudAccessControlService miniCloudAccessControlService;

    public void setSharedFileImageService(SharedFileImageService sharedFileImageService) {
        this.sharedFileImageService = sharedFileImageService;
    }

    public void setResourceFunnelDatabaseReadAndWriteService(ResourceFunnelDatabaseReadAndWriteService resourceFunnelDatabaseReadAndWriteService) {
        this.resourceFunnelDatabaseReadAndWriteService = resourceFunnelDatabaseReadAndWriteService;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setMiniCloudAccessControlService(MiniCloudAccessControlService miniCloudAccessControlService) {
        this.miniCloudAccessControlService = miniCloudAccessControlService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        try {
            if (!PCHelperConstant.isJobEnabled((String)"fileSharingCleanerTrigger")) {
                logger.debug("FileSharingCleanerTimer ............ disabled");
                return;
            }
            List clouds = this.licenseService.getClouds();
            ArrayList<ObjectId> shareIds = new ArrayList<ObjectId>();
            for (Cloud cloud : clouds) {
                List sharedFileImages = this.sharedFileImageService.getAllSharedFileImages(cloud.getCloudName());
                for (SharedFileImage sharedFileImage : sharedFileImages) {
                    long currentTime = System.currentTimeMillis();
                    if (sharedFileImage.getValidUntil() != 0L) {
                        logger.debug("FileSharingCleanerTime : Current Time : " + currentTime + " Valid Until : " + sharedFileImage.getValidUntil());
                        if (currentTime <= sharedFileImage.getValidUntil()) continue;
                        shareIds.add(sharedFileImage.getId());
                        continue;
                    }
                    BaseController.printLogs((String)"valid until is zero 00 so skip >>>>>>>>", (boolean)PCHelperConstant.isBrevityLogging());
                }
            }
            if (!CollectionUtils.isEmpty(shareIds)) {
                this.sharedFileImageService.deleteUsersSharedFilesBySharedFileImageIds(1, shareIds);
                this.sharedFileImageService.deleteSharedFileImages(shareIds);
            }
        }
        catch (Exception e) {
            logger.debug("Exception trying to delete expired shared files ... " + e);
            logger.error("Exception trying to delete expired shared files ... " + e.getMessage());
        }
    }
}

