/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.backup.service.BackupDataCleanerService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.DeletedUser;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.CollectionUtils;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class DeleteduserDataCleanerTimer
extends QuartzJobBean {
    private static Logger logger = LogManager.getLogger(DeleteduserDataCleanerTimer.class);
    private BackupDataCleanerService backupDataCleanerService;
    private LicenseService licenseService;
    private UserManagementService userManagementService;

    public BackupDataCleanerService getBackupDataCleanerService() {
        return this.backupDataCleanerService;
    }

    public void setBackupDataCleanerService(BackupDataCleanerService backupDataCleanerService) {
        this.backupDataCleanerService = backupDataCleanerService;
    }

    public UserManagementService getUserManagementService() {
        return this.userManagementService;
    }

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public LicenseService getLicenseService() {
        return this.licenseService;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"deleteduserDataCleanerTrigger")) {
            logger.debug("DeleteduserDataCleanerTimer ............ disabled");
            return;
        }
        logger.debug("Remove Deleted User Cleaner Timer started .......");
        List clouds = this.licenseService.getClouds();
        ArrayList<String> removableUserNames = new ArrayList<String>();
        for (Cloud cloud : clouds) {
            boolean isDeletedUserCleaned;
            List deletedUserElements = this.userManagementService.getAllDeletedUsers(cloud.getCloudId(), cloud.getCloudName());
            List userElements = this.userManagementService.getAllDeletedUsers(cloud.getCloudId());
            for (DeletedUser user : deletedUserElements) {
                isDeletedUserCleaned = this.backupDataCleanerService.isDeletedUserCleaned(cloud.getCloudId(), cloud.getCloudName(), user.getUserName());
                if (!isDeletedUserCleaned) continue;
                removableUserNames.add(user.getUserName());
            }
            for (DeletedUser user : userElements) {
                isDeletedUserCleaned = this.backupDataCleanerService.isDeletedUserCleaned(cloud.getCloudId(), cloud.getCloudName(), user.getUserName());
                if (!isDeletedUserCleaned) continue;
                removableUserNames.add(user.getUserName());
            }
            if (CollectionUtils.isEmpty(removableUserNames)) continue;
            this.userManagementService.removeUsersByName(cloud.getCloudId(), removableUserNames);
        }
    }
}

