/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.cloud.security.service.LicenseService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.rf.service.DeleteTimerService;
import java.io.File;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class DeleteFileTimerImpl
extends QuartzJobBean {
    private Logger logger = LogManager.getLogger(DeleteFileTimerImpl.class);
    private DeleteTimerService deleteTimerService;
    private LicenseService licenseService;

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setDeleteTimerService(DeleteTimerService deleteTimerService) {
        this.deleteTimerService = deleteTimerService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"deleteTimerTrigger")) {
            this.logger.debug("DeleteFileTimerImpl ........ disabled");
            return;
        }
        List clouds = this.licenseService.getClouds();
        if (clouds == null) {
            return;
        }
        int limit = 500;
        for (Cloud cloud : clouds) {
            if (!this.checkIfDeviceIsAttached(cloud.getCloudName())) continue;
            Long fileRevisionCount = this.deleteTimerService.getCountOfAllLatestFileRevisions(cloud.getCloudId(), cloud.getCloudName(), (long)cloud.getVersioningEnabled());
            int i = 0;
            while ((long)i < fileRevisionCount) {
                this.deleteTimerService.deleteOlderFileRevisionsBasedOnRevisionCount(cloud.getCloudId(), cloud.getCloudName(), cloud, cloud.getVersioningEnabled(), 0, limit);
                i += limit;
            }
            this.deleteTimerService.saveTask(cloud.getCloudId(), cloud.getCloudName());
        }
    }

    protected boolean checkIfDeviceIsAttached(String cloudName) {
        return new File(PCHelperConstant.getPropertyFileValueParabluFolderBasePath((String)cloudName)).exists();
    }
}

