/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.backup.service.BackupDataCleanerService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.UserElement;
import com.parablu.pcbd.domain.BackupFile;
import com.parablu.pcbd.domain.Cloud;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.StatefulJob;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.CollectionUtils;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class DeleteExternalStorageDataTimer
extends QuartzJobBean
implements StatefulJob {
    private static Logger logger = LogManager.getLogger(DeleteExternalStorageDataTimer.class);
    private BackupDataCleanerService backupDataCleanerService;
    private LicenseService licenseService;
    private UserManagementService userManagementService;

    public void setBackupDataCleanerService(BackupDataCleanerService backupDataCleanerService) {
        this.backupDataCleanerService = backupDataCleanerService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"deleteBackupDataTrigger")) {
            logger.debug("DeleteExternalStorageDataTimer ............... disabled");
            return;
        }
        logger.debug("@@@ Delete JOB STARTED for delete blob...");
        try {
            List clouds = this.licenseService.getClouds();
            for (Cloud cloud : clouds) {
                this.getAllDeletedBackupImagesAndDeleteFromExternalStorage(cloud);
            }
            logger.debug("@@@@ Delete JOB ENDED...");
        }
        catch (Exception e) {
            logger.error("Exception : " + e.getMessage());
            logger.debug("Exception : " + e);
        }
    }

    private void getAllDeletedBackupImagesAndDeleteFromExternalStorage(Cloud cloud) {
        List users = this.userManagementService.getAllUsers(cloud.getCloudId(), cloud.getCloudName(), false, false);
        Collections.sort(users, new Comparator<UserElement>(){

            @Override
            public int compare(UserElement d1, UserElement d2) {
                return d1.getUserName().compareTo(d2.getUserName());
            }
        });
        for (UserElement user : users) {
            long count = this.backupDataCleanerService.getCountOfODTable(cloud.getCloudId(), cloud.getCloudName(), user.getUserName());
            long modCount = 0L;
            if (count > 300L) {
                modCount = count / 300L;
            }
            int i = 0;
            while ((long)i <= modCount) {
                List backupFiles = this.backupDataCleanerService.getBackupFiles(cloud.getCloudId(), cloud.getCloudName(), user.getUserName(), i);
                logger.debug(user.getUserName() + "<<<<<<<<<<user name backup  file list size>>>>>> for" + i + "is>>>" + backupFiles.size());
                if (CollectionUtils.isEmpty((Collection)backupFiles)) {
                    logger.debug("BackupList Size is zeroooooooooooooo");
                } else {
                    List<BackupFile> filesToDelete = this.checkWithBackupImageTableGetFilesToDelete(backupFiles, cloud, user.getUserName());
                    logger.debug(user.getUserName() + "<<<<<<<<<<user name file list size after check with backup image table>>>>>> for" + i + "is>>>" + filesToDelete.size());
                    this.backupDataCleanerService.deleteODTableEntriesAndMarkchunksToDelete(cloud.getCloudId(), cloud.getCloudName(), user.getUserName(), filesToDelete);
                }
                ++i;
            }
        }
    }

    private List<BackupFile> checkWithBackupImageTableGetFilesToDelete(List<BackupFile> backupFiles, Cloud cloud, String user) {
        ArrayList<ObjectId> objectIds = new ArrayList<ObjectId>();
        for (BackupFile backupFile : backupFiles) {
            objectIds.add(backupFile.getId());
        }
        List deletedBackupIds = this.backupDataCleanerService.getDeletedBackupIds(cloud.getCloudId(), cloud.getCloudName(), user, objectIds);
        return this.compareAndGetDeletedBackupFiles(deletedBackupIds, backupFiles);
    }

    private List<BackupFile> compareAndGetDeletedBackupFiles(List<ObjectId> deletedBackupIds, List<BackupFile> backupFiles) {
        ArrayList<BackupFile> deletedBackupFilesList = new ArrayList<BackupFile>();
        block0: for (ObjectId backupId : deletedBackupIds) {
            for (BackupFile backupFile : backupFiles) {
                if (!backupFile.getId().toString().contentEquals(backupId.toString())) continue;
                deletedBackupFilesList.add(backupFile);
                continue block0;
            }
        }
        return deletedBackupFilesList;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }
}

