/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.cloud.security.service.UpgradeService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.ClientUpgradeRequestElement;
import com.parablu.paracloud.element.UpgradeRequestElement;
import com.parablu.paracloud.util.JaxBSerializerHelper;
import com.parablu.pc.timer.ResponseStatusCodeAndXml;
import com.parablu.pcbd.domain.Release;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class CloudUpdateTimer
extends QuartzJobBean {
    private Logger logger = LogManager.getLogger(CloudUpdateTimer.class);
    private UpgradeService upgradeService;
    private static final String IO_EXCEPTION = "IOException ";

    public void setUpgradeService(UpgradeService upgradeService) {
        this.upgradeService = upgradeService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        List oldReleaseList = this.upgradeService.loadAllRelease();
        if (oldReleaseList == null) {
            this.logger.debug("old release list is null ");
            return;
        }
        ArrayList<UpgradeRequestElement> upgradeRequestElementList = new ArrayList<UpgradeRequestElement>();
        Release oldParaCloudRelease = this.formUpgradeElementListForReleaseElement(oldReleaseList, upgradeRequestElementList);
        if (oldParaCloudRelease == null) {
            this.logger.debug("paracloud Old Release Version Not found ");
            return;
        }
        ResponseStatusCodeAndXml responseStatusCodeAndXml = null;
        try {
            responseStatusCodeAndXml = this.getLatestParacloudVersionToDownload(oldParaCloudRelease);
        }
        catch (IOException e1) {
            this.logger.debug(IO_EXCEPTION + e1);
            this.logger.error(IO_EXCEPTION + e1.getMessage());
        }
        if (responseStatusCodeAndXml == null || responseStatusCodeAndXml.getStatusCode() == 500) {
            this.logger.debug("response null");
            this.logger.debug("" + responseStatusCodeAndXml);
            if (responseStatusCodeAndXml != null) {
                this.logger.debug(" " + responseStatusCodeAndXml.getStatusCode());
            }
            return;
        }
        this.logger.debug("The upgrade status code is:" + responseStatusCodeAndXml.getStatusCode());
        this.downloadAndInstallParacloudUpdate(responseStatusCodeAndXml);
        try {
            this.updateBlusyncClientsComplete(oldReleaseList, upgradeRequestElementList);
        }
        catch (IOException e) {
            this.logger.debug(IO_EXCEPTION + e);
            this.logger.error(IO_EXCEPTION + e.getMessage());
        }
    }

    private void downloadAndInstallParacloudUpdate(ResponseStatusCodeAndXml responseStatusCodeAndXml) {
        if (responseStatusCodeAndXml.getXmlResponse() != null) {
            UpgradeRequestElement upgradeRequestElement = JaxBSerializerHelper.unmarshallUpgradeRequestElement((String)responseStatusCodeAndXml.getXmlResponse());
            String paracloudDownloadPath = "NEED TO CLEAN";
            String downloadScriptName = "NEED TO CLEAN";
            if (this.downloadFileToPath(paracloudDownloadPath + downloadScriptName, upgradeRequestElement.getDownloadLink())) {
                try {
                    Runtime.getRuntime().exec(paracloudDownloadPath + downloadScriptName);
                }
                catch (IOException e) {
                    this.logger.debug(IO_EXCEPTION, (Throwable)e);
                }
            }
        }
    }

    private void updateBlusyncClientsComplete(List<Release> oldReleaseList, List<UpgradeRequestElement> upgradeRequestElementList) throws IOException {
        if (upgradeRequestElementList.isEmpty()) {
            return;
        }
        ClientUpgradeRequestElement clientUpgradeRequestElement = new ClientUpgradeRequestElement();
        clientUpgradeRequestElement.setUpgradeRequestElementList(upgradeRequestElementList);
        ResponseStatusCodeAndXml responseStatusCodeAndXml = this.getLatestVersionOfClientsToDownload(clientUpgradeRequestElement);
        if (responseStatusCodeAndXml == null || responseStatusCodeAndXml.getStatusCode() == 500) {
            this.logger.debug("response for clients is null");
            return;
        }
        this.logger.debug("responseStatusCodeAndXml.getStatusCode()" + responseStatusCodeAndXml.getStatusCode());
        this.downloadBlusyncClientOneByOne(oldReleaseList, responseStatusCodeAndXml);
    }

    private Release getReleaseDetailsFromOLdReleaseList(List<Release> oldReleaseList, UpgradeRequestElement element) {
        Release newRelease = new Release();
        for (Release release : oldReleaseList) {
            if (!release.getProductFamily().equals(element.getProductFamily()) || !release.getProductMinorGroup().equals(element.getProductMinorGroup())) continue;
            newRelease.setReleaseId(release.getReleaseId());
            newRelease.setLastModifiedTimestamp(System.currentTimeMillis());
            newRelease.setProductFamily(release.getProductFamily());
            newRelease.setProductMinorGroup(release.getProductMinorGroup());
            newRelease.setProductVersion(element.getCurrentVersion());
            newRelease.setDownloadLink(element.getDownloadLink());
            newRelease.setStatus(release.getStatus());
            return newRelease;
        }
        return null;
    }

    private Release formUpgradeElementListForReleaseElement(List<Release> oldReleaseList, List<UpgradeRequestElement> upgradeRequestElementList) {
        Release oldParaCloudRelease = null;
        for (Release release : oldReleaseList) {
            if (release.getProductFamily().equals("Paracloud")) {
                oldParaCloudRelease = release;
                continue;
            }
            UpgradeRequestElement upgradeRequestElement = new UpgradeRequestElement();
            upgradeRequestElement.setCurrentVersion(release.getProductVersion());
            upgradeRequestElement.setProductFamily(release.getProductFamily());
            upgradeRequestElement.setProductMinorGroup(release.getProductMinorGroup());
            upgradeRequestElementList.add(upgradeRequestElement);
        }
        return oldParaCloudRelease;
    }

    private ResponseStatusCodeAndXml getLatestParacloudVersionToDownload(Release release) throws IOException {
        StringBuilder upgradeResponseXml = new StringBuilder();
        StringBuilder urlWithParams = new StringBuilder("https://crm.parablu.com/api").append("/upgrade/paracloud");
        String upgradeRequestXml = this.createUpgradeRequestBody(release);
        if (upgradeRequestXml == null) {
            this.logger.debug("request xml null");
            return null;
        }
        this.logger.debug(upgradeRequestXml);
        HttpsURLConnection conn = null;
        try {
            URL url = new URL(urlWithParams.toString());
            conn = (HttpsURLConnection)url.openConnection();
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/xml");
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(conn.getOutputStream());){
                outputStreamWriter.write(upgradeRequestXml);
                outputStreamWriter.flush();
                outputStreamWriter.close();
            }
            catch (IOException e) {
                this.logger.debug(IO_EXCEPTION, (Throwable)e);
                this.logger.error(IO_EXCEPTION + e.getMessage());
            }
        }
        catch (MalformedURLException ex) {
            this.logger.debug("Exception", (Throwable)ex);
            this.logger.error("MalformedURLException  " + ex.getMessage());
            return null;
        }
        catch (ProtocolException ex) {
            this.logger.debug("Exception", (Throwable)ex);
            this.logger.error("ProtocolException  " + ex.getMessage());
            return null;
        }
        catch (IOException ex) {
            this.logger.debug("Exception", (Throwable)ex);
            this.logger.error(IO_EXCEPTION + ex.getMessage());
        }
        ResponseStatusCodeAndXml responseStatusCodeAndXml = new ResponseStatusCodeAndXml();
        return this.parseResponseAndReturnXML(upgradeResponseXml, responseStatusCodeAndXml, conn);
    }

    private ResponseStatusCodeAndXml getLatestVersionOfClientsToDownload(ClientUpgradeRequestElement clientUpgradeRequestElement) throws IOException {
        StringBuilder upgradeResponseXml = new StringBuilder();
        StringBuilder urlWithParams = new StringBuilder("https://crm.parablu.com/api").append("/upgrade/blusync");
        String upgradeRequestXml = JaxBSerializerHelper.marshallClientUpgradeRequestElement((ClientUpgradeRequestElement)clientUpgradeRequestElement);
        if (upgradeRequestXml == null) {
            return null;
        }
        HttpsURLConnection conn = null;
        try {
            URL url = new URL(urlWithParams.toString());
            conn = (HttpsURLConnection)url.openConnection();
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/xml");
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(conn.getOutputStream());){
                outputStreamWriter.write(upgradeRequestXml);
                outputStreamWriter.flush();
                outputStreamWriter.close();
            }
            catch (IOException e) {
                this.logger.debug("IOException  " + e);
                this.logger.error("IOException  " + e.getMessage());
            }
        }
        catch (MalformedURLException | ProtocolException ex) {
            this.logger.debug("Exception", (Throwable)ex);
            return null;
        }
        catch (IOException ex) {
            this.logger.debug("Exception", (Throwable)ex);
        }
        ResponseStatusCodeAndXml responseStatusCodeAndXml = new ResponseStatusCodeAndXml();
        return this.parseResponseAndReturnXML(upgradeResponseXml, responseStatusCodeAndXml, conn);
    }

    private boolean downloadFileToPath(String downloadPath, String downloadUrl) {
        HttpsURLConnection conn = null;
        boolean success = false;
        try {
            URL url = new URL(downloadUrl);
            conn = (HttpsURLConnection)url.openConnection();
            conn.setDoInput(true);
        }
        catch (MalformedURLException e1) {
            this.logger.debug("MalformedURLException", (Throwable)e1);
            return false;
        }
        catch (IOException e1) {
            this.logger.debug(IO_EXCEPTION, (Throwable)e1);
            return false;
        }
        try {
            File file = new File(downloadPath);
            new File(file.getParent()).mkdirs();
            if (file.exists() && !file.delete()) {
                throw new IOException("couldnt delete file");
            }
            if (!file.createNewFile()) {
                throw new IOException("couldnt create file");
            }
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                IOUtils.copy((InputStream)conn.getInputStream(), (OutputStream)fileOutputStream);
                success = true;
            }
            catch (IOException e) {
                this.logger.debug(IO_EXCEPTION, (Throwable)e);
                this.logger.error(IO_EXCEPTION + e.getMessage());
            }
        }
        catch (IOException e) {
            this.logger.debug(IO_EXCEPTION, (Throwable)e);
        }
        return success;
    }

    private ResponseStatusCodeAndXml parseResponseAndReturnXML(StringBuilder upgradeResponseXml, ResponseStatusCodeAndXml responseStatusCodeAndXml, HttpURLConnection conn) {
        try {
            int responseCode = conn.getResponseCode();
            responseStatusCodeAndXml.setStatusCode(responseCode);
            if (responseCode != 200) {
                return responseStatusCodeAndXml;
            }
            try (BufferedReader buff = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                String inline;
                while ((inline = buff.readLine()) != null) {
                    upgradeResponseXml.append(inline);
                }
            }
            catch (IOException e) {
                this.logger.debug(IO_EXCEPTION + e);
                this.logger.error(IO_EXCEPTION + e.getMessage());
            }
        }
        catch (IOException e) {
            this.logger.debug("Exception", (Throwable)e);
        }
        responseStatusCodeAndXml.setXmlResponse(upgradeResponseXml.toString());
        return responseStatusCodeAndXml;
    }

    private void downloadBlusyncClientOneByOne(List<Release> oldReleaseList, ResponseStatusCodeAndXml responseStatusCodeAndXml) {
        if (responseStatusCodeAndXml.getXmlResponse() != null) {
            ClientUpgradeRequestElement serverResponseForClientUpgradeRequestElement = JaxBSerializerHelper.unMarshallClientUpgradeRequestElement((String)responseStatusCodeAndXml.getXmlResponse());
            if (serverResponseForClientUpgradeRequestElement == null) {
                return;
            }
            for (UpgradeRequestElement element : serverResponseForClientUpgradeRequestElement.getUpgradeRequestElementList()) {
                Release newRelease = this.getReleaseDetailsFromOLdReleaseList(oldReleaseList, element);
                if (newRelease == null) {
                    this.logger.debug("null");
                    continue;
                }
                if (!this.downloadFileToPath(PCHelperConstant.getPropertyFileValueClientDownloadPath() + element.getProductMinorGroup(), element.getDownloadLink())) continue;
                this.upgradeService.updateReleaseDetail(newRelease);
            }
        }
    }

    private String createUpgradeRequestBody(Release release) throws IOException {
        if (release == null) {
            return null;
        }
        UpgradeRequestElement upgradeRequestElement = new UpgradeRequestElement();
        upgradeRequestElement.setCurrentVersion(release.getProductVersion());
        upgradeRequestElement.setProductFamily("Paracloud");
        upgradeRequestElement.setProductMinorGroup("None");
        return JaxBSerializerHelper.marshallUpgradeRequestElement((UpgradeRequestElement)upgradeRequestElement);
    }
}

