/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.backup.service.BackupService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.constant.ParaMailHelperConstant;
import com.parablu.paracloud.element.BackupActivityHistoryElement;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.ReportQueryElement;
import com.parablu.pcbd.domain.User;
import com.parablu.psc.service.UserAndDeviceStatisticService;
import com.parablu.report.service.ReportService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.CollectionUtils;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class CloudOverviewNewTimer
extends QuartzJobBean {
    private Logger logger = LogManager.getLogger(CloudOverviewNewTimer.class);
    private UserAndDeviceStatisticService userAndDeviceStatisticService;
    private ReportService reportService;
    private LicenseService licenseService;
    private CloudMailService cloudMailService;
    private UserManagementService userManagementService;
    private BackupService backupService;
    public static final String PRESCAN_COMMAND_EXECUTION = "PRESCAN_COMMAND_EXECUTION";
    private static final String MM_DD_YYYY = "MM/dd/yyyy";
    private static final String INSIDE_SEND_CLOUD_OVER_VIEW_JOB_TIMER = " @@@@@@@@@@@@@@@@@@@@@@@@@@ inside send cloud over view job timer ";
    private static final String BEFORE_SENDING_MAIL = " @@@ Before sending mail ";
    private static final String PARSE_EXCEPTION = "ParseException  ";
    private static final String NUMBER_FORMAT_EXCEPTION = "NumberFormatException  ";

    public void setBackupService(BackupService backupService) {
        this.backupService = backupService;
    }

    public void setCloudMailService(CloudMailService cloudMailService) {
        this.cloudMailService = cloudMailService;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setUserAndDeviceStatisticService(UserAndDeviceStatisticService userAndDeviceStatisticService) {
        this.userAndDeviceStatisticService = userAndDeviceStatisticService;
    }

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        this.logger.debug("....start of CloudOverviewNewTimer... ");
        if (!PCHelperConstant.isJobEnabled((String)"CloudOverviewNewTimer")) {
            this.logger.debug("CloudOverviewNewTimer ............... disabled");
            return;
        }
        List clouds = this.licenseService.getClouds();
        for (Cloud cloud : clouds) {
            this.sendBackupStatusToUser(cloud, "backup-status-info");
        }
        this.logger.debug("....end of CloudOverviewTimer... ");
    }

    private void getDataForOverviewReport(Cloud cloud) {
        long bkpUsersCount = 0L;
        long syncUsersCount = 0L;
        long noOfFullBackupsDone = 0L;
        long currentlyRunningBkps = 0L;
        List allUsers = this.userManagementService.getAllActiveUsers(cloud.getCloudId());
        for (User user : allUsers) {
            if (user.isBackupEnabled()) {
                ++bkpUsersCount;
            }
            if (!user.isSyncEnabled()) continue;
            ++syncUsersCount;
        }
        List activeOneDriveUsers = this.userManagementService.getActiveOneDriveUsers(cloud.getCloudId());
        List activeExchangeUsers = this.userManagementService.getActiveExchangeUsers(cloud.getCloudId());
        List overViewList = this.userManagementService.getAllOverviewsBasedOnProductType(cloud.getCloudId(), "BACKUP");
        for (DeviceBackupOverView deviceBackupOverView : overViewList) {
            if (StringUtils.isEmpty((String)deviceBackupOverView.getFirstBkpEndTime()) && StringUtils.isEmpty((String)deviceBackupOverView.getLastSuccessfulBkp())) continue;
            ++noOfFullBackupsDone;
        }
        currentlyRunningBkps = this.reportService.getAllBackupBatchForStatus(cloud.getCloudId()).size();
        ReportQueryElement reportQueryElement = new ReportQueryElement();
        reportQueryElement.setNoOfDays(7);
        List devicePolicyDetailsList = this.reportService.getLastAgentServerConnectionDetails(cloud, reportQueryElement);
        List userList = this.userManagementService.getAllUsersWithoutdevice(cloud.getCloudId(), 0, reportQueryElement.getPolicyNames(), false, "BACKUP");
        userList.removeAll(Collections.singleton(null));
        reportQueryElement.setReason("INTERRUPTED");
        long interruptedRecordsCount = this.backupService.getCountAllBackupBatchWthPagination(cloud, cloud.getCloudName(), 0, reportQueryElement);
        reportQueryElement.setReason("PAUSED");
        long pausedRecordsCount = this.backupService.getCountAllBackupBatchWthPagination(cloud, cloud.getCloudName(), 0, reportQueryElement);
        reportQueryElement.setReason("STOPPED");
        long stoppedRecordsCount = this.backupService.getCountAllBackupBatchWthPagination(cloud, cloud.getCloudName(), 0, reportQueryElement);
        reportQueryElement.setReason("EXITED");
        long exitedRecordsCount = this.backupService.getCountAllBackupBatchWthPagination(cloud, cloud.getCloudName(), 0, reportQueryElement);
    }

    private void sendBackupStatusToUser(Cloud cloud, String action) {
        block6: {
            try {
                EmailProps email = new EmailProps();
                ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
                List admins = this.userManagementService.getAllAdmins(cloud.getCloudId(), cloud.getCloudName());
                for (User user : admins) {
                    if (!user.isActive()) continue;
                    EmailRecipent emailRecipent = new EmailRecipent();
                    emailRecipent.setEmail(user.getEmailId());
                    emailRecipent.setUserName(user.getUserName());
                    emailRecipents.add(emailRecipent);
                }
                email.setAction(action);
                StringBuilder bodyData = new StringBuilder();
                email.setDeviceUUID("");
                String url = ParaMailHelperConstant.getPropertyFileValueParacloudUrl() + "/portal/report/incompleteBackup/backup";
                this.logger.debug("......incomplete bkp overview report url...." + url);
                email.setDownloadLink(url);
                bodyData.append(this.setDynamicDeviceTemplate(cloud));
                email.setBodyData(bodyData.toString());
                this.logger.debug(INSIDE_SEND_CLOUD_OVER_VIEW_JOB_TIMER);
                if (emailRecipents.isEmpty()) break block6;
                this.logger.debug(BEFORE_SENDING_MAIL);
                email.setRecipents(emailRecipents);
                this.cloudMailService.sendMail(email);
                int delayTime = PCHelperConstant.getBulkEmailDelay();
                if (delayTime > 0) {
                    try {
                        Thread.sleep((long)delayTime * 1000L);
                    }
                    catch (InterruptedException e) {
                        this.logger.error(" error in sleep >>" + e + "Message is>>" + e.getMessage());
                    }
                }
                this.logger.debug("Delay time is..." + delayTime + " .so sleepinggggg......");
            }
            catch (Exception e) {
                this.logger.error(".......Exception......", (Throwable)e);
                e.printStackTrace();
            }
        }
    }

    private String setDynamicDeviceTemplate(Cloud cloud) {
        StringBuilder finalBodyData = new StringBuilder();
        try {
            StringBuilder bodyData;
            this.logger.debug(".....setDynamicDeviceTemplate......");
            long bkpUsersCount = 0L;
            long oneDrivebkpUsersCount = 0L;
            long exchangebkpUsersCount = 0L;
            long noOfFullBackupsDone = 0L;
            long noOfOnedriveFullBackupsDone = 0L;
            long noOfExchangeFullBackupsDone = 0L;
            List currentlyRunningBkp = new ArrayList();
            long currentlyRunningBkpcount = 0L;
            long currentlyRunningOnedriveBkpcount = 0L;
            long currentlyRunningExchangeBkpcount = 0L;
            boolean isBkpEnabled = this.isLicenseEnabled(cloud, "Backup Enabled");
            boolean isOnedriveBkpEnabled = this.isLicenseEnabled(cloud, "OneDrive Backup Enabled");
            boolean isExchangeBkpEnabled = this.isLicenseEnabled(cloud, "Exchange Backup Enabled");
            currentlyRunningBkp = this.reportService.getAllBackupBatchForStatus(cloud.getCloudId());
            for (BackupBatch bkpBatch : currentlyRunningBkp) {
                if (this.userAndDeviceStatisticService != null) {
                    this.logger.debug("userAndDeviceStatisticService  not null..");
                } else {
                    this.logger.debug("userAndDeviceStatisticService  null..");
                }
                if (bkpBatch.getDeviceUUID() != null) {
                    this.logger.debug("getDeviceUUID  not null..");
                } else {
                    this.logger.debug("getDeviceUUID  null..");
                }
                Device device = this.userAndDeviceStatisticService.getDeviceInfoByUUID(cloud.getCloudId(), cloud.getCloudName(), bkpBatch.getDeviceUUID());
                if (device != null && device.getDeviceType().equalsIgnoreCase("BACKUP")) {
                    ++currentlyRunningBkpcount;
                    continue;
                }
                if (device != null && device.getDeviceType().equalsIgnoreCase("ONEDRIVE")) {
                    ++currentlyRunningOnedriveBkpcount;
                    continue;
                }
                if (device == null || !device.getDeviceType().equalsIgnoreCase("OUTLOOK")) continue;
                ++currentlyRunningExchangeBkpcount;
            }
            ReportQueryElement reportQueryElement = new ReportQueryElement();
            reportQueryElement.setNoOfDays(7);
            long usersWithoutAgent = 0L;
            long onedriveUsersWithoutAgent = 0L;
            long exchangeUsersWithoutAgent = 0L;
            long notHeardDevicesCount = 0L;
            long interruptedRecordsCount = 0L;
            long onedriveInterruptedRecordsCount = 0L;
            long exchangeInterruptedRecordsCount = 0L;
            long pausedRecordsCount = 0L;
            long onedrivePausedRecordsCount = 0L;
            long exchangepausedRecordsCount = 0L;
            long stoppedRecordsCount = 0L;
            long onedriveStoppedRecordsCount = 0L;
            long exchangeStoppedRecordsCount = 0L;
            long exitedRecordsCount = 0L;
            long onedriveExitedRecordsCount = 0L;
            long exchangeExitedRecordsCount = 0L;
            long totalInterruptedRecordsCount = 0L;
            long totalOnerdriveInterruptedRecordsCount = 0L;
            long totalExchangeInterruptedRecordsCount = 0L;
            reportQueryElement.setReason("INTERRUPTED");
            List bkpBatchForInterrupted = this.backupService.getAllBackupBatchWthoutPagination(cloud, cloud.getCloudName(), 0, reportQueryElement);
            for (Object bkpBatch : bkpBatchForInterrupted) {
                Device device = this.userAndDeviceStatisticService.getDeviceInfoByUUID(cloud.getCloudId(), cloud.getCloudName(), bkpBatch.getDeviceUUID());
                User user = this.userAndDeviceStatisticService.getUserDetails(cloud.getCloudId(), device.getUserName());
                if (device == null || device.isBlocked() || user == null || !user.isActive()) continue;
                if (device != null && device.getDeviceType().equalsIgnoreCase("BACKUP")) {
                    ++interruptedRecordsCount;
                    continue;
                }
                if (device != null && device.getDeviceType().equalsIgnoreCase("ONEDRIVE")) {
                    ++onedriveInterruptedRecordsCount;
                    continue;
                }
                if (device == null || !device.getDeviceType().equalsIgnoreCase("OUTLOOK")) continue;
                ++exchangeInterruptedRecordsCount;
            }
            reportQueryElement.setReason("PAUSED");
            List bkpBatchForPaused = this.backupService.getAllBackupBatchWthoutPagination(cloud, cloud.getCloudName(), 0, reportQueryElement);
            for (Object bkpBatch : bkpBatchForPaused) {
                Device device = this.userAndDeviceStatisticService.getDeviceInfoByUUID(cloud.getCloudId(), cloud.getCloudName(), bkpBatch.getDeviceUUID());
                User user = this.userAndDeviceStatisticService.getUserDetails(cloud.getCloudId(), device.getUserName());
                if (device == null || device.isBlocked() || user == null || !user.isActive()) continue;
                if (device != null && device.getDeviceType().equalsIgnoreCase("BACKUP")) {
                    ++pausedRecordsCount;
                    continue;
                }
                if (device != null && device.getDeviceType().equalsIgnoreCase("ONEDRIVE")) {
                    ++onedrivePausedRecordsCount;
                    continue;
                }
                if (device == null || !device.getDeviceType().equalsIgnoreCase("OUTLOOK")) continue;
                ++exchangepausedRecordsCount;
            }
            reportQueryElement.setReason("STOPPED");
            List bkpBatchForStopped = this.backupService.getAllBackupBatchWthoutPagination(cloud, cloud.getCloudName(), 0, reportQueryElement);
            for (Object bkpBatch : bkpBatchForStopped) {
                Device device = this.userAndDeviceStatisticService.getDeviceInfoByUUID(cloud.getCloudId(), cloud.getCloudName(), bkpBatch.getDeviceUUID());
                Object user = this.userAndDeviceStatisticService.getUserDetails(cloud.getCloudId(), device.getUserName());
                if (device == null || device.isBlocked() || user == null || !user.isActive()) continue;
                if (device != null && device.getDeviceType().equalsIgnoreCase("BACKUP")) {
                    ++stoppedRecordsCount;
                    continue;
                }
                if (device != null && device.getDeviceType().equalsIgnoreCase("ONEDRIVE")) {
                    ++onedriveStoppedRecordsCount;
                    continue;
                }
                if (device == null || !device.getDeviceType().equalsIgnoreCase("OUTLOOK")) continue;
                ++exchangeStoppedRecordsCount;
            }
            reportQueryElement.setReason("EXITED");
            List bkpBatchForExit = this.backupService.getAllBackupBatchWthoutPagination(cloud, cloud.getCloudName(), 0, reportQueryElement);
            for (Object bkpBatch : bkpBatchForExit) {
                Device device = this.userAndDeviceStatisticService.getDeviceInfoByUUID(cloud.getCloudId(), cloud.getCloudName(), bkpBatch.getDeviceUUID());
                User user = this.userAndDeviceStatisticService.getUserDetails(cloud.getCloudId(), device.getUserName());
                if (device == null || device.isBlocked() || user == null || !user.isActive()) continue;
                if (device != null && device.getDeviceType().equalsIgnoreCase("BACKUP")) {
                    ++exitedRecordsCount;
                    continue;
                }
                if (device != null && device.getDeviceType().equalsIgnoreCase("ONEDRIVE")) {
                    ++onedriveExitedRecordsCount;
                    continue;
                }
                if (device == null || !device.getDeviceType().equalsIgnoreCase("OUTLOOK")) continue;
                ++exchangeExitedRecordsCount;
            }
            if (isBkpEnabled) {
                List allUsers = this.userManagementService.getAllActiveUsers(cloud.getCloudId());
                for (Object user : allUsers) {
                    if (!user.isBackupEnabled()) continue;
                    ++bkpUsersCount;
                }
                List overViewList = this.userManagementService.getAllOverviewsBasedOnProductType(cloud.getCloudId(), "BACKUP");
                for (DeviceBackupOverView deviceBackupOverView : overViewList) {
                    if (deviceBackupOverView.isDeviceBolcked() || !deviceBackupOverView.isUserActive() || StringUtils.isEmpty((String)deviceBackupOverView.getFirstBkpEndTime()) && StringUtils.isEmpty((String)deviceBackupOverView.getLastSuccessfulBkp())) continue;
                    ++noOfFullBackupsDone;
                }
                this.logger.debug(".....setDynamicDeviceTemplate.....22222222.");
                reportQueryElement.setNoOfDays(7);
                List notHeardDevices = this.reportService.getLastAgentServerConnectionDetails(cloud, reportQueryElement);
                notHeardDevicesCount = notHeardDevices.size();
                List userWitoutAgent = this.userManagementService.getAllUsersWithoutdevice(cloud.getCloudId(), 0, reportQueryElement.getPolicyNames(), false, "BACKUP");
                userWitoutAgent.removeAll(Collections.singleton(null));
                usersWithoutAgent = userWitoutAgent.size();
            }
            List overViewList = this.userManagementService.getAllOverviewsBasedOnProductType(cloud.getCloudId(), "office");
            if (isOnedriveBkpEnabled) {
                List activeOneDriveUsers = this.userManagementService.getActiveOneDriveUsers(cloud.getCloudId());
                oneDrivebkpUsersCount = activeOneDriveUsers.size();
                for (DeviceBackupOverView deviceBackupOverView : overViewList) {
                    if (deviceBackupOverView.isDeviceBolcked() || !deviceBackupOverView.isUserActive() || !deviceBackupOverView.getDeviceType().equalsIgnoreCase("ONEDRIVE") || StringUtils.isEmpty((String)deviceBackupOverView.getFirstBkpEndTime()) && StringUtils.isEmpty((String)deviceBackupOverView.getLastSuccessfulBkp())) continue;
                    ++noOfOnedriveFullBackupsDone;
                }
                List userWithoutAgentOnedrive = this.userManagementService.getAllUsersWithoutdevice(cloud.getCloudId(), 0, reportQueryElement.getPolicyNames(), false, "ONEDRIVE");
                userWithoutAgentOnedrive.removeAll(Collections.singleton(null));
                onedriveUsersWithoutAgent = userWithoutAgentOnedrive.size();
            }
            if (isExchangeBkpEnabled) {
                List activeExchangeUsers = this.userManagementService.getActiveExchangeUsers(cloud.getCloudId());
                exchangebkpUsersCount = activeExchangeUsers.size();
                for (DeviceBackupOverView deviceBackupOverView : overViewList) {
                    if (deviceBackupOverView.isDeviceBolcked() || !deviceBackupOverView.isUserActive() || !deviceBackupOverView.getDeviceType().equalsIgnoreCase("OUTLOOK") || StringUtils.isEmpty((String)deviceBackupOverView.getFirstBkpEndTime()) && StringUtils.isEmpty((String)deviceBackupOverView.getLastSuccessfulBkp())) continue;
                    ++noOfExchangeFullBackupsDone;
                }
                List userWithoutAgentMail = this.userManagementService.getAllUsersWithoutdevice(cloud.getCloudId(), 0, reportQueryElement.getPolicyNames(), true, "MAIL");
                userWithoutAgentMail.removeAll(Collections.singleton(null));
                exchangeUsersWithoutAgent = userWithoutAgentMail.size();
            }
            totalInterruptedRecordsCount = 0L;
            totalOnerdriveInterruptedRecordsCount = 0L;
            totalExchangeInterruptedRecordsCount = 0L;
            totalInterruptedRecordsCount = interruptedRecordsCount + pausedRecordsCount + stoppedRecordsCount + exitedRecordsCount;
            totalOnerdriveInterruptedRecordsCount = onedriveInterruptedRecordsCount + onedrivePausedRecordsCount + onedriveStoppedRecordsCount + onedriveExitedRecordsCount;
            totalExchangeInterruptedRecordsCount = exchangeInterruptedRecordsCount + exchangeStoppedRecordsCount + exchangepausedRecordsCount + exchangeExitedRecordsCount;
            if (isExchangeBkpEnabled) {
                bodyData = new StringBuilder("<table class=\"table\" style=\"width:75%\">");
                bodyData.append("<thead>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th style=\"border: 1px solid black;text-align: left\">").append("Number of Exchange Backup").append("<br>").append("Users Allowed").append("</th>").append("<th colspan=\"4\" style=\"border: 1px solid black;text-align: center\">").append(cloud.getNoOfExchangeUsersAllowed()).append("</th>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th style=\"border: 1px solid black;text-align: left\">").append("Number of active users").append("</th>").append("<th colspan=\"4\" style=\"border: 1px solid black;text-align: center\">").append(Optional.ofNullable(String.valueOf(exchangebkpUsersCount)).orElse("0")).append("</th>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th style=\"border: 1px solid black;text-align: left\">").append("Number of first backups completed").append("</th>").append("<th colspan=\"4\" style=\"border: 1px solid black;text-align: center\">").append(Optional.ofNullable(String.valueOf(noOfExchangeFullBackupsDone)).orElse("0")).append("</th>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th style=\"border: 1px solid black;text-align: left\">").append("Number of backups currently running").append("</th>").append("<th colspan=\"4\" style=\"border: 1px solid black;text-align: center\">").append(Optional.ofNullable(String.valueOf(currentlyRunningExchangeBkpcount)).orElse("0")).append("</th>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th style=\"border: 1px solid black;text-align: left\">").append("Number of backups incomplete").append("</th>").append("<th colspan=\"4\" style=\"border: 1px solid black;text-align: center\">").append(Optional.ofNullable(String.valueOf(totalExchangeInterruptedRecordsCount)).orElse("0")).append("</th>").append("</tr>").append("<tr align=\"center\"  style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;text-align: center;\">").append(" Interrupted").append("</td>").append("<td style=\"border: 1px solid black;text-align: center;\">").append(Optional.ofNullable(String.valueOf(exchangeInterruptedRecordsCount)).orElse("0")).append("</td>").append("</tr>").append("<tr align=\"center\"  style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;text-align: center;\">").append(" Paused").append("</td>").append("<td style=\"border: 1px solid black;text-align: center;\">").append(Optional.ofNullable(String.valueOf(exchangepausedRecordsCount)).orElse("0")).append("</td>").append("</tr>").append("<tr align=\"center\"  style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;text-align: center;\">").append(" Stopped").append("</td>").append("<td style=\"border: 1px solid black;text-align: center;\">").append(Optional.ofNullable(String.valueOf(exchangeStoppedRecordsCount)).orElse("0")).append("</td>").append("</tr>").append("<tr align=\"center\"  style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;text-align: center;\">").append(" User exited the agent").append("</td>").append("<td style=\"border: 1px solid black;text-align: center;\">").append(Optional.ofNullable(String.valueOf(exchangeExitedRecordsCount)).orElse("0")).append("</td>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th style=\"border: 1px solid black;text-align: left\">").append("Number of users without agent").append("</th>").append("<th colspan=\"4\" style=\"border: 1px solid black;text-align: center\">").append(Optional.ofNullable(String.valueOf(exchangeUsersWithoutAgent)).orElse("0")).append("</th>").append("</tr>");
                bodyData.append("</tbody>").append("</table>").append("<br>");
                finalBodyData.append((CharSequence)bodyData);
            }
            if (isOnedriveBkpEnabled) {
                bodyData = new StringBuilder("<table class=\"table\" style=\"width:75%\">");
                bodyData.append("<thead>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th style=\"border: 1px solid black;text-align: left\">").append("Number of Onedrive Backup Users Allowed").append("</th>").append("<th colspan=\"4\" style=\"border: 1px solid black;text-align: center\">").append(cloud.getNoOfOneDriveUsersAllowed()).append("</th>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th style=\"border: 1px solid black;text-align: left\">").append("Number of active users").append("</th>").append("<th colspan=\"4\" style=\"border: 1px solid black;text-align: center\">").append(Optional.ofNullable(String.valueOf(oneDrivebkpUsersCount)).orElse("0")).append("</th>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th style=\"border: 1px solid black;text-align: left\">").append("Number of first backups completed").append("</th>").append("<th colspan=\"4\" style=\"border: 1px solid black;text-align: center\">").append(Optional.ofNullable(String.valueOf(noOfOnedriveFullBackupsDone)).orElse("0")).append("</th>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th style=\"border: 1px solid black;text-align: left\">").append("Number of backups currently running").append("</th>").append("<th colspan=\"4\" style=\"border: 1px solid black;text-align: center\">").append(Optional.ofNullable(String.valueOf(currentlyRunningOnedriveBkpcount)).orElse("0")).append("</th>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th style=\"border: 1px solid black;text-align: left\">").append("Number of backups incomplete").append("</th>").append("<th colspan=\"4\" style=\"border: 1px solid black;text-align: center\">").append(Optional.ofNullable(String.valueOf(totalOnerdriveInterruptedRecordsCount)).orElse("0")).append("</th>").append("</tr>").append("<tr align=\"center\"  style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;text-align: center;\">").append(" Interrupted").append("</td>").append("<td style=\"border: 1px solid black;text-align: center;\">").append(Optional.ofNullable(String.valueOf(onedriveInterruptedRecordsCount)).orElse("0")).append("</td>").append("</tr>").append("<tr align=\"center\"  style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;text-align: center;\">").append(" Paused").append("</td>").append("<td style=\"border: 1px solid black;text-align: center;\">").append(Optional.ofNullable(String.valueOf(onedrivePausedRecordsCount)).orElse("0")).append("</td>").append("</tr>").append("<tr align=\"center\"  style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;text-align: center;\">").append(" Stopped").append("</td>").append("<td style=\"border: 1px solid black;text-align: center;\">").append(Optional.ofNullable(String.valueOf(onedriveStoppedRecordsCount)).orElse("0")).append("</td>").append("</tr>").append("<tr align=\"center\"  style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;text-align: center;\">").append(" User exited the agent").append("</td>").append("<td style=\"border: 1px solid black;text-align: center;\">").append(Optional.ofNullable(String.valueOf(onedriveExitedRecordsCount)).orElse("0")).append("</td>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th style=\"border: 1px solid black;text-align: left\">").append("Number of users without agent").append("</th>").append("<th colspan=\"4\" style=\"border: 1px solid black;text-align: center\">").append(Optional.ofNullable(String.valueOf(onedriveUsersWithoutAgent)).orElse("0")).append("</th>").append("</tr>");
                bodyData.append("</tbody>").append("</table>").append("<br>");
                finalBodyData.append((CharSequence)bodyData);
            }
            if (isBkpEnabled) {
                bodyData = new StringBuilder("<table class=\"table\" style=\"width:75%\">");
                bodyData.append("<thead>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th style=\"border: 1px solid black;text-align: left\">").append("Number of Backup Users Allowed").append("</th>").append("<th colspan=\"4\" style=\"border: 1px solid black;text-align: center\">").append(cloud.getNoOfBackupUsersAllowed()).append("</th>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th style=\"border: 1px solid black;text-align: left\">").append("Number of active users").append("</th>").append("<th colspan=\"4\" style=\"border: 1px solid black;text-align: center\">").append(Optional.ofNullable(String.valueOf(bkpUsersCount)).orElse("0")).append("</th>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th style=\"border: 1px solid black;text-align: left\">").append("Number of first backups completed").append("</th>").append("<th colspan=\"4\" style=\"border: 1px solid black;text-align: center\">").append(Optional.ofNullable(String.valueOf(noOfFullBackupsDone)).orElse("0")).append("</th>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th style=\"border: 1px solid black;text-align: left\">").append("Number of backups currently running").append("</th>").append("<th colspan=\"4\" style=\"border: 1px solid black;text-align: center\">").append(Optional.ofNullable(String.valueOf(currentlyRunningBkpcount)).orElse("0")).append("</th>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th style=\"border: 1px solid black;text-align: left\">").append("Number of backups incomplete").append("</th>").append("<th colspan=\"4\" style=\"border: 1px solid black;text-align: center\">").append(Optional.ofNullable(String.valueOf(totalInterruptedRecordsCount)).orElse("0")).append("</th>").append("</tr>").append("<tr align=\"center\"  style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;text-align: center;\">").append(" Interrupted").append("</td>").append("<td style=\"border: 1px solid black;text-align: center;\">").append(Optional.ofNullable(String.valueOf(interruptedRecordsCount)).orElse("0")).append("</td>").append("</tr>").append("<tr align=\"center\"  style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;text-align: center;\">").append("Paused").append("</td>").append("<td style=\"border: 1px solid black;text-align: center;\">").append(Optional.ofNullable(String.valueOf(pausedRecordsCount)).orElse("0")).append("</td>").append("</tr>").append("<tr align=\"center\"  style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;text-align: center;\">").append(" Stopped").append("</td>").append("<td style=\"border: 1px solid black;text-align: center;\">").append(Optional.ofNullable(String.valueOf(stoppedRecordsCount)).orElse("0")).append("</td>").append("</tr>").append("<tr align=\"center\"  style=\"border: 1px solid black;\">").append("<td style=\"border: 1px solid black;text-align: center;\">").append(" User exited the agent").append("</td>").append("<td style=\"border: 1px solid black;text-align: center;\">").append(Optional.ofNullable(String.valueOf(exitedRecordsCount)).orElse("0")).append("</td>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th style=\"border: 1px solid black;text-align: left\">").append("Number of devices that have").append("<br>").append("not communicated for 7 days").append("</th>").append("<th colspan=\"4\" style=\"border: 1px solid black;text-align: center\">").append(Optional.ofNullable(String.valueOf(notHeardDevicesCount)).orElse("0")).append("</th>").append("</tr>").append("<tr align=\"center\" style=\"border: 1px solid black;\">").append("<th style=\"border: 1px solid black;text-align: left\">").append("Number of users without agent").append("</th>").append("<th colspan=\"4\" style=\"border: 1px solid black;text-align: center\">").append(Optional.ofNullable(String.valueOf(usersWithoutAgent)).orElse("0")).append("</th>").append("</tr>");
                bodyData.append("</tbody>").append("</table>").append("<br>");
                finalBodyData.append((CharSequence)bodyData);
            }
            this.logger.debug("....bodydatamy...." + finalBodyData.toString());
            return finalBodyData.toString();
        }
        catch (Exception e) {
            this.logger.error("...Exception.....", (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    private boolean checkIsBkpRunning(List<BackupActivityHistoryElement> backupHistoryElements) {
        boolean result = false;
        if (!CollectionUtils.isEmpty(backupHistoryElements) && backupHistoryElements.size() == 1 && backupHistoryElements.get(0) != null) {
            try {
                Date batchStartDate = new SimpleDateFormat(MM_DD_YYYY).parse(backupHistoryElements.get(0).getStartTime());
                Date batchEndDate = new SimpleDateFormat(MM_DD_YYYY).parse(backupHistoryElements.get(0).getStartTime());
                Calendar cal = Calendar.getInstance();
                cal.add(5, -8);
                Date mailStartDate = cal.getTime();
                boolean isBefore = mailStartDate.before(batchStartDate);
                cal = Calendar.getInstance();
                cal.add(5, -1);
                Date mailEndDate = cal.getTime();
                boolean isAfter = batchEndDate.after(mailEndDate);
                if (isAfter && isBefore) {
                    result = true;
                }
            }
            catch (ParseException e) {
                this.logger.debug(NUMBER_FORMAT_EXCEPTION + e);
                this.logger.error(NUMBER_FORMAT_EXCEPTION + e.getMessage());
            }
        }
        return result;
    }

    private boolean isLicenseEnabled(Cloud cl, String licenseName) {
        boolean isLicenseScanEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !licenseName.equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isLicenseScanEnabled = true;
                break;
            }
        }
        this.logger.debug("is " + licenseName + " License Enabled...." + isLicenseScanEnabled);
        return isLicenseScanEnabled;
    }
}

