/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.report.service.ReportService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.CollectionUtils;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class CheckLicenceExpiryTimer
extends QuartzJobBean {
    public static final String EMAIL_IDS = "emailIds";
    private Logger logger = LogManager.getLogger(CheckLicenceExpiryTimer.class);
    private static final String EXCEPTION = "Exception :";
    private LicenseService licenseService;
    private CloudMailService cloudMailService;
    private ReportService reportService;
    private UserManagementService userManagementService;

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setCloudMailService(CloudMailService cloudMailService) {
        this.cloudMailService = cloudMailService;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"checkLicenceExpiry")) {
            this.logger.debug("CheckLicenceExpiryTimer ............... disabled");
            return;
        }
        this.logger.debug("   start of job Checking the Licence Expiry .... ");
        try {
            List clouds = this.licenseService.getClouds();
            if (!CollectionUtils.isEmpty((Collection)clouds)) {
                for (Cloud cloud : clouds) {
                    Map reportConfigProperties = this.reportService.getReportConfig(cloud.getCloudId(), "licenceExpiry");
                    if (!CollectionUtils.isEmpty((Map)reportConfigProperties)) {
                        Date date = new Date(cloud.getValidityPeriod());
                        DateTime validityPeriod = new DateTime((Object)date);
                        DateTime currentDateTime = new DateTime();
                        boolean isCurrentTimeGreater = currentDateTime.toDate().getTime() > validityPeriod.toDate().getTime();
                        long difference = CheckLicenceExpiryTimer.removeTime(validityPeriod.toDate()).getTime() - CheckLicenceExpiryTimer.removeTime(currentDateTime.toDate()).getTime();
                        int daysDiff = (int)(difference / 86400000L);
                        this.logger.debug("Days Difference" + daysDiff);
                        ArrayList<String> emailIds = new ArrayList();
                        if (reportConfigProperties.get(EMAIL_IDS) != null) {
                            String strSpaceRemoval = reportConfigProperties.get(EMAIL_IDS).toString().replaceAll(" ", "");
                            if (StringUtils.isEmpty((String)strSpaceRemoval)) continue;
                            emailIds = Arrays.asList(((String)reportConfigProperties.get(EMAIL_IDS)).split(","));
                        } else {
                            this.logger.debug("Email id's is empty so send mail to all admin");
                            List adminList = this.userManagementService.getAllAdmins(cloud.getCloudId(), cloud.getCloudName());
                            emailIds = adminList.stream().filter(user -> !StringUtils.isEmpty((String)user.getEmailId())).map(user -> user.getEmailId()).collect(Collectors.toList());
                        }
                        if (reportConfigProperties.get("days") != null) {
                            ArrayList<Integer> compareDay = this.getIntegerArray(reportConfigProperties.get("days").toString());
                            if (daysDiff >= 0 && compareDay.contains(daysDiff)) {
                                if (daysDiff == 0 && isCurrentTimeGreater) {
                                    this.sendmailForExpired(cloud, emailIds, date);
                                } else {
                                    this.sendmail(cloud, emailIds, date);
                                }
                            }
                            if (daysDiff < 0) {
                                this.sendmailForExpired(cloud, emailIds, date);
                            }
                        }
                        if (daysDiff >= 0 || reportConfigProperties.get("days") != null) continue;
                        this.sendmailForExpired(cloud, emailIds, date);
                        continue;
                    }
                    this.logger.debug("   reportConfig is empty .... ");
                }
            } else {
                this.logger.debug("   cloud is empty .... ");
            }
        }
        catch (Exception e) {
            this.logger.trace(EXCEPTION + e);
            this.logger.error(EXCEPTION + e.getMessage());
        }
    }

    private void sendmail(Cloud cloud, List<String> userMailIds, Date validityPeriod) {
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction("licence-expiry-notification");
        email.setClientMailName(PCHelperConstant.getClientMailName());
        email.setCloudName(cloud.getCloudName());
        SimpleDateFormat sdf = new SimpleDateFormat("dd:MM:yyyy");
        sdf.setTimeZone(TimeZone.getTimeZone("IST"));
        email.setStartDate(sdf.format(validityPeriod));
        for (String userEmail : userMailIds) {
            EmailRecipent emailRecipent = new EmailRecipent();
            emailRecipent.setEmail(userEmail);
            emailRecipents.add(emailRecipent);
        }
        this.logger.debug(" @@@ Before sending mail ");
        email.setRecipents(emailRecipents);
        this.cloudMailService.sendMail(email);
    }

    private ArrayList<Integer> getIntegerArray(String string) {
        List<String> stringArray = Arrays.asList(string.split(","));
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String stringValue : stringArray) {
            try {
                result.add(Integer.parseInt(stringValue));
            }
            catch (NumberFormatException e) {
                this.logger.trace(EXCEPTION + e);
                this.logger.error(EXCEPTION + e.getMessage());
            }
        }
        return result;
    }

    private void sendmailForExpired(Cloud cloud, List<String> userMailIds, Date validityPeriod) {
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction("licence-expiried-notification");
        email.setClientMailName(PCHelperConstant.getClientMailName());
        email.setCloudName(cloud.getCloudName());
        SimpleDateFormat sdf = new SimpleDateFormat("dd:MM:yyyy");
        sdf.setTimeZone(TimeZone.getTimeZone("IST"));
        email.setStartDate(sdf.format(validityPeriod));
        for (String userEmail : userMailIds) {
            EmailRecipent emailRecipent = new EmailRecipent();
            emailRecipent.setEmail(userEmail);
            emailRecipents.add(emailRecipent);
        }
        this.logger.debug(" @@@ Before sending mail ");
        email.setRecipents(emailRecipents);
        this.cloudMailService.sendMail(email);
    }

    public static Date removeTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }
}

