/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.cloud.security.service.LicenseService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.ReportQueryElement;
import com.parablu.report.service.ReportService;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class BackupOverviewCreateExcelTimer
extends QuartzJobBean {
    private Logger logger = LogManager.getLogger(BackupOverviewCreateExcelTimer.class);
    private ReportService reportService;
    private LicenseService licenseService;

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"backupOverviewExcelTrigger")) {
            this.logger.debug("BackupOverviewCreateExcelTimer ............. disabled");
            return;
        }
        List clouds = this.licenseService.getClouds();
        for (Cloud cloud : clouds) {
            this.logger.debug(" before create excel records in overview table .... ");
            ReportQueryElement reportQueryElement = new ReportQueryElement();
            this.reportService.createExcelForBackupOverview(cloud, reportQueryElement, null);
            this.logger.debug(" end of create excel in overview table .... ");
        }
    }
}

