/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.cloud.security.service.LicenseService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.domain.Cloud;
import java.io.File;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class BackupDeleteFileTimerImpl
extends QuartzJobBean {
    private static Logger logger = LogManager.getLogger(BackupDeleteFileTimerImpl.class);
    private LicenseService licenseService;

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"backupDeleteTimerTrigger")) {
            logger.debug("BackupDeleteFileTimerImpl ............ disabled");
            return;
        }
        List clouds = this.licenseService.getClouds();
        if (clouds == null) {
            return;
        }
        int limit = 500;
        for (Cloud cloud : clouds) {
            if (!this.checkIfDeviceIsAttached(cloud.getCloudName())) continue;
            logger.debug("BEFORECALL getCountOfAllLatestBackupRevisions ..... ");
            try {
                Long backupRevisionCount = null;
                int i = 0;
                while ((long)i < backupRevisionCount) {
                    i += limit;
                }
            }
            catch (Exception e) {
                logger.error("BEFORECALL getCountOfAllLatestBackupRevisions EXCEPTION ..... " + e.getMessage());
                logger.debug("BEFORECALL getCountOfAllLatestBackupRevisions EXCEPTION ..... " + e);
            }
        }
    }

    protected boolean checkIfDeviceIsAttached(String cloudName) {
        return new File(PCHelperConstant.getPropertyFileValueParabluFolderBasePath((String)cloudName)).exists();
    }
}

