/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.mail.service.CloudMailService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.element.UserElement;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.rf.service.BackupBatchService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.StatefulJob;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class BackupBatchJobTimer
extends QuartzJobBean
implements StatefulJob {
    private Logger logger = LogManager.getLogger(BackupBatchJobTimer.class);
    private BackupBatchService backupBatchService;
    private LicenseService licenseService;
    private CloudMailService cloudMailService;
    private UserManagementService userManagementService;

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setBackupBatchService(BackupBatchService backupBatchService) {
        this.backupBatchService = backupBatchService;
    }

    public void setCloudMailService(CloudMailService cloudMailService) {
        this.cloudMailService = cloudMailService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"cronTrigger")) {
            this.logger.debug("BackupBatchJobTimer ............... disabled");
            return;
        }
        List clouds = this.licenseService.getClouds();
        for (Cloud cloud : clouds) {
            List incompleteBackupList = this.backupBatchService.getAllBackupBatchForStatus(cloud.getCloudId(), cloud.getCloudName(), BackupBatch.STATUS.STARTED.toString());
            for (BackupBatch backupBatch : incompleteBackupList) {
                this.sendEmail(backupBatch, "failed-backup", cloud);
            }
            List failedBackupList = this.backupBatchService.getAllBackupBatchForStatus(cloud.getCloudId(), cloud.getCloudName(), BackupBatch.STATUS.FAILED.toString());
            for (BackupBatch backupBatch : failedBackupList) {
                Long diffTime = System.currentTimeMillis() - backupBatch.getBatchStartTimestamp();
                if (diffTime >= 86400000L && diffTime < 172800000L) {
                    this.sendEmail(backupBatch, "failed-backup-day", cloud);
                }
                if (diffTime >= 604800000L && diffTime < 691200000L) {
                    this.sendEmail(backupBatch, "failed-backup-week", cloud);
                }
                if (diffTime < 2592000000L) continue;
                this.sendEmail(backupBatch, "failed-backup-month", cloud);
            }
        }
    }

    private void sendEmail(BackupBatch backupBatch, String action, Cloud cloud) {
        UserElement user = this.userManagementService.getUserByUserNameOrEmail(cloud, backupBatch.getUserName());
        if (user != null) {
            EmailProps email = new EmailProps();
            ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
            email.setAction(action);
            EmailRecipent emailRecipent = new EmailRecipent();
            emailRecipent.setUserName(user.getUserName());
            emailRecipent.setEmail(user.getEmailId());
            email.setActionBy(user.getUserName());
            email.setStartDate(this.getDate(backupBatch.getBatchStartTimestamp()));
            if (PCHelperConstant.getPropertyFileValueEmailsToadminsOnly()) {
                if (user.isAdmin()) {
                    emailRecipents.add(emailRecipent);
                }
            } else {
                emailRecipents.add(emailRecipent);
            }
            this.logger.debug(" @@@@@@@@@@@@@@@@@@@@@@@@@@ inside backup job timer " + backupBatch.getId());
            if (!emailRecipents.isEmpty()) {
                this.logger.debug(" @@@ Before sending mail ");
                email.setRecipents(emailRecipents);
                this.cloudMailService.sendMail(email);
            }
        } else {
            this.logger.error("..user is not available for email.... " + backupBatch.getUserName());
        }
    }

    private String getDate(long dateVal) {
        Date date = new Date(dateVal);
        SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        return df2.format(date);
    }
}

