/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.DeviceElement;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.rf.service.BackupBatchService;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.StatefulJob;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.CollectionUtils;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class BackupBatchCleanTimer
extends QuartzJobBean
implements StatefulJob {
    private Logger logger = LogManager.getLogger(BackupBatchCleanTimer.class);
    @Autowired
    private BackupBatchService backupBatchService;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private int noOfBackupBatchToKeep;
    @Autowired
    private DeviceManagementService deviceManagementService;

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"backupBatchCleanerTrigger")) {
            this.logger.debug("BackupBatchCleanTimer ............... disabled");
            return;
        }
        List clouds = this.licenseService.getClouds();
        if (this.noOfBackupBatchToKeep <= 0) {
            this.logger.debug("noOfBackupBatchToKeep is lesser than 0 so return");
            return;
        }
        block0: for (Cloud cloud : clouds) {
            int skipValue = 0;
            while (true) {
                this.logger.debug("..........................." + cloud.getCloudId());
                this.logger.debug("..........................." + this.deviceManagementService.getAllDeviceCount(cloud.getCloudId()));
                List deviceList = this.deviceManagementService.getAllDevicesWithPagination(cloud.getCloudId(), skipValue, null, "");
                if (CollectionUtils.isEmpty((Collection)deviceList)) continue block0;
                for (DeviceElement device : deviceList) {
                    this.logger.debug("Cleaning the backupBatch for deviceUUID : " + device.getDeviceUUID());
                    this.backupBatchService.cleanBackupBatchForDeviceUUID(cloud.getCloudId(), device.getDeviceUUID(), this.noOfBackupBatchToKeep);
                }
                ++skipValue;
            }
        }
    }

    public BackupBatchService getBackupBatchService() {
        return this.backupBatchService;
    }

    public void setBackupBatchService(BackupBatchService backupBatchService) {
        this.backupBatchService = backupBatchService;
    }

    public LicenseService getLicenseService() {
        return this.licenseService;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public int getNoOfBackupBatchToKeep() {
        return this.noOfBackupBatchToKeep;
    }

    public void setNoOfBackupBatchToKeep(int noOfBackupBatchToKeep) {
        this.noOfBackupBatchToKeep = noOfBackupBatchToKeep;
    }

    public DeviceManagementService getDeviceManagementService() {
        return this.deviceManagementService;
    }

    public void setDeviceManagementService(DeviceManagementService deviceManagementService) {
        this.deviceManagementService = deviceManagementService;
    }
}

