/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.domain.Cloud;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class AutoDeleteUserTimer
extends QuartzJobBean {
    private Logger logger = LogManager.getLogger(AutoDeleteUserTimer.class);
    private UserManagementService userManagementService;
    private LicenseService licenseService;

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"autoDeleteUserTimerTrigger")) {
            this.logger.debug("autoDeleteUserTimerTrigger ............. disabled");
            return;
        }
        this.logger.debug("   start of job autoDeleteUserTimerTrigger .... ");
        List clouds = this.licenseService.getClouds();
        for (Cloud cloud : clouds) {
            this.userManagementService.autoDeleteUser(cloud);
        }
        this.logger.debug("   end of job autoDeleteUserTimerTrigger .... ");
    }

    public UserManagementService getUserManagementService() {
        return this.userManagementService;
    }

    public void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public LicenseService getLicenseService() {
        return this.licenseService;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }
}

