/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.AuthorizationService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.User;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.SchedulerException;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class AuthorizationTokenCleanerTimer
extends QuartzJobBean {
    private Logger logger = LogManager.getLogger(AuthorizationTokenCleanerTimer.class);
    private LicenseService licenseService;
    private AuthorizationService authorizationService;
    private UserManagementService managementService;

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public void setManagementService(UserManagementService managementService) {
        this.managementService = managementService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"authorizationTokenCleanerTimerTrigger")) {
            this.logger.debug("AuthorizationTokenCleanerTimer ........... disabled");
            return;
        }
        try {
            List jobs = arg0.getScheduler().getCurrentlyExecutingJobs();
            if (jobs != null && !jobs.isEmpty()) {
                for (JobExecutionContext job : jobs) {
                    if (!job.getTrigger().equals((Object)arg0.getTrigger()) || job.getJobInstance().equals((Object)this)) continue;
                    this.logger.debug("There's another instance running,SO skipping>>>>>>>>>>>>> : " + (Object)((Object)this));
                    return;
                }
            }
        }
        catch (SchedulerException e) {
            this.logger.debug("" + (Object)((Object)e));
            this.logger.error("" + e.getCause());
        }
        this.logger.debug("   start of job AuthorizationTokenCleanerTimer .... ");
        List clouds = this.licenseService.getClouds();
        for (Cloud cloud : clouds) {
            List users = this.managementService.getAllUsersDetails(cloud.getCloudId(), cloud.getCloudName(), false);
            this.logger.debug("   after getall users  .... " + users.size());
            for (User user : users) {
                this.authorizationService.deleteAllExpiredTokensByUserBasedOnDevicesAllowed(cloud.getCloudId(), cloud.getCloudName(), user, cloud);
                this.authorizationService.deleteAllLimitedValiditoryPeriodTokens(cloud.getCloudId(), cloud.getCloudName(), user);
            }
        }
        this.logger.debug("   end of job AuthorizationTokenCleanerTimer .... ");
    }
}

