/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.timer;

import com.parablu.bluvault.udc.service.AADManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.domain.Cloud;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class AADUserSyncTimer
extends QuartzJobBean {
    private Logger logger = LogManager.getLogger(AADUserSyncTimer.class);
    private LicenseService licenseService;
    private AADManagementService aadManagementService;

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"autoUserSyncFromADDTimerTrigger")) {
            this.logger.debug("AADUserSyncTimer ............. disabled");
            return;
        }
        this.logger.debug("  .. start of job UsersSyncFromADDTimer .... ");
        List clouds = this.licenseService.getClouds();
        for (Cloud cloud : clouds) {
            this.logger.debug("...New newgraph enabled ..." + cloud.getGraphAADEnabled());
            if (cloud.getGraphAADEnabled() == 1) {
                this.aadManagementService.syncNewUserAttributes(cloud);
                continue;
            }
            this.aadManagementService.synUserAttributes(cloud);
        }
        this.logger.debug("   end of job UsersSyncFromADDTimer .... ");
    }

    public AADManagementService getAadManagementService() {
        return this.aadManagementService;
    }

    public void setAadManagementService(AADManagementService aadManagementService) {
        this.aadManagementService = aadManagementService;
    }

    public LicenseService getLicenseService() {
        return this.licenseService;
    }
}

