/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.google.common.util.concurrent.RateLimiter;
import com.microsoft.graph.requests.GraphServiceClient;
import com.parablu.pcbd.dao.BlackListUserDao;
import com.parablu.pcbd.dao.ExternalStorageBackupFileDao;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.BlackListUser;
import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCredentials;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupJob;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.MSGTokens;
import com.parablu.pcbd.domain.MiniCloud;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.SyncPolicy;
import com.parablu.pcbd.domain.User;
import com.pg.controller.Graph;
import com.pg.dao.BackupFileDao;
import com.pg.dao.FileDao;
import com.pg.dao.OneDriveDao;
import com.pg.dao.SyncFileDao;
import com.pg.dao.UtilDao;
import com.pg.domain.BackupFile;
import com.pg.domain.ContentChunkFile;
import com.pg.domain.DriveFileInfo;
import com.pg.domain.FileInfo;
import com.pg.element.FileStatusElement;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.encryption.service.FileEncryptionService;
import com.pg.exception.BaseException;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MD5Generator;
import com.pg.helper.utils.MemoryStore;
import com.pg.odb.util.OneDriveUtil;
import com.pg.service.CloudSupportService;
import com.pg.service.UploadService;
import com.pg.service.UtilService;
import com.pg.service.impl.BaseUploadService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UploadServiceImpl
extends BaseUploadService
implements UploadService {
    private static Logger logger = LogManager.getLogger(UploadServiceImpl.class);
    public static final int HTTP_FILE_ALREADY_MOVED = 555;
    public static final int HTTP_FILE_NOT_PRESENT_LOCALLY = 556;
    private static final String BLACK_LIST_USERS = "BlackListUsers";
    private static final String UPLOAD = "/upload/";
    public static final String ENCRYPTED = "/encrypted/";
    public static final String CHUNK = "/chunk/";
    @Autowired
    private FileDao fileDao;
    @Autowired
    private OneDriveDao oneDriveDao;
    @Autowired
    private FileEncryptionService fileEncryptionService;
    @Autowired
    private UtilService utilService;
    @Autowired
    private ExternalStorageBackupFileDao externalStorageBackupFileDao;
    @Autowired
    private BackupFileDao backupFileDao;
    @Autowired
    private UtilDao utilDao;
    private static final String BACKUP = "backup";
    private static final String IS_JOB_RUNNING = "isJobRunning";
    private static final String SYNC = "sync";
    @Autowired
    private CloudSupportService cloudSupportService;
    @Autowired
    private BlackListUserDao blackListUserDao;
    @Autowired
    private SyncFileDao syncFileDao;
    private RateLimiter limiter = null;

    public void setExternalStorageBackupFileDao(ExternalStorageBackupFileDao externalStorageBackupFileDao) {
        this.externalStorageBackupFileDao = externalStorageBackupFileDao;
    }

    public void setCloudSupportService(CloudSupportService cloudSupportService) {
        this.cloudSupportService = cloudSupportService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    public void setFileDao(FileDao fileDao) {
        this.fileDao = fileDao;
    }

    public void setOneDriveDao(OneDriveDao oneDriveDao) {
        this.oneDriveDao = oneDriveDao;
    }

    public void setFileEncryptionService(FileEncryptionService fileEncryptionService) {
        this.fileEncryptionService = fileEncryptionService;
    }

    @Override
    public boolean saveFileInfo(String cloudName, String userName, FileInfo fileInfo) {
        return this.fileDao.saveFileInfo(fileInfo, cloudName, userName);
    }

    @Override
    public boolean saveFileInfoForSync(String cloudName, String gatewayName, FileInfo fileInfo) {
        return this.fileDao.saveFileInfoForSync(fileInfo, cloudName, gatewayName);
    }

    @Override
    public BackupFile getBackupFile(String userName, String cloudName, String backupId, String gatewayName) {
        return this.fileDao.getBackupFile(userName, cloudName, backupId, gatewayName);
    }

    @Override
    public String getOneDriveAccessToken(PciAuthorizationTokenElement pciAuthorizationTokenElement) {
        return this.oneDriveDao.getOneDriveAccessToken(pciAuthorizationTokenElement);
    }

    @Override
    public void deleteBackupFile(String userName, String cloudName, String backupId, String accessToken) {
        this.fileDao.deleteBackupFile(userName, cloudName, backupId, accessToken);
    }

    @Override
    public FileInfo getFileInfo(String cloudName, String userName, String gatewayName, String dedupifiedBackupId) {
        return this.fileDao.getFileInfo(cloudName, userName, gatewayName, dedupifiedBackupId);
    }

    @Override
    public FileInfo getBackupFileInfo(String cloudName, String userName, String gatewayName, String dedupifiedBackupId) {
        return this.fileDao.getBackupFileInfo(cloudName, userName, gatewayName, dedupifiedBackupId);
    }

    @Override
    public void deleteUploadedFiles(FileInfo fileInfo, String cloudName) {
        this.fileDao.deleteFile(fileInfo, cloudName);
    }

    @Override
    public List<EventHub> getEventHubForDeviceUUID(int cloudId, String deviceUUID) {
        return this.utilDao.getEventHubForDeviceUUID(cloudId, deviceUUID);
    }

    public boolean isPathInsideMC(int cloudId, String path) {
        String mcNameFromPath = UploadServiceImpl.getMCName(path);
        if (StringUtils.isEmpty((String)mcNameFromPath)) {
            return false;
        }
        List cloudElementList = this.syncFileDao.getAllMiniClouds(cloudId);
        boolean isPathInsideMC = false;
        for (MiniCloud miniCloudElement : cloudElementList) {
            if (!mcNameFromPath.equalsIgnoreCase(miniCloudElement.getMiniCloudName())) continue;
            isPathInsideMC = true;
            break;
        }
        return isPathInsideMC;
    }

    private static String getMCName(String path) {
        String[] list = path.split("/");
        if (list != null && list.length == 1) {
            return "";
        }
        return list[1];
    }

    @Override
    public FileStatusElement uploadAllFilesToCloud(String cloudName, FileInfo fileInfo, Cloud cloud, RateLimiter rateLimiter) {
        logger.debug("  INSIDE uploadAllFilesToCloud..... " + fileInfo.getId());
        FileStatusElement fileStatusElement = new FileStatusElement();
        String deviceTempPath = null;
        User user = null;
        MiniCloud miniCloud = null;
        logger.debug("--- File Info isSync --- " + fileInfo.isSync());
        if (this.isPathInsideMC(cloud.getCloudId(), fileInfo.getFilePath())) {
            String mcName = UploadServiceImpl.getMCName(fileInfo.getFilePath());
            miniCloud = this.syncFileDao.getMiniCloudByName(cloud.getCloudId(), mcName);
        } else {
            user = this.utilService.getUserInfoByName(1, fileInfo.getUserName());
        }
        deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
        String batchId = fileInfo.getBatchId();
        logger.debug("@#@#@#Inside uploadAllChunksToCloud ..... " + batchId);
        if (!StringUtils.isEmpty((String)batchId)) {
            deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId;
        }
        logger.debug("@#@#@#Inside devicetempath ..... " + deviceTempPath);
        String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + "chunk";
        BackupFile backupFile = new BackupFile();
        backupFile.setChunkFiles(new ArrayList());
        backupFile.setFileName(fileInfo.getFileName());
        backupFile.setFilePath(fileInfo.getFilePath());
        backupFile.setMd5(fileInfo.getMd5());
        backupFile.setSize(fileInfo.getSize());
        backupFile.setBackupId(new ObjectId(fileInfo.getId()));
        backupFile.setDeviceUUID(fileInfo.getDeviceUUID());
        backupFile.setCompressed(fileInfo.isCompressed());
        backupFile.setId(fileInfo.getId());
        backupFile.setBackupId(new ObjectId(fileInfo.getId()));
        String userName = fileInfo.getUserName();
        String gatewayName = fileInfo.getGatewayName();
        logger.debug("@#@#@# before Inside uploadAllChunksToCloud ..... " + fileInfo.getBatchId());
        Device device = null;
        if (!fileInfo.isSync()) {
            List<String> list;
            device = this.utilService.getDeviceForUUID(cloud.getCloudId(), fileInfo.getDeviceUUID());
            if (!fileInfo.isSync() && device == null && CollectionUtils.isEmpty(list = this.utilService.getAllDeviceByUserName(cloud.getCloudId(), fileInfo.getUserName()))) {
                fileInfo.setClientDedupEnabled(false);
            }
            if (!fileInfo.isClientDedupEnabled() && device == null || device != null && device.isDeleted()) {
                fileStatusElement.setUploadStatus(true);
                fileStatusElement.setUploadStatuscode(200);
                return fileStatusElement;
            }
        }
        BackUpImage backUpImage = null;
        backUpImage = !fileInfo.isSync() ? this.utilService.getBackupImageFile(cloud.getCloudId(), fileInfo.getId(), device) : this.utilService.getSyncBackUpImageFile(cloud.getCloudId(), fileInfo.getId(), user, miniCloud);
        if (backUpImage == null) {
            logger.debug(".....................Backup image is missing................");
            long chunksSize = 0L;
            String dedupVal = null;
            if (!fileInfo.isSync()) {
                BackupPolicy backupPolicy = this.utilService.getBackupPolicy(1, user.getPolicyName());
                dedupVal = this.getDedupValue(backupPolicy);
            } else {
                SyncPolicy syncPolicy = this.utilService.getSyncPolicy(1, user.getPolicyName());
                dedupVal = this.getDedupValue(syncPolicy);
            }
            if (fileInfo.isClientDedupEnabled()) {
                logger.debug(".....client dedup.....");
                for (String fileName : fileInfo.getChunkFiles()) {
                    logger.debug("missingget backup image is null so delete and de reference pre entry chunks");
                    logger.debug("missingget chunk size..." + chunksSize);
                    int occurance = StringUtils.countMatches((String)fileName, (String)".");
                    String md5 = UploadServiceImpl.getMd5FromFileName(fileName, occurance);
                    if (occurance > 1) {
                        fileName = fileName.substring(0, fileName.lastIndexOf(46));
                    }
                    ChunkDetail chunkDetail = null;
                    List chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ToUpload(1, md5, dedupVal, userName, true, false);
                    if (CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                        logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                        chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ToUpload(1, md5, dedupVal, userName, true, true);
                    }
                    if (!CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                        for (ChunkDetail detailFromDB : chunkDetailList) {
                            if (detailFromDB.getRefCount() <= 0 && detailFromDB.getClientDedupRefCount() <= 0) continue;
                            chunkDetail = detailFromDB;
                            break;
                        }
                    }
                    logger.debug("get backup image is null so delete and de reference pre entry chunks and chunk detail:" + chunkDetail);
                    if (chunkDetail != null) {
                        fileStatusElement.setUploadStatuscode(203);
                        if (chunkDetail.getClientDedupRefCount() > 0) {
                            chunkDetail.setClientDedupRefCount(chunkDetail.getClientDedupRefCount() - 1);
                        }
                        logger.debug("After deref client dedup ref count:" + chunkDetail.getClientDedupRefCount());
                        if (chunkDetail.getClientDedupRefCount() <= 0) {
                            long indivChunkSize = this.getChunksSize(fileInfo.getDeviceUUID(), cloud.getCloudName(), fileName, fileInfo.getBatchId(), fileInfo.getFileName(), chunkDetail.getFsPath());
                            logger.debug("........ eligible chunk size for deletion...." + fileName + "....." + indivChunkSize + "..overallsize... " + (chunksSize += indivChunkSize / 1024L));
                            if (!fileInfo.isSync()) {
                                this.deleteUnReferencedChunk(device.getDeviceUUID(), cloud.getCloudName(), fileName, batchId, fileInfo.getFileName(), chunkDetail.getFsPath());
                            } else {
                                this.deleteUnReferencedChunk(fileInfo.getDeviceUUID(), cloud.getCloudName(), fileName, batchId, fileInfo.getFileName(), chunkDetail.getFsPath());
                            }
                            logger.debug("..missing chunknane for path..." + fileName + "....." + fileInfo.getDeviceUUID() + "....batch...." + fileInfo.getBatchId());
                        }
                        logger.debug("........not eligilble for deletion...." + chunkDetail.getClientDedupRefCount() + "....filename..." + fileName);
                        this.externalStorageBackupFileDao.saveChunkDetail(1, chunkDetail);
                        logger.debug("After save or delete chunk detail..");
                        continue;
                    }
                    logger.debug(".....chunk null..... " + fileName);
                }
            } else {
                logger.debug(".....client not dedup.....");
                for (String fileName : fileInfo.getChunkFiles()) {
                    logger.debug("missingget backup image is null so delete and de reference pre entry chunks" + fileName);
                    int occurance = StringUtils.countMatches((String)fileName, (String)".");
                    if (occurance > 1) {
                        fileName = fileName.substring(0, fileName.lastIndexOf(46));
                    }
                    logger.debug("filename..." + fileName);
                    long independentChunkSize = this.getChunksSize(fileInfo.getDeviceUUID(), cloud.getCloudName(), fileName, fileInfo.getBatchId(), fileInfo.getFileName(), "");
                    logger.debug(independentChunkSize + "missingget chunk size..." + (chunksSize += independentChunkSize / 1024L));
                }
            }
            if (chunksSize != 0L && !fileInfo.isSync()) {
                logger.debug("..file to reduce...." + fileInfo.getId() + "...name..." + fileInfo.getFileName() + "...size...." + fileInfo.getSize() + "...chunkssize...." + chunksSize);
                long fileUplaodedSize = -chunksSize;
                logger.debug("file size in bytes..." + chunksSize + ".........updateSizeInDeviceBackupOverview....." + fileUplaodedSize + "....storageSizeInCloud ...");
                OneDriveUtil.getInstance().updateSizeInDeviceBackupOverview(cloud.getCloudId(), backupFile.getDeviceUUID(), null, null, null, fileUplaodedSize);
            }
            fileStatusElement.setUploadStatus(true);
            return fileStatusElement;
        }
        backUpImage.setBusy(true);
        if (!fileInfo.isSync()) {
            this.utilService.saveImageToBackUp(cloud.getCloudId(), backUpImage, device);
        } else {
            this.utilService.saveSyncBackUpImageToDB(cloud.getCloudId(), backUpImage, user, miniCloud);
        }
        long storageInPG = 0L;
        long storageInCloud = 0L;
        fileStatusElement = this.uploadAllChunksToCloud(cloudName, userName, fileInfo, gatewayName, chunkFilePath, backupFile, cloud, rateLimiter, device, storageInPG, storageInCloud, backUpImage);
        boolean isFileUploaded = fileStatusElement.isUploadStatus();
        backupFile.setBackupId(new ObjectId(fileInfo.getId()));
        backupFile.setId(fileInfo.getId());
        if (fileStatusElement.getUploadStatuscode() == 555 || fileStatusElement.getUploadStatuscode() == 556) {
            logger.debug("..file not present locally .. " + fileStatusElement.getUploadStatuscode());
            if (PCHelperConstant.getPropertyFileValueUpdatepgnameWhenChunkNotFoundMultipgenv()) {
                logger.debug("inside update gateway name when pg not found");
                FileInfo fileInfoObj = this.utilService.getFileInfoFromMongo(cloud.getCloudId(), cloudName, fileInfo.getId());
                logger.debug("fileInfo:" + fileInfoObj);
                if (fileInfoObj != null) {
                    ArrayList<String> processedFileList = CollectionUtils.isEmpty((Collection)fileInfoObj.getProcessedPgList()) ? new ArrayList<String>() : fileInfoObj.getProcessedPgList();
                    processedFileList.add(PCHelperConstant.getPropertyFileValueGatewayname());
                    logger.debug("processed pg list before remove duplicates:" + processedFileList.size());
                    processedFileList = new ArrayList(new HashSet(processedFileList));
                    logger.debug("processed pg list after remove duplicates:" + processedFileList.size());
                    fileInfoObj.setProcessedPgList(processedFileList);
                    this.utilService.saveFileInfoInMongo(fileInfoObj);
                } else {
                    logger.debug("fileInfo is null when taking from backup_pg");
                }
            } else {
                logger.debug(fileStatusElement.getUploadStatuscode() + "...NOT PRESENT.........status coode...." + fileStatusElement.getUploadStatuscode());
                logger.debug("......FILE_INFO....." + fileInfo.getFileName() + "...." + fileInfo.getSize());
                if (fileStatusElement.getUploadStatuscode() == 556 && backUpImage != null && !"CLOUD".equals(backUpImage.getStoragePlace())) {
                    long filesizeInKB = backupFile.getSize() / 1024L;
                    logger.debug(fileStatusElement.getUploadStatuscode() + "...don't DELETE...... " + filesizeInKB + "...." + fileInfo.getUserName());
                    logger.debug("......completed updating deleted.....");
                }
                logger.debug(fileInfo.getUserName() + "...deleting file......" + fileInfo.getFileName());
                this.utilService.removeBackupFromTempDb(cloud, backupFile.getBackupId(), true);
            }
        } else if (isFileUploaded) {
            if (!fileInfo.isSync()) {
                logger.debug(fileInfo.getId() + "update maindb2....." + (device != null ? device.getDestCollection() : null));
            } else {
                logger.debug(fileInfo.getId() + "update maindb2..... user destination collection : " + (user != null ? user.getSyncDestinationCollection() : null) + " minicloud destination collection : " + (miniCloud != null ? miniCloud.getSyncDestinationCollection() : null));
            }
            try {
                if (!fileInfo.isReducePGSize()) {
                    logger.debug("Its old file so no need to reduse pgCompressed Size..........");
                    fileStatusElement.setPgFileSize(0L);
                }
                this.utilService.saveChunksAndUpdateStorageForBackup(cloud, backupFile, cloudName, userName, gatewayName, fileInfo.isFullBackup(), device, fileStatusElement.getUploadedFileSize(), fileStatusElement.getPgFileSize(), fileInfo, user, miniCloud);
                logger.debug("after update saveChunksAndUpdateStorageForBackup....");
                if (!CollectionUtils.isEmpty((Collection)backupFile.getAttachChunkFiles())) {
                    for (com.pg.domain.ChunkFile chunkFile : backupFile.getAttachChunkFiles()) {
                        logger.debug("...ATttacccccc.... " + chunkFile.getFileName() + "...... " + chunkFile.getCloudStoragePath());
                    }
                } else {
                    logger.debug("..... no attachments .... .");
                }
                logger.debug("update removeBackupFromTempDb.....");
                if (backupFile.getBackupId() != null) {
                    this.utilService.removeBackupFromTempDb(cloud, backupFile.getBackupId(), true);
                }
                logger.debug("after removeBackupFromTempDb.....");
            }
            catch (Exception e) {
                isFileUploaded = false;
                logger.debug(" trying to remove from tmp table....." + e);
                logger.error(" trying to remove from tmp table.....");
            }
        } else {
            logger.error("Unable to upload file ....");
        }
        logger.debug("after upload....." + isFileUploaded);
        if (fileStatusElement.getUploadStatuscode() != 556 && !isFileUploaded) {
            backUpImage.setBusy(false);
            if (!fileInfo.isSync()) {
                this.utilService.saveImageToBackUp(cloud.getCloudId(), backUpImage, device);
            } else {
                this.utilService.saveSyncBackUpImageToDB(cloud.getCloudId(), backUpImage, user, miniCloud);
            }
        }
        return fileStatusElement;
    }

    private long getChunksSize(String deviceUUID, String cloudName, String name, String batchId, String fileName, String fsPath) {
        long chunksSize = 0L;
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            String parabluBaseMountFolder = PCHelperConstant.getParabluFolderBasePath();
            String chunkPath = parabluBaseMountFolder + cloudName + UPLOAD + deviceUUID + CHUNK;
            if (!StringUtils.isEmpty((String)batchId)) {
                chunkPath = parabluBaseMountFolder + cloudName + UPLOAD + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId + CHUNK;
            }
            try {
                File deleteChunkFile = new File(chunkPath + name);
                if (deleteChunkFile.exists()) {
                    chunksSize = deleteChunkFile.length();
                } else {
                    logger.debug(chunkPath + name + "... file in diff path.... " + fsPath);
                    deleteChunkFile = new File(fsPath);
                    if (deleteChunkFile.exists()) {
                        chunksSize = deleteChunkFile.length();
                    }
                }
            }
            catch (Exception e) {
                logger.error("Error trying to clean files ..... " + e.getMessage());
                logger.trace("" + e);
            }
        }
        return chunksSize;
    }

    private void deleteUnReferencedChunk(String deviceUUID, String cloudName, String name, String batchId, String fileName, String fsPath) {
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            String parabluBaseMountFolder = PCHelperConstant.getParabluFolderBasePath();
            String chunkPath = parabluBaseMountFolder + cloudName + UPLOAD + deviceUUID + CHUNK;
            String encryptedPath = parabluBaseMountFolder + cloudName + UPLOAD + deviceUUID + ENCRYPTED;
            String filePath = parabluBaseMountFolder + cloudName + UPLOAD + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            if (!StringUtils.isEmpty((String)batchId)) {
                chunkPath = parabluBaseMountFolder + cloudName + UPLOAD + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId + CHUNK;
                encryptedPath = parabluBaseMountFolder + cloudName + UPLOAD + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId + ENCRYPTED;
                filePath = parabluBaseMountFolder + cloudName + UPLOAD + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            }
            try {
                File deleteOrgFile;
                File deleteChunkFile = new File(chunkPath + name);
                File deleteEncryptedFile = new File(encryptedPath + name);
                logger.debug(fsPath + "......chunkpath to delete...." + chunkPath + name);
                if (deleteChunkFile.exists()) {
                    deleteChunkFile.delete();
                } else {
                    File deleteChunkFileFromPath = new File(fsPath);
                    if (deleteChunkFileFromPath.exists()) {
                        logger.debug("...deleleting chunk from diff path.... " + fsPath);
                        deleteChunkFileFromPath.delete();
                    }
                }
                if (deleteEncryptedFile.exists()) {
                    deleteEncryptedFile.delete();
                }
                if ((deleteOrgFile = new File(filePath + fileName)).exists()) {
                    deleteOrgFile.delete();
                }
            }
            catch (Exception e) {
                logger.error("Error trying to clean files ..... " + e.getMessage());
                logger.trace("" + e);
            }
        }
    }

    private FileStatusElement uploadAllChunksToCloud(String cloudName, String userName, FileInfo fileInfo, String gatewayName, String chunkFilePath, BackupFile backupFile, Cloud cloudTemp, RateLimiter rateLimiter, Device device, long storageInPG1, long storageInCloud1, BackUpImage backUpImage) {
        long pgFileSize = 0L;
        long largeFileSize = 0L;
        int[] chunkDetails = new int[2];
        String driveId = "";
        Object pciTokenElement = null;
        Cloud cloud = cloudTemp;
        User user = this.utilService.getUserInfoByName(1, userName);
        if (user == null) {
            Set<String> blackUsersList = new HashSet<String>();
            Object obj = MemoryStore.get((String)BLACK_LIST_USERS);
            if (obj != null) {
                blackUsersList = (Set)obj;
            }
            blackUsersList.add(userName.toLowerCase());
            logger.debug("......user is not found so mark as blacklisted ..." + userName);
            MemoryStore.add((String)BLACK_LIST_USERS, blackUsersList, (long)240000L);
            return new FileStatusElement();
        }
        boolean isSync = fileInfo.isSync();
        String dedupVal = null;
        BackupPolicy backupPolicy = null;
        SyncPolicy syncPolicy = null;
        if (!isSync) {
            backupPolicy = this.utilService.getBackupPolicy(1, user.getPolicyName());
            dedupVal = this.getDedupValue(backupPolicy);
        } else {
            syncPolicy = this.utilService.getSyncPolicy(1, user.getPolicyName());
            dedupVal = this.getDedupValue(syncPolicy);
        }
        boolean isODBEnabled = this.isODBEnabled(cloudTemp.getCloudCustomisableDetails());
        boolean isSPDestEnabled = this.isSPDestEnabled(cloudTemp.getCloudCustomisableDetails());
        if ((isODBEnabled || isSPDestEnabled) && StringUtils.isEmpty((String)user.getOdbDriveid())) {
            if (isSPDestEnabled) {
                String storagePooldestination = user.getOdbLoginId();
                driveId = OneDriveUtil.getPBFolderItemIdForSPWithErrorCode(storagePooldestination);
                logger.debug("....updateazureid for sharepoint...." + driveId);
                if (!"404".equals(driveId) && !"403".equals(driveId)) {
                    this.utilService.updateAzureProperties(cloud.getCloudId(), userName, driveId);
                }
            } else {
                String emailId = user.getEmailId();
                boolean muxedEnabled = false;
                if (StringUtils.isNotEmpty((String)PCHelperConstant.getOneDriveBackupType()) && PCHelperConstant.getOneDriveBackupType().equalsIgnoreCase("MUX")) {
                    muxedEnabled = true;
                }
                if (muxedEnabled && StringUtils.isEmpty((String)user.getOdbLoginId())) {
                    this.utilService.updateUserBackupTargetStatus(1, user.getUserName(), 204);
                    FileStatusElement fileStatusElement = new FileStatusElement();
                    fileStatusElement.setUploadStatus(false);
                    logger.debug("...muxedEnabled..." + muxedEnabled + "...user OdbLoginId is empty or return...");
                    return fileStatusElement;
                }
                if (!StringUtils.isEmpty((String)user.getOdbLoginId())) {
                    emailId = user.getOdbLoginId();
                }
                if (!StringUtils.isEmpty((String)user.getDestOdbLoginId())) {
                    emailId = user.getDestOdbLoginId();
                }
                logger.debug("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%" + emailId.toLowerCase());
                logger.debug(user.getUserName() + "%%%%%%%%%%%%%%%%%%%%get drive for user%%%%%%%%%%%%%%%%%%" + emailId);
                driveId = OneDriveUtil.getPBFolderItemIdWithErrorCode(emailId.toLowerCase());
                logger.debug("%%%%%%%%%%%%%%%%%%%%test%%%%%%%%%%%%%%%%%%" + driveId);
                if (!StringUtils.isEmpty((String)driveId) && !"404".equals(driveId)) {
                    user.setOdbDriveid(driveId);
                }
                logger.debug(user.getOdbDriveid() + "%%%%%%%%%%%%%^^^%%%%%%%%%%%%%%%%%%%%%%%%%" + user.getAzureUniqueId() + "...driveid..." + driveId);
                if (!StringUtils.isEmpty((String)driveId)) {
                    BlackListUser blackListUserObj = this.blackListUserDao.getBlackListUserbyName(1, userName, PCHelperConstant.getComponentName());
                    if ("404".equals(driveId)) {
                        FileStatusElement fileStatusElement = new FileStatusElement();
                        fileStatusElement.setUploadStatus(false);
                        user.setBackupTargetAssigned(false);
                        user.setBackupTargetErrorCode(404);
                        this.utilDao.saveUser(1, user);
                        logger.debug("....driveid is 404....");
                        if (blackListUserObj == null) {
                            BlackListUser blackListUser = new BlackListUser();
                            blackListUser.setResponseCode("404");
                            blackListUser.setUserName(userName);
                            blackListUser.setLocalHost(PCHelperConstant.getComponentName());
                            this.blackListUserDao.saveBlackListUser(1, blackListUser);
                        } else if (!blackListUserObj.getResponseCode().equalsIgnoreCase("404")) {
                            this.blackListUserDao.updateBlackListUserWithCode(1, userName, PCHelperConstant.getComponentName(), "404");
                        }
                        return fileStatusElement;
                    }
                    if ("403".equals(driveId)) {
                        FileStatusElement fileStatusElement = new FileStatusElement();
                        fileStatusElement.setUploadStatus(false);
                        user.setBackupTargetAssigned(false);
                        user.setBackupTargetErrorCode(403);
                        this.utilDao.saveUser(1, user);
                        logger.debug("....driveid is 403....");
                        String userBlockedForWrite = "403_" + userName;
                        Object obj = MemoryStore.get((String)BLACK_LIST_USERS);
                        obj = MemoryStore.get((String)userBlockedForWrite);
                        if (obj == null) {
                            MemoryStore.add((String)userBlockedForWrite, (Object)userName, (long)1800000L);
                            if (blackListUserObj == null) {
                                BlackListUser blackListUser = new BlackListUser();
                                blackListUser.setResponseCode("403");
                                blackListUser.setUserName(userName);
                                blackListUser.setLocalHost(PCHelperConstant.getComponentName());
                                this.blackListUserDao.saveBlackListUser(1, blackListUser);
                            }
                        }
                        return fileStatusElement;
                    }
                }
                if (!"404".equals(driveId) && !"403".equals(driveId)) {
                    this.utilService.updateAzureProperties(cloud.getCloudId(), userName, driveId);
                }
            }
        }
        GraphServiceClient<Request> graphClient = null;
        OkHttpClient okHttpClient = null;
        if (isODBEnabled || isSPDestEnabled) {
            graphClient = OneDriveUtil.getGraphClient();
            okHttpClient = Graph.getInstance().getOkHttpClient();
        }
        PCHelperConstant.setPropertyFileValueEncryptionEnabled((String)"true");
        if (StringUtils.isEmpty((String)PCHelperConstant.getPropertyFileValueEncryptionEnabled()) || !"true".equals(PCHelperConstant.getPropertyFileValueEncryptionEnabled())) {
            String filePath = this.mergeAllChunksAndCreateSingleFile(fileInfo, chunkFilePath, cloudName);
            File file = new File(filePath);
            logger.debug("Cloud upload  FILE started inside no encryption..... " + file.getName());
            logger.debug("Cloud upload  file.length() started inside no encryption..... " + file.length());
            long fileSize = file.length();
            FileStatusElement fileStatusElement = new FileStatusElement();
            fileStatusElement.setUploadedFileSize(fileSize);
            try {
                fileStatusElement = this.checkNThrottleAndUploadChunkFileToCloud(cloudName, user, fileInfo, gatewayName, backupFile, file.getName(), file, fileSize, cloud, rateLimiter, dedupVal, null, null, device, false, graphClient, okHttpClient);
            }
            catch (Exception e) {
                logger.trace("" + e);
                logger.error("...error while uploading....." + e.getMessage());
            }
            if (fileStatusElement.isUploadStatus()) {
                this.updateCloudStorageConsumed(fileInfo, file.length());
            }
            return fileStatusElement;
        }
        logger.debug(chunkFilePath + "...Inside uploadallchunkstocloud ....... " + fileInfo.getBatchId() + "....." + backupFile.getBackupId());
        if (backupPolicy != null) {
            int chunkSize = backupPolicy.getFileChunkableSize();
            int pftSize = backupPolicy.getPftSize();
            chunkDetails[0] = chunkSize;
            chunkDetails[1] = pftSize;
        } else {
            logger.debug("User backup mapping policy is empty so set default values........so set deafilt chunk size 4 and ptf size as 4");
            chunkDetails[0] = 4;
            chunkDetails[1] = 4;
        }
        logger.debug(fileInfo.getSize() + "..chunk info ..... " + chunkDetails[1]);
        logger.debug(fileInfo.getChunkFiles().size() + "..chunk info1 ..... " + chunkDetails[1]);
        String largeFilePath = "";
        fileInfo = this.getFileFromPG(cloud.getCloudName(), fileInfo.getId());
        FileStatusElement fileStatusElement = new FileStatusElement();
        HashMap<String, com.pg.domain.ChunkFile> uploadedFiles = fileInfo.getUploadedChunks();
        if (CollectionUtils.isEmpty((Map)uploadedFiles)) {
            uploadedFiles = new HashMap<String, com.pg.domain.ChunkFile>();
        }
        for (Map.Entry entry : uploadedFiles.entrySet()) {
            File file;
            com.pg.domain.ChunkFile chunkFile = (com.pg.domain.ChunkFile)entry.getValue();
            String fileName = chunkFile.getFileName();
            int occurance = StringUtils.countMatches((String)fileName, (String)".");
            String fileNameExcludeId = fileName;
            if (occurance > 1) {
                fileNameExcludeId = fileName.substring(0, fileName.lastIndexOf(46));
            }
            if (!(file = new File(chunkFilePath + "/" + fileNameExcludeId)).exists()) continue;
            long fileSize = file.length();
            pgFileSize += fileSize / 1024L;
        }
        boolean largeNonChunkedFile = false;
        logger.debug("..beforebefore..." + pgFileSize);
        int skipCount = 0;
        logger.debug(".........skiplargeupload...." + PCHelperConstant.getSkipOverloadCount());
        for (String fileName : fileInfo.getChunkFiles()) {
            long srcFileSize = 0L;
            long totalBytesRead = 0L;
            if (StringUtils.isEmpty((String)fileName)) continue;
            do {
                File dir;
                Object[] files;
                boolean largeFileChunk = false;
                long eightmb = 0x800000L;
                int eightmbint = 0x800000;
                RandomAccessFile raf = null;
                boolean officeProduct = false;
                if (device != null && (device.getOsType().equalsIgnoreCase(Device.TYPE.OUTLOOK.name()) || device.getOsType().equalsIgnoreCase(Device.TYPE.ONEDRIVE.name()) || device.getOsType().equalsIgnoreCase(Device.TYPE.SHAREPOINT.name()))) {
                    officeProduct = true;
                }
                if (officeProduct && fileInfo.getSize() > eightmb && fileInfo.getChunkFiles().size() == 1) {
                    long verifyoffset = 0L;
                    long verifynumberOfChunks = 0L;
                    try {
                        int occuranceTemp = StringUtils.countMatches((String)((String)fileInfo.getChunkFiles().get(0)), (String)".");
                        String fileNameExcludeIdTemp = (String)fileInfo.getChunkFiles().get(0);
                        if (occuranceTemp > 1) {
                            fileNameExcludeIdTemp = ((String)fileInfo.getChunkFiles().get(0)).substring(0, ((String)fileInfo.getChunkFiles().get(0)).lastIndexOf(46));
                        }
                        logger.debug(fileInfo.getSize() + "........source file ........." + chunkFilePath + "/" + fileNameExcludeIdTemp);
                        File sourceFile = new File(chunkFilePath + "/" + fileNameExcludeIdTemp);
                        long offset = 0L;
                        int numberOfChunks = 0;
                        FileInfo updateInfo = this.fileDao.getFileFromPG(cloud.getCloudName(), fileInfo.getId());
                        if (!CollectionUtils.isEmpty((Map)updateInfo.getUploadedChunks()) && updateInfo.getUploadedChunks().size() > 0) {
                            logger.debug("..updateinfo updloadedchunks val  .... " + updateInfo.getUploadedChunks().size() + "*" + eightmb);
                            verifyoffset = offset = (long)updateInfo.getUploadedChunks().size() * eightmb;
                            numberOfChunks = updateInfo.getUploadedChunks().size();
                            verifynumberOfChunks = numberOfChunks;
                        }
                        ++numberOfChunks;
                        raf = new RandomAccessFile(sourceFile.getAbsolutePath(), "rw");
                        raf.seek(offset);
                        int length = eightmbint;
                        largeFileSize = sourceFile.length();
                        if (offset + (long)length > largeFileSize) {
                            length = (int)largeFileSize - (int)offset;
                        }
                        if (length <= 0) {
                            logger.error(totalBytesRead + "... looks like negative so come out...." + offset + "....." + length + "...." + largeFileSize);
                            if (sourceFile.exists()) {
                                sourceFile.delete();
                                fileStatusElement.setUploadStatus(true);
                                fileStatusElement.setUploadStatuscode(555);
                                continue;
                            }
                        } else {
                            byte[] data = new byte[length];
                            logger.debug(length + ":length..............startOffset:" + offset);
                            int bytesRead = raf.read(data, 0, length);
                            logger.debug("bytes read.++..." + bytesRead);
                            raf.close();
                            String md5 = UploadServiceImpl.generateMD5ForByteArray(data);
                            String chunkName = String.format("part%09d.%s", numberOfChunks, md5);
                            String path = chunkFilePath + "/" + chunkName;
                            logger.debug("...newchunk..." + path);
                            com.pg.util.FileUtils.write((byte[])data, (String)path);
                            fileName = chunkName;
                            totalBytesRead = offset + (long)bytesRead;
                            srcFileSize = sourceFile.length();
                            logger.debug("....overallread..." + srcFileSize + "...." + totalBytesRead);
                            largeFileChunk = true;
                            largeNonChunkedFile = totalBytesRead < srcFileSize;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("....GFILENAME....." + fileInfo.getFileName() + "..." + fileInfo.getUploadedChunks().size());
                        logger.error(verifynumberOfChunks + "..chunks and offset..." + verifyoffset + "....error trying to create chunks latest ..... " + e.getMessage());
                        if (raf != null) {
                            try {
                                raf.close();
                            }
                            catch (IOException e1) {
                                logger.error("....unable to close raf.....");
                            }
                        }
                        fileStatusElement.setUploadStatus(false);
                        return fileStatusElement;
                    }
                }
                boolean isJobRunning = true;
                if (MemoryStore.get((String)IS_JOB_RUNNING) != null) {
                    isJobRunning = (Boolean)MemoryStore.get((String)IS_JOB_RUNNING);
                }
                logger.debug("........Is-tomcat job running val........." + isJobRunning);
                if (!isJobRunning) {
                    logger.error("..Tomcat job is going to be stopped.. so stopping upload ....");
                    fileStatusElement.setUploadStatus(false);
                    return fileStatusElement;
                }
                logger.debug(fileInfo.getId() + "....inside Cloud upload  FILE started ..... " + fileName + "..uploadedFiles.size().." + uploadedFiles.size());
                String chunkNameInFileInfo = fileName.replaceAll("\\.", "_");
                if (!CollectionUtils.isEmpty(uploadedFiles) && uploadedFiles.keySet().contains(chunkNameInFileInfo)) {
                    logger.debug("fileName present in uploaded files list so skip...." + chunkNameInFileInfo + "..uploadedFiles.size().." + uploadedFiles.size());
                    backupFile.getChunkFiles().add(uploadedFiles.get(chunkNameInFileInfo));
                    fileStatusElement.setUploadStatus(true);
                    continue;
                }
                fileStatusElement.setUploadStatus(false);
                int occurance = StringUtils.countMatches((String)fileName, (String)".");
                String md5 = UploadServiceImpl.getMd5FromFileName(fileName, occurance);
                String fileNameExcludeId = fileName;
                if (occurance > 1) {
                    fileNameExcludeId = fileName.substring(0, fileName.lastIndexOf(46));
                } else if (occurance == 0) {
                    fileName = fileName + "." + backupFile.getBackupId().toString();
                }
                if ((StringUtils.isEmpty((String)dedupVal) || dedupVal.equalsIgnoreCase(DEDUP.DISABLED.toString())) && isODBEnabled) {
                    dedupVal = DEDUP.USER.toString();
                }
                logger.debug(dedupVal + "...md5 before uploading.... " + md5);
                ChunkDetail chunkDetail = null;
                List chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ToUpload(1, md5, dedupVal, userName, true, false);
                if (CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                    logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                    chunkDetailList = this.externalStorageBackupFileDao.getChunkDetailForMd5ToUpload(1, md5, dedupVal, userName, true, true);
                }
                boolean isChunkDeleteProcessStarted = false;
                if (!CollectionUtils.isEmpty((Collection)chunkDetailList)) {
                    for (ChunkDetail detailFromDB : chunkDetailList) {
                        if (!detailFromDB.isPreEntry() && detailFromDB.getRefCount() <= 0) {
                            isChunkDeleteProcessStarted = true;
                        }
                        if (detailFromDB.getRefCount() <= 0 && detailFromDB.getClientDedupRefCount() <= 0) continue;
                        chunkDetail = detailFromDB;
                    }
                }
                chunkDetailList = null;
                File file = new File(chunkFilePath + "/" + fileNameExcludeId);
                if (!file.exists() && chunkDetail == null && ArrayUtils.isNotEmpty((Object[])(files = (dir = new File(chunkFilePath)).list((FilenameFilter)new PrefixFileFilter(fileNameExcludeId))))) {
                    File fileDup = new File(chunkFilePath + "/" + (String)files[0]);
                    if (!file.exists()) {
                        fileDup.renameTo(file);
                    }
                }
                if (!file.exists() && chunkDetail == null) {
                    logger.debug("....file does not exist..... ");
                    if (!fileInfo.isRebackupFile() && backUpImage != null && "CLOUD".equals(backUpImage.getStoragePlace())) {
                        logger.debug(" File is already moved to cloud........ " + fileInfo.getId());
                        fileStatusElement.setUploadStatus(true);
                        fileStatusElement.setUploadStatuscode(555);
                        return fileStatusElement;
                    }
                }
                logger.debug(md5 + ".....Cloud upload  FILE started after changed filename ..... " + fileName);
                long fileSize = file.length();
                logger.debug(fileName + ".....filename and size..... " + fileSize + "...filesize kb ..." + fileSize / 1024L);
                logger.debug((pgFileSize += fileSize / 1024L) + ".....uploadedFileSize before...." + fileStatusElement.getUploadedFileSize());
                logger.debug(".....uploadedFileSize after...." + fileStatusElement.getUploadedFileSize());
                if (!fileInfo.isRebackupFile() && chunkDetail != null && !chunkDetail.isPreEntry()) {
                    if (chunkDetail != null) {
                        logger.debug("Chunk alreadyexists............pvn");
                        File cFile = new File(chunkFilePath + "/" + fileNameExcludeId);
                        long fileSize1 = cFile.length();
                        com.pg.domain.ChunkFile chunkFile = new com.pg.domain.ChunkFile();
                        chunkFile.setFileName(fileName);
                        chunkFile.setMd5(md5);
                        chunkFile.setfSPath(chunkFile.getCloudStoragePath());
                        chunkFile.setFileId(fileName);
                        chunkFile.setSize(Long.valueOf(fileSize1));
                        chunkFile.setUploadedTimeStamp(System.currentTimeMillis());
                        chunkFile.setCloudStoragePath(chunkFile.getCloudStoragePath());
                        backupFile.getChunkFiles().add(chunkFile);
                        fileStatusElement.setUploadStatus(true);
                        uploadedFiles.put(chunkNameInFileInfo.replaceAll("\\.", "_"), chunkFile);
                    }
                    if (chunkDetail != null) {
                        this.updateRefChunks(userName, cloud, dedupVal, md5, chunkDetail, fileInfo);
                        logger.debug(" chunkDetail already exists.... ");
                        this.updateUploadedChunks(cloud.getCloudName(), uploadedFiles, fileInfo);
                        if (!file.exists()) continue;
                        file.delete();
                        continue;
                    }
                }
                String preFSPath = "";
                boolean isPreEntry = false;
                if (!file.exists() && chunkDetail != null && chunkDetail.isPreEntry()) {
                    logger.debug("cunk detail is pre entry...");
                    file = new File(chunkDetail.getFsPath());
                    if (file.exists()) {
                        preFSPath = chunkDetail.getFsPath();
                        isPreEntry = true;
                        logger.debug(file.getName() + "...preentry chunk size ..." + fileSize);
                    }
                }
                if (!file.exists()) {
                    logger.error("File not present in the local mnt");
                    File mntPath = new File(PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName));
                    boolean isMountPointAvailable = false;
                    try {
                        if (mntPath.exists()) {
                            isMountPointAvailable = true;
                        }
                    }
                    catch (Exception e) {
                        logger.error(".......unable to check mount point..... ");
                    }
                    if (!isMountPointAvailable) {
                        logger.error(".../parablu unmounted..............");
                        fileStatusElement.setUploadStatus(false);
                        return fileStatusElement;
                    }
                    if (PCHelperConstant.getPropertyFileValueDeleteBkptblWhenChunksNotFound()) {
                        logger.debug("....file does not exist..... ");
                        if (!fileInfo.isRebackupFile() && backUpImage != null && !"CLOUD".equals(backUpImage.getStoragePlace())) {
                            this.deleteFilesAndDbEntries(cloudName, userName, fileInfo, device);
                        }
                    }
                    if (chunkDetail != null && chunkDetail.isPreEntry()) {
                        logger.debug("ChunkDetail is pre entry and file not present locally so delete...");
                        this.externalStorageBackupFileDao.deleteChunkDetail(1, chunkDetail);
                    }
                    fileStatusElement.setUploadStatuscode(556);
                    fileStatusElement.setUploadStatus(true);
                    return fileStatusElement;
                }
                chunkDetail = null;
                logger.debug("Cloud upload  file.length() started.... " + file.length());
                logger.debug("uploadAllChunksToCloud inside fileInfo.getServerBackupJobId()  ..... " + fileInfo.getServerBackupJobId());
                cloud = this.utilService.getCloud(cloud.getCloudId());
                logger.debug(fileName + "....RAMTRACK1...beforeupload.." + fileInfo.getChunkFiles().size());
                fileStatusElement = this.checkNThrottleAndUploadChunkFileToCloud(cloudName, user, fileInfo, gatewayName, backupFile, fileName, file, fileSize, cloud, rateLimiter, dedupVal, chunkNameInFileInfo, uploadedFiles, device, isChunkDeleteProcessStarted, graphClient, okHttpClient);
                ++skipCount;
                logger.debug(fileName + "....RAMTRACK2...afterupload.." + fileInfo.getChunkFiles().size());
                if (fileStatusElement.isUploadStatus() && !fileStatusElement.isChunkAlreadyExist()) {
                    this.updateCloudStorageConsumed(fileInfo, file.length());
                }
                if (!fileStatusElement.isUploadStatus()) {
                    logger.error("file upload to cloud exception so return false");
                    return fileStatusElement;
                }
                if (!fileStatusElement.isUploadStatus() || !isPreEntry && !largeFileChunk) continue;
                logger.debug("...... deleting preentryfile  or largechunkfile..... " + preFSPath);
                if (!file.exists()) continue;
                file.delete();
            } while (largeNonChunkedFile);
            logger.debug("...skipcount val1...." + skipCount);
            if (skipCount < PCHelperConstant.getSkipOverloadCount()) continue;
            fileStatusElement.setUploadStatus(false);
            logger.debug("...skipcount val...more than 100chunksuploaded so skip");
            return fileStatusElement;
        }
        if (largeFileSize > 0L) {
            pgFileSize = largeFileSize / 1024L;
            logger.debug("....largefile so reduce pg size.... " + pgFileSize);
        }
        logger.debug(largeFileSize + "... actualstorageinpg before ..." + pgFileSize);
        if (fileStatusElement.isUploadStatus()) {
            File file;
            logger.debug(largeFilePath + "File uploaded successfully in blob.withutss........" + backupFile.getBackupId().toString());
            if (!StringUtils.isEmpty((String)largeFilePath) && (file = new File(largeFilePath)).exists()) {
                logger.debug("....before delete.... " + file.length() + "..storeee..." + pgFileSize);
                file.delete();
            }
        }
        logger.debug(storageInPG1 + "...acturalstorageinpg after ..." + pgFileSize);
        fileStatusElement.setUploadedFileSize(fileInfo.getStorageUtilizedInCloud());
        fileStatusElement.setPgFileSize(pgFileSize);
        return fileStatusElement;
    }

    private void updateRefChunks(String userName, Cloud cloud, String dedupVal, String md5, ChunkDetail chunkDetail, FileInfo fileInfo) {
        try {
            chunkDetail.setRefCount(chunkDetail.getClientDedupRefCount() + chunkDetail.getRefCount());
            if (!fileInfo.isClientDedupEnabled()) {
                int refCount = chunkDetail.getRefCount() + 1;
                chunkDetail.setRefCount(refCount);
            }
            chunkDetail.setClientDedupRefCount(0);
            this.externalStorageBackupFileDao.saveChunkDetail(cloud.getCloudId(), chunkDetail);
            logger.debug(" Chunk updated succcessfully  .........." + chunkDetail.getCloudChunkName());
        }
        catch (OptimisticLockingFailureException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while updating ref chunks :" + (Object)((Object)e));
            int maxTries = 5;
            int count = 0;
            while (true) {
                try {
                    Thread.sleep(2000L);
                    logger.debug(" retry chunk update ..............." + md5);
                    ChunkDetail chunkDetailObj = this.externalStorageBackupFileDao.getChunkDetailForMd51(1, md5, dedupVal, userName, true, false);
                    if (chunkDetailObj == null) {
                        logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
                        chunkDetailObj = this.externalStorageBackupFileDao.getChunkDetailForMd51(1, md5, dedupVal, userName, true, true);
                    }
                    if (chunkDetail != null && chunkDetail.isDeleteProcessStarted()) {
                        logger.debug("................chunk detail is not empty and deleteProcessStarted is true");
                        chunkDetail = this.externalStorageBackupFileDao.getChunkForUpdateRefCount(1, md5, dedupVal, userName, true, false);
                        if (chunkDetail == null) {
                            chunkDetail = this.externalStorageBackupFileDao.getChunkForUpdateRefCount(1, md5, dedupVal, userName, true, true);
                        }
                    }
                    int refCount = chunkDetailObj.getRefCount() + 1;
                    chunkDetailObj.setRefCount(refCount);
                    this.externalStorageBackupFileDao.saveChunkDetail(1, chunkDetailObj);
                }
                catch (Exception ex) {
                    logger.trace("" + ex);
                    logger.error(" ex ..." + ex.getMessage());
                    if (++count != maxTries) continue;
                }
                break;
            }
        }
    }

    private void deleteFilesAndDbEntries(String cloudName, String userName, FileInfo fileInfo, Device device) {
        try {
            this.utilService.deleteBackupFiles(1, cloudName, userName, fileInfo.getId(), fileInfo.getDedupBackupId(), device);
        }
        catch (Exception e) {
            logger.debug("Exception :" + e);
            logger.error("Exception :" + e.getMessage());
        }
    }

    private String mergeAllChunksAndCreateSingleFile(FileInfo fileInfo, String chunkFilePath, String cloudName) {
        logger.debug("inside merge into a single file............");
        String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
        String destinationPath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + "merge" + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileInfo.getFileName();
        com.pg.util.FileUtils.merge((List)fileInfo.getChunkFiles(), (String)chunkFilePath, (String)destinationPath);
        return destinationPath;
    }

    private FileStatusElement checkNThrottleAndUploadChunkFileToCloud(String cloudName, User user, FileInfo fileInfo, String gatewayName, BackupFile backupFile, String fileName, File file, long fileSize, Cloud cloud, RateLimiter rateLimiter, String dedupType, String chunkName, Map<String, com.pg.domain.ChunkFile> uploadedFiles, Device device, boolean isChunkDeleteProcessStarted, GraphServiceClient<Request> graphClient, OkHttpClient okHttpClient) {
        FileStatusElement fileStatusElement = new FileStatusElement();
        try {
            fileStatusElement = this.uploadFileToCloud(cloudName, user, file, fileInfo.getDeviceUUID(), backupFile, gatewayName, false, fileName, cloud, fileInfo.getBatchId(), rateLimiter, dedupType, fileInfo.isFullBackup(), fileInfo.isRebackupFile(), fileInfo.getGatewayName(), chunkName, uploadedFiles, fileInfo, device, isChunkDeleteProcessStarted, graphClient, okHttpClient);
            logger.debug("......................" + fileStatusElement.isChunkAlreadyExist());
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Checking Throttle and Uploading Chunk File to Cloud :" + e.getMessage());
            logger.debug(" UNABLE TO UPLOAD FILES ..... " + file.getName());
        }
        return fileStatusElement;
    }

    private FileStatusElement uploadFileToCloud(String cloudName, User user, File file, String deviceUUID, BackupFile fileInfo, String gatewayName, boolean nonChunkable, String fileName, Cloud cloud, String batchId, RateLimiter rateLimiter, String dedupType, boolean isFullBackup, boolean isRebackupFile, String gateWayName, String chunkName, Map<String, com.pg.domain.ChunkFile> uploadedFiles, FileInfo localFileInfo, Device device, boolean isChunkDeleteProcessStarted, GraphServiceClient<Request> graphClient, OkHttpClient okHttpClient) throws BaseException {
        File encryptedFile;
        String pathname = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + cloudName + UPLOAD + deviceUUID + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        if (!StringUtils.isEmpty((String)batchId)) {
            pathname = pathname + batchId + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
        }
        this.createFolders(pathname);
        String encryptedFileName = fileName;
        if (!StringUtils.isEmpty((String)PCHelperConstant.getPropertyFileValueEncryptionEnabled()) && "true".equals(PCHelperConstant.getPropertyFileValueEncryptionEnabled())) {
            encryptedFile = new File(pathname + "encrypted/" + encryptedFileName);
            String saltKey = localFileInfo.isSync() ? this.utilService.getEncryptionKey(1, SYNC) : this.utilService.getEncryptionKey(1, BACKUP);
            encryptedFile = this.fileEncryptionService.encrypt(saltKey, user.getUserName(), file, encryptedFile);
            logger.debug("after Encryption........^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        } else {
            encryptedFile = file;
            logger.debug("fileName...." + encryptedFile.getName());
        }
        long fileSize = 0L;
        if (encryptedFile.exists()) {
            fileSize = encryptedFile.length() / 1024L;
            logger.debug(".........Encrypted file size........." + fileSize);
        }
        String containerName = this.checkPreConditionForCreateContainer(user.getUserName(), cloud);
        logger.debug(" Calling cloudsupportservice .........." + containerName);
        String lastStoragePathForSameFile = "";
        lastStoragePathForSameFile = this.getLastStoragePath(fileInfo, lastStoragePathForSameFile);
        String fileMd5 = "";
        long fileLength = 0L;
        if (file.exists()) {
            fileMd5 = MD5Generator.generateMD5OfFile((File)file);
            fileLength = file.length();
        }
        FileStatusElement fileStatusElement = this.cloudSupportService.uploadToCloud(cloud, containerName, encryptedFile, user, localFileInfo.isSync(), lastStoragePathForSameFile, rateLimiter, fileInfo, gatewayName, isChunkDeleteProcessStarted, graphClient, okHttpClient);
        logger.debug(" end of uploading using  cloudsupportservice .........." + fileStatusElement.isUploadStatus());
        if (fileStatusElement.isUploadStatus()) {
            try {
                String unwantedChar;
                logger.debug(fileInfo.getId() + ">>>>>>>>>>>>>>>> BEFORE ...." + encryptedFileName);
                String encodedNameInCloud = this.convertStringTOBase64(this.removeIdFromChunkName(fileInfo.getId(), encryptedFile)).replaceAll("/", "_");
                if (StringUtils.isNotEmpty((String)fileStatusElement.getEncodedFileName())) {
                    encodedNameInCloud = fileStatusElement.getEncodedFileName();
                }
                String encodedFileName = this.convertStringTOBase64(encryptedFile.getName()).replaceAll("/", "_");
                logger.debug(fileStatusElement.getCloudStoragePath() + "...>>>>>>>>>>>>>>> Before .... " + encryptedFileName);
                if (encryptedFileName.contains("_") && encryptedFileName.contains(".") && !StringUtils.isEmpty((String)(unwantedChar = encryptedFileName.substring(encryptedFileName.lastIndexOf("_"), encryptedFileName.lastIndexOf("."))))) {
                    encryptedFileName = encryptedFileName.replace(unwantedChar, "");
                }
                logger.debug(fileStatusElement.getCloudStoragePath() + ">>>>>>>>>>>>>>> After path .... " + encryptedFileName);
                com.pg.domain.ChunkFile chunkFile = new com.pg.domain.ChunkFile();
                chunkFile.setFileName(encryptedFileName);
                chunkFile.setEncodedName(encodedNameInCloud);
                chunkFile.setfSPath(encodedFileName);
                chunkFile.setFileId(fileStatusElement.getFileId());
                chunkFile.setGatewayName(gateWayName);
                if (!StringUtils.isEmpty((String)fileStatusElement.getOdbLoginId())) {
                    chunkFile.setOdbLoginId(fileStatusElement.getOdbLoginId());
                }
                if (fileStatusElement.isUploadStatus()) {
                    chunkFile.setMd5(fileMd5);
                    chunkFile.setSize(Long.valueOf(fileLength));
                }
                chunkFile.setUploadedTimeStamp(System.currentTimeMillis());
                chunkFile.setCloudStoragePath(fileStatusElement.getCloudStoragePath());
                ChunkFile chunkFileRef = new ChunkFile();
                BeanUtils.copyProperties((Object)chunkFile, (Object)chunkFileRef);
                boolean isGDEnabled = this.isGDEnabled(cloud.getCloudCustomisableDetails());
                if (isGDEnabled) {
                    chunkFileRef.setFileName(fileStatusElement.getFileId());
                }
                if (device != null && StringUtils.isNotEmpty((String)device.getDeviceType()) && device.getDeviceType().equals("ONEDRIVE")) {
                    chunkFileRef.setProductType("ONEDRIVE");
                }
                if (localFileInfo.isSync()) {
                    chunkFileRef.setProductType("SYNC");
                } else {
                    chunkFileRef.setProductType("BACKUP");
                }
                boolean isJobRunning = true;
                if (MemoryStore.get((String)IS_JOB_RUNNING) != null) {
                    isJobRunning = (Boolean)MemoryStore.get((String)IS_JOB_RUNNING);
                }
                logger.debug("........Is job running........." + isJobRunning);
                if (isJobRunning) {
                    String odbLoginId = user.getOdbLoginId();
                    if (org.springframework.util.StringUtils.isEmpty((Object)odbLoginId)) {
                        odbLoginId = user.getEmailId();
                    }
                    this.updateRefChunks(chunkFileRef, localFileInfo, this.externalStorageBackupFileDao, containerName, dedupType, user.getUserName(), isFullBackup, isRebackupFile, deviceUUID, cloud, fileSize, gateWayName, odbLoginId, user.getOdbDriveid());
                    uploadedFiles.put(chunkName.replaceAll("\\.", "_"), chunkFile);
                    logger.debug("........updateRefChunks.....is completed ....");
                    long sizeInCloud = localFileInfo.getStorageUtilizedInCloud();
                    if (fileStatusElement.isChunkAlreadyExist()) {
                        fileSize = 0L;
                    }
                    this.updateUploadedChunksAndSize(cloud, uploadedFiles, localFileInfo, deviceUUID, fileSize);
                    logger.debug("........updateUploadedChunksAndSize is completed.........");
                    fileInfo.getChunkFiles().add(chunkFile);
                    localFileInfo.setStorageUtilizedInCloud(sizeInCloud += fileSize);
                }
            }
            catch (Exception e) {
                logger.error(" JSON EXEPTION " + e);
                fileStatusElement.setUploadStatus(false);
            }
        } else if (!CollectionUtils.isEmpty((Collection)fileInfo.getChunkFiles())) {
            for (com.pg.domain.ChunkFile chunk : fileInfo.getChunkFiles()) {
                ChunkFile chunkFileRef = new ChunkFile();
                BeanUtils.copyProperties((Object)chunk, (Object)chunkFileRef);
            }
        }
        if (encryptedFile.exists()) {
            logger.debug(encryptedFile.getName() + " Delete encryptedFile using delete method  ........  " + encryptedFile.getPath());
            encryptedFile.delete();
        }
        return fileStatusElement;
    }

    private String removeIdFromChunkName(String bkpFileId, File encryptedFile) {
        String encryptedFileName = encryptedFile.getName();
        try {
            logger.debug(encryptedFileName + ">>>>>>>>>>>>>>> BEFORE...." + encryptedFileName);
            if (encryptedFileName.contains("." + bkpFileId)) {
                encryptedFileName = encryptedFileName.replaceAll("." + bkpFileId, "");
            }
            logger.debug(encryptedFileName);
            if (encryptedFileName.contains("_")) {
                encryptedFileName = encryptedFileName.substring(0, encryptedFileName.indexOf("_"));
            }
        }
        catch (Exception e) {
            logger.error("error in Encoding the chunk name " + encryptedFileName + e.getMessage());
            logger.trace("" + e);
        }
        return encryptedFileName;
    }

    private boolean isODBEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isODBEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"ODB Enabled".equalsIgnoreCase(license.getName())) continue;
            isODBEnabled = true;
            break;
        }
        return isODBEnabled;
    }

    private boolean isGDEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isGDEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"Google Drive Enabled".equalsIgnoreCase(license.getName())) continue;
            isGDEnabled = true;
            break;
        }
        return isGDEnabled;
    }

    private String getDedupValue(BackupPolicy backupPolicy) {
        String dedupVal = null;
        if (backupPolicy != null) {
            dedupVal = backupPolicy.getDedup();
        }
        return dedupVal;
    }

    private String getDedupValue(SyncPolicy syncPolicy) {
        String dedupVal = null;
        if (syncPolicy != null) {
            dedupVal = syncPolicy.getDedup();
        }
        return dedupVal;
    }

    private String checkPreConditionForCreateContainer(String userName, Cloud cloud) {
        String userNameTemp = userName;
        userNameTemp = userNameTemp.toLowerCase();
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty((String)userNameTemp)) {
            boolean isLocalStorageEnabled;
            if (userNameTemp.length() < 3) {
                userNameTemp = userNameTemp + "-parablu";
            }
            if (isLocalStorageEnabled = this.isLocalStorageEnabled(cloud)) {
                userNameTemp = userNameTemp.replaceAll("[^A-Za-z0-9,]", "-");
                userNameTemp = userNameTemp.replaceAll(" ", "-");
            } else {
                userNameTemp = userNameTemp.replaceAll(" ", "-");
                userNameTemp = userNameTemp.replace(".", "-46");
                userNameTemp = userNameTemp.replace("@", "-64");
                userNameTemp = userNameTemp.replace("_", "-95");
            }
            sb.append(userNameTemp);
            return sb.toString();
        }
        return userNameTemp;
    }

    private boolean isLocalStorageEnabled(Cloud cloud) {
        boolean isLocalStorageEnabled = false;
        for (CloudCredentials cc : cloud.getCloudCredentials()) {
            if (cc == null || !"localStorage".equalsIgnoreCase(cc.getCloudName())) continue;
            isLocalStorageEnabled = true;
            break;
        }
        return isLocalStorageEnabled;
    }

    private String convertStringTOBase64(String name) {
        String base64EncodeString = null;
        if (name != null) {
            byte[] bytes = DigestUtils.md5((String)name);
            byte[] bytesEncoded = Base64.encodeBase64((byte[])bytes);
            base64EncodeString = new String(bytesEncoded);
            base64EncodeString = base64EncodeString.substring(0, base64EncodeString.length() - 2);
            logger.debug("encoded value for given file is " + base64EncodeString);
        }
        return base64EncodeString;
    }

    public void createFolders(String pathname) {
        File chunkDir;
        File encryptedDir = new File(pathname + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + "encrypted");
        if (!encryptedDir.exists()) {
            encryptedDir.mkdir();
        }
        if (!(chunkDir = new File(pathname + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + "chunk")).exists()) {
            chunkDir.mkdir();
        }
    }

    private String getLastStoragePath(BackupFile fileInfo, String lastStoragePathForSameFile) {
        List files = fileInfo.getChunkFiles();
        String lastStoragePathForSameFileTemp = lastStoragePathForSameFile;
        if (!CollectionUtils.isEmpty((Collection)files)) {
            Collections.sort(files, new Comparator<com.pg.domain.ChunkFile>(){

                @Override
                public int compare(com.pg.domain.ChunkFile c1, com.pg.domain.ChunkFile c2) {
                    long t1 = c1.getUploadedTimeStamp();
                    long t2 = c2.getUploadedTimeStamp();
                    if (t2 > t1) {
                        return 1;
                    }
                    if (t1 > t2) {
                        return -1;
                    }
                    return 0;
                }
            });
            com.pg.domain.ChunkFile chunkFile = (com.pg.domain.ChunkFile)files.get(0);
            lastStoragePathForSameFileTemp = chunkFile.getCloudStoragePath();
        }
        return lastStoragePathForSameFileTemp;
    }

    @Override
    public FileInfo getFileFromPG(String userName, String cloudName, String id, boolean sync) {
        return this.fileDao.getFileFromPG(userName, cloudName, id, sync);
    }

    private static String getMd5FromFileName(String fileName, int occurance) {
        String md5 = "";
        if (occurance == 1 && !fileName.startsWith("part")) {
            md5 = fileName.substring(0, fileName.lastIndexOf(46));
        } else if (occurance == 1 && fileName.startsWith("part")) {
            md5 = fileName.substring(fileName.lastIndexOf(46) + 1);
        } else if (occurance == 0) {
            md5 = fileName;
        } else if (occurance > 1) {
            md5 = fileName.substring(fileName.indexOf(46) + 1, fileName.lastIndexOf(46));
        }
        if (StringUtils.isNotEmpty((String)md5) && md5.contains("_")) {
            md5 = md5.substring(0, md5.lastIndexOf("_"));
        }
        return md5;
    }

    private void updateCloudStorageConsumed(FileInfo fileInfo, long fileSize) {
        logger.debug("updateCloudStorageConsumed > fileSize > " + fileSize);
        if (!StringUtils.isEmpty((String)fileInfo.getServerBackupJobId())) {
            ObjectId jobObjId = new ObjectId(fileInfo.getServerBackupJobId());
            DeviceBackupJob dbj = this.utilDao.getDeviceBackupJob(1, fileInfo.getDeviceUUID(), jobObjId);
            dbj.setBackupSizeOnCloudInBytes(dbj.getBackupSizeOnCloudInBytes() + fileSize);
            this.utilDao.registerJob(dbj, 1);
            logger.debug("updateCloudStorageConsumed > fileSize > dbj.getBackupSizeOnCloudInKB() > UPDATED > " + dbj.getBackupSizeOnCloudInBytes());
        }
    }

    private void deleteFileFromMnt(File file) {
        try {
            if (file.exists()) {
                FileUtils.forceDelete((File)file);
            }
        }
        catch (IOException e) {
            logger.error("error in deleting file" + e.getMessage());
            logger.trace("" + e);
        }
    }

    @Override
    public void updateFileInfo(String cloudName, String gatewayName, FileInfo fileInfo) {
        this.fileDao.updateFileInfo(cloudName, gatewayName, fileInfo);
    }

    @Override
    public void moveFailedFilesToBkpQueue(String cloudName, FileInfo fileInfo, boolean isBlackListUser) {
        this.fileDao.moveFailedFilesToBkpQueue(fileInfo, cloudName, isBlackListUser);
    }

    @Override
    public boolean deleteFileInfoFromReBackup(String cloudName, ObjectId backupId) {
        return this.backupFileDao.deleteBackupFileForIDFromReBackup(1, backupId);
    }

    @Override
    public boolean restoreQueue(FileInfo fileInfo, Cloud cloud) {
        return this.fileDao.restoreQueue(fileInfo, cloud);
    }

    @Override
    public List<FileInfo> getFilesForUpload(String cloudName, boolean firstTime) {
        return this.fileDao.getFilesForUpload(cloudName, firstTime);
    }

    @Override
    public void updateUploadedChunks(String cloudName, Map<String, com.pg.domain.ChunkFile> uploadedFiles, FileInfo fileInfo) {
        logger.debug("Saving updateUploadedChunks in " + fileInfo.getId() + "....size is..." + uploadedFiles.size());
        this.fileDao.updateUploadedChunks(cloudName, uploadedFiles, fileInfo);
    }

    @Override
    public List<FileInfo> getFaileFilesForReUpload(String cloudName) {
        return this.fileDao.getFaileFilesForReUpload(cloudName);
    }

    @Override
    public void restoreFailedFiles(FileInfo fileInfo, Cloud cloud) {
        this.fileDao.moveFailedFilesToBkpQueueAndDeleteInLocal(fileInfo, cloud.getCloudName(), false, false, false);
    }

    @Override
    public void restoreSyncFailedFiles(FileInfo fileInfo, Cloud cloud) {
        this.fileDao.moveFailedFilesToBkpQueueAndDeleteInLocalForSync(fileInfo, cloud.getCloudName(), false);
    }

    public void updateUploadedChunksAndSize(Cloud cloud, Map<String, com.pg.domain.ChunkFile> uploadedFiles, FileInfo fileInfo, String deviceUUID, Long sizeInCloud) {
        logger.debug("Inside ....updateUploadedChunksAndSize ");
        this.fileDao.updateUploadedChunksAndSize(cloud, sizeInCloud, fileInfo, uploadedFiles);
    }

    @Override
    public void removeSyncFile(int cloudId, String syncrevisionId, String consolidatedImageId) {
        this.fileDao.removeSyncFile(cloudId, syncrevisionId, consolidatedImageId);
    }

    @Override
    public void removeSyncBackUpImage(int cloudId, String syncBackUpImageId) {
        this.fileDao.removeSyncBackUpImageFile(cloudId, syncBackUpImageId);
    }

    @Override
    public void removeBackupFile(int cloudId, String backupId, String destCollection) {
        this.fileDao.removeBackupFile(cloudId, backupId, destCollection);
    }

    @Override
    public boolean saveFileInfoForODB(String cloudName, String userName, FileInfo fileInfo, String driveFileInfoId, boolean isMail) {
        return this.fileDao.saveFileInfoForODB(cloudName, userName, fileInfo, driveFileInfoId, isMail);
    }

    @Override
    public void removeFileInfoForAlreadyExists(String driveFileInfoId, boolean isMail) {
        this.fileDao.removeFileInfoForAlreadyExists(driveFileInfoId, isMail);
    }

    @Override
    public void removeBackupFromTempDb(Cloud cloud, ObjectId backupId) {
        this.utilService.removeBackupFromTempDb(cloud, backupId, true);
        logger.debug("after removeBackupFromTempDb....." + backupId);
    }

    @Override
    public BackUpImage getBkpFileByIdAndDevice(int cloudId, ObjectId backupId, Device device) {
        return this.backupFileDao.getBkpFileByIdAndDevice(cloudId, backupId, device);
    }

    @Override
    public void saveImageToBackUp(int cloudId, BackUpImage backUpImage, Device device) {
        this.backupFileDao.saveImageToBackUp(cloudId, backUpImage, device);
    }

    @Override
    public boolean restoreOneFileForBlackListUser(String userName, Cloud cloud) {
        return this.fileDao.restoreOneFileForBlackListUser(userName, cloud);
    }

    @Override
    public StringBuilder checkOdbFolders(Cloud cloud, StringBuilder result) {
        List usersList = this.utilDao.getAllUsers(cloud.getCloudId());
        ArrayList<String> completedUsersList = new ArrayList<String>();
        for (User user : usersList) {
            if (user == null) continue;
            String emailId = user.getEmailId();
            if (StringUtils.isNotEmpty((String)user.getOdbLoginId())) {
                emailId = user.getOdbLoginId();
            }
            if (!completedUsersList.contains(emailId)) {
                HashMap<String, Long> foldersMap = new HashMap<String, Long>();
                this.cloudSupportService.checkOdbFolders(cloud, user.getUserName(), emailId, foldersMap, result);
                completedUsersList.add(emailId);
                continue;
            }
            logger.debug("already checked " + emailId);
        }
        return result;
    }

    @Override
    public BackupPolicy getBackupPolicyForUser(int cloudId, String userName) {
        User user = this.utilService.getUserInfoByName(1, userName);
        BackupPolicy backupPolicy = this.utilDao.getBackupPolicy(cloudId, user.getPolicyName());
        return backupPolicy;
    }

    @Override
    public OfficeBackupPolicy getOfficeBackupPolicyForUser(int cloudId, String userName) {
        User user = this.utilService.getUserInfoByName(1, userName);
        OfficeBackupPolicy backupPolicy = this.utilDao.getODBBackupPolicy(cloudId, user.getOneDrivePolicyName());
        return backupPolicy;
    }

    @Override
    public List<BackUpImage> getVersions(int cloudId, String cloudName, String fileName, String devicePath, Device device) {
        List<BackUpImage> backUpImagesList = this.utilDao.getVersions(cloudId, cloudName, fileName, devicePath, device);
        logger.debug("size before getFilteredBackupImageListForVersions " + backUpImagesList.size());
        backUpImagesList = this.getFilteredBackupImageListForVersions(backUpImagesList);
        logger.debug("size after getFilteredBackupImageListForVersions " + backUpImagesList.size());
        return backUpImagesList;
    }

    private List<BackUpImage> getFilteredBackupImageListForVersions(List<BackUpImage> backUpImages) {
        logger.debug("Inside grouping backup images For versions");
        ArrayList iterateList = new ArrayList();
        backUpImages.stream().collect(Collectors.toList()).stream().collect(Collectors.groupingBy(BackUpImage::getLastServerModifiedTime)).entrySet().stream().forEach(p -> iterateList.add(((List)p.getValue()).stream().findFirst().get()));
        List<BackUpImage> filteredBackUpImages = iterateList.stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).collect(Collectors.toList());
        return filteredBackUpImages;
    }

    @Override
    public boolean saveContentChunkFileInfo(String cloudName, String fileName, ContentChunkFile fileInfo, boolean isUpdate) {
        return this.fileDao.saveContentChunkFileInfoInMongo(fileInfo, fileName, cloudName, isUpdate);
    }

    @Override
    public ContentChunkFile getContentChunkFileInfo(String tableName, String fileName, String cloudName) {
        return this.fileDao.getContentChunkFileInfoInMongo(tableName, fileName, cloudName);
    }

    @Override
    public List<ContentChunkFile> getFilesForContentChnkStatus(String tableNameHash, String queryParam, int skipValue) {
        return this.fileDao.getFilesForContentChunkStatus(tableNameHash, queryParam, skipValue);
    }

    @Override
    public void updateStatusOfContentChnkFile(String userName, ContentChunkFile contentChunkFile, String tableNameHash, List<ContentChunkFile> noContentChunkFileList, String batchId) {
        this.setRateLimiter();
        logger.debug("%%% PVN ACQ in secs:" + this.limiter.acquire());
        ChunkDetail chunkDetail = this.fileDao.getChunkDetailFromLocalMongo(tableNameHash, contentChunkFile.getMd5());
        if (chunkDetail != null) {
            contentChunkFile.setChunkFound(true);
        } else {
            chunkDetail = this.checkChunkDetail(userName, contentChunkFile, batchId);
            if (chunkDetail != null) {
                chunkDetail.setClientDedupRefCount(0);
            }
        }
        if (chunkDetail == null && contentChunkFile.isContentPresent()) {
            logger.debug("................chunk detail is nulllllll " + chunkDetail + "content chunjk d etail...........");
            chunkDetail = new ChunkDetail();
            chunkDetail.setMd5(contentChunkFile.getMd5());
            chunkDetail.setFsPath(contentChunkFile.getfSPath());
            chunkDetail.setPreEntry(true);
            chunkDetail.setUserName(userName);
            chunkDetail.setChunkCreatedTime(System.currentTimeMillis());
            contentChunkFile.setChunkFound(true);
        }
        if (chunkDetail != null) {
            chunkDetail.setClientDedupRefCount(chunkDetail.getClientDedupRefCount() + 1);
            logger.debug("client dedup ref count..." + chunkDetail.getClientDedupRefCount());
            this.fileDao.saveChunkDetailFromLocalMongo(tableNameHash, chunkDetail);
        }
        contentChunkFile.setProcessed(true);
        if (!contentChunkFile.isContentPresent() && !contentChunkFile.isChunkFound()) {
            noContentChunkFileList.add(contentChunkFile);
        }
        this.saveContentChunkFileInfo("", tableNameHash, contentChunkFile, false);
    }

    private void setRateLimiter() {
        if (this.limiter == null) {
            this.limiter = RateLimiter.create((double)PCHelperConstant.getNumOfHitsToDBForContentChunkCheck());
            logger.debug("....Rate limiter value:" + this.limiter.getRate());
        }
    }

    @Override
    public boolean moveChunkDetailFromTempColl(String tableName) {
        try {
            List chunkDetailList = this.fileDao.getAllChunkDetailsFromLocalMongo(tableName);
            for (ChunkDetail chunkDetail : chunkDetailList) {
                this.externalStorageBackupFileDao.saveChunkDetailForClientDedup(1, chunkDetail);
            }
            this.removeContentChunkTableFromMongo(tableName, "chunkDetail");
        }
        catch (Exception e) {
            logger.error("error in saving to chunkdetail from temp", (Throwable)e);
        }
        return true;
    }

    private ChunkDetail checkChunkDetail(String userName, ContentChunkFile contentChunkFile, String batchId) {
        User user = this.utilService.getUserInfoByName(1, userName);
        BackupPolicy backupPolicy = this.utilService.getBackupPolicy(1, user.getPolicyName());
        String dedupVal = this.getDedupValue(backupPolicy);
        logger.debug(backupPolicy + "......" + dedupVal + " update pvnnnnnnnnnn............" + contentChunkFile.getMd5());
        ChunkDetail chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd5ForClientDedup(1, contentChunkFile.getMd5(), dedupVal, userName, true, false, batchId);
        if (chunkDetail == null) {
            logger.debug("................chunk detail is empty for userName " + userName + " so search with userName case insesitive...........");
            chunkDetail = this.externalStorageBackupFileDao.getChunkDetailForMd5ForClientDedup(1, contentChunkFile.getMd5(), dedupVal, userName, true, true, batchId);
        }
        logger.debug("................chunk detail " + chunkDetail + "content chunjk d etail...........");
        if (chunkDetail != null) {
            logger.debug("................chunk detail notttttt nulllllllllll" + chunkDetail + "content chunjk d etail...........");
            boolean isFileExists = true;
            contentChunkFile.setChunkFound(true);
            if (chunkDetail.isPreEntry() && !new File(chunkDetail.getFsPath()).exists()) {
                isFileExists = false;
                this.externalStorageBackupFileDao.deleteChunkDetail(1, chunkDetail);
                contentChunkFile.setChunkFound(false);
                chunkDetail = null;
            }
            if (isFileExists) {
                logger.debug(" chunk found update pvnnnnnnnnnn............" + contentChunkFile.getMd5());
                contentChunkFile.setChunkFound(true);
                logger.debug(" update pvnnnnnnnnnn............" + contentChunkFile.isChunkFound());
            }
        }
        return chunkDetail;
    }

    @Override
    public void removeContentChunkTableFromMongo(String tableNameHash, String type) {
        logger.debug("Before dropping the collection...." + tableNameHash);
        this.fileDao.dropContentChunkFileCollectionInMongo(tableNameHash, "", type);
    }

    @Override
    public boolean removeContentChunkFileByName(String fileName, String tableName, String cloudName) {
        this.fileDao.removeContentChunkFileByName(fileName, tableName, cloudName);
        return true;
    }

    @Override
    public boolean removeContentChunkFileInfoInMongo(ContentChunkFile contentChunkFile, String tableName, String cloudName) {
        this.fileDao.removeContentChunkFileInfoInMongo(contentChunkFile, tableName, cloudName);
        return false;
    }

    @Override
    public void deleteTablenChunkEntriesIfExistsWithSameHash(String tablenameHash) {
        this.fileDao.delCollIfSameNameExists(tablenameHash);
    }

    @Override
    public boolean isCollExists(String tableName) {
        return this.fileDao.isCollExists(tableName);
    }

    @Override
    public void moveFailedFilesToBkpQueueAndDeleteInLocal(String cloudName, FileInfo fileInfo, boolean isBlackListUser) {
        this.fileDao.moveFailedFilesToBkpQueueAndDeleteInLocal(fileInfo, cloudName, isBlackListUser, true, false);
    }

    @Override
    public void moveFailedFilesToDiffQueueAndDeleteInLocal(String cloudName, FileInfo fileInfo, boolean isBlackListUser) {
        this.fileDao.moveFailedFilesToDiffQueueAndDeleteInLocal(fileInfo, cloudName, isBlackListUser);
    }

    public static String generateMD5ForByteArray(byte[] bytes) {
        String md5 = null;
        try {
            md5 = new String(Hex.encodeHex((byte[])DigestUtils.md5((InputStream)new ByteArrayInputStream(bytes))));
        }
        catch (Exception exception) {
            logger.trace("execption while genrating MD5 for stream" + exception);
            logger.error(exception.getMessage());
        }
        return md5;
    }

    @Override
    public void addFailedFiles(DriveFileInfo item, String policyName) {
        this.fileDao.addFailedFiles(item, policyName);
    }

    @Override
    public List<DriveFileInfo> getFailedFiles(String deviceUUID) {
        return this.fileDao.getFailedFiles(deviceUUID);
    }

    private PciAuthorizationTokenElement getMSGTokenElement(MSGTokens msgTokens, User user) {
        PciAuthorizationTokenElement tokenElement = new PciAuthorizationTokenElement();
        if (msgTokens == null) {
            return tokenElement;
        }
        tokenElement.setAccessToken(msgTokens.getAccessToken());
        tokenElement.setClientId(msgTokens.getClientId());
        tokenElement.setClientSecret(msgTokens.getClientSecret());
        tokenElement.setRedirectUri(msgTokens.getRedirectUri());
        tokenElement.setRefreshToken(msgTokens.getRefreshToken());
        tokenElement.setAccountId(msgTokens.getAccountId());
        tokenElement.setSharePointUrl(msgTokens.getSharePointUrl());
        tokenElement.setCloudName(msgTokens.getCloudName());
        if (user != null) {
            if (StringUtils.isEmpty((String)user.getOdbLoginId())) {
                tokenElement.setAccountId(user.getEmailId());
            } else {
                tokenElement.setAccountId(user.getOdbLoginId());
            }
            tokenElement.setUserName(user.getUserName());
        }
        return tokenElement;
    }

    @Override
    public FileInfo getFileFromPG(String cloudName, String backupId) {
        return this.fileDao.getFileFromPG(cloudName, backupId);
    }

    @Override
    public void saveFileInfoBusy(String cloudName, String userName, FileInfo fileInfo) {
        this.fileDao.saveFileInfoBusy(fileInfo, cloudName);
    }

    @Override
    public void checkAzureBlobConnection(Cloud cloud) {
        this.cloudSupportService.checkAzureBlobConnection(cloud);
    }

    @Override
    public boolean deleteUserFolderInsidePB(ChunkDetail chunkDetail) {
        return this.cloudSupportService.deleteUserFolderInsidePB(chunkDetail);
    }

    @Override
    public MiniCloud getMiniCloudById(int cloudId, String miniCloudId) {
        return this.syncFileDao.getMiniCloudById(cloudId, miniCloudId);
    }

    private boolean isSPDestEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isSPDestEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"SharePoint Dest Enabled".equalsIgnoreCase(license.getName())) continue;
            isSPDestEnabled = true;
            break;
        }
        return isSPDestEnabled;
    }

    @Override
    public OfficeBackupPolicy getOfficeBackupPolicyForUserSite(int cloudId, String userName) {
        User user = this.utilService.getUserInfoByName(1, userName);
        OfficeBackupPolicy backupPolicy = this.utilDao.getSpBackupPolicy(cloudId, user.getSpPolicyName());
        return backupPolicy;
    }

    @Override
    public OfficeBackupPolicy getOfficeBackupPolicyForUserDeviceProduct(int cloudId, String userName, String osType) {
        return null;
    }

    static enum DEDUP {
        DISABLED,
        USER,
        GLOBAL;

    }
}

