/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.parablu.pcbd.domain.BlackListUser;
import com.pg.dao.FileDao;
import com.pg.dao.Office365Dao;
import com.pg.element.FileStatusElement;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.encryption.service.FileEncryptionService;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MD5Generator;
import com.pg.helper.utils.MemoryStore;
import com.pg.httpclient.util.HttpClientUtil;
import com.pg.service.LocalFileSystemService;
import com.pg.service.Office365UploadService;
import com.pg.service.UtilService;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

public class Office365UploadServiceImpl
implements Office365UploadService {
    private static Logger logger = LogManager.getLogger(Office365UploadServiceImpl.class);
    private FileDao fileDao;
    private Office365Dao office365Dao;
    @Autowired
    private FileEncryptionService fileEncryptionService;
    @Autowired
    private LocalFileSystemService localFileSystemService;
    @Autowired
    private UtilService utilService;
    private static final String FOLDER_CREATION_FALSE_REFRESH_TOKEN = "Sucess for creating folder is false so refreshh the token";
    private static final String BEARER = "Bearer ";
    private static final String PARACLOUD_CLOUD_PATH = "/paracloud/cloud/";
    private static final String BLACK_LIST_USERS = "BlackListUsers";
    private static final String COUNT_429 = "CountOf429";

    public void setFileDao(FileDao fileDao) {
        this.fileDao = fileDao;
    }

    public void setOffice365Dao(Office365Dao office365Dao) {
        this.office365Dao = office365Dao;
    }

    public void setFileEncryptionService(FileEncryptionService fileEncryptionService) {
        this.fileEncryptionService = fileEncryptionService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    protected String decodeBase64UTFString(String encodedString) {
        String decodedString = encodedString;
        try {
            decodedString = new String(Base64.decodeBase64((String)encodedString), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("UnsupportedEncodingException", (Throwable)e);
        }
        return decodedString;
    }

    @Override
    public FileStatusElement uploadFileToODB(String accessToken, PciAuthorizationTokenElement pciTokenElement, File encryptedFile, String cloudStoragePath, String deviceUUID, String gateWayName, String uploadingFileName, FileStatusElement fileStatusElement, boolean isChunkDeleteProcessStarted, boolean isSync) {
        String encodedFileName = "";
        PciAuthorizationTokenElement pciTokenElementTemp = pciTokenElement;
        FileStatusElement element = new FileStatusElement();
        String accessTokenTemp = accessToken;
        if (pciTokenElementTemp != null) {
            String userName = pciTokenElementTemp.getUserName();
            String accountId = pciTokenElementTemp.getAccountId();
            if (!StringUtils.isEmpty((String)accessTokenTemp)) {
                String pbFolderName = this.office365Dao.getOdbFolderName(1);
                if (StringUtils.isEmpty((String)pbFolderName)) {
                    pbFolderName = "PB";
                }
                logger.debug("%^%^%^%^%^%^%^ AFTER...." + uploadingFileName);
                encodedFileName = this.convertStringTOBase64(uploadingFileName).replaceAll("/", "_");
                if (isChunkDeleteProcessStarted) {
                    encodedFileName = encodedFileName + "_1";
                }
                FileStatusElement writeElement = this.write(pciTokenElementTemp.getSharePointUrl(), accessTokenTemp, encryptedFile, accountId, userName, pciTokenElementTemp, cloudStoragePath, encodedFileName, false, pbFolderName, deviceUUID, gateWayName, fileStatusElement, isSync);
                boolean uploadSuccess = writeElement.isUploadStatus();
                element.setUploadStatuscode(writeElement.getUploadStatuscode());
                if (!StringUtils.isEmpty((String)writeElement.getOdbLoginId())) {
                    logger.debug("..........." + writeElement.getOdbLoginId());
                    element.setOdbLoginId(writeElement.getOdbLoginId());
                }
                if (!uploadSuccess) {
                    encodedFileName = "";
                }
                element.setEncodedFileName(encodedFileName);
            }
        }
        return element;
    }

    private String getEncodedName(File encryptedFile) {
        String encryptedFileName = encryptedFile.getName();
        logger.debug("%^%^%^%^%^%^%^ BEFORE...." + encryptedFileName);
        try {
            if (encryptedFile.getName().contains("_")) {
                String charToRemove = "";
                charToRemove = encryptedFile.getName().contains(".") ? encryptedFile.getName().substring(encryptedFile.getName().lastIndexOf("_"), encryptedFile.getName().lastIndexOf(".")) : encryptedFile.getName().substring(encryptedFile.getName().lastIndexOf("_"), encryptedFile.getName().length());
                logger.debug("%^%^%^%^%^%^%^ REMOVING CHAR .... " + charToRemove);
                encryptedFileName = encryptedFileName.replace(charToRemove, "");
            }
        }
        catch (Exception e) {
            logger.error("error in Encoding the chunk name " + encryptedFileName + e.getMessage());
            logger.trace("" + e);
        }
        return encryptedFileName;
    }

    private static String getUniqueODUserFolder(String uniqueId) {
        String convertedString = "";
        if (!StringUtils.isEmpty((String)uniqueId)) {
            String md5Val = MD5Generator.generateMD5OfString((String)uniqueId);
            Long l = ByteBuffer.wrap(md5Val.toString().getBytes()).getLong();
            convertedString = Long.toString(l, 36);
        }
        return convertedString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileStatusElement write(String sharePointURL, String token, File file, String accountId, String userName, PciAuthorizationTokenElement pciTokenElement, String cloudStoragePath, String encodedFileName, boolean uploadAdminAcc, String pbFolderName, String deviceUUID, String gateWayName, FileStatusElement fileStatusElement, boolean isSync) {
        PciAuthorizationTokenElement pciTokenElementTemp = pciTokenElement;
        FileStatusElement element = new FileStatusElement();
        String userNameToGetUrl = userName;
        String tokenTemp = token;
        int cloudId = 1;
        boolean uploadSuccess = false;
        if (!uploadAdminAcc) {
            userNameToGetUrl = "";
        }
        if (!StringUtils.isEmpty((String)deviceUUID) && !isSync) {
            userNameToGetUrl = Office365UploadServiceImpl.getUniqueODUserFolder(deviceUUID);
            logger.debug("....device unique id ....... " + userNameToGetUrl);
        } else if (!StringUtils.isEmpty((String)userName) && isSync) {
            userNameToGetUrl = Office365UploadServiceImpl.getUniqueODUserFolder(userName);
            logger.debug("device unique id : " + userNameToGetUrl);
        }
        element.setOdbLoginId(accountId);
        String uploadurl = PCHelperConstant.getParabluLibraryUrl((String)sharePointURL, (String)accountId, (String)userNameToGetUrl, (String)cloudStoragePath, (String)pbFolderName);
        String fileUrl = uploadurl + "/Files/add(overwrite=false,url='" + encodedFileName + "')";
        logger.debug(file.length() + "...url>>>>>>>>>>>" + fileUrl);
        HttpPost httpPost = new HttpPost(fileUrl);
        httpPost.setEntity((HttpEntity)new FileEntity(file, "*/*"));
        httpPost.addHeader("Authorization", BEARER + tokenTemp);
        httpPost.addHeader("Accept", "application/json;odata=verbose");
        if (!StringUtils.isEmpty((String)PCHelperConstant.getODBDecorationValue())) {
            httpPost.addHeader("User-Agent", PCHelperConstant.getODBDecorationValue());
            logger.debug("..add THROTTLE_DECOR..............." + PCHelperConstant.getODBDecorationValue());
        }
        logger.debug("..check THROTTLE_DECOR...............");
        HttpResponse result = null;
        String proxyUserName = PCHelperConstant.getProxyUserName();
        String password = PCHelperConstant.getProxyPassword();
        String host = PCHelperConstant.getProxyHost();
        int port = PCHelperConstant.getProxyPort();
        boolean isProxyEnabled = false;
        int responseCode = 0;
        try {
            Set blackUsersList;
            Object obj = MemoryStore.get((String)BLACK_LIST_USERS);
            if (obj != null && (blackUsersList = (Set)obj).contains(userName)) {
                logger.debug("...user is blacklisted.... " + userName);
                element.setUploadStatus(false);
                FileStatusElement fileStatusElement2 = element;
                return fileStatusElement2;
            }
            if (StringUtils.isEmpty((String)userName) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)host) || port <= 0) {
                HttpClient httpclient = HttpClientUtil.getSSlConnection();
                result = httpclient.execute((HttpUriRequest)httpPost);
            } else {
                isProxyEnabled = true;
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(proxyUserName, password));
                CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
                HttpHost proxy = new HttpHost(host, port);
                int timeout = 10;
                RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).setProxy(proxy).build();
                httpPost.setConfig(config);
                result = httpclient.execute((HttpUriRequest)httpPost);
            }
            responseCode = result.getStatusLine().getStatusCode();
            logger.debug(result.getStatusLine().getReasonPhrase() + "...Response status code for user : " + userNameToGetUrl + "....." + responseCode);
            String pathTobeCreated = cloudStoragePath;
            if (!StringUtils.isEmpty((String)userNameToGetUrl)) {
                pathTobeCreated = userNameToGetUrl + "/" + cloudStoragePath;
            }
            if (responseCode == 401) {
                uploadSuccess = false;
                if ((pciTokenElementTemp = this.office365Dao.getAccessToken(pciTokenElementTemp)) != null) {
                    tokenTemp = pciTokenElementTemp.getAccessToken();
                    if (pciTokenElementTemp.isServiceAcct()) {
                        this.office365Dao.updatePciAuthorizationTokensForServiceAcct(1, pciTokenElementTemp.getAccessToken(), pciTokenElementTemp.getRefreshToken());
                    } else {
                        this.utilService.updatePciAuthorizationToken(pciTokenElementTemp, userName);
                    }
                    uploadSuccess = this.retryWrite(sharePointURL, tokenTemp, file, accountId, userNameToGetUrl, pciTokenElementTemp, cloudStoragePath, encodedFileName, pbFolderName, isProxyEnabled, gateWayName, fileStatusElement, userName);
                }
            } else {
                BlackListUser blackListUser;
                BlackListUser blackListUserObj = this.utilService.getBlackListUserbyNameAndLocalHost(cloudId, userName, gateWayName);
                if (responseCode == 403) {
                    try {
                        logger.debug("%%%%%%%%%%%%%%%%%%%%%%%%%%%INSIDE403..................\n\tprivate void closeResponse(HttpResponse result) {\n\t\tif(result != null) {\n\t\t\ttry {\n\t\t\t\tresult.close();\n\t\t\t} catch (IOException e) {\n\t\t\t\tlogger.error(\"error in closing http client:\"+e.getMessage());\n\t\t\t}\n\t\t}\n\t}." + pathTobeCreated);
                        boolean success = this.office365Dao.createLibraryIfNotExists(pciTokenElementTemp.getSharePointUrl(), pciTokenElementTemp.getAccessToken(), pciTokenElementTemp.getAccountId(), pbFolderName, pathTobeCreated);
                        uploadSuccess = false;
                        if (success) {
                            uploadSuccess = this.retryWrite(sharePointURL, tokenTemp, file, accountId, userNameToGetUrl, pciTokenElementTemp, cloudStoragePath, encodedFileName, pbFolderName, isProxyEnabled, gateWayName, fileStatusElement, userName);
                        } else {
                            this.utilService.updateUserBackupTargetStatus(cloudId, userName, 403);
                            String userBlockedForWrite = "403_" + userName;
                            obj = MemoryStore.get((String)userBlockedForWrite);
                            if (obj == null) {
                                MemoryStore.add((String)userBlockedForWrite, (Object)userName, (long)1800000L);
                                if (blackListUserObj == null) {
                                    blackListUser = new BlackListUser();
                                    blackListUser.setResponseCode("403");
                                    blackListUser.setUserName(userName);
                                    blackListUser.setLocalHost(PCHelperConstant.getComponentName());
                                    this.utilService.saveBlackListUser(cloudId, blackListUser);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error("..responseCode 403..... " + e.getMessage());
                        logger.error("..responseCode 403..... " + e);
                    }
                } else if (responseCode == 404) {
                    logger.debug("...before calling createLibraryIfNotExists... " + pathTobeCreated);
                    boolean success = this.office365Dao.createLibraryIfNotExists(pciTokenElementTemp.getSharePointUrl(), pciTokenElementTemp.getAccessToken(), pciTokenElementTemp.getAccountId(), pbFolderName, pathTobeCreated);
                    if (!success) {
                        if ((pciTokenElementTemp = this.office365Dao.getAccessToken(pciTokenElementTemp)) != null) {
                            tokenTemp = pciTokenElementTemp.getAccessToken();
                            success = this.office365Dao.createLibraryIfNotExists(pciTokenElementTemp.getSharePointUrl(), pciTokenElementTemp.getAccessToken(), pciTokenElementTemp.getAccountId(), pbFolderName, pathTobeCreated);
                            if (success) {
                                uploadSuccess = this.retryWrite(sharePointURL, tokenTemp, file, accountId, userNameToGetUrl, pciTokenElementTemp, cloudStoragePath, encodedFileName, pbFolderName, isProxyEnabled, gateWayName, fileStatusElement, userName);
                                this.utilService.updatePciAuthorizationToken(pciTokenElementTemp, userName);
                            } else {
                                this.utilService.updateUserBackupTargetStatus(cloudId, userName, 404);
                                logger.debug(" user not mapped .... " + userName);
                                uploadSuccess = false;
                                String userBlockedForWrite = "404_" + userName;
                                obj = MemoryStore.get((String)userBlockedForWrite);
                                if (obj == null) {
                                    MemoryStore.add((String)userBlockedForWrite, (Object)userName, (long)1800000L);
                                    if (blackListUserObj == null) {
                                        blackListUser = new BlackListUser();
                                        blackListUser.setResponseCode("404");
                                        blackListUser.setUserName(userName);
                                        blackListUser.setLocalHost(PCHelperConstant.getComponentName());
                                        this.utilService.saveBlackListUser(cloudId, blackListUser);
                                    } else if (!blackListUserObj.getResponseCode().equalsIgnoreCase("404")) {
                                        this.utilService.updateBlackListUserWithCode(cloudId, userName, gateWayName, "404");
                                    }
                                } else if (blackListUserObj != null && !blackListUserObj.getResponseCode().equalsIgnoreCase("404")) {
                                    this.utilService.updateBlackListUserWithCode(cloudId, userName, gateWayName, "404");
                                }
                            }
                        }
                    } else {
                        uploadSuccess = false;
                        uploadSuccess = this.retryWrite(sharePointURL, tokenTemp, file, accountId, userNameToGetUrl, pciTokenElementTemp, cloudStoragePath, encodedFileName, pbFolderName, isProxyEnabled, gateWayName, fileStatusElement, userName);
                    }
                } else if (responseCode == 400) {
                    String chunkPath = userNameToGetUrl + "/" + cloudStoragePath;
                    uploadSuccess = this.checkIfFileAlreadyExists(chunkPath, encodedFileName, pbFolderName, pciTokenElementTemp, uploadSuccess, proxyUserName, password, host, port);
                    fileStatusElement.setChunkAlreadyExist(uploadSuccess);
                } else if (responseCode != 200) {
                    if (responseCode == 429) {
                        try {
                            try {
                                Object countOf429 = MemoryStore.get((String)COUNT_429);
                                logger.debug("....429 get count " + countOf429);
                                if (countOf429 != null) {
                                    int count = (Integer)countOf429 + 1;
                                    logger.debug("....429 adding count " + count);
                                    MemoryStore.add((String)COUNT_429, (Object)count++, (long)1800000L);
                                } else {
                                    logger.debug("....429 user ading count 1");
                                    MemoryStore.add((String)COUNT_429, (Object)1, (long)1800000L);
                                }
                            }
                            catch (Exception e) {
                                logger.trace("" + e);
                                logger.error("Exception While adding in 429 count :" + e.getMessage());
                            }
                            String value = result.getFirstHeader("Retry-After").getValue();
                            logger.debug("*****************429head**************************" + value);
                            long waitTime = Long.parseLong(value);
                            long addn429wait = PCHelperConstant.getAddn429WaitMultiplier();
                            long millis = addn429wait * waitTime * 1000L;
                            logger.debug("...Sleeping for " + waitTime + "..milli..." + millis + "....for userName..." + userName);
                            logger.debug("...PB429User..." + userName + "...resp code..." + responseCode + "..odbwait.." + waitTime + "..pbwait.." + addn429wait + "..millis to wait.." + millis);
                            this.sleepForGivenTime(millis);
                            logger.debug("...sleep completed........for userName..." + userName);
                        }
                        catch (Exception e) {
                            logger.trace("" + e);
                            logger.error("Exception While Writting :" + e.getMessage());
                        }
                    }
                    uploadSuccess = false;
                    uploadSuccess = this.retryWrite(sharePointURL, tokenTemp, file, accountId, userNameToGetUrl, pciTokenElementTemp, cloudStoragePath, encodedFileName, pbFolderName, isProxyEnabled, gateWayName, fileStatusElement, userName);
                }
            }
            if (responseCode == 200) {
                this.remove429Count();
                uploadSuccess = true;
                this.utilService.deleteBlackListUserByUserName(cloudId, userName);
            }
        }
        catch (Exception e) {
            uploadSuccess = false;
            logger.trace("" + e);
            logger.error("Exception While Writting :" + e.getMessage());
            uploadSuccess = this.retryWrite(sharePointURL, tokenTemp, file, accountId, userNameToGetUrl, pciTokenElementTemp, cloudStoragePath, encodedFileName, pbFolderName, isProxyEnabled, gateWayName, fileStatusElement, userName);
        }
        finally {
            httpPost.releaseConnection();
        }
        if (!uploadSuccess) {
            logger.debug("Response code...:" + responseCode + " for the userName..." + userName);
        }
        if (!uploadSuccess && responseCode != 429 && responseCode != 503) {
            Set<String> blackUsersList = new HashSet<String>();
            Object obj = MemoryStore.get((String)BLACK_LIST_USERS);
            if (obj != null) {
                blackUsersList = (Set)obj;
            }
            blackUsersList.add(userName.toLowerCase());
            logger.debug("......marking user as blacklisted ..code..." + responseCode);
            MemoryStore.add((String)BLACK_LIST_USERS, blackUsersList, (long)1800000L);
        }
        element.setUploadStatus(uploadSuccess);
        element.setUploadStatuscode(responseCode);
        return element;
    }

    private void remove429Count() {
        try {
            logger.debug("....429 inside remove429Count");
            Object countOf429 = MemoryStore.get((String)COUNT_429);
            if (countOf429 != null) {
                logger.debug("....429 get count for 200 case " + countOf429);
                MemoryStore.delete((String)COUNT_429);
            } else {
                logger.debug("....429 count is empty");
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While adding in 429 count :" + e.getMessage());
        }
    }

    private boolean checkIfFileAlreadyExists(String cloudStoragePath, String encodedFileName, String pbFolderName, PciAuthorizationTokenElement pciTokenElementTemp, boolean uploadSuccess1, String proxyUserName, String password, String host, int port) {
        boolean uploadSuccess = uploadSuccess1;
        String downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)pciTokenElementTemp.getSharePointUrl(), (String)encodedFileName, (String)pciTokenElementTemp.getAccountId(), (String)"", (String)cloudStoragePath, (String)pbFolderName);
        HttpGet httpGet = new HttpGet(downloadurl);
        httpGet.addHeader("Authorization", BEARER + pciTokenElementTemp.getAccessToken());
        httpGet.addHeader("Accept", "application/json;odata=verbose");
        httpGet.addHeader("Content-Type", "*/*");
        try {
            HttpResponse result;
            if (StringUtils.isEmpty((String)proxyUserName) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)host) || port <= 0) {
                logger.debug(" without proxy ...");
                HttpClient httpclient = HttpClientUtil.getSSlConnection();
                result = httpclient.execute((HttpUriRequest)httpGet);
            } else {
                logger.debug(" using proxy ...");
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(proxyUserName, password));
                CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
                HttpHost proxy = new HttpHost(host, port);
                RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
                httpGet.setConfig(config);
                result = httpclient.execute((HttpUriRequest)httpGet);
            }
            int statusCode = result.getStatusLine().getStatusCode();
            logger.debug(" already exists check Response status code: " + statusCode);
            if (statusCode == 200) {
                uploadSuccess = true;
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Downloading File From One Drive :" + e.getMessage());
        }
        return uploadSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean retryWrite(String sharePointURL, String token, File file, String accountId, String encodedFolderPath, PciAuthorizationTokenElement pciTokenElement, String cloudStoragePath, String encodedFileName, String pbFolderName, boolean proxyEnabled, String gateWayName, FileStatusElement fileStatusElement, String userName1) {
        boolean retry;
        String tokenTemp = token;
        int retryCount = 0;
        int sleepMultiplier = 1;
        int cloudId = 1;
        long sleepTime = 60000L * (long)sleepMultiplier;
        PciAuthorizationTokenElement pciTokenElementTemp = pciTokenElement;
        HttpPost httpPost = null;
        boolean uploadSuccess = false;
        String proxyUserName = PCHelperConstant.getProxyUserName();
        String password = PCHelperConstant.getProxyPassword();
        String host = PCHelperConstant.getProxyHost();
        int port = PCHelperConstant.getProxyPort();
        do {
            retry = false;
            uploadSuccess = true;
            try {
                Object obj;
                String userBlockedForWrite;
                Object obj2;
                String userBlockedForWrite2;
                String value;
                HttpResponse result;
                String uploadurl = PCHelperConstant.getParabluLibraryUrl((String)sharePointURL, (String)accountId, (String)encodedFolderPath, (String)cloudStoragePath, (String)pbFolderName);
                String fileUrl = uploadurl + "/Files/add(overwrite=false,url='" + encodedFileName + "')";
                httpPost = new HttpPost(fileUrl);
                httpPost.setEntity((HttpEntity)new FileEntity(file, "*/*"));
                httpPost.addHeader("Authorization", BEARER + tokenTemp);
                httpPost.addHeader("Accept", "application/json;odata=verbose");
                if (!StringUtils.isEmpty((String)PCHelperConstant.getODBDecorationValue())) {
                    httpPost.addHeader("User-Agent", PCHelperConstant.getODBDecorationValue());
                    logger.debug("..add retry THROTTLE_DECOR..............." + PCHelperConstant.getODBDecorationValue());
                }
                logger.debug("..RETRY THROTTLE_DECOR...............");
                if (!proxyEnabled) {
                    HttpClient httpclient = HttpClientUtil.getSSlConnection();
                    result = httpclient.execute((HttpUriRequest)httpPost);
                } else {
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    credsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(proxyUserName, password));
                    CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
                    HttpHost proxy = new HttpHost(host, port);
                    int timeout = 10;
                    RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).setProxy(proxy).build();
                    httpPost.setConfig(config);
                    result = httpclient.execute((HttpUriRequest)httpPost);
                }
                int responseCode = result.getStatusLine().getStatusCode();
                logger.debug("Response status code: " + responseCode + "result message" + result.getStatusLine().getReasonPhrase());
                if (responseCode == 401) {
                    pciTokenElementTemp = this.office365Dao.getAccessToken(pciTokenElementTemp);
                    tokenTemp = pciTokenElementTemp.getAccessToken();
                    if (pciTokenElementTemp.isServiceAcct()) {
                        this.office365Dao.updatePciAuthorizationTokensForServiceAcct(1, pciTokenElementTemp.getAccessToken(), pciTokenElementTemp.getRefreshToken());
                    } else {
                        this.utilService.updatePciAuthorizationToken(pciTokenElementTemp, userName1);
                    }
                    uploadSuccess = false;
                    retry = true;
                    ++retryCount;
                } else if (responseCode == 429) {
                    uploadSuccess = false;
                    retry = true;
                    retryCount = 3;
                    try {
                        value = result.getFirstHeader("Retry-After").getValue();
                        logger.debug("*****************429head**************************" + value);
                        long waitTime = Long.parseLong(value);
                        userBlockedForWrite2 = "429_" + userName1;
                        obj2 = MemoryStore.get((String)userBlockedForWrite2);
                        if (obj2 == null) {
                            MemoryStore.add((String)userBlockedForWrite2, (Object)userName1, (long)(waitTime * 1000L));
                            if (this.utilService.getBlackListUserbyNameAndLocalHost(cloudId, userName1, gateWayName) == null) {
                                BlackListUser blackListUser = new BlackListUser();
                                blackListUser.setResponseCode("429");
                                blackListUser.setUserName(userName1);
                                blackListUser.setLocalHost(gateWayName);
                                blackListUser.setWaitTime(waitTime);
                                this.utilService.saveBlackListUser(cloudId, blackListUser);
                            }
                        }
                        long millis = waitTime * 1000L;
                        logger.debug("...Sleeping for " + waitTime + "..milli..." + millis + "....for userName..." + userName1);
                        this.sleepForGivenTime(millis);
                    }
                    catch (Exception e) {
                        logger.debug("Exception while retry....." + e.getMessage());
                        logger.debug("Exception while retry....." + e);
                    }
                } else if (responseCode == 403) {
                    this.utilService.updateUserBackupTargetStatus(cloudId, userName1, 403);
                    userBlockedForWrite = "403_" + userName1;
                    obj = MemoryStore.get((String)userBlockedForWrite);
                    if (obj == null) {
                        MemoryStore.add((String)userBlockedForWrite, (Object)userName1, (long)1800000L);
                        if (this.utilService.getBlackListUserbyNameAndLocalHost(cloudId, userName1, gateWayName) == null) {
                            BlackListUser blackListUser = new BlackListUser();
                            blackListUser.setResponseCode("403");
                            blackListUser.setUserName(userName1);
                            blackListUser.setLocalHost(gateWayName);
                            this.utilService.saveBlackListUser(cloudId, blackListUser);
                        }
                    }
                    uploadSuccess = false;
                } else if (responseCode == 404) {
                    userBlockedForWrite = "404_" + userName1;
                    this.utilService.updateUserBackupTargetStatus(cloudId, userName1, 404);
                    obj = MemoryStore.get((String)userBlockedForWrite);
                    if (obj == null) {
                        MemoryStore.add((String)userBlockedForWrite, (Object)userName1, (long)1800000L);
                        if (this.utilService.getBlackListUserbyNameAndLocalHost(cloudId, userName1, gateWayName) == null) {
                            BlackListUser blackListUser = new BlackListUser();
                            blackListUser.setResponseCode("404");
                            blackListUser.setUserName(userName1);
                            blackListUser.setLocalHost(PCHelperConstant.getComponentName());
                            this.utilService.saveBlackListUser(cloudId, blackListUser);
                        }
                    }
                    uploadSuccess = false;
                } else if (responseCode == 400) {
                    String chunkPath = encodedFolderPath + "/" + cloudStoragePath;
                    uploadSuccess = this.checkIfFileAlreadyExists(chunkPath, encodedFileName, pbFolderName, pciTokenElementTemp, uploadSuccess, proxyUserName, password, host, port);
                    fileStatusElement.setChunkAlreadyExist(uploadSuccess);
                } else if (responseCode != 200) {
                    if (responseCode == 503) {
                        if (result != null && result.getFirstHeader("Retry-After") != null) {
                            value = result.getFirstHeader("Retry-After").getValue();
                            try {
                                logger.debug("*****************503 head**************************" + value);
                                long waitTime = Long.parseLong(value);
                                userBlockedForWrite2 = "503_" + userName1;
                                obj2 = MemoryStore.get((String)userBlockedForWrite2);
                                if (obj2 == null) {
                                    MemoryStore.add((String)userBlockedForWrite2, (Object)userName1, (long)(waitTime * 1000L));
                                    if (this.utilService.getBlackListUserbyNameAndLocalHost(cloudId, userName1, gateWayName) == null) {
                                        BlackListUser blackListUser = new BlackListUser();
                                        blackListUser.setResponseCode("503");
                                        blackListUser.setUserName(userName1);
                                        blackListUser.setLocalHost(PCHelperConstant.getComponentName());
                                        this.utilService.saveBlackListUser(cloudId, blackListUser);
                                    }
                                }
                            }
                            catch (Exception e) {
                                logger.debug("Exception while retry....." + e.getMessage());
                                logger.debug("Exception while retry....." + e);
                            }
                            logger.debug("......retry for 503...... " + value);
                        } else {
                            logger.debug("result is null and status code is 503....");
                        }
                    }
                    uploadSuccess = false;
                    retry = true;
                    retryCount = 3;
                }
                if (responseCode != 200) continue;
                uploadSuccess = true;
                this.utilService.deleteBlackListUserByUserName(cloudId, userName1);
            }
            catch (UnknownHostException e) {
                logger.error("unknown host exception .... " + e.getMessage());
                logger.error("unknown host exception .... " + e);
                uploadSuccess = false;
                retry = true;
                retryCount = 2;
            }
            catch (SocketException e) {
                logger.error("....SocketException exception .... " + e.getMessage());
                logger.error("....SocketException exception .... " + e);
                uploadSuccess = false;
                retry = true;
                retryCount = 2;
            }
            catch (Exception e) {
                uploadSuccess = false;
                retry = true;
                ++retryCount;
                sleepTime = this.sleepForGivenTime(sleepTime);
                logger.trace("" + e);
                logger.error("Exception While Retrying Writting :" + e.getMessage());
            }
            finally {
                if (httpPost != null) {
                    httpPost.releaseConnection();
                }
            }
        } while (retry && retryCount < 3);
        return uploadSuccess;
    }

    private long sleepForGivenTime(long sleepTime) {
        long sleepTimeTemp = sleepTime;
        try {
            logger.debug("SleepTime is" + sleepTimeTemp);
            Thread.sleep(sleepTimeTemp);
            int sleepMultiplier = 2;
            sleepTimeTemp *= (long)sleepMultiplier;
        }
        catch (InterruptedException e1) {
            logger.error("Thread interupted error");
        }
        return sleepTimeTemp;
    }

    @Override
    public PciAuthorizationTokenElement getAccessToken(PciAuthorizationTokenElement pciAuthorizationTokenElement) {
        return this.office365Dao.getAccessToken(pciAuthorizationTokenElement);
    }

    @Override
    public long getThreadSize(String cloudName) {
        return this.fileDao.getThreadSize(cloudName);
    }

    public void setLocalFileSystemService(LocalFileSystemService localFileSystemService) {
        this.localFileSystemService = localFileSystemService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String deleteEntryForBackup(String backupId, String cloudName, String userName, String dedupedBkId) {
        logger.debug("Delete entry for backup ..... ");
        HttpClient httpclient = HttpClientUtil.getSSlConnection();
        String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + PARACLOUD_CLOUD_PATH + cloudName + "/externalbackup/" + userName + "/delete/";
        HttpPost httpPost = new HttpPost(url);
        try {
            Header[] headerarr;
            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            entity.addPart("backupId", (ContentBody)new StringBody(backupId));
            entity.addPart("dedupedBkId", (ContentBody)new StringBody(dedupedBkId));
            httpPost.setEntity((HttpEntity)entity);
            HttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            for (Header header : headerarr = response.getAllHeaders()) {
                if (!"isFileDeleted".equals(header.getName())) continue;
                logger.debug("Deleted backup Id for file ..... " + header.getName());
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Deleting Entry For Backup :" + e.getMessage());
        }
        finally {
            httpPost.releaseConnection();
            httpclient.getConnectionManager().closeIdleConnections(1L, TimeUnit.MICROSECONDS);
            httpclient.getConnectionManager().shutdown();
        }
        return backupId;
    }

    private String convertStringTOBase64(String name) {
        String base64EncodeString = null;
        if (name != null) {
            byte[] bytes = DigestUtils.md5((String)name);
            byte[] bytesEncoded = Base64.encodeBase64((byte[])bytes);
            base64EncodeString = new String(bytesEncoded);
            base64EncodeString = base64EncodeString.substring(0, base64EncodeString.length() - 2);
            logger.debug("ecncoded value for given string is " + base64EncodeString);
        }
        return base64EncodeString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCountOfFilesInFolder(PciAuthorizationTokenElement ppciTokenElement, String cloudStoragePath, String deviceUUID, boolean isSync) {
        String userNameToGetUrl = "";
        if (!StringUtils.isEmpty((String)deviceUUID) && !isSync) {
            userNameToGetUrl = Office365UploadServiceImpl.getUniqueODUserFolder(deviceUUID);
            logger.debug("....device unique id ....... " + userNameToGetUrl);
        } else if (!StringUtils.isEmpty((String)ppciTokenElement.getUserName()) && isSync) {
            userNameToGetUrl = Office365UploadServiceImpl.getUniqueODUserFolder(ppciTokenElement.getUserName());
            logger.debug("device unique id : " + userNameToGetUrl);
        }
        PciAuthorizationTokenElement pciTokenElement = ppciTokenElement;
        String pbFolderName = this.office365Dao.getOdbFolderName(1);
        String paraBluFolderPath = PCHelperConstant.getParabluLibraryUrl((String)pciTokenElement.getSharePointUrl(), (String)pciTokenElement.getAccountId(), (String)userNameToGetUrl, (String)cloudStoragePath, (String)pbFolderName);
        logger.debug(" latest PATH from onedrive ............ " + paraBluFolderPath);
        int count = 0;
        String fileUrl = paraBluFolderPath + "/itemcount";
        HttpGet httpGet = new HttpGet(fileUrl);
        httpGet.addHeader("Authorization", BEARER + pciTokenElement.getAccessToken());
        httpGet.addHeader("Accept", "application/json;odata=verbose");
        HttpResponse result = null;
        try {
            String proxyUserName = PCHelperConstant.getProxyUserName();
            String password = PCHelperConstant.getProxyPassword();
            String host = PCHelperConstant.getProxyHost();
            int port = PCHelperConstant.getProxyPort();
            if (StringUtils.isEmpty((String)proxyUserName) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)host) || port <= 0) {
                logger.debug(" #$##$@$ without proxy .getCountOfFilesInFolder.." + fileUrl);
                HttpClient httpclient = HttpClientUtil.getSSlConnection();
                result = httpclient.execute((HttpUriRequest)httpGet);
            } else {
                logger.debug(" #$##$@$ using proxy .getCountOfFilesInFolder.." + fileUrl);
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(proxyUserName, password));
                CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
                HttpHost proxy = new HttpHost(host, port);
                int timeout = 5;
                RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).setProxy(proxy).build();
                httpGet.setConfig(config);
                result = httpclient.execute((HttpUriRequest)httpGet);
            }
            int statusCode = result.getStatusLine().getStatusCode();
            if (statusCode == 401) {
                logger.debug(" token expired ........... retry count .....");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException httpclient) {
                    // empty catch block
                }
                pciTokenElement = this.office365Dao.getAccessToken(pciTokenElement);
                if (pciTokenElement != null) {
                    int httpclient = this.getCountOfFilesInFolder(pciTokenElement, cloudStoragePath, deviceUUID, isSync);
                    return httpclient;
                }
            }
            if (statusCode != 200) {
                logger.error(" path doesnot exists ......... " + statusCode);
                int httpclient = count;
                return httpclient;
            }
            logger.debug(" status code ................ " + statusCode);
            String json = EntityUtils.toString((HttpEntity)result.getEntity());
            JSONObject jsonObject = new JSONObject(json);
            String itemCount = jsonObject.optString("d");
            if (itemCount != null) {
                jsonObject = new JSONObject(new String(itemCount));
                itemCount = jsonObject.optString("ItemCount");
                count = Integer.parseInt(itemCount);
            }
            logger.debug(" item count ................ " + itemCount);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Getting Count of Files In Folder :" + e.getMessage());
        }
        finally {
            httpGet.releaseConnection();
        }
        return count;
    }

    @Override
    public FileStatusElement deleteFileFromODB(PciAuthorizationTokenElement pciTokenElement, String fileName, String cloudStoragePath, String deviceUUID, boolean isSync) {
        boolean retry;
        String fileNameTemp = fileName;
        FileStatusElement fileStatusElement = new FileStatusElement();
        PciAuthorizationTokenElement authorizationTokenElementTemp = pciTokenElement;
        String userNameInPath = "";
        if (!StringUtils.isEmpty((String)deviceUUID) && !isSync) {
            userNameInPath = Office365UploadServiceImpl.getUniqueODUserFolder(deviceUUID);
            logger.debug("....device unique id ....... " + userNameInPath);
        } else if (!StringUtils.isEmpty((String)pciTokenElement.getUserName()) && isSync) {
            userNameInPath = Office365UploadServiceImpl.getUniqueODUserFolder(pciTokenElement.getUserName());
            logger.debug("device unique id : " + userNameInPath);
        }
        logger.debug(".................." + fileNameTemp);
        String deleteurl = this.getFilePathToDelete(pciTokenElement, fileNameTemp, cloudStoragePath, deviceUUID, isSync);
        if (StringUtils.isEmpty((String)deleteurl)) {
            logger.debug("File not found on any path so return false ");
            return fileStatusElement;
        }
        String deleteFileUrl = deleteurl.substring(0, deleteurl.length() - 7);
        int retryCount = 0;
        do {
            retry = false;
            logger.debug(retryCount + "..retrycount...url>>>>>>>>>>>" + deleteFileUrl);
            HttpPost httpPost = new HttpPost(deleteFileUrl);
            httpPost.addHeader("Authorization", BEARER + authorizationTokenElementTemp.getAccessToken());
            httpPost.addHeader("Accept", "application/json;odata=verbose");
            httpPost.addHeader("X-HTTP-Method", "DELETE");
            HttpResponse result = null;
            String proxyUserName = PCHelperConstant.getProxyUserName();
            String password = PCHelperConstant.getProxyPassword();
            String host = PCHelperConstant.getProxyHost();
            int port = PCHelperConstant.getProxyPort();
            try {
                result = this.executeRequest(httpPost, proxyUserName, password, host, port);
                int responseCode = result.getStatusLine().getStatusCode();
                logger.debug("Response Code.." + responseCode);
                if (responseCode == 200) {
                    fileStatusElement.setDeleteStatus(true);
                    return fileStatusElement;
                }
                if (responseCode == 401) {
                    logger.debug("inside get access token...");
                    retry = true;
                    ++retryCount;
                    authorizationTokenElementTemp = this.office365Dao.getAccessToken(authorizationTokenElementTemp);
                }
                logger.debug("retry...." + retry + " count:" + retryCount);
            }
            catch (Exception e) {
                logger.error("error while trying to delete file...." + e.getMessage());
                logger.error("error while trying to delete file...." + e);
                return fileStatusElement;
            }
        } while (retry && retryCount < 2);
        return fileStatusElement;
    }

    private HttpResponse executeRequest(HttpPost httpPost, String proxyUserName, String password, String host, int port) throws IOException, ClientProtocolException {
        HttpResponse result;
        if (StringUtils.isEmpty((String)proxyUserName) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)host) || port <= 0) {
            HttpClient httpclient = HttpClientUtil.getSSlConnection();
            result = httpclient.execute((HttpUriRequest)httpPost);
        } else {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(proxyUserName, password));
            CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
            HttpHost proxy = new HttpHost(host, port);
            int timeout = 10;
            RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).setProxy(proxy).build();
            httpPost.setConfig(config);
            result = httpclient.execute((HttpUriRequest)httpPost);
        }
        return result;
    }

    public String getFilePathToDelete(PciAuthorizationTokenElement authorizationTokenElement, String fileName, String chunkFilePath, String deviceUUID, boolean isSync) {
        boolean retry;
        logger.debug("Retrying file delete form ODB");
        String pbFolderName = this.office365Dao.getOdbFolderName(1);
        PciAuthorizationTokenElement authorizationTokenElementTemp = authorizationTokenElement;
        String userNameInPath = "";
        if (!StringUtils.isEmpty((String)deviceUUID) && !isSync) {
            userNameInPath = Office365UploadServiceImpl.getUniqueODUserFolder(deviceUUID);
            logger.debug("....device unique id ....... " + userNameInPath);
        } else if (!StringUtils.isEmpty((String)authorizationTokenElement.getUserName()) && isSync) {
            userNameInPath = Office365UploadServiceImpl.getUniqueODUserFolder(authorizationTokenElement.getUserName());
            logger.debug("device unique id : " + userNameInPath);
        }
        String downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)chunkFilePath, (String)pbFolderName);
        String proxyUserName = PCHelperConstant.getProxyUserName();
        String password = PCHelperConstant.getProxyPassword();
        String host = PCHelperConstant.getProxyHost();
        int port = PCHelperConstant.getProxyPort();
        boolean incrementPath = false;
        boolean decrementPath = false;
        boolean newPathCheck = false;
        boolean oldStylePath = false;
        boolean customOldStylePath = false;
        boolean increOldStylePath = false;
        boolean decreOldStylePath = false;
        int retryCount = 0;
        int sleepMultiplier = 1;
        long sleepTime = 5000L * (long)sleepMultiplier;
        do {
            retry = false;
            HttpGet httpGet = null;
            String modifiedPath = chunkFilePath;
            try {
                String cloudPath;
                HttpResponse result;
                logger.debug(downloadurl + "......download path........." + retryCount);
                httpGet = new HttpGet(downloadurl);
                httpGet.addHeader("Authorization", BEARER + authorizationTokenElementTemp.getAccessToken());
                httpGet.addHeader("Accept", "application/json;odata=verbose");
                httpGet.addHeader("Content-Type", "*/*");
                if (!StringUtils.isEmpty((String)PCHelperConstant.getODBDecorationValue())) {
                    httpGet.addHeader("User-Agent", PCHelperConstant.getODBDecorationValue());
                    logger.debug("..add retry THROTTLE_DECOR..............." + PCHelperConstant.getODBDecorationValue());
                }
                if (StringUtils.isEmpty((String)proxyUserName) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)host) || port <= 0) {
                    logger.debug(" without proxy ...");
                    HttpClient httpclient = HttpClientUtil.getSSlConnection();
                    result = httpclient.execute((HttpUriRequest)httpGet);
                } else {
                    logger.debug(" using proxy ...");
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    credsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(proxyUserName, password));
                    CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
                    HttpHost proxy = new HttpHost(host, port);
                    RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
                    httpGet.setConfig(config);
                    result = httpclient.execute((HttpUriRequest)httpGet);
                }
                int responseCode = result.getStatusLine().getStatusCode();
                logger.debug(">>>>>>>>>>>>>>>>>Retry Response status code: " + responseCode);
                if (responseCode == 200) {
                    logger.debug("File found so return path is " + downloadurl);
                    return downloadurl;
                }
                if (responseCode == 401) {
                    retry = true;
                    ++retryCount;
                    sleepTime = this.sleepForGivenTime(sleepTime);
                    authorizationTokenElementTemp = this.office365Dao.getAccessToken(authorizationTokenElementTemp);
                    continue;
                }
                if (responseCode == 200) continue;
                retry = true;
                sleepTime = responseCode != 404 ? this.sleepForGivenTime(sleepTime) : 0L;
                logger.debug("..retry attempt for response code ...." + responseCode + "...." + ++retryCount + "....." + authorizationTokenElementTemp.getEmailId());
                logger.debug("..retry url ...." + downloadurl);
                if (responseCode != 404) continue;
                if (!increOldStylePath) {
                    cloudPath = chunkFilePath;
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + 1);
                    }
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)"", (String)cloudPath, (String)pbFolderName);
                    modifiedPath = cloudPath;
                    logger.debug("...increOldStylePath..." + modifiedPath);
                    increOldStylePath = true;
                    continue;
                }
                if (!newPathCheck && PCHelperConstant.getRetryOdbFolderValue() > 0) {
                    cloudPath = chunkFilePath;
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + PCHelperConstant.getRetryOdbFolderValue());
                    }
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)cloudPath, (String)pbFolderName);
                    newPathCheck = true;
                    modifiedPath = cloudPath;
                    logger.debug("...newPathCheck ..." + modifiedPath);
                    continue;
                }
                if (!decrementPath) {
                    cloudPath = chunkFilePath;
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path - 1);
                    }
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)cloudPath, (String)pbFolderName);
                    decrementPath = true;
                    modifiedPath = cloudPath;
                    logger.debug("...decre new path..." + modifiedPath);
                    continue;
                }
                if (!incrementPath) {
                    cloudPath = chunkFilePath;
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + 1);
                    }
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)cloudPath, (String)pbFolderName);
                    modifiedPath = cloudPath;
                    logger.debug("...incre new path..." + modifiedPath);
                    incrementPath = true;
                    continue;
                }
                if (!oldStylePath) {
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)"", (String)chunkFilePath, (String)pbFolderName);
                    oldStylePath = true;
                    logger.debug("...oldStylePath restore ...");
                    continue;
                }
                if (!customOldStylePath && PCHelperConstant.getRetryOdbFolderValue() > 0) {
                    cloudPath = chunkFilePath;
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + PCHelperConstant.getRetryOdbFolderValue());
                    }
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)"", (String)cloudPath, (String)pbFolderName);
                    customOldStylePath = true;
                    modifiedPath = cloudPath;
                    logger.debug("...customOldStylePath retryodbValue ..." + modifiedPath);
                    continue;
                }
                if (decreOldStylePath) continue;
                cloudPath = chunkFilePath;
                if (StringUtils.isNotEmpty((String)cloudPath)) {
                    int path = Integer.parseInt(cloudPath);
                    cloudPath = "" + (path - 1);
                }
                downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)"", (String)cloudPath, (String)pbFolderName);
                decreOldStylePath = true;
                modifiedPath = cloudPath;
                logger.debug("...decreOldStylePath..." + modifiedPath);
            }
            catch (Exception e) {
                retry = true;
                ++retryCount;
                sleepTime = this.sleepForGivenTime(sleepTime);
                logger.trace("" + e);
                logger.error("Exception While Retying Download File From One Drive :" + e.getMessage());
            }
        } while (retry && retryCount < 8);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String checkOdbFolders(PciAuthorizationTokenElement authorizationTokenElement, String folderUrl, Map<String, Long> foldersMap, StringBuilder response) {
        logger.debug(".folderUrl.." + folderUrl);
        PciAuthorizationTokenElement pciTokenElement = authorizationTokenElement;
        String proxyUserName = PCHelperConstant.getProxyUserName();
        String password = PCHelperConstant.getProxyPassword();
        String host = PCHelperConstant.getProxyHost();
        int port = PCHelperConstant.getProxyPort();
        HttpGet httpGet = new HttpGet(folderUrl);
        try {
            HttpClient httpclient;
            httpGet.addHeader("Authorization", BEARER + authorizationTokenElement.getAccessToken());
            httpGet.addHeader("Accept", "application/json;odata=verbose");
            httpGet.addHeader("Content-Type", "*/*");
            if (!StringUtils.isEmpty((String)PCHelperConstant.getODBDecorationValue())) {
                httpGet.addHeader("User-Agent", PCHelperConstant.getODBDecorationValue());
                logger.debug("..add retry THROTTLE_DECOR..............." + PCHelperConstant.getODBDecorationValue());
            }
            HttpResponse result = null;
            if (StringUtils.isEmpty((String)proxyUserName) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)host) || port <= 0) {
                logger.debug(" without proxy ...");
                httpclient = HttpClientUtil.getSSlConnection();
                result = httpclient.execute((HttpUriRequest)httpGet);
            } else {
                logger.debug(" using proxy ...");
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(proxyUserName, password));
                CloseableHttpClient httpclient2 = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
                HttpHost proxy = new HttpHost(host, port);
                RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
                httpGet.setConfig(config);
                result = httpclient2.execute((HttpUriRequest)httpGet);
            }
            httpclient = HttpClientUtil.getSSlConnection();
            result = httpclient.execute((HttpUriRequest)httpGet);
            int statusCode = result.getStatusLine().getStatusCode();
            logger.debug("..........." + statusCode);
            if (statusCode == 401) {
                pciTokenElement = this.office365Dao.getAccessToken(pciTokenElement);
                this.checkOdbFolders(pciTokenElement, folderUrl, foldersMap, response);
            }
            if (statusCode == 200) {
                String folders;
                logger.debug("  path doesnot exists ......... " + statusCode);
                String json = EntityUtils.toString((HttpEntity)result.getEntity());
                logger.debug(json);
                JSONObject jsonObject = new JSONObject(json);
                String itemCount = jsonObject.optString("d");
                if (itemCount != null && StringUtils.isNotEmpty((String)(folders = (jsonObject = new JSONObject(new String(itemCount))).optString("Folders")))) {
                    String reslut = new JSONObject(new String(folders)).get("results").toString();
                    JSONArray jsonArray = new JSONArray(new String(reslut));
                    for (Object jsonObj : jsonArray) {
                        JSONObject folderJson = (JSONObject)jsonObj;
                        JSONObject files = folderJson.getJSONObject("Files");
                        JSONObject __deferred = files.getJSONObject("__deferred");
                        String folderName = __deferred.getString("uri").toString();
                        if (foldersMap.containsKey(folderName)) continue;
                        foldersMap.put(folderName, folderJson.getLong("ItemCount"));
                        logger.debug(".....Path " + folderName.substring(folderName.lastIndexOf("("), folderName.lastIndexOf(")")) + " count " + folderJson.getLong("ItemCount") + "\n");
                        int countOfFiles = PCHelperConstant.getCountOfODBFiles();
                        if (countOfFiles == 0) {
                            countOfFiles = 4500;
                        }
                        logger.debug("checking odb folders " + countOfFiles);
                        if (folderJson.getLong("ItemCount") > (long)countOfFiles) {
                            String path = folderName.substring(folderName.lastIndexOf("("), folderName.lastIndexOf(")"));
                            response.append(authorizationTokenElement.getAccountId() + " Path " + path + " count " + folderJson.getLong("ItemCount") + "\n");
                        }
                        logger.debug(folderName);
                        this.checkOdbFolders(pciTokenElement, folderName.replace("Files", "?$select=StorageMetrics&$expand=Folders"), foldersMap, response);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Retying Download File From One Drive :" + e.getMessage());
        }
        finally {
            httpGet.releaseConnection();
        }
        return response.toString();
    }
}

