/*
 * Decompiled with CFR 0.152.
 */
package com.pg.controller;

import com.google.api.client.repackaged.org.apache.commons.codec.binary.Base64;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.models.Drive;
import com.microsoft.graph.models.DriveItem;
import com.microsoft.graph.models.MailFolder;
import com.microsoft.graph.models.Site;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.DriveItemCollectionPage;
import com.microsoft.graph.requests.DriveItemCollectionRequest;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.ListCollectionPage;
import com.microsoft.graph.requests.ListCollectionRequest;
import com.microsoft.graph.requests.ListCollectionRequestBuilder;
import com.microsoft.graph.requests.MailFolderCollectionPage;
import com.microsoft.graph.requests.MailFolderCollectionRequest;
import com.microsoft.graph.requests.MailFolderCollectionRequestBuilder;
import com.microsoft.graph.requests.MailFolderDeltaCollectionPage;
import com.microsoft.graph.requests.MailFolderDeltaCollectionRequest;
import com.microsoft.graph.requests.MailFolderDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.MailFolderRequestBuilder;
import com.microsoft.graph.requests.UserCollectionPage;
import com.microsoft.graph.requests.UserCollectionRequest;
import com.microsoft.graph.requests.UserRequestBuilder;
import com.parablu.paracloud.element.RestoreEventsElement;
import com.parablu.paracloud.element.RestoreProgressEventsElement;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.MailBackupBatch;
import com.parablu.pcbd.domain.OTPValidation;
import com.parablu.pcbd.domain.PstBatch;
import com.parablu.pcbd.domain.RestoreProgressEvents;
import com.parablu.pcbd.domain.User;
import com.pg.domain.BackupFile;
import com.pg.exception.ParacloudBackupException;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.odb.util.OneDriveUtil;
import com.pg.paracloud.to.DownloadFileTO;
import com.pg.paracloud.to.DownloadTO;
import com.pg.service.DownloadService;
import com.pg.service.UtilService;
import com.pg.sync.service.SyncDownloadService;
import com.pg.sync.service.impl.SyncDownloadServiceImpl;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import okhttp3.Request;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class CommonDownloadController {
    private static Logger logger = LogManager.getLogger(CommonDownloadController.class);
    private static final String RESOURCE = "https://outlook.office365.com";
    private static final String AUTHORITY = "https://login.microsoftonline.com/";
    private static final String EWS_URL = "https://outlook.office365.com/EWS/Exchange.asmx";
    private static final long TWO_MIN_IN_MILLI = 300000L;
    @Autowired
    private UtilService utilService;
    @Autowired
    private DownloadService downloadService;
    @Autowired
    private SyncDownloadService syncDownloadService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/cloud/{cloudName}/portal/download/files/"}, method={RequestMethod.GET})
    public void downloadFileForPortal(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String browserType = request.getHeader("user-agent");
        InputStream inputStream = null;
        try {
            boolean isSync = false;
            String isSyncFlag = request.getParameter("isSync");
            DownloadFileTO downloadFileTO = this.getRequestParameters(request, cloudName);
            String loginUserName = request.getParameter("loginUserName");
            String attachmentId = request.getParameter("attachmentId");
            String accesskey = request.getParameter("accessKey");
            loginUserName = this.decodeBase64UTFString(loginUserName);
            String uniqueId = request.getParameter("userId");
            String isDownload = request.getParameter("isDownload");
            String checkStatus = request.getParameter("checkStatus");
            logger.debug(accesskey + "...unique id..." + uniqueId + "....");
            if (!org.springframework.util.StringUtils.isEmpty((Object)accesskey)) {
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)uniqueId)) {
                    User u = this.utilService.getUserInfoByName(1, uniqueId);
                    if (u != null) {
                        uniqueId = u.getEmailId();
                    }
                    OTPValidation otpValidation = this.utilService.getOTPForUniqueId(1, uniqueId);
                    logger.debug("otp value:" + otpValidation);
                    if (otpValidation == null || !accesskey.equalsIgnoreCase(otpValidation.getToken())) {
                        logger.error("access key validation not successfull.." + otpValidation);
                        response.setStatus(451);
                        return;
                    }
                    if (accesskey.equalsIgnoreCase(otpValidation.getToken()) && otpValidation.getModifiedTime() + 300000L < System.currentTimeMillis()) {
                        logger.error("access key validation not successfull..");
                        response.setStatus(451);
                        return;
                    }
                } else {
                    logger.error("unique id not found....");
                    response.setStatus(451);
                    return;
                }
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)isSyncFlag)) {
                isSync = Boolean.parseBoolean(isSyncFlag);
                downloadFileTO.setSync(isSync);
            } else {
                response.setStatus(400);
            }
            String deviceUUID = request.getParameter("deviceUUID");
            if (org.springframework.util.StringUtils.isEmpty((Object)deviceUUID)) {
                deviceUUID = request.getHeader("deviceUUID");
            }
            DownloadTO downloadTO = null;
            Cloud cloud = this.utilService.getCloud(1);
            logger.debug(deviceUUID + "<<<Downloading backup file>>>" + request.getParameter("backupID"));
            downloadFileTO.setDeviceUUID(deviceUUID);
            downloadFileTO.setBackupID(request.getParameter("backupID"));
            if (org.springframework.util.StringUtils.isEmpty((Object)downloadFileTO.getUserName())) {
                downloadFileTO.setUserName(loginUserName);
            }
            downloadFileTO.setAttachmentId(attachmentId);
            downloadTO = this.backupFileDownloadForPortal(downloadFileTO, cloud, cloudName, response, browserType);
            if (downloadTO != null) {
                logger.debug(" File size after  ...." + downloadTO.getSize());
            }
            if (downloadTO != null && downloadTO.getSize() > 0L) {
                response.setStatus(200);
                if (!org.springframework.util.StringUtils.isEmpty((Object)downloadTO.getFilePath())) {
                    downloadFileTO.setFilePath(downloadTO.getFilePath());
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)downloadTO.getFileName())) {
                    downloadFileTO.setFileName(downloadTO.getFileName());
                }
                if (isSync) {
                    long fileSizeInKB = (long)Math.ceil((double)downloadTO.getSize() / 1024.0);
                    this.utilService.saveSyncOverview(cloud.getCloudId(), 0L, fileSizeInKB, 0L, 1L);
                }
                String action = "Downloaded file ";
                int actionType = 4;
                if (!org.springframework.util.StringUtils.isEmpty((Object)isDownload) && isDownload.equalsIgnoreCase("false")) {
                    action = "Viewed file ";
                    actionType = 115;
                }
                if (StringUtils.isEmpty((String)checkStatus) || checkStatus.equalsIgnoreCase("false")) {
                    if (downloadTO.isPathInsideMC()) {
                        String mcName = downloadTO.getMcName();
                        this.saveAuditHistoryMC(downloadFileTO, loginUserName, cloud, mcName, action, actionType);
                    } else {
                        this.saveAuditHistory(downloadFileTO, loginUserName, cloud, action, actionType);
                    }
                }
                this.downloadService.updateModifiedTimeForFileAndParentFolder(downloadFileTO, cloud, System.currentTimeMillis(), downloadTO.getMcName(), downloadTO.isPathInsideMC());
            } else if (response.getStatus() == 451) {
                this.saveAuditHistoryForFailedFile(downloadFileTO, loginUserName, cloud);
                logger.debug("file download failed file md5 is blocked >>>>>>>>>>>$$$$$$$$$$$$ ");
            } else {
                logger.debug("file download file input stream is null>>>>>>>>>>>$$$$$$$$$$$$ ");
                response.setStatus(449);
            }
        }
        catch (ParacloudBackupException e) {
            e.printStackTrace();
            logger.trace("" + (Object)((Object)e));
            logger.debug(" File not found during download  ...." + e.getMessage());
            response.setStatus(449);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.trace("" + e);
            logger.error("  UNALBE TO DOWNLOAD FILE ", (Throwable)e);
            response.setStatus(500);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        logger.debug(" end of  download file  Completed for portal ....");
    }

    private void saveAuditHistoryForFailedFile(DownloadFileTO downloadFileTO, String loginUserName, Cloud cloud) {
        if (!org.springframework.util.StringUtils.isEmpty((Object)loginUserName)) {
            AuditHistory auditHistory = new AuditHistory();
            StringBuilder action = new StringBuilder("Download failed.File has been quarantined");
            auditHistory.setAction(action.toString());
            auditHistory.setActionByUserName(loginUserName);
            auditHistory.setActionOnObject(downloadFileTO.getFilePath() + "/" + downloadFileTO.getFileName());
            auditHistory.setTimestamp(System.currentTimeMillis());
            auditHistory.setActionUsingObject("Portal");
            auditHistory.setActionType(4);
            logger.debug("Action type" + auditHistory.getActionType());
            this.utilService.saveAudit(cloud.getCloudId(), auditHistory);
        }
    }

    @GetMapping(value={"/cloud/{cloudName}/portal/download/files/photo/"})
    @ResponseBody
    public ModelAndView getPhoto(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            boolean isSync = false;
            String isSyncFlag = request.getParameter("isSync");
            DownloadFileTO downloadFileTO = this.getRequestParameters(request, cloudName);
            String loginUserName = request.getParameter("loginUserName");
            String attachmentId = request.getParameter("attachmentId");
            loginUserName = this.decodeBase64UTFString(loginUserName);
            logger.debug(attachmentId + "...loginUserName..." + loginUserName + "....");
            if (!org.springframework.util.StringUtils.isEmpty((Object)isSyncFlag)) {
                isSync = Boolean.parseBoolean(isSyncFlag);
                downloadFileTO.setSync(isSync);
            } else {
                response.setStatus(400);
            }
            Object downloadTO = null;
            Cloud cloud = this.utilService.getCloud(1);
            logger.debug("<<<Downloading backup file>>>" + request.getParameter("backupID"));
            downloadFileTO.setBackupID(request.getParameter("backupID"));
            if (org.springframework.util.StringUtils.isEmpty((Object)downloadFileTO.getUserName())) {
                downloadFileTO.setUserName(loginUserName);
            }
            downloadFileTO.setAttachmentId(attachmentId);
            logger.debug(" end of  download file  Completed for portalModelAndView ....");
            byte[] out = this.backupFileDownloadPhotoForPortal(downloadFileTO, cloud, cloudName);
            modelAndView.addObject((Object)out);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("  UNALBE TO DOWNLOAD FILE " + e.getMessage());
            response.setStatus(500);
            byte[] byteaa = new byte[]{0, 1, 2};
            modelAndView.addObject((Object)byteaa);
        }
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/restoreEvents/"}, method={RequestMethod.POST})
    public ModelAndView createRestoreActions(@PathVariable(value="cloudName") String cloudName1, @RequestBody RestoreEventsElement restoreEventsElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/eventHub/events/...  to edit action" + restoreEventsElement.getActionBy());
        try {
            Cloud cloud = this.utilService.getCloud(1);
            cloudName = cloud.getCloudName();
            int cloudId = cloud.getCloudId();
            logger.debug(restoreEventsElement.getActionOnDeviceUUID() + "calling clouds/{cloudName}/eventHub/events/...  to edit action" + restoreEventsElement.getDestinationDeviceUUID());
            Device device = this.utilService.getDeviceForUUID(cloudId, restoreEventsElement.getActionOnDeviceUUID());
            if (device == null) {
                response.setStatus(406);
                logger.error("...invalid device.....");
                return null;
            }
            logger.debug(restoreEventsElement.getFileElement().isFolder() + "..sss...backupid.. dev.. " + restoreEventsElement.getFileElement().getBackupId() + "....." + restoreEventsElement.getFileElement().isDevice() + "..office policy name:" + restoreEventsElement.getOfficePolicyName());
            logger.debug(restoreEventsElement.isSuspendBackup() + "..sss...actionby.... " + restoreEventsElement.getActionBy().toString());
            RestoreEventsElement updateRestoreEvents = this.utilService.updateRestoreEvents(cloudId, restoreEventsElement, device.getUserName(), device.getDeviceType());
            if (updateRestoreEvents != null) {
                logger.debug("....inplace restore..failed..");
                modelAndView.addObject((Object)updateRestoreEvents);
                response.setStatus(417);
                return modelAndView;
            }
            logger.debug("....inplace restore....");
            String restorePath = "in place restore ";
            if (!restoreEventsElement.isInPlaceRestore()) {
                restorePath = restoreEventsElement.getDestinationPath();
            }
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.error(".....errorr trying ...", (Throwable)e);
            response.setStatus(500);
        }
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/restoreEventsProgress/{deviceUUID}"}, method={RequestMethod.GET})
    public ModelAndView getRestoreProgressEvents(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="deviceUUID") String deviceUUID, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        response.setContentType("text/html; charset=UTF-8");
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/restoreEventsProgress/...  to get restoreEvents of " + deviceUUID);
        try {
            Cloud cloud = this.utilService.getCloud(1);
            cloudName = cloud.getCloudName();
            int cloudId = cloud.getCloudId();
            String loginUserName = request.getHeader("loginUserName");
            String batchId = request.getHeader("batchId");
            logger.debug(batchId + ".... deviceuuid and user ..." + deviceUUID + "...." + loginUserName);
            RestoreProgressEvents restoreProgressEvents = this.utilService.getRestoreEventProgressByUUID(cloudId, deviceUUID, loginUserName);
            RestoreProgressEventsElement restoreProgressEventsElement = null;
            if (restoreProgressEvents == null) {
                logger.error("... restore not started ... ");
                restoreProgressEventsElement = new RestoreProgressEventsElement();
                restoreProgressEventsElement.setDeviceUUID(deviceUUID);
                restoreProgressEventsElement.setFolderName("");
                restoreProgressEventsElement.setUserName("");
                restoreProgressEventsElement.setCurrentFolderPath("");
                restoreProgressEventsElement.setRestoredFiles(0L);
                restoreProgressEventsElement.setRestoredFilesForFolder(0L);
                restoreProgressEventsElement.setRestoredPctForFolder(0L);
                restoreProgressEventsElement.setSize(0L);
                restoreProgressEventsElement.setSubject("");
                restoreProgressEventsElement.setTotalNoOfFilesForRestore(0L);
                restoreProgressEventsElement.setTotalNoOfRestoreFilesForFolder(0L);
                restoreProgressEventsElement.setTotalRestorePct(0L);
                modelAndView.addObject((Object)restoreProgressEventsElement);
                logger.debug("... backupbatch id ...." + batchId);
                if (!org.springframework.util.StringUtils.isEmpty((Object)batchId)) {
                    BackupBatch backupBatch = this.utilService.getBackupBatchById(cloudId, batchId);
                    if (backupBatch != null && "RESTORE".equals(backupBatch.getJobType())) {
                        response.setStatus(202);
                    }
                } else {
                    response.setStatus(204);
                }
            } else {
                restoreProgressEventsElement = new RestoreProgressEventsElement();
                BeanUtils.copyProperties((Object)restoreProgressEvents, (Object)restoreProgressEventsElement);
                restoreProgressEventsElement.setBatchId(restoreProgressEvents.getBatchId());
                if (restoreProgressEventsElement.getTotalNoOfFilesForRestore() == 0L || restoreProgressEventsElement.getRestoredFiles() == 0L) {
                    restoreProgressEventsElement.setTotalRestorePct(0L);
                } else {
                    restoreProgressEventsElement.setTotalRestorePct(this.getPercentageCompleted(restoreProgressEventsElement.getTotalNoOfFilesForRestore(), restoreProgressEventsElement.getRestoredFiles()));
                }
                if (restoreProgressEventsElement.getRestoredFilesForFolder() == 0L || restoreProgressEventsElement.getTotalNoOfRestoreFilesForFolder() == 0L) {
                    restoreProgressEventsElement.setRestoredPctForFolder(0L);
                } else {
                    restoreProgressEventsElement.setRestoredPctForFolder(this.getPercentageCompleted(restoreProgressEventsElement.getTotalNoOfRestoreFilesForFolder(), restoreProgressEventsElement.getRestoredFilesForFolder()));
                }
                logger.debug("....pct... " + restoreProgressEventsElement.getTotalNoOfFilesForRestore() + "...." + restoreProgressEventsElement.getRestoredFiles() + "...." + restoreProgressEventsElement.getTotalRestorePct());
                modelAndView.addObject((Object)restoreProgressEventsElement);
                response.setStatus(200);
            }
            return modelAndView;
        }
        catch (Exception e) {
            logger.error("" + e.getMessage());
            response.setStatus(500);
            return null;
        }
    }

    private long getPercentageCompleted(long totalNoOfFiles, long noOfFilesRemaining) {
        logger.debug("..calling getPercentageCompleted.." + totalNoOfFiles + "...." + noOfFilesRemaining);
        long percentage = 100L;
        percentage = noOfFilesRemaining * 100L / totalNoOfFiles;
        logger.debug("..percentage.." + percentage);
        return percentage;
    }

    @RequestMapping(value={"/cloud/{cloudName}/inPlaceRestore/mail/"}, method={RequestMethod.GET})
    public void inPlaceRestoreForMail(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(" ... start of inplace restore  ....");
        String browserType = request.getHeader("user-agent");
        try {
            DownloadFileTO downloadFileTO = this.getRequestParameters(request, cloudName);
            String loginUserName = request.getParameter("loginUserName");
            String deviceUUID = request.getParameter("deviceUUID");
            String userName = request.getParameter("userName");
            if (userName == null || userName.equalsIgnoreCase("undefined")) {
                userName = "testmailsharedbox@parablu.com";
            }
            if (org.springframework.util.StringUtils.isEmpty((Object)deviceUUID)) {
                deviceUUID = request.getHeader("deviceUUID");
            }
            loginUserName = this.decodeBase64UTFString(loginUserName);
            logger.debug(deviceUUID + "..uuid ....loginUserName..." + loginUserName + "...." + userName);
            Cloud cloud = this.utilService.getCloud(1);
            boolean isFolder = false;
            if (request.getParameter("isFolder") != null) {
                isFolder = Boolean.parseBoolean(request.getParameter("isFolder"));
            }
            String backupId = request.getParameter("backupID");
            logger.debug(isFolder + " bool <<<Downloading backup file>>>" + backupId);
            downloadFileTO.setBackupID(backupId);
            if (org.springframework.util.StringUtils.isEmpty((Object)downloadFileTO.getUserName())) {
                downloadFileTO.setUserName(loginUserName);
            }
            User user = this.utilService.getUserInfoByName(1, userName);
            logger.debug("....user..... " + user.getUserName());
            BackupFile backupFile = this.downloadService.getBackupFileForId(cloud.getCloudId(), userName, backupId);
            if (backupFile == null) {
                logger.error(".... mail does not exists.... ");
                response.setStatus(507);
                return;
            }
            MailBackupBatch backupBatch = this.utilService.getMailBackupBatch(cloud.getCloudId(), backupFile.getDeviceUUID());
            if (backupBatch != null) {
                logger.error(".... Already a restore is  running .... ");
                response.setStatus(455);
                return;
            }
            backupBatch = new MailBackupBatch();
            backupBatch.setStatus(MailBackupBatch.STATUS.STARTED.name());
            backupBatch.setDeviceUUID(backupFile.getDeviceUUID());
            backupBatch.setBackupId(backupFile.getBackupId().toString());
            backupBatch.setFolder(isFolder);
            backupBatch.setUserName(userName);
            backupBatch.setOfficePolicyName(user.getOneDrivePolicyName());
            backupBatch.setRestoreByUserName(loginUserName);
            EventHub eventHub = new EventHub();
            eventHub.setActionBy(loginUserName);
            eventHub.setAction(PCHelperConstant.EVENTHUB_ACTION_STATUS.RESTORE_CREATED.toString());
            eventHub.setActionStatus(PCHelperConstant.EVENTHUB_ACTION_STATUS.RESTORE_CREATED.toString());
            eventHub.setActionToUserName(backupFile.getUserName());
            eventHub.setActionToDeviceUUID(backupFile.getDeviceUUID());
            eventHub.setOdStatus(EventHub.ODSTATUS.RESTORE_STARTED.toString());
            this.utilService.saveMailBackupBatch(cloud.getCloudId(), backupBatch, eventHub);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.error("..... UNALBE TO INITIATE A RESTORE .... " + e.getMessage());
            response.setStatus(500);
        }
        logger.debug(" ... end of inplace restore  ....");
    }

    private void saveAuditHistory(DownloadFileTO downloadFileTO, String loginUserName, Cloud cloud, String action, int actionType) {
        if (!org.springframework.util.StringUtils.isEmpty((Object)loginUserName)) {
            AuditHistory auditHistory = new AuditHistory();
            auditHistory.setAction(action.toString());
            auditHistory.setActionByUserName(loginUserName);
            auditHistory.setActionOnObject(downloadFileTO.getFilePath() + "/" + downloadFileTO.getFileName());
            auditHistory.setTimestamp(System.currentTimeMillis());
            auditHistory.setActionUsingObject("Portal");
            auditHistory.setActionType(actionType);
            logger.debug("Action type" + auditHistory.getActionType());
            this.utilService.saveAudit(cloud.getCloudId(), auditHistory);
        }
    }

    private void saveAuditHistoryMC(DownloadFileTO downloadFileTO, String loginUserName, Cloud cloud, String mcName, String action, int actionType) {
        if (!org.springframework.util.StringUtils.isEmpty((Object)loginUserName)) {
            AuditHistory auditHistory = new AuditHistory();
            if (mcName.startsWith("_mc_")) {
                mcName = mcName.replaceFirst("_mc_", "");
            }
            auditHistory.setAction(action.toString());
            auditHistory.setActionByUserName(loginUserName);
            auditHistory.setActionOnObject(downloadFileTO.getFilePath() + "/" + downloadFileTO.getFileName() + " from minicloud " + mcName);
            auditHistory.setTimestamp(System.currentTimeMillis());
            auditHistory.setActionUsingObject("Portal");
            auditHistory.setMiniCloud(true);
            auditHistory.setMcName(mcName);
            auditHistory.setActionType(actionType);
            logger.debug("Action type" + auditHistory.getActionType());
            this.utilService.saveAudit(cloud.getCloudId(), auditHistory);
        }
    }

    private DownloadTO backupFileDownloadForPortal(DownloadFileTO downloadFileTO, Cloud cloud, String cloudName, HttpServletResponse response, String browserType) {
        if (!downloadFileTO.isFolder()) {
            return this.downloadService.downloadBackupFileForPortal(downloadFileTO, cloud, cloudName, response, browserType);
        }
        return this.downloadService.downloadBackupFolderForPortal(downloadFileTO, cloud, response, browserType, true);
    }

    private byte[] backupFileDownloadPhotoForPortal(DownloadFileTO downloadFileTO, Cloud cloud, String cloudName) {
        return this.downloadService.downloadContactsPhotoForPortal(downloadFileTO, cloud, cloudName, "");
    }

    private DownloadFileTO getRequestParameters(HttpServletRequest request, String cloudName) {
        DownloadFileTO downloadFileTO = new DownloadFileTO();
        String actionType = request.getParameter("actionType");
        String filePath = request.getParameter("filePath");
        if (!org.springframework.util.StringUtils.isEmpty((Object)filePath)) {
            filePath = this.decodeBase64UTFString(request.getParameter("filePath"));
        }
        String userName = request.getParameter("userName");
        String fileName = request.getParameter("fileName");
        if (!org.springframework.util.StringUtils.isEmpty((Object)fileName)) {
            fileName = this.decodeBase64UTFString(request.getParameter("fileName"));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)userName)) {
            userName = this.decodeBase64UTFString(userName);
        }
        String gatewayName = request.getParameter("gatewayName");
        String isFolder = request.getParameter("isFolder");
        if (!org.springframework.util.StringUtils.isEmpty((Object)isFolder)) {
            downloadFileTO.setFolder(Boolean.parseBoolean(isFolder));
        }
        downloadFileTO.setCloudName(cloudName);
        downloadFileTO.setFileName(fileName);
        downloadFileTO.setFilePath(filePath);
        downloadFileTO.setGatewayName(gatewayName);
        downloadFileTO.setUserName(userName);
        downloadFileTO.setActionType(actionType);
        return downloadFileTO;
    }

    protected String decodeBase64UTFString(String encodedString) {
        String decodedString = encodedString;
        try {
            decodedString = new String(Base64.decodeBase64((String)encodedString), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.trace("" + e);
            logger.error("" + e.getMessage());
            logger.debug("UnsupportedEncodingException", (Throwable)e);
        }
        return decodedString;
    }

    protected String encodeUTFBase64(String input) {
        try {
            return Base64.encodeBase64String((byte[])input.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("UnsupportedEncodingException", (Throwable)e);
            return input;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/cloud/{cloudName}/download/folderAsZip/"}, method={RequestMethod.GET})
    public void downloadSyncPortalFile(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        InputStream inputStream = null;
        String browserType = request.getHeader("user-agent");
        logger.debug(".......download folder as zip....");
        try {
            String fileName = "";
            String syncRevisionId = "";
            String filePath = "";
            String userName = "";
            String gatewayName = "";
            String sourceDeviceUUID = "";
            boolean isFolder = false;
            boolean isSync = false;
            String loginUserName = null;
            Map parameters = request.getParameterMap();
            for (String key : parameters.keySet()) {
                String[] vals;
                logger.debug("....key...." + key);
                for (String val : vals = (String[])parameters.get(key)) {
                    logger.debug("....val...." + val);
                    if ("fileName".equalsIgnoreCase(key)) {
                        fileName = val;
                    }
                    if ("syncRevisionId".equalsIgnoreCase(key)) {
                        syncRevisionId = val;
                    }
                    if ("filePath".equalsIgnoreCase(key)) {
                        filePath = val;
                    }
                    if ("userName".equalsIgnoreCase(key)) {
                        userName = val;
                        userName = this.decodeBase64UTFString(userName);
                    }
                    if ("isFolder".equalsIgnoreCase(key)) {
                        isFolder = Boolean.parseBoolean(val);
                    }
                    if ("isSync".equalsIgnoreCase(key)) {
                        isSync = Boolean.parseBoolean(val);
                    }
                    if ("deviceUUID".equalsIgnoreCase(key)) {
                        sourceDeviceUUID = val;
                    }
                    if (!"loginUserName".equalsIgnoreCase(key)) continue;
                    loginUserName = val;
                    loginUserName = this.decodeBase64UTFString(loginUserName);
                }
            }
            DownloadFileTO downloadFileTO = this.getRequestParameters(request, cloudName);
            boolean isrestoreDeletedFile = false;
            String restoreDeletedFileStr = request.getParameter("restoreDeletedFile");
            if (!org.springframework.util.StringUtils.isEmpty((Object)restoreDeletedFileStr)) {
                isrestoreDeletedFile = Boolean.valueOf(restoreDeletedFileStr);
                logger.debug("...isrestoreDeletedFile..........." + isrestoreDeletedFile);
            }
            logger.debug("...isrestoreDeletedFile..........." + isrestoreDeletedFile);
            downloadFileTO.setBackupID(syncRevisionId);
            downloadFileTO.setDeviceUUID(sourceDeviceUUID);
            logger.debug(syncRevisionId + " Filename ..." + downloadFileTO.getFileName());
            logger.debug(syncRevisionId + "  DOWNLOAD FILE  STARTED for portal1 ...." + fileName);
            String deviceUUID = "Portal";
            DownloadTO downloadTO = null;
            String saltKey = this.utilService.getEncryptionKey(1, "sync");
            Cloud cloud = this.utilService.getCloud(1);
            response.addHeader("Pragma", "public");
            response.addHeader("Expires", String.valueOf(200));
            response.addHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
            String zipFileName = downloadFileTO.getFileName() + ".zip";
            String encodedFileName = URLEncoder.encode(zipFileName, StandardCharsets.UTF_8.toString());
            if (browserType.contains("Firefox")) {
                response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + encodedFileName);
            } else if (browserType.contains("Chrome")) {
                response.setHeader("Content-Disposition", "attachment; filename=" + encodedFileName);
            } else {
                response.setHeader("Content-Disposition", "attachment; filename=\"" + encodedFileName + "\"");
            }
            response.addHeader("Content-Transfer-Encoding", "binary");
            response.addHeader("filename", downloadFileTO.getFileName() + ".zip");
            response.addHeader("Content-Transfer-Encodingsdasda", "binary");
            response.setContentType("application/octet-stream");
            downloadTO = this.downloadFolderAsZip(cloud, userName, downloadFileTO.getFileName(), downloadFileTO.getFilePath(), saltKey, deviceUUID, syncRevisionId, response, browserType, isSync, downloadFileTO, isrestoreDeletedFile);
            response.addHeader("file-download-path", this.encodeUTFBase64(downloadTO.getPath()));
            logger.debug("header name....." + response.getHeader("file-download-path"));
            logger.debug("header name....." + response.getHeader("filename"));
            response.setStatus(200);
            String action = "Downloaded Folder ";
            int actionType = 11;
            boolean isPathInsideMC = this.syncDownloadService.isPathInsideMC(cloud.getCloudId(), downloadFileTO.getFilePath() + "/" + downloadFileTO.getFileName());
            if (isPathInsideMC) {
                String mcName = this.syncDownloadService.getMCName(downloadFileTO.getFilePath() + "/" + downloadFileTO.getFileName());
                this.saveAuditHistoryMC(downloadFileTO, loginUserName, cloud, mcName, action, actionType);
            } else {
                this.saveAuditHistory(downloadFileTO, loginUserName, cloud, action, actionType);
            }
        }
        catch (Exception e) {
            logger.error("error trying to download folder..." + e);
            response.setStatus(500);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        logger.debug(" end of  download file  Completed for portal ....");
    }

    private DownloadTO downloadFolderAsZip(Cloud cloud, String userName, String fileName, String filePath, String saltKey, String deviceUUID, String syncRevisionId, HttpServletResponse response, String browserType, boolean isSync, DownloadFileTO downloadFileTO, boolean isrestoreDeletedFile) {
        if (isSync) {
            downloadFileTO.setUserName(userName);
            downloadFileTO.setFileName(fileName);
            downloadFileTO.setFilePath(filePath);
            downloadFileTO.setSync(true);
            return this.syncDownloadService.downloadZipSyncFileForPortal(downloadFileTO, cloud, response, browserType, isrestoreDeletedFile, syncRevisionId);
        }
        return this.downloadService.downloadBackupFolderForPortal(downloadFileTO, cloud, response, browserType, isrestoreDeletedFile);
    }

    public void setSyncDownloadService(SyncDownloadServiceImpl syncDownloadService) {
        this.syncDownloadService = syncDownloadService;
    }

    @RequestMapping(value={"/cloud/{cloudName}/delete/zipFile/"}, method={RequestMethod.DELETE})
    public void deleteZipFile(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String filePath = request.getHeader("filePath");
        try {
            logger.debug("filePath...." + filePath);
            File file = new File(filePath);
            if (file.exists()) {
                response.setStatus(200);
            } else {
                logger.debug("File not presnt..." + filePath);
                response.setStatus(507);
            }
        }
        catch (ParacloudBackupException e) {
            logger.trace("" + (Object)((Object)e));
            logger.debug(" File not found during download  ...." + e.getMessage());
            response.setStatus(449);
        }
        catch (Exception e) {
            logger.trace("" + e);
            response.setStatus(500);
        }
        logger.debug(" end of  download file  delete for portal ....");
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/mail/folders/{deviceUUID}"}, method={RequestMethod.GET})
    public ModelAndView getMailFolders(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="deviceUUID") String deviceUUID, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        response.setContentType("text/html; charset=UTF-8");
        String folderpath = request.getHeader("folderpath");
        logger.debug(folderpath + " head calling versions/{versionNumber}/clouds/{cloudName}/mail/folders/{deviceUUID}...  to get child folders of " + deviceUUID);
        try {
            Cloud cloud = this.utilService.getCloud(1);
            cloudName = cloud.getCloudName();
            int cloudId = cloud.getCloudId();
            Device device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
            if (device == null) {
                response.setStatus(406);
                logger.error("...invalid device.....");
                return null;
            }
            User userObj = this.utilService.getUserInfoByName(1, device.getUserName());
            String userMail = userObj.getEmailId();
            if (!org.springframework.util.StringUtils.isEmpty((Object)userObj.getOdbLoginId())) {
                userMail = userObj.getOdbLoginId();
            }
            logger.debug(".... trying to get folders..... " + device.getUserName());
            GraphServiceClient<Request> graphClient = OneDriveUtil.getGraphClient();
            String emailId = userObj.getEmailId();
            com.microsoft.graph.models.User userFound = null;
            ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
            requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + emailId + "'")));
            UserCollectionPage iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
            for (com.microsoft.graph.models.User userObjVal : iUserCollectionPage.getCurrentPage()) {
                logger.debug(userObjVal.userPrincipalName + "... vals..." + userObjVal.givenName);
                if (!emailId.equalsIgnoreCase(userObjVal.mail) || !emailId.equalsIgnoreCase(userObjVal.userPrincipalName)) continue;
                userFound = userObjVal;
                break;
            }
            if (userFound == null) {
                for (com.microsoft.graph.models.User user : iUserCollectionPage.getCurrentPage()) {
                    if (!emailId.equalsIgnoreCase(user.mail)) continue;
                    userFound = user;
                    break;
                }
            }
            if (org.springframework.util.StringUtils.isEmpty((Object)folderpath)) {
                List<String> folders = CommonDownloadController.getParentMailFolders(graphClient, userFound.id);
                modelAndView.addObject(folders);
            } else {
                Map<String, String> exisfolderPathMap = CommonDownloadController.getExistingFoldersID(graphClient, userFound.id);
                String folderId = exisfolderPathMap.get(folderpath);
                logger.debug("..... id ..." + folderId);
                List<String> childFolders = CommonDownloadController.getExistingChildFolders(graphClient, userFound.id, folderId);
                modelAndView.addObject(childFolders);
                logger.debug("...size of child.." + childFolders.size());
            }
            response.setStatus(200);
            return modelAndView;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("...error trying to get folders......" + e.getMessage());
            response.setStatus(500);
            return null;
        }
    }

    private static List<String> getExistingChildFolders(GraphServiceClient<Request> graphClient, String userId, String folderId) {
        ArrayList<String> childFolderName = new ArrayList<String>();
        UserRequestBuilder users = graphClient.users(userId);
        MailFolderRequestBuilder mailFolders = users.mailFolders(folderId);
        String deltaLink = "";
        MailFolderDeltaCollectionPage deltaPage = (MailFolderDeltaCollectionPage)((MailFolderDeltaCollectionRequest)mailFolders.childFolders().delta().buildRequest(new Option[0])).get();
        boolean isNextPageExists = false;
        List currentPage = null;
        ArrayList listItems = new ArrayList();
        int i = 0;
        do {
            currentPage = deltaPage.getCurrentPage();
            listItems.addAll(currentPage);
            deltaLink = deltaPage.deltaLink();
            if (deltaLink == null) {
                deltaLink = ((MailFolderDeltaCollectionRequestBuilder)deltaPage.getNextPage()).getRequestUrl().replaceFirst(graphClient.getServiceRoot(), "");
            }
            if (deltaPage.getNextPage() == null) break;
            deltaPage = (MailFolderDeltaCollectionPage)((MailFolderDeltaCollectionRequest)((MailFolderDeltaCollectionRequestBuilder)deltaPage.getNextPage()).buildRequest(new Option[0])).get();
            ++i;
        } while (currentPage.size() > 0 && (isNextPageExists = true));
        for (MailFolder fol : listItems) {
            String folderName = fol.displayName;
            System.out.println("...all name... " + folderName);
            if (folderName.contains("Contacts") || folderName.contains("Calendar") || folderName.contains("Yammer Root") || folderName.contains("Outbox") || folderName.contains("Journal") || folderName.contains("Team Chat") || folderName.contains("Files") || folderName.contains("Companies") || folderName.contains("PersonMetadata") || folderName.contains("Feeds") || folderName.contains("Inbound") || folderName.contains("Outbound") || folderName.contains("Recipient Cache") || folderName.contains("Conversation History")) continue;
            childFolderName.add(fol.displayName);
        }
        System.out.println("...total folders.. " + childFolderName.size());
        return childFolderName;
    }

    static Map<String, String> getExistingFoldersID(GraphServiceClient<Request> graphClient, String userId) {
        UserRequestBuilder users = graphClient.users(userId);
        MailFolderCollectionRequestBuilder mailFolders = users.mailFolders();
        String deltaLink = "";
        MailFolderDeltaCollectionPage deltaPage = (MailFolderDeltaCollectionPage)((MailFolderDeltaCollectionRequest)mailFolders.delta().buildRequest(new Option[0])).get();
        boolean isNextPageExists = false;
        List currentPage = null;
        ArrayList listItems = new ArrayList();
        int i = 0;
        do {
            currentPage = deltaPage.getCurrentPage();
            listItems.addAll(currentPage);
            deltaLink = deltaPage.deltaLink();
            if (deltaLink == null) {
                deltaLink = ((MailFolderDeltaCollectionRequestBuilder)deltaPage.getNextPage()).getRequestUrl().replaceFirst(graphClient.getServiceRoot(), "");
            }
            if (deltaPage.getNextPage() == null) break;
            deltaPage = (MailFolderDeltaCollectionPage)((MailFolderDeltaCollectionRequest)((MailFolderDeltaCollectionRequestBuilder)deltaPage.getNextPage()).buildRequest(new Option[0])).get();
            ++i;
        } while (currentPage.size() > 0 && (isNextPageExists = true));
        HashMap<String, String> folderPathMap = new HashMap<String, String>();
        ArrayList sublistItems = new ArrayList();
        listItems.forEach(fol -> {
            MailFolder folderval = ((MailFolderRequestBuilder)mailFolders.byId(fol.parentFolderId)).buildRequest(new Option[0]).get();
            if (folderval.displayName.equalsIgnoreCase("Top of Information Store")) {
                folderPathMap.put(fol.displayName, fol.id);
            }
            if (fol.childFolderCount > 0) {
                CommonDownloadController.addChildFolders(mailFolders, sublistItems, folderPathMap, fol);
            }
        });
        logger.debug("...total folders.. " + folderPathMap.size());
        return folderPathMap;
    }

    private static void addChildFolders(MailFolderCollectionRequestBuilder mailFolders, List<MailFolder> sublistItems, Map<String, String> folderPathMap, MailFolder fol) {
        MailFolderCollectionPage iMailFolderCollectionPage2 = (MailFolderCollectionPage)((MailFolderCollectionRequest)((MailFolderRequestBuilder)mailFolders.byId(fol.id)).childFolders().buildRequest(new Option[0])).get();
        List currentPage2 = iMailFolderCollectionPage2.getCurrentPage();
        String parentPath1 = folderPathMap.get(fol.id);
        if (org.springframework.util.StringUtils.isEmpty((Object)parentPath1)) {
            String pathva = fol.displayName;
            if (!org.springframework.util.StringUtils.isEmpty((Object)parentPath1)) {
                pathva = parentPath1 + "/" + fol.displayName;
            }
            folderPathMap.put(pathva, fol.id);
        }
        currentPage2.forEach(chfol -> {
            String parentPath = (String)folderPathMap.get(chfol.parentFolderId);
            String path = CommonDownloadController.getPath(fol, chfol, parentPath);
            folderPathMap.put(path, chfol.id);
            if (chfol.childFolderCount > 0) {
                CommonDownloadController.addChildFolders(mailFolders, sublistItems, folderPathMap, chfol);
                sublistItems.addAll(currentPage2);
            }
        });
        sublistItems.addAll(currentPage2);
    }

    private static String getPath(MailFolder fol, MailFolder chfol, String parentPath) {
        String path = fol.displayName + "/" + chfol.displayName;
        if (!org.springframework.util.StringUtils.isEmpty((Object)parentPath)) {
            path = parentPath + "/" + chfol.displayName;
        }
        return path;
    }

    private static List<String> getParentMailFolders(GraphServiceClient<Request> graphClient, String userId) {
        ArrayList<String> folderNames = new ArrayList<String>();
        UserRequestBuilder users = graphClient.users(userId);
        MailFolderCollectionRequestBuilder mailFolders = users.mailFolders();
        String deltaLink = "";
        MailFolderDeltaCollectionPage deltaPage = (MailFolderDeltaCollectionPage)((MailFolderDeltaCollectionRequest)mailFolders.delta().buildRequest(new Option[0])).get();
        boolean isNextPageExists = false;
        List currentPage = null;
        ArrayList listItems = new ArrayList();
        int i = 0;
        do {
            currentPage = deltaPage.getCurrentPage();
            listItems.addAll(currentPage);
            deltaLink = deltaPage.deltaLink();
            if (deltaLink == null) {
                deltaLink = ((MailFolderDeltaCollectionRequestBuilder)deltaPage.getNextPage()).getRequestUrl().replaceFirst(graphClient.getServiceRoot(), "");
            }
            if (deltaPage.getNextPage() == null) break;
            deltaPage = (MailFolderDeltaCollectionPage)((MailFolderDeltaCollectionRequest)((MailFolderDeltaCollectionRequestBuilder)deltaPage.getNextPage()).buildRequest(new Option[0])).get();
            ++i;
        } while (currentPage.size() > 0 && (isNextPageExists = true));
        HashMap folderPathMap = new HashMap();
        for (MailFolder fol : listItems) {
            MailFolder folderval = ((MailFolderRequestBuilder)mailFolders.byId(fol.parentFolderId)).buildRequest(new Option[0]).get();
            String folderName = fol.displayName;
            if (folderName.contains("Contacts") || folderName.contains("Calendar") || folderName.contains("Yammer Root") || folderName.contains("Outbox") || folderName.contains("Journal") || folderName.contains("Team Chat") || folderName.contains("Files") || folderName.contains("Companies") || folderName.contains("PersonMetadata") || folderName.contains("Feeds") || folderName.contains("Inbound") || folderName.contains("Outbound") || folderName.contains("Recipient Cache") || folderName.contains("Conversation History") || !folderval.displayName.equalsIgnoreCase("Top of Information Store")) continue;
            folderNames.add(fol.displayName);
        }
        logger.debug("...total folders.. " + folderPathMap.size());
        for (String entry : folderNames) {
            logger.debug("...all paths....." + entry);
        }
        return folderNames;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/onedrive/folders/{deviceUUID}"}, method={RequestMethod.GET})
    public ModelAndView getOneDriveFolders(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="deviceUUID") String deviceUUID, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        response.setContentType("text/html; charset=UTF-8");
        String folderpath = request.getHeader("folderpath");
        logger.debug(folderpath + " head calling versions/{versionNumber}/clouds/{cloudName}/onedrive/folders/{deviceUUID}...  to get child folders of " + deviceUUID);
        try {
            Cloud cloud = this.utilService.getCloud(1);
            int cloudId = cloud.getCloudId();
            Device device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
            if (device == null) {
                response.setStatus(406);
                logger.error("...invalid device.....");
                return null;
            }
            GraphServiceClient<Request> graphClient = null;
            if (cloud.getGraphApiEnabled() == 1) {
                graphClient = OneDriveUtil.getGraphClient();
            }
            User user = this.utilService.getUserInfoByName(cloudId, device.getUserName());
            String emailId = user.getEmailId();
            List<String> folders = this.getFoldersForOneDrivePath(cloudId, emailId, folderpath, graphClient);
            modelAndView.addObject(folders);
            response.setStatus(200);
            return modelAndView;
        }
        catch (Exception e) {
            logger.error("...unable to get folders...." + e.getMessage());
            response.setStatus(500);
            return null;
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/site/folders/{deviceUUID}"}, method={RequestMethod.GET})
    public ModelAndView getSiteFolders(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="deviceUUID") String deviceUUID, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        response.setContentType("text/html; charset=UTF-8");
        String folderpath = request.getHeader("folderpath");
        logger.debug(folderpath + " head calling versions/{versionNumber}/clouds/{cloudName}/site/folders/{deviceUUID}...  to get child folders of " + deviceUUID);
        try {
            Cloud cloud = this.utilService.getCloud(1);
            int cloudId = cloud.getCloudId();
            Device device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
            if (device == null) {
                response.setStatus(406);
                logger.error("...invalid device.....");
                return null;
            }
            GraphServiceClient<Request> graphClient = null;
            if (cloud.getGraphApiEnabled() == 1) {
                graphClient = OneDriveUtil.getGraphClient();
            }
            User user = this.utilService.getUserInfoByName(cloudId, device.getUserName());
            List<String> folders = this.getFoldersForSitePath(cloudId, user.getSiteId(), folderpath, graphClient);
            modelAndView.addObject(folders);
            response.setStatus(200);
            return modelAndView;
        }
        catch (Exception e) {
            logger.error("...unable to get folders...." + e.getMessage());
            response.setStatus(500);
            return null;
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/onedrive/folders"}, method={RequestMethod.GET})
    public ModelAndView getOneDriveFoldersForUserName(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        response.setContentType("text/html; charset=UTF-8");
        String folderpath = request.getHeader("folderpath");
        String userName = this.decodeBase64UTFString(request.getHeader("userName"));
        String c2cRestore = request.getHeader("c2cRestore");
        boolean c2cRestoreBool = false;
        if (!org.springframework.util.StringUtils.isEmpty((Object)request.getHeader("folderpath"))) {
            folderpath = this.decodeBase64UTFString(request.getHeader("folderpath"));
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)c2cRestore)) {
            c2cRestoreBool = true;
        }
        logger.debug(folderpath + " head calling versions/{versionNumber}/clouds/{cloudName}/onedrive/folders...  to get child folders of " + userName);
        try {
            Cloud cloud = this.utilService.getCloud(1);
            int cloudId = cloud.getCloudId();
            GraphServiceClient<Request> graphClient = null;
            if (cloud.getGraphApiEnabled() == 1) {
                graphClient = c2cRestoreBool ? OneDriveUtil.getC2CGraphClient() : OneDriveUtil.getGraphClient();
            }
            User user = this.utilService.getUserInfoByName(cloudId, userName);
            String emailId = user.getEmailId();
            List<String> folders = this.getFoldersForOneDrivePath(cloudId, emailId, folderpath, graphClient);
            modelAndView.addObject(folders);
            response.setStatus(200);
            return modelAndView;
        }
        catch (Exception e) {
            logger.error("...unable to get folders....", (Throwable)e);
            response.setStatus(500);
            return null;
        }
    }

    private List<String> getFoldersForOneDrivePath(int cloudId, String userMail, String path, GraphServiceClient<Request> graphClient) {
        ArrayList<String> folders = new ArrayList<String>();
        try {
            com.microsoft.graph.models.User userFound = null;
            ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
            requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + userMail + "'")));
            UserCollectionPage iUserCollectionPage = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).top(1).get();
            Iterator iterator = iUserCollectionPage.getCurrentPage().iterator();
            if (iterator.hasNext()) {
                com.microsoft.graph.models.User userObj = (com.microsoft.graph.models.User)iterator.next();
                logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                userFound = userObj;
            }
            if (userFound == null) {
                logger.error("... user not found ...");
                return new ArrayList<String>();
            }
            Drive drive = graphClient.users(userFound.id).drive().buildRequest(new Option[0]).get();
            String driveId = drive.id;
            DriveItem item = null;
            DriveItemCollectionPage iDriveItemCollectionPage = null;
            if (org.springframework.util.StringUtils.isEmpty((Object)path) || path.equalsIgnoreCase("/")) {
                iDriveItemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)graphClient.drives(driveId).root().children().buildRequest(new Option[0])).get();
            } else {
                item = (DriveItem)graphClient.customRequest("/drives/" + driveId + "/root:/" + path, DriveItem.class).buildRequest(new Option[0]).get();
                iDriveItemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)graphClient.users(userFound.id).drive().items(item.id).children().buildRequest(new Option[0])).get();
            }
            if (iDriveItemCollectionPage != null) {
                List currentPage = iDriveItemCollectionPage.getCurrentPage();
                for (DriveItem driveItem : currentPage) {
                    if (driveItem.folder == null) continue;
                    logger.debug("..... items... " + driveItem.name);
                    folders.add(driveItem.name);
                }
            }
        }
        catch (GraphServiceException e) {
            logger.error(".... error trying to get folders... " + e.getMessage());
        }
        return folders;
    }

    private List<String> getFoldersForSitePath(int cloudId, String siteId, String path, GraphServiceClient<Request> graphClient) {
        ArrayList<String> folders = new ArrayList<String>();
        HashMap<String, String> listMap = new HashMap<String, String>();
        try {
            Site site = graphClient.sites(siteId).buildRequest(new Option[0]).get();
            ListCollectionPage listCollectionPage = (ListCollectionPage)((ListCollectionRequest)graphClient.sites(siteId).lists().buildRequest(new Option[0])).get();
            List currentListPageVal = null;
            ListCollectionRequestBuilder nextListPage = (ListCollectionRequestBuilder)listCollectionPage.getNextPage();
            do {
                currentListPageVal = listCollectionPage.getCurrentPage();
                for (com.microsoft.graph.models.List list : listCollectionPage.getCurrentPage()) {
                    if (!"documentLibrary".equals(list.list.template)) continue;
                    String displayName = list.displayName;
                    if (org.springframework.util.StringUtils.isEmpty((Object)displayName)) {
                        displayName = list.name;
                    }
                    listMap.put(list.id, displayName);
                    logger.debug("....list.." + displayName + ".." + list.id);
                    folders.add(displayName);
                }
                nextListPage = (ListCollectionRequestBuilder)listCollectionPage.getNextPage();
                if (nextListPage == null) continue;
                listCollectionPage = (ListCollectionPage)((ListCollectionRequest)nextListPage.buildRequest(new Option[0])).get();
            } while (org.springframework.util.StringUtils.isEmpty((Object)siteId) && currentListPageVal.size() > 0 && nextListPage != null && listCollectionPage != null && nextListPage != null);
        }
        catch (GraphServiceException e) {
            logger.error(".... error trying to get folders... " + e.getMessage());
        }
        catch (Exception e) {
            logger.error("..error..." + e.getMessage());
        }
        return folders;
    }

    @RequestMapping(value={"/cloud/{cloudName}/get/fileAsStream/"}, method={RequestMethod.GET})
    public void writeFileInResponse(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String fullyQualifiedPath = request.getParameter("file-download-path");
        String browserType = "";
        browserType = request.getParameter("browser-type");
        try {
            if (StringUtils.isEmpty((String)fullyQualifiedPath)) {
                return;
            }
            fullyQualifiedPath = this.decodeBase64UTFString(fullyQualifiedPath);
            logger.debug("calling the api.....get/fileAsStream dwonload path:" + fullyQualifiedPath);
            File file = new File(fullyQualifiedPath);
            if (!file.exists()) {
                return;
            }
            String encodedFileName = URLEncoder.encode(file.getName(), StandardCharsets.UTF_8.toString());
            if (browserType.contains("Firefox")) {
                response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + encodedFileName);
            } else if (browserType.contains("Chrome")) {
                response.setHeader("Content-Disposition", "attachment; filename=" + encodedFileName);
            } else {
                response.setHeader("Content-Disposition", "attachment; filename=\"" + encodedFileName + "\"");
            }
            response.addHeader("Content-Transfer-Encoding", "binary");
            response.addHeader("Content-Length", String.valueOf(file.length()));
            response.setStatus(200);
            try {
                logger.debug("beofre writng  the file.." + file.getAbsolutePath());
                this.writeDataToStream(file, response);
            }
            catch (IOException e) {
                logger.error("could not wrote file.. ", (Throwable)e);
                response.setStatus(500);
            }
        }
        catch (Exception e) {
            logger.error("exception writinr the file", (Throwable)e);
            response.setStatus(500);
        }
    }

    private void writeDataToStream(File file, HttpServletResponse response) throws IOException {
        try {
            int buff;
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream fif = new BufferedInputStream(fis);
            byte[] b = new byte[4096];
            while ((buff = ((InputStream)fif).read(b)) != -1) {
                response.getOutputStream().write(b, 0, buff);
                response.getOutputStream().flush();
            }
            ((InputStream)fif).close();
            logger.debug("finished writing to stream file...." + file.getName());
            file.delete();
            logger.debug("deleting  file  under path ....." + file.getPath());
        }
        catch (Exception e) {
            logger.debug("Exception   " + e);
            logger.error("Exception   " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/cloud/{cloudName}/download/folderAsPst/"}, method={RequestMethod.GET})
    public void downloadPst(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        InputStream inputStream = null;
        String browserType = request.getHeader("user-agent");
        logger.debug(".......download as pst...." + request.getHeader("pstName"));
        try {
            String fileName = "";
            String syncRevisionId = "";
            String userName = "";
            String sourceDeviceUUID = "";
            boolean isFolder = false;
            boolean isSync = false;
            Map parameters = request.getParameterMap();
            String batchId = "";
            String pstName = request.getHeader("pstName");
            syncRevisionId = request.getHeader("syncRevisionId");
            boolean isrestoreDeletedFile = false;
            String restoreDeletedFileStr = request.getParameter("restoreDeletedFile");
            if (!org.springframework.util.StringUtils.isEmpty((Object)restoreDeletedFileStr)) {
                isrestoreDeletedFile = Boolean.valueOf(restoreDeletedFileStr);
                logger.debug("...isrestoreDeletedFile..........." + isrestoreDeletedFile);
            }
            for (String key : parameters.keySet()) {
                String[] vals;
                logger.debug("....key...." + key);
                for (String val : vals = (String[])parameters.get(key)) {
                    logger.debug("....val...." + val);
                    if ("fileName".equalsIgnoreCase(key)) {
                        fileName = val;
                    }
                    if ("syncRevisionId".equalsIgnoreCase(key)) {
                        syncRevisionId = val;
                    }
                    if ("userName".equalsIgnoreCase(key)) {
                        userName = val;
                        userName = this.decodeBase64UTFString(userName);
                    }
                    if ("isFolder".equalsIgnoreCase(key)) {
                        isFolder = Boolean.parseBoolean(val);
                    }
                    if ("isSync".equalsIgnoreCase(key)) {
                        isSync = Boolean.parseBoolean(val);
                    }
                    if ("deviceUUID".equalsIgnoreCase(key)) {
                        sourceDeviceUUID = val;
                    }
                    if ("batchId".equalsIgnoreCase(key)) {
                        batchId = val;
                    }
                    if (!"pstName".equalsIgnoreCase(key)) continue;
                    pstName = val;
                }
            }
            int cloudId = 1;
            String backupId = syncRevisionId;
            DownloadFileTO downloadFileTO = this.getRequestParameters(request, cloudName);
            downloadFileTO.setBackupID(backupId);
            downloadFileTO.setDeviceUUID(sourceDeviceUUID);
            logger.debug(backupId + " Filename ..." + downloadFileTO.getFileName());
            logger.debug(batchId + "  DOWNLOAD FILE  STARTED for portal1 ...." + pstName);
            String deviceUUID = "Portal";
            DownloadTO downloadTO = null;
            if (!org.springframework.util.StringUtils.isEmpty((Object)batchId)) {
                PstBatch pstBatch = this.utilService.getPstBatch(batchId);
                sourceDeviceUUID = pstBatch.getDeviceUUID();
                downloadFileTO.setDeviceUUID(sourceDeviceUUID);
                if (!org.springframework.util.StringUtils.isEmpty((Object)pstName)) {
                    downloadFileTO.setFileName(pstName);
                } else {
                    downloadFileTO.setFileName(userName + "_search_results");
                }
                logger.debug(pstName + "..pstbatch...." + pstBatch.getDeviceUUID());
            }
            String saltKey = this.utilService.getEncryptionKey(1, "backup");
            Cloud cloud = this.utilService.getCloud(1);
            response.addHeader("Pragma", "public");
            response.addHeader("Expires", String.valueOf(200));
            response.addHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
            Device device = this.utilService.getDeviceForUUID(cloudId, sourceDeviceUUID);
            BackUpImage backUpImage = null;
            String dowloadFile = downloadFileTO.getFileName() + ".pst";
            if (!org.springframework.util.StringUtils.isEmpty((Object)backupId)) {
                if (!backupId.contains(",")) {
                    backUpImage = this.utilService.getBackupImageFile(cloudId, backupId, device);
                    if (backUpImage != null && dowloadFile.equalsIgnoreCase(".pst")) {
                        downloadFileTO.setFileName(backUpImage.getFileName());
                        dowloadFile = backUpImage.getFileName() + ".pst";
                    }
                } else {
                    backUpImage = null;
                    downloadFileTO.setFileName(device.getUserName());
                    dowloadFile = device.getUserName() + ".pst";
                }
            }
            if (backUpImage != null && !backUpImage.isFolder()) {
                dowloadFile = backUpImage.getFileName() + ".pst";
                downloadFileTO.setFileName(backUpImage.getFileName());
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)pstName)) {
                downloadFileTO.setFileName(pstName);
            }
            if (browserType.contains("Firefox")) {
                response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + dowloadFile);
            } else if (browserType.contains("Chrome")) {
                response.setHeader("Content-Disposition", "attachment; filename=" + dowloadFile);
            } else {
                response.setHeader("Content-Disposition", "attachment; filename=\"" + dowloadFile + "\"");
            }
            response.addHeader("Content-Transfer-Encoding", "binary");
            response.addHeader("filename", dowloadFile);
            response.addHeader("Content-Transfer-Encodingsdasda", "binary");
            response.setContentType("application/octet-stream");
            downloadTO = this.downloadFolderAsPst(cloud, userName, downloadFileTO.getFileName(), downloadFileTO.getFilePath(), saltKey, deviceUUID, response, browserType, downloadFileTO, batchId, isrestoreDeletedFile);
            response.addHeader("file-download-path", downloadTO.getPath());
            logger.debug("header name....." + response.getHeader("file-download-path"));
            logger.debug("header name....." + response.getHeader("filename"));
            response.setStatus(200);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error trying to download folder..." + e);
            response.setStatus(500);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        logger.debug(" end of  download file  Completed for portal ....");
    }

    private DownloadTO downloadFolderAsPst(Cloud cloud, String userName, String fileName, String filePath, String saltKey, String deviceUUID, HttpServletResponse response, String browserType, DownloadFileTO downloadFileTO, String pstBatchId, boolean isrestoreDeletedFile) {
        return this.downloadService.downloadPstBackupFolderForPortal(downloadFileTO, cloud, response, browserType, pstBatchId, isrestoreDeletedFile);
    }

    private boolean isODBEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isODBEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"ODB Enabled".equalsIgnoreCase(license.getName())) continue;
            isODBEnabled = true;
            break;
        }
        return isODBEnabled;
    }
}

