/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.paracloud.util;

import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.util.FileTypeHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ThumbnailHelper {
    private static Logger logger = LogManager.getLogger(ThumbnailHelper.class);
    private static final String VIDEO_THUMBNAIL_SCRIPT = "generateVideoThumbnails.sh";
    private static final String IMAGE_THUMBNAIL_SCRIPT = "generateThumnailForPictures.sh";
    private static final String AUDIO_THUMBNAIL_SCRIPT = "generateThumnailForMusic.sh";

    private ThumbnailHelper() {
    }

    public static void createThumbnails(String cloudName, String completeSourcePath, String folderRelativePath, String extension) {
        if (FileTypeHelper.isVideoFile(extension)) {
            ThumbnailHelper.createVideoThumbnail(cloudName, new File(completeSourcePath), folderRelativePath);
        } else if (FileTypeHelper.isImageFile(extension)) {
            ThumbnailHelper.createPictureThumbnail(cloudName, new File(completeSourcePath), folderRelativePath);
        } else if (FileTypeHelper.isAudioFile(extension)) {
            ThumbnailHelper.createAudioThumbnail(cloudName, new File(completeSourcePath), folderRelativePath);
        }
    }

    public static void createThumbnails(String cloudName, String fileSysPath, File source, String extension) {
        if (FileTypeHelper.isVideoFile(extension)) {
            ThumbnailHelper.createVideoThumbnail(cloudName, source, fileSysPath);
        } else if (FileTypeHelper.isImageFile(extension)) {
            ThumbnailHelper.createPictureThumbnail(cloudName, source, fileSysPath);
        } else if (FileTypeHelper.isAudioFile(extension)) {
            ThumbnailHelper.createAudioThumbnail(cloudName, source, fileSysPath);
        } else {
            ThumbnailHelper.createGeneralThumbnails(cloudName, fileSysPath, source);
        }
    }

    public static void createVideoThumbnail(String cloudName, File sourceFile, String folderRelativePath) {
        logger.debug("Creating VideoThumbnail : " + folderRelativePath);
        try {
            String thumbnailPath = PCHelperConstant.getPropertyFileValueParabluThumbnailsBasePath(cloudName) + folderRelativePath;
            String originalImagePath = sourceFile.getAbsolutePath();
            File fileParent = new File(thumbnailPath).getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            ProcessBuilder pb = new ProcessBuilder(PCHelperConstant.getPropertyFileValueParacloudScriptsFolder() + VIDEO_THUMBNAIL_SCRIPT, originalImagePath, thumbnailPath);
            pb.start();
        }
        catch (Exception e) {
            logger.debug("Exception", (Throwable)e);
        }
    }

    public static void createPictureThumbnail(String cloudName, File sourceFile, String folderRelativePath) {
        logger.debug("Creating PictureThumbnail : " + folderRelativePath + " " + sourceFile.getName());
        try {
            String thumbnailPath = PCHelperConstant.getPropertyFileValueParabluThumbnailsBasePath(cloudName) + folderRelativePath;
            String originalImagePath = sourceFile.getAbsolutePath();
            File imageParent = new File(thumbnailPath).getParentFile();
            if (!imageParent.exists()) {
                imageParent.mkdirs();
            }
            logger.debug("Executing: sudo convert -thumbnail 50 " + originalImagePath + " " + thumbnailPath);
            ProcessBuilder pb = new ProcessBuilder(PCHelperConstant.getPropertyFileValueParacloudScriptsFolder() + IMAGE_THUMBNAIL_SCRIPT, originalImagePath, thumbnailPath);
            pb.start();
        }
        catch (Exception e) {
            logger.debug("Exception", (Throwable)e);
        }
    }

    public static void createAudioThumbnail(String cloudName, File sourceFile, String folderRelativePath) {
        logger.debug("Creating PictureThumbnail : " + folderRelativePath + " " + sourceFile.getName());
        try {
            String thumbnailPath = PCHelperConstant.getPropertyFileValueParabluThumbnailsBasePath(cloudName) + folderRelativePath;
            String originalImagePath = sourceFile.getAbsolutePath();
            File imageParent = new File(thumbnailPath).getParentFile();
            if (!imageParent.exists()) {
                imageParent.mkdirs();
            }
            logger.debug("Executing: sudo convert -thumbnail 50 " + originalImagePath + " " + thumbnailPath);
            ProcessBuilder pb = new ProcessBuilder(PCHelperConstant.getPropertyFileValueParacloudScriptsFolder() + AUDIO_THUMBNAIL_SCRIPT, originalImagePath, thumbnailPath);
            pb.start();
        }
        catch (Exception e) {
            logger.debug("Exception", (Throwable)e);
        }
    }

    public static void createGeneralThumbnails(String cloudName, String parentPath, File sourceFile) {
        logger.debug("Creating GeneralThumbnails : " + parentPath + " " + sourceFile.getName());
        try {
            String thumbnailPath = PCHelperConstant.getPropertyFileValueParabluThumbnailsBasePath(cloudName) + parentPath;
            File fileParent = new File(thumbnailPath).getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            String[] str = new String[]{"touch", thumbnailPath};
            logger.debug("touching.." + thumbnailPath);
            Process pr = Runtime.getRuntime().exec(str);
            pr.waitFor();
            try {
                String line;
                BufferedReader buf = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                while ((line = buf.readLine()) != null) {
                    logger.debug(line);
                }
                buf.close();
            }
            catch (IOException e) {
                logger.debug("IOException ", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.debug("Exception", (Throwable)e);
        }
    }
}

