/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.paracloud.util;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Font;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class PdfGeneratorUtil {
    public static void addCellIntoTable(PdfPTable table, String data, boolean isNoWrap) {
        PdfPCell cell = new PdfPCell(new Phrase(data));
        cell.setNoWrap(isNoWrap);
        table.addCell(cell);
    }

    public static void addCellIntoTableByCheckingEmpty(PdfPTable table, String data, boolean isNoWrap) {
        if (StringUtils.isEmpty((String)data)) {
            data = "-";
        }
        PdfPCell cell = new PdfPCell(new Phrase(data));
        cell.setNoWrap(isNoWrap);
        table.addCell(cell);
    }

    public static void addHeaderCell(PdfPTable table, String data, boolean isNoWrap) {
        Font headerFont = new Font(Font.FontFamily.HELVETICA, 12.0f, 1, BaseColor.DARK_GRAY);
        PdfPCell cell = new PdfPCell(new Phrase(data, headerFont));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setNoWrap(isNoWrap);
        table.addCell(cell);
    }

    public static void setColspanForPdf(Map<String, Integer> pdfColSpanMap, String fieldName, String fieldNameValue) {
        Integer fieldNameColSpan = pdfColSpanMap.get(fieldName);
        if (fieldNameColSpan == null) {
            if (org.springframework.util.StringUtils.isEmpty((Object)fieldNameValue)) {
                fieldNameValue = "";
            }
            fieldNameColSpan = fieldName.length() >= fieldNameValue.length() ? Integer.valueOf(fieldName.length()) : Integer.valueOf(fieldNameValue.length());
        } else {
            if (org.springframework.util.StringUtils.isEmpty((Object)fieldNameValue)) {
                fieldNameValue = "";
            }
            if (fieldNameColSpan < fieldNameValue.length()) {
                fieldNameColSpan = fieldNameValue.length();
            }
        }
        pdfColSpanMap.put(fieldName, fieldNameColSpan);
    }
}

