/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.paracloud.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileUtils {
    private static Logger logger = LogManager.getLogger(FileUtils.class);
    public static final int BUFF_SIZE = 8192;
    public static final int RADIX = 16;

    private FileUtils() {
    }

    public static Map<String, String> splitAndWrite(String sourceFilePath, int chunkSize1, String destinationPath) throws IOException, NoSuchAlgorithmException {
        int chunkSize = chunkSize1;
        File willBeRead = new File(sourceFilePath);
        int fileSize = (int)willBeRead.length();
        HashMap<String, String> md5AndFileValueMap = new HashMap<String, String>();
        int numberOfChunks = 0;
        byte[] temporary = null;
        try {
            int totalBytesRead = 0;
            try (BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(willBeRead));){
                while (totalBytesRead < fileSize) {
                    int bytesRead;
                    String partName = Integer.toString(numberOfChunks);
                    int bytesRemaining = fileSize - totalBytesRead;
                    if (bytesRemaining < chunkSize) {
                        chunkSize = bytesRemaining;
                        logger.debug("CHUNK_SIZE: " + chunkSize);
                    }
                    if ((bytesRead = ((InputStream)inStream).read(temporary = new byte[chunkSize], 0, chunkSize)) > 0) {
                        totalBytesRead += bytesRead;
                        ++numberOfChunks;
                    }
                    FileUtils.write(temporary, destinationPath + partName);
                    File tempFile = new File(destinationPath + partName);
                    String tempFileMd5 = FileUtils.getMD5(tempFile);
                    md5AndFileValueMap.put(tempFileMd5, tempFile.getPath());
                    logger.debug("Total Bytes Read: " + totalBytesRead);
                }
            }
        }
        catch (Exception ex) {
            logger.trace(" Exception while trying to splitAndWrite " + ex);
        }
        return md5AndFileValueMap;
    }

    static void write(byte[] dataByteArray, String destinationFileName) {
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(destinationFileName));){
            ((OutputStream)output).write(dataByteArray);
            ((OutputStream)output).close();
        }
        catch (Exception e) {
            logger.trace("  ********************EXCEPTION FAILED while writing of chunk file ***************** " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void merge(List<String> nameList, String chunkFilePath, String destinationPath) {
        byte[] allFilesContent = null;
        int totalSize = 0;
        int fileNumber = nameList.size();
        int fileLength = 0;
        int currentLength = 0;
        logger.debug(" NUMBER  OF FILES " + fileNumber);
        for (String name : nameList) {
            logger.debug(" ||||||  Chunk File Path  " + chunkFilePath + name);
            File newFile = new File(chunkFilePath + "/" + name);
            totalSize = (int)((long)totalSize + newFile.length());
        }
        try {
            allFilesContent = new byte[totalSize];
            Collections.sort(nameList);
            for (String name : nameList) {
                logger.debug(" PAth   " + chunkFilePath + name);
                File file2 = new File(chunkFilePath + "/" + name);
                try {
                    BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(file2));
                    Throwable throwable = null;
                    try {
                        fileLength = (int)file2.length();
                        ((InputStream)inStream).read(allFilesContent, currentLength, fileLength);
                        currentLength += fileLength;
                        ((InputStream)inStream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inStream == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)inStream).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((InputStream)inStream).close();
                    }
                }
                catch (IOException e) {
                    logger.debug("Exception  " + e);
                }
            }
        }
        catch (Exception ioe) {
            logger.debug("Exception while reading the file " + ioe);
        }
        finally {
            FileUtils.write(allFilesContent, destinationPath);
        }
        logger.debug(totalSize + "Merge was executed successfully.!");
    }

    public static String getMD5(File f) throws NoSuchAlgorithmException, FileNotFoundException {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        String output = "";
        byte[] buffer = new byte[8192];
        int read = 0;
        try (FileInputStream is = new FileInputStream(f);){
            while ((read = ((InputStream)is).read(buffer)) > 0) {
                digest.update(buffer, 0, read);
            }
            byte[] md5sum = digest.digest();
            BigInteger bigInt = new BigInteger(1, md5sum);
            output = bigInt.toString(16);
        }
        catch (IOException e) {
            logger.error("IOException trying to get md5" + e);
        }
        return output;
    }

    public static List<String> getExistingFileNamesForGivenPath(String path) {
        File[] files;
        ArrayList<String> results = new ArrayList<String>();
        for (File file : files = new File(path).listFiles()) {
            if (!file.isFile()) continue;
            results.add(file.getName());
        }
        return results;
    }
}

