/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.helper.utils;

import com.parablu.helper.utils.ObjectDiffFinder;
import com.parablu.paracloud.element.SyncPolicyElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class SyncPolicyDiffFinder {
    private static Logger logger = LogManager.getLogger(SyncPolicyDiffFinder.class);

    /*
     * WARNING - void declaration
     */
    public String findDiff(SyncPolicyElement existingSyncPolicyElement, SyncPolicyElement syncPolicyElement) {
        Collection<Object> keys;
        if (!syncPolicyElement.isPftEnabled()) {
            syncPolicyElement.setPftSize(existingSyncPolicyElement.getPftSize());
            syncPolicyElement.setFileChunkableSize(existingSyncPolicyElement.getFileChunkableSize());
        }
        ObjectDiffFinder objectDiffFinder = new ObjectDiffFinder();
        objectDiffFinder.finder(existingSyncPolicyElement, syncPolicyElement);
        objectDiffFinder.visiter(objectDiffFinder);
        ArrayList<Map<String, Object>> changes = new ArrayList<Map<String, Object>>(objectDiffFinder.changes);
        HashMap<String, String> fieldChanges = new HashMap<String, String>();
        StringBuilder fieldChangesResponse = new StringBuilder();
        for (Map map : changes) {
            keys = map.keySet();
            String propertyName = "";
            String newValue = "";
            String oldValue = "";
            for (String string : keys) {
                if (!StringUtils.isEmpty(map.get(string)) && string.contains("newValue")) {
                    newValue = map.get(string).toString();
                }
                if (string.contains("propertyName")) {
                    propertyName = map.get(string).toString();
                }
                if (string.contains("oldValue") && !StringUtils.isEmpty(map.get(string))) {
                    oldValue = map.get(string).toString();
                }
                if (StringUtils.isEmpty((Object)propertyName) || propertyName.contains("lastModifiedTimestamp")) continue;
                fieldChanges.put(propertyName, "\"" + oldValue + "\" => \"" + newValue + "\"");
            }
        }
        if (!existingSyncPolicyElement.getPrivacyGatewayMappingElement().getPrivacyGatewayNames().equals(syncPolicyElement.getPrivacyGatewayMappingElement().getPrivacyGatewayNames())) {
            fieldChanges.put("Preferred Blukrypt Hostnames", "\"" + existingSyncPolicyElement.getPrivacyGatewayMappingElement().getPrivacyGatewayNames().toString() + "\" => \"" + syncPolicyElement.getPrivacyGatewayMappingElement().getPrivacyGatewayNames().toString() + "\"");
        }
        if (!existingSyncPolicyElement.getNwFromClientToPG().equals(syncPolicyElement.getNwFromClientToPG())) {
            if (existingSyncPolicyElement.getNwFromClientToPG().toString().equals("")) {
                fieldChanges.put("Network Throttle Setting from Client to BluKrypt (In Mbps)", " \"UNLIMITED\" => \"" + syncPolicyElement.getNwFromClientToPG() + "\"");
            } else if (syncPolicyElement.getNwFromClientToPG().toString().equals("")) {
                fieldChanges.put("Network Throttle Setting from Client to BluKrypt (In Mbps)", " \"" + existingSyncPolicyElement.getNwFromClientToPG() + "\" => \"UNLIMITED\"");
            } else {
                fieldChanges.put("Network Throttle Setting from Client to BluKrypt (In Mbps)", " \"" + existingSyncPolicyElement.getNwFromClientToPG() + "\" => \"" + syncPolicyElement.getNwFromClientToPG() + "\"");
            }
        }
        if (existingSyncPolicyElement.getUserSizeAllowed() != syncPolicyElement.getUserSizeAllowed()) {
            if (existingSyncPolicyElement.getUserSizeAllowed() == 102400) {
                fieldChanges.put("User Storage Quota (In GB)", " \"UNLIMITED\" => \"" + syncPolicyElement.getUserSizeAllowed() + "\"");
            } else if (syncPolicyElement.getUserSizeAllowed() == 102400) {
                fieldChanges.put("User Storage Quota (In GB)", " \"" + existingSyncPolicyElement.getUserSizeAllowed() + "\" => \"UNLIMITED\"");
            } else {
                fieldChanges.put("User Storage Quota (In GB)", " \"" + existingSyncPolicyElement.getUserSizeAllowed() + "\" => \"" + syncPolicyElement.getUserSizeAllowed() + "\"");
            }
        }
        if (!existingSyncPolicyElement.getMaxFileSize().equals(syncPolicyElement.getMaxFileSize())) {
            if (existingSyncPolicyElement.getMaxFileSize().toString().equals("1048576")) {
                fieldChanges.put("Maximum File Size (In MB)", " \"UNLIMITED\" => \"" + syncPolicyElement.getMaxFileSize() + "\"");
            } else if (syncPolicyElement.getMaxFileSize().toString().equals("1048576")) {
                fieldChanges.put("Maximum File Size (In MB)", " \"" + existingSyncPolicyElement.getMaxFileSize() + "\" => \"UNLIMITED\"");
            } else {
                fieldChanges.put("Maximum File Size (In MB)", " \"" + existingSyncPolicyElement.getMaxFileSize() + "\" => \"" + syncPolicyElement.getMaxFileSize() + "\"");
            }
        }
        if (existingSyncPolicyElement.getMaxVersions() != syncPolicyElement.getMaxVersions()) {
            if (existingSyncPolicyElement.getMaxVersions() == -1) {
                fieldChanges.put("Maximum number of Versions Allowed", " \"UNLIMITED\" => \"" + syncPolicyElement.getMaxVersions() + "\"");
            } else if (syncPolicyElement.getMaxVersions() == -1) {
                fieldChanges.put("Maximum number of Versions Allowed", " \"" + existingSyncPolicyElement.getMaxVersions() + "\" => \"UNLIMITED\"");
            } else {
                fieldChanges.put("Maximum number of Versions Allowed", " \"" + existingSyncPolicyElement.getMaxVersions() + "\" => \"" + syncPolicyElement.getMaxVersions() + "\"");
            }
        }
        if (existingSyncPolicyElement.getNoOfDevicesAllowed() != syncPolicyElement.getNoOfDevicesAllowed()) {
            if (existingSyncPolicyElement.getNoOfDevicesAllowed() == -1) {
                fieldChanges.put("Maximum number of Devices Allowed", " \"UNLIMITED\" => \"" + syncPolicyElement.getNoOfDevicesAllowed() + "\"");
            } else if (syncPolicyElement.getNoOfDevicesAllowed() == -1) {
                fieldChanges.put("Maximum number of Devices Allowed", " \"" + existingSyncPolicyElement.getNoOfDevicesAllowed() + "\" => \"UNLIMITED\"");
            } else {
                fieldChanges.put("Maximum number of Devices Allowed", " \"" + existingSyncPolicyElement.getNoOfDevicesAllowed() + "\" => \"" + syncPolicyElement.getNoOfDevicesAllowed() + "\"");
            }
        }
        if (!(CollectionUtils.isEmpty(existingSyncPolicyElement.getFilterInclusionName()) || CollectionUtils.isEmpty(syncPolicyElement.getFilterInclusionName()) || existingSyncPolicyElement.getFilterInclusionName().equals(syncPolicyElement.getFilterInclusionName()))) {
            fieldChanges.put("Filters", " \"" + existingSyncPolicyElement.getFilterInclusionName() + "\" => \"" + syncPolicyElement.getFilterInclusionName() + "\"");
        }
        if (!existingSyncPolicyElement.getFilterType().equals(syncPolicyElement.getFilterType())) {
            fieldChanges.put("Filter Type", " \"" + existingSyncPolicyElement.getFilterType() + "\" => \"" + syncPolicyElement.getFilterType() + "\"");
        }
        if (!(CollectionUtils.isEmpty(existingSyncPolicyElement.getShareDomainIncExclusions()) || CollectionUtils.isEmpty(syncPolicyElement.getShareDomainIncExclusions()) || existingSyncPolicyElement.getShareDomainIncExclusions().equals(syncPolicyElement.getShareDomainIncExclusions()))) {
            fieldChanges.put("Share Domain Inclusions/Exclusions", " \"" + existingSyncPolicyElement.getShareDomainIncExclusions() + "\" => \"" + syncPolicyElement.getShareDomainIncExclusions() + "\"");
        }
        if (!(CollectionUtils.isEmpty(existingSyncPolicyElement.getShareDomainIncExclusionsException()) || CollectionUtils.isEmpty(syncPolicyElement.getShareDomainIncExclusionsException()) || existingSyncPolicyElement.getShareDomainIncExclusionsException().equals(syncPolicyElement.getShareDomainIncExclusionsException()))) {
            fieldChanges.put("Share Domain Inclusions/Exclusions Exception", " \"" + existingSyncPolicyElement.getShareDomainIncExclusionsException() + "\" => \"" + syncPolicyElement.getShareDomainIncExclusionsException() + "\"");
        }
        if (!(StringUtils.isEmpty((Object)existingSyncPolicyElement.getShareDomainType()) || StringUtils.isEmpty((Object)syncPolicyElement.getShareDomainType()) || existingSyncPolicyElement.getShareDomainType().equals(syncPolicyElement.getShareDomainType()))) {
            fieldChanges.put("Share Domain Type", " \"" + existingSyncPolicyElement.getShareDomainType() + "\" => \"" + syncPolicyElement.getShareDomainType() + "\"");
        }
        if (!StringUtils.isEmpty(fieldChanges)) {
            for (String string : fieldChanges.keySet()) {
                String key = string;
                if (key.contains("syncEnableAutomatic")) {
                    key = "Automatic Sync";
                } else if (key.contains("syncInterval")) {
                    key = "Sync Interval (In Minutes)";
                } else if (key.contains("osType")) {
                    key = "Operating System Type";
                } else if (key.contains("pftEnabled")) {
                    key = "Partial File Transfer";
                } else if (key.contains("pftSize")) {
                    key = "Minimum File Size to Enable Partial File Transfer (In MB)";
                } else if (key.contains("fileChunkableSize")) {
                    key = "Partial File Transfer Chunk Size (In MB)";
                } else if (key.contains("nwFromClientToPG")) {
                    key = "Network Throttle Setting from Client to BluKrypt (In Mbps)";
                } else if (key.contains("dedup")) {
                    key = "Dedup";
                } else if (key.contains("compressionEnabled")) {
                    key = "Enable Compression";
                } else if (key.contains("policyRefresh")) {
                    key = "Policy Refresh Frequency (In Hours)";
                } else if (key.contains("shareEnabled")) {
                    key = "Share";
                } else if (key.contains("twoWayShareEnabled")) {
                    key = "Two Way Share Enabled";
                } else if (key.contains("canUserChangePassword")) {
                    key = "Allow User To Change Password";
                } else if (key.contains("canAdminChangeUserPassword")) {
                    key = "Allow Admin To Change User Password";
                } else if (key.contains("noOfDaysToPurgeFile")) {
                    key = "Number Of Days Old File To Be Deleted";
                } else if (key.contains("filterType")) {
                    key = "Filter Type";
                } else if (key.contains("webBasedLogin")) {
                    key = "Web based login";
                } else if (key.contains("googleAuth")) {
                    key = "Google Auth code";
                } else if (key.contains("downloadAgent")) {
                    key = "Enable Download Agent";
                } else if (key.contains("showShareLink")) {
                    key = "Show Share Link";
                } else if (key.contains("enableAVScan")) {
                    key = "Enable Scan";
                } else if (key.contains("switchAgentPassword")) {
                    key = "Enable Agent uninstallation password";
                } else if (key.contains("highSecureShareEnabled")) {
                    key = "Highly Secure Share";
                } else if (key.contains("complexPassword")) {
                    key = "Complex Password";
                } else if (key.contains("preventDownloadEnabled")) {
                    key = "Allow Download";
                } else if (key.contains("expiredDate")) {
                    key = "Share Expiry Date Required";
                } else if (!(key.contains("UI Settings For Agent") || key.contains("Preferred Blukrypt Hostnames") || key.contains("Network Throttle Setting from Client to BluKrypt (In Mbps)") || key.contains("User Storage Quota (In GB)") || key.contains("Maximum File Size (In MB)") || key.contains("Maximum number of Versions Allowed") || key.contains("Maximum number of Devices Allowed") || key.contains("Filters") || key.contains("Filter Type") || key.contains("Share Domain Inclusions/Exclusions") || key.contains("Email Alert Configurations") || key.contains("Share Domain Type"))) {
                    key = "";
                }
                if (StringUtils.isEmpty((Object)key)) continue;
                fieldChanges.get(string);
                fieldChangesResponse.append(" (");
                fieldChangesResponse.append(key);
                fieldChangesResponse.append(" values ");
                fieldChangesResponse.append((String)fieldChanges.get(string));
                fieldChangesResponse.append(")");
                if (key.length() <= 1) continue;
                fieldChangesResponse.append(", ");
            }
            if (!existingSyncPolicyElement.getEndpointUiPreferences().equals(syncPolicyElement.getEndpointUiPreferences())) {
                fieldChangesResponse.append(" ( UI Settings For Agent ");
                fieldChangesResponse.append(" Values : [ ");
                String oldValue = "Enabled";
                String string = "Enabled";
                keys = new ArrayList();
                keys.add("Exit");
                keys.add("Decouple");
                keys.add("Support");
                keys.add("Initiate Sync");
                keys.add("Sync Settings");
                keys.add("Sync Files");
                keys.add("Refresh Sync Policy");
                keys.add("Search");
                keys.add("Open Sync Folder");
                keys.add("Update Agent");
                keys.add("About");
                keys.add("systray Icon");
                List<String> existingEndpointUiValue = existingSyncPolicyElement.getEndpointUiPreferences();
                List<String> endpointUiValue = syncPolicyElement.getEndpointUiPreferences();
                HashMap oldValueMap = new HashMap();
                HashMap<void, void> hashMap = new HashMap<void, void>();
                if (!StringUtils.isEmpty(existingEndpointUiValue)) {
                    String string2 = "";
                    for (String string3 : existingEndpointUiValue) {
                        void var15_42;
                        if (string3.contains("EXIT")) {
                            String string4 = "Exit";
                        } else if (string3.contains("DECOUPLE")) {
                            String string5 = "Decouple";
                        } else if (string3.contains("SUPPORT")) {
                            String string6 = "Support";
                        } else if (string3.contains("INITIATE_SYNC")) {
                            String string7 = "Initiate Sync";
                        } else if (string3.contains("SYNC_SETTINGS")) {
                            String string8 = "Sync Settings";
                        } else if (string3.contains("SYNC_FILES")) {
                            String string9 = "Sync Files";
                        } else if (string3.contains("REFRESH_SYNC_POLICY")) {
                            String string10 = "Refresh Sync Policy";
                        } else if (string3.contains("SEARCH")) {
                            String string11 = "Search";
                        } else if (string3.contains("OPEN_SYNC_FOLDER")) {
                            String string12 = "Open Sync Folder";
                        } else if (string3.contains("UPDATE_AGENT")) {
                            String string13 = "Update Agent";
                        } else if (string3.contains("ABOUT")) {
                            String string14 = "About";
                        } else if (string3.contains("SYSTRAYICON")) {
                            String string15 = "systray Icon";
                        } else {
                            oldValue = "Disabled";
                        }
                        oldValueMap.put(var15_42, oldValue);
                    }
                }
                if (!StringUtils.isEmpty(endpointUiValue)) {
                    String string16 = "";
                    for (String string17 : endpointUiValue) {
                        void var9_12;
                        void var15_57;
                        if (string17.contains("EXIT")) {
                            String string18 = "Exit";
                        } else if (string17.contains("DECOUPLE")) {
                            String string19 = "Decouple";
                        } else if (string17.contains("SUPPORT")) {
                            String string20 = "Support";
                        } else if (string17.contains("INITIATE_SYNC")) {
                            String string21 = "Initiate Sync";
                        } else if (string17.contains("SYNC_SETTINGS")) {
                            String string22 = "Sync Settings";
                        } else if (string17.contains("SYNC_FILES")) {
                            String string23 = "Sync Files";
                        } else if (string17.contains("REFRESH_SYNC_POLICY")) {
                            String string24 = "Refresh Sync Policy";
                        } else if (string17.contains("SEARCH")) {
                            String string25 = "Search";
                        } else if (string17.contains("OPEN_SYNC_FOLDER")) {
                            String string26 = "Open Sync Folder";
                        } else if (string17.contains("UPDATE_AGENT")) {
                            String string27 = "Update Agent";
                        } else if (string17.contains("ABOUT")) {
                            String string28 = "About";
                        } else if (string17.contains("SYSTRAYICON")) {
                            String string29 = "systray Icon";
                        } else {
                            String string30 = "Disabled";
                        }
                        hashMap.put(var15_57, var9_12);
                    }
                }
                boolean bl = false;
                for (String string31 : keys) {
                    void var15_72;
                    ++var15_72;
                    fieldChangesResponse.append("\"" + string31 + "\" : ");
                    if (oldValueMap.containsKey(string31)) {
                        fieldChangesResponse.append("\"" + (String)oldValueMap.get(string31));
                    } else {
                        fieldChangesResponse.append("\"Disabled");
                    }
                    if (hashMap.containsKey(string31)) {
                        fieldChangesResponse.append("\" => \"" + (String)hashMap.get(string31));
                    } else {
                        fieldChangesResponse.append("\" => \"Disabled");
                    }
                    if (string31.length() <= 0 || var15_72 >= string31.length()) continue;
                    fieldChangesResponse.append(", ");
                }
                if (fieldChangesResponse.length() > 0) {
                    fieldChangesResponse.replace(fieldChangesResponse.length() - 2, fieldChangesResponse.length(), "");
                }
                fieldChangesResponse.append("\" ] ) ");
            } else if (fieldChangesResponse.length() > 0) {
                fieldChangesResponse.replace(fieldChangesResponse.length() - 1, fieldChangesResponse.length(), " ");
            }
            if (!existingSyncPolicyElement.getMenuOptions().equals(syncPolicyElement.getMenuOptions())) {
                fieldChangesResponse.append(" ( My files user action preferences ");
                fieldChangesResponse.append(" Values : [ ");
                ArrayList<String> keys2 = new ArrayList<String>();
                Map<String, Boolean> map = existingSyncPolicyElement.getMenuOptions();
                Map<String, Boolean> menuOptionsValue = syncPolicyElement.getMenuOptions();
                HashMap<void, String> oldValueMap = new HashMap<void, String>();
                HashMap<void, String> newValueMap = new HashMap<void, String>();
                if (!StringUtils.isEmpty(map)) {
                    for (String string : map.keySet()) {
                        void var15_85;
                        String string32 = "";
                        if (string.contains("open") && Boolean.compare(map.get(string), menuOptionsValue.get(string) == false) == 0) {
                            String string33 = "Open";
                            keys2.add(string33);
                        } else if (string.contains("view") && Boolean.compare(map.get(string), menuOptionsValue.get(string) == false) == 0) {
                            String string34 = "View";
                            keys2.add(string34);
                        } else if (string.contains("versions") && Boolean.compare(map.get(string), menuOptionsValue.get(string) == false) == 0) {
                            String string35 = "Versions";
                            keys2.add(string35);
                        } else if (string.contains("share") && Boolean.compare(map.get(string), menuOptionsValue.get(string) == false) == 0) {
                            String string36 = "Share";
                            keys2.add(string36);
                        } else if (string.contains("download") && Boolean.compare(map.get(string), menuOptionsValue.get(string) == false) == 0) {
                            String string37 = "Download";
                            keys2.add(string37);
                        } else if (string.contains("rename") && Boolean.compare(map.get(string), menuOptionsValue.get(string) == false) == 0) {
                            String string38 = "Rename";
                            keys2.add(string38);
                        } else if (string.contains("cutCopyPaste") && Boolean.compare(map.get(string), menuOptionsValue.get(string) == false) == 0) {
                            String string39 = "Cut, Copy and Paste";
                            keys2.add(string39);
                        } else if (string.contains("fileUpload") && Boolean.compare(map.get(string), menuOptionsValue.get(string) == false) == 0) {
                            String string40 = "File/Folder Upload";
                            keys2.add(string40);
                        } else if (string.contains("createFolder") && Boolean.compare(map.get(string), menuOptionsValue.get(string) == false) == 0) {
                            String string41 = "Create Folder";
                            keys2.add(string41);
                        } else if (string.contains("createMiniCloud") && Boolean.compare(map.get(string), menuOptionsValue.get(string) == false) == 0) {
                            String string42 = "Create MiniCloud";
                            keys2.add(string42);
                        } else if (string.contains("delete") && Boolean.compare(map.get(string), menuOptionsValue.get(string) == false) == 0) {
                            String string43 = "Delete";
                            keys2.add(string43);
                        }
                        oldValueMap.put(var15_85, map.get(string) == true ? "Enabled" : "Disabled");
                        newValueMap.put(var15_85, menuOptionsValue.get(string) == true ? "Enabled" : "Disabled");
                    }
                }
                int i = 0;
                for (String string : keys2) {
                    ++i;
                    fieldChangesResponse.append("\"" + string + "\" : ");
                    if (oldValueMap.containsKey(string)) {
                        fieldChangesResponse.append("\"" + (String)oldValueMap.get(string));
                    } else {
                        fieldChangesResponse.append("\"Disabled");
                    }
                    if (newValueMap.containsKey(string)) {
                        fieldChangesResponse.append("\" => \"" + (String)newValueMap.get(string) + "\"");
                    } else {
                        fieldChangesResponse.append("\" => \"Disabled");
                    }
                    if (string.length() <= 0 || i >= string.length()) continue;
                    fieldChangesResponse.append(", ");
                }
                if (fieldChangesResponse.length() > 0) {
                    fieldChangesResponse.replace(fieldChangesResponse.length() - 2, fieldChangesResponse.length(), "");
                }
                fieldChangesResponse.append("] ) ");
            } else if (fieldChangesResponse.length() > 0) {
                fieldChangesResponse.replace(fieldChangesResponse.length() - 1, fieldChangesResponse.length(), " ");
            }
            if (existingSyncPolicyElement.getEmailsRestriction() != null && !existingSyncPolicyElement.getEmailsRestriction().equals(syncPolicyElement.getEmailsRestriction())) {
                Map<String, String> existingEmailsRestriction = existingSyncPolicyElement.getEmailsRestriction();
                Map<String, String> map = syncPolicyElement.getEmailsRestriction();
                ArrayList<String> emailKeys = new ArrayList<String>();
                fieldChangesResponse.append(" ( Email Alert Configurations ");
                fieldChangesResponse.append(" Values : [ ");
                emailKeys.add("createUser");
                emailKeys.add("userDeleted");
                emailKeys.add("userBlocked");
                emailKeys.add("userLimitReached");
                HashMap<String, String> oldValues = new HashMap<String, String>();
                HashMap<String, String> newValues = new HashMap<String, String>();
                if (!existingEmailsRestriction.isEmpty()) {
                    for (String string : emailKeys) {
                        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(existingEmailsRestriction.get(string).split(",")));
                        if (string.equalsIgnoreCase("createUser")) {
                            if (!StringUtils.isEmpty((Object)existingEmailsRestriction.get(string))) {
                                if (arrayList.contains("users")) {
                                    oldValues.put("User create", "Enabled");
                                } else {
                                    oldValues.put("User create", "Disabled");
                                }
                            } else {
                                oldValues.put("User create", "Disabled");
                            }
                        }
                        if (string.equalsIgnoreCase("userDeleted")) {
                            if (!StringUtils.isEmpty((Object)existingEmailsRestriction.get(string))) {
                                if (arrayList.contains("users")) {
                                    oldValues.put("User deleted", "Enabled");
                                } else {
                                    oldValues.put("User deleted", "Disabled");
                                }
                            } else {
                                oldValues.put("User deleted", "Disabled");
                            }
                        }
                        if (string.equalsIgnoreCase("userBlocked")) {
                            if (!StringUtils.isEmpty((Object)existingEmailsRestriction.get(string))) {
                                if (arrayList.contains("users")) {
                                    oldValues.put("User blocked", "Enabled");
                                } else {
                                    oldValues.put("User blocked", "Disabled");
                                }
                            } else {
                                oldValues.put("User blocked", "Disabled");
                            }
                        }
                        if (!string.equalsIgnoreCase("userLimitReached")) continue;
                        if (!StringUtils.isEmpty((Object)existingEmailsRestriction.get(string))) {
                            if (arrayList.contains("users")) {
                                oldValues.put("User limit reached", "Enabled");
                                continue;
                            }
                            oldValues.put("User limit reached", "Disabled");
                            continue;
                        }
                        oldValues.put("User limit reached", "Disabled");
                    }
                }
                if (!map.isEmpty()) {
                    for (String string : emailKeys) {
                        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(map.get(string).split(",")));
                        if (string.equalsIgnoreCase("createUser")) {
                            if (!StringUtils.isEmpty((Object)map.get(string))) {
                                if (arrayList.contains("users")) {
                                    newValues.put("User create", "Enabled");
                                } else {
                                    newValues.put("User create", "Disabled");
                                }
                            } else {
                                newValues.put("User create", "Disabled");
                            }
                        }
                        if (string.equalsIgnoreCase("userDeleted")) {
                            if (!StringUtils.isEmpty((Object)map.get(string))) {
                                if (arrayList.contains("users")) {
                                    newValues.put("User deleted", "Enabled");
                                } else {
                                    newValues.put("User deleted", "Disabled");
                                }
                            } else {
                                newValues.put("User deleted", "Disabled");
                            }
                        }
                        if (string.equalsIgnoreCase("userBlocked")) {
                            if (!StringUtils.isEmpty((Object)map.get(string))) {
                                if (arrayList.contains("users")) {
                                    newValues.put("User blocked", "Enabled");
                                } else {
                                    newValues.put("User blocked", "Disabled");
                                }
                            } else {
                                newValues.put("User blocked", "Disabled");
                            }
                        }
                        if (!string.equalsIgnoreCase("userLimitReached")) continue;
                        if (!StringUtils.isEmpty((Object)map.get(string))) {
                            if (arrayList.contains("users")) {
                                newValues.put("User limit reached", "Enabled");
                                continue;
                            }
                            newValues.put("User limit reached", "Disabled");
                            continue;
                        }
                        newValues.put("User limit reached", "Disabled");
                    }
                }
                for (String string : oldValues.keySet()) {
                    fieldChangesResponse.append("\"" + string + "\" : \"" + (String)oldValues.get(string) + "\"");
                    fieldChangesResponse.append("\" => \"" + (String)newValues.get(string));
                    fieldChangesResponse.append(", ");
                }
                if (fieldChangesResponse.length() > 0) {
                    fieldChangesResponse.replace(fieldChangesResponse.length() - 2, fieldChangesResponse.length(), "");
                }
                fieldChangesResponse.append("\" ] ) ");
            } else if (fieldChangesResponse.length() > 0) {
                fieldChangesResponse.replace(fieldChangesResponse.length() - 1, fieldChangesResponse.length(), " ");
            }
        }
        String responseString = fieldChangesResponse.toString();
        responseString = responseString.replace("true", "Enabled");
        responseString = responseString.replace("false", "Disabled");
        return fieldChangesResponse.toString();
    }
}

