/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.helper.utils;

import com.parablu.helper.utils.ObjectDiffFinder;
import com.parablu.paracloud.element.OfficeBackupPolicyElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class OfficeBackupPolicyDiffFinder {
    /*
     * WARNING - void declaration
     */
    public String findDiff(OfficeBackupPolicyElement existingBackupPolicyElement, OfficeBackupPolicyElement backupPolicyElement) {
        Collection<Object> keys;
        StringBuilder fieldChangesResponse = new StringBuilder();
        ObjectDiffFinder objectDiffFinder = new ObjectDiffFinder();
        objectDiffFinder.finder(existingBackupPolicyElement, backupPolicyElement);
        objectDiffFinder.visiter(objectDiffFinder);
        ArrayList<Map<String, Object>> changes = new ArrayList<Map<String, Object>>(objectDiffFinder.changes);
        HashMap<String, String> fieldChanges = new HashMap<String, String>();
        for (Map map : changes) {
            keys = map.keySet();
            String propertyName = "";
            String newValue = "";
            String oldValue = "";
            for (String string : keys) {
                if (!StringUtils.isEmpty(map.get(string)) && string.contains("newValue")) {
                    newValue = map.get(string).toString();
                }
                if (string.contains("propertyName")) {
                    propertyName = map.get(string).toString();
                }
                if (StringUtils.isEmpty(map.get(string)) || !string.contains("oldValue")) continue;
                oldValue = map.get(string).toString();
            }
            if (StringUtils.isEmpty((Object)propertyName) || propertyName.contains("lastModifiedTimestamp")) continue;
            fieldChanges.put(propertyName, "\"" + oldValue + "\" => \"" + newValue + "\"");
        }
        if (!StringUtils.isEmpty(existingBackupPolicyElement.getScheduleNames())) {
            Collections.sort(existingBackupPolicyElement.getScheduleNames());
        }
        if (!StringUtils.isEmpty(backupPolicyElement.getScheduleNames())) {
            Collections.sort(backupPolicyElement.getScheduleNames());
        }
        if (!existingBackupPolicyElement.getScheduleNames().equals(backupPolicyElement.getScheduleNames())) {
            fieldChanges.put("Schedules", " \"" + existingBackupPolicyElement.getScheduleNames() + "\" => \"" + backupPolicyElement.getScheduleNames() + "\"");
        }
        if (!existingBackupPolicyElement.getBackupFolderPaths().equals(backupPolicyElement.getBackupFolderPaths())) {
            fieldChanges.put("Default Folders", " \"" + existingBackupPolicyElement.getBackupFolderPaths() + "\" => \"" + backupPolicyElement.getBackupFolderPaths() + "\"");
        }
        if (!CollectionUtils.isEmpty(existingBackupPolicyElement.getExcludedFolderpaths()) && !existingBackupPolicyElement.getExcludedFolderpaths().equals(backupPolicyElement.getExcludedFolderpaths())) {
            fieldChanges.put("Excluded Folders", " \"" + existingBackupPolicyElement.getExcludedFolderpaths() + "\" => \"" + backupPolicyElement.getExcludedFolderpaths() + "\"");
        }
        if (existingBackupPolicyElement.getNoOfDaysToKeepDeletedFiles() != backupPolicyElement.getNoOfDaysToKeepDeletedFiles()) {
            if (existingBackupPolicyElement.getNoOfDaysToKeepDeletedFiles() == -1L) {
                fieldChanges.put("Purge deleted files from the catalogue after", " \"UNLIMITED\" => \"" + backupPolicyElement.getNoOfDaysToKeepDeletedFiles() + "\"");
            } else if (backupPolicyElement.getNoOfDaysToKeepDeletedFiles() == -1L) {
                fieldChanges.put("Purge deleted files from the catalogue after", " \"" + existingBackupPolicyElement.getNoOfDaysToKeepDeletedFiles() + "\" => \"UNLIMITED\"");
            } else {
                fieldChanges.put("Purge deleted files from the catalogue after", " \"" + existingBackupPolicyElement.getNoOfDaysToKeepDeletedFiles() + "\" => \"" + backupPolicyElement.getNoOfDaysToKeepDeletedFiles() + "\"");
            }
        }
        if (existingBackupPolicyElement.getUserSizeAllowed() != backupPolicyElement.getUserSizeAllowed()) {
            if (existingBackupPolicyElement.getUserSizeAllowed() == 102400) {
                fieldChanges.put("Per Device Backup Storage Limit for OneDrive (In GB)", " \"UNLIMITED\" => \"" + backupPolicyElement.getUserSizeAllowed() + "\"");
            } else if (backupPolicyElement.getUserSizeAllowed() == 102400) {
                fieldChanges.put("Per Device Backup Storage Limit for OneDrive  (In GB)", " \"" + existingBackupPolicyElement.getUserSizeAllowed() + "\" => \"UNLIMITED\"");
            } else {
                fieldChanges.put("Per Device Backup Storage Limit for OneDrive  (In GB)", " \"" + existingBackupPolicyElement.getUserSizeAllowed() + "\" => \"" + backupPolicyElement.getUserSizeAllowed() + "\"");
            }
        }
        if (!existingBackupPolicyElement.getMaxFileSize().equals(backupPolicyElement.getMaxFileSize())) {
            if (existingBackupPolicyElement.getMaxFileSize().toString().equals("1048576")) {
                fieldChanges.put("Maximum Permissible File Size for OneDrive  (In MB)", " \"UNLIMITED\" => \"" + backupPolicyElement.getMaxFileSize() + "\"");
            } else if (backupPolicyElement.getMaxFileSize().toString().equals("1048576")) {
                fieldChanges.put("Maximum Permissible File Size for OneDrive (In MB)", " \"" + existingBackupPolicyElement.getMaxFileSize() + "\" => \"UNLIMITED\"");
            } else {
                fieldChanges.put("Maximum Permissible File Size for OneDrive (In MB)", " \"" + existingBackupPolicyElement.getMaxFileSize() + "\" => \"" + backupPolicyElement.getMaxFileSize() + "\"");
            }
        }
        if (existingBackupPolicyElement.getMaxVersions() != backupPolicyElement.getMaxVersions()) {
            if (existingBackupPolicyElement.getMaxVersions() == -1) {
                fieldChanges.put("Maximum number of Versions Allowed for OneDrive ", " \"UNLIMITED\" => \"" + backupPolicyElement.getMaxVersions() + "\"");
            } else if (backupPolicyElement.getMaxVersions() == -1) {
                fieldChanges.put("Maximum number of Versions Allowed for OneDrive ", " \"" + existingBackupPolicyElement.getMaxVersions() + "\" => \"UNLIMITED\"");
            } else {
                fieldChanges.put("Maximum number of Versions Allowed for OneDrive ", " \"" + existingBackupPolicyElement.getMaxVersions() + "\" => \"" + backupPolicyElement.getMaxVersions() + "\"");
            }
        }
        for (String string : fieldChanges.keySet()) {
            String key = string;
            if (key.contains("osType")) {
                key = "Operating System Type";
            } else if (key.contains("filterInclusionName")) {
                key = "Filters";
            } else if (key.contains("ftEnabled")) {
                key = "Partial File Transfer";
            } else if (key.contains("pftSize")) {
                key = "Minimum File Size to Enable Partial File Transfer (In MB)";
            } else if (key.contains("fileChunkableSize")) {
                key = "Partial File Transfer Chunk Size (In MB)";
            } else if (key.contains("legalHoldEnabled")) {
                key = "Enable Legal Hold";
            } else if (key.contains("dedup")) {
                key = "Dedup";
            } else if (key.contains("compressionEnabled")) {
                key = "Enable Compression";
            } else if (key.contains("vssEnabled")) {
                key = "Volume Shadow Service";
            } else if (key.contains("searchAlgoForPg")) {
                key = "Blukrypt Search Algorithm";
            } else if (key.contains("policyRefresh")) {
                key = "Policy Refresh Frequency (In Hours)";
            } else if (key.contains("shareEnabled")) {
                key = "Share";
            } else if (key.contains("highSecureShareEnabled")) {
                key = "Highly Secure Share";
            } else if (key.contains("complexPassword")) {
                key = "Complex Password";
            } else if (key.contains("allowDownload")) {
                key = "Allow Download";
            } else if (key.contains("shareExpireDateEnable")) {
                key = "Share Expiry Date Required";
            } else if (key.contains("filterInclusionName")) {
                key = "Filters";
            } else if (key.contains("backupSystemFilesEnabled")) {
                key = "Include System Folders";
            } else if (key.contains("canUserChangePassword")) {
                key = "Allow User To Change Password";
            } else if (key.contains("canAdminChangeUserPassword")) {
                key = "Allow Admin To Change User Password";
            } else if (key.contains("canBackupHiddenFiles")) {
                key = "Skip Hidden Files To Be BackedUp";
            } else if (key.contains("cpuThrottling")) {
                key = "CPU Throttling";
            } else if (!(key.contains("Preferred Blukrypt Hostnames") || key.contains("Schedules") || key.contains("Default Folders") || key.contains("Excluded Folders") || key.contains("Network Throttle Setting from Client to BluKrypt (In Mbps)") || key.contains("UI Settings For Agent") || key.contains("Per Device Backup Storage Limit (In GB)") || key.contains("Purge deleted files from the catalogue after") || key.contains("Maximum Permissible File Size (In MB)") || key.contains("Maximum number of Versions Allowed") || key.contains("Email Alert Configurations"))) {
                key = "";
            }
            if (StringUtils.isEmpty((Object)key)) continue;
            fieldChanges.get(string);
            fieldChangesResponse.append(" (");
            fieldChangesResponse.append(key);
            fieldChangesResponse.append(" values ");
            fieldChangesResponse.append((String)fieldChanges.get(string));
            fieldChangesResponse.append(")");
            if (key.length() <= 1) continue;
            fieldChangesResponse.append(", ");
        }
        if (!existingBackupPolicyElement.getEndpointUiPreferences().equals(backupPolicyElement.getEndpointUiPreferences())) {
            fieldChangesResponse.append(" ( UI Settings For Agent ");
            fieldChangesResponse.append(" Values : [ ");
            String oldValue = "Enabled";
            String string = "Enabled";
            keys = new ArrayList();
            keys.add("Exit");
            keys.add("Decouple");
            keys.add("Support");
            keys.add("Initiate Backup");
            keys.add("Restore");
            keys.add("Stop Backup");
            keys.add("Backup Settings");
            keys.add("Backup Files");
            keys.add("Refresh Backup Policy");
            keys.add("Pause Backup");
            List<String> existingEndpointUiValue = existingBackupPolicyElement.getEndpointUiPreferences();
            List<String> endpointUiValue = backupPolicyElement.getEndpointUiPreferences();
            HashMap oldValueMap = new HashMap();
            HashMap<void, void> hashMap = new HashMap<void, void>();
            if (!StringUtils.isEmpty(existingEndpointUiValue)) {
                String string2 = "";
                for (String string3 : existingEndpointUiValue) {
                    void var14_42;
                    if (string3.contains("EXIT")) {
                        String string4 = "Exit";
                    } else if (string3.contains("DECOUPLE")) {
                        String string5 = "Decouple";
                    } else if (string3.contains("SUPPORT")) {
                        String string6 = "Support";
                    } else if (string3.contains("INTIATE_BACKUP")) {
                        String string7 = "Initiate Backup";
                    } else if (string3.contains("RESTORE")) {
                        String string8 = "Restore";
                    } else if (string3.contains("STOP_BACKUP")) {
                        String string9 = "Stop Backup";
                    } else if (string3.contains("BACKUP_SETTINGS")) {
                        String string10 = "Backup Settings";
                    } else if (string3.contains("BACKUP_FILES")) {
                        String string11 = "Backup Files";
                    } else if (string3.contains("REFRESH_BACKUP_POLICY")) {
                        String string12 = "Refresh Backup Policy";
                    } else if (string3.contains("PAUSE_BACKUP")) {
                        String string13 = "Pause Backup";
                    } else {
                        oldValue = "Disabled";
                    }
                    oldValueMap.put(var14_42, oldValue);
                }
            }
            if (!StringUtils.isEmpty(endpointUiValue)) {
                String string14 = "";
                for (String string15 : endpointUiValue) {
                    void var8_12;
                    void var14_55;
                    if (string15.contains("EXIT")) {
                        String string16 = "Exit";
                    } else if (string15.contains("DECOUPLE")) {
                        String string17 = "Decouple";
                    } else if (string15.contains("SUPPORT")) {
                        String string18 = "Support";
                    } else if (string15.contains("INTIATE_BACKUP")) {
                        String string19 = "Initiate Backup";
                    } else if (string15.contains("RESTORE")) {
                        String string20 = "Restore";
                    } else if (string15.contains("STOP_BACKUP")) {
                        String string21 = "Stop Backup";
                    } else if (string15.contains("BACKUP_SETTINGS")) {
                        String string22 = "Backup Settings";
                    } else if (string15.contains("BACKUP_FILES")) {
                        String string23 = "Backup Files";
                    } else if (string15.contains("REFRESH_BACKUP_POLICY")) {
                        String string24 = "Refresh Backup Policy";
                    } else if (string15.contains("PAUSE_BACKUP")) {
                        String string25 = "Pause Backup";
                    } else {
                        String string26 = "Disabled";
                    }
                    hashMap.put(var14_55, var8_12);
                }
            }
            boolean bl = false;
            for (String string27 : keys) {
                void var14_68;
                ++var14_68;
                fieldChangesResponse.append("\"" + string27 + "\" : ");
                if (oldValueMap.containsKey(string27)) {
                    fieldChangesResponse.append("\"" + (String)oldValueMap.get(string27));
                } else {
                    fieldChangesResponse.append("\"Disabled");
                }
                if (hashMap.containsKey(string27)) {
                    fieldChangesResponse.append("\" => \"" + (String)hashMap.get(string27));
                } else {
                    fieldChangesResponse.append("\" => \"Disabled");
                }
                if (string27.length() <= 0 || var14_68 >= string27.length()) continue;
                fieldChangesResponse.append(", ");
            }
            if (fieldChangesResponse.length() > 0) {
                fieldChangesResponse.replace(fieldChangesResponse.length() - 2, fieldChangesResponse.length(), "");
            }
            fieldChangesResponse.append("\" ] ) ");
        } else if (fieldChangesResponse.length() > 0) {
            fieldChangesResponse.replace(fieldChangesResponse.length() - 1, fieldChangesResponse.length(), " ");
        }
        if (!existingBackupPolicyElement.getMenuOptions().equals(backupPolicyElement.getMenuOptions())) {
            fieldChangesResponse.append(" ( My files user action preferences ");
            fieldChangesResponse.append(" Values : [ ");
            ArrayList<String> keys2 = new ArrayList<String>();
            Map<String, Boolean> map = existingBackupPolicyElement.getMenuOptions();
            Map<String, Boolean> menuOptionsValue = backupPolicyElement.getMenuOptions();
            HashMap<void, String> oldValueMap = new HashMap<void, String>();
            HashMap<void, String> newValueMap = new HashMap<void, String>();
            if (!StringUtils.isEmpty(map)) {
                for (String string : map.keySet()) {
                    void var14_79;
                    String string28 = "";
                    if (string.contains("open") && Boolean.compare(map.get(string), menuOptionsValue.get(string) == false) == 0) {
                        String string29 = "Open";
                        keys2.add(string29);
                    } else if (string.contains("delete") && Boolean.compare(map.get(string), menuOptionsValue.get(string) == false) == 0) {
                        String string30 = "Delete";
                        keys2.add(string30);
                    } else if (string.contains("view") && Boolean.compare(map.get(string), menuOptionsValue.get(string) == false) == 0) {
                        String string31 = "View";
                        keys2.add(string31);
                    } else if (string.contains("initiateRestore") && Boolean.compare(map.get(string), menuOptionsValue.get(string) == false) == 0) {
                        String string32 = "Initiate Restore";
                        keys2.add(string32);
                    } else if (string.contains("versions") && Boolean.compare(map.get(string), menuOptionsValue.get(string) == false) == 0) {
                        String string33 = "Versions";
                        keys2.add(string33);
                    } else if (string.contains("addToRestore") && Boolean.compare(map.get(string), menuOptionsValue.get(string) == false) == 0) {
                        String string34 = "Add To Restore";
                        keys2.add(string34);
                    } else if (string.contains("share") && Boolean.compare(map.get(string), menuOptionsValue.get(string) == false) == 0) {
                        String string35 = "Share";
                        keys2.add(string35);
                    } else if (string.contains("addAllVersionsToRestore") && Boolean.compare(map.get(string), menuOptionsValue.get(string) == false) == 0) {
                        String string36 = "Add All Versions To Restore";
                        keys2.add(string36);
                    } else if (string.contains("download") && Boolean.compare(map.get(string), menuOptionsValue.get(string) == false) == 0) {
                        String string37 = "Download";
                        keys2.add(string37);
                    }
                    oldValueMap.put(var14_79, map.get(string) == true ? "Enabled" : "Disabled");
                    newValueMap.put(var14_79, menuOptionsValue.get(string) == true ? "Enabled" : "Disabled");
                }
            }
            int i = 0;
            for (String string : keys2) {
                ++i;
                fieldChangesResponse.append("\"" + string + "\" : ");
                if (oldValueMap.containsKey(string)) {
                    fieldChangesResponse.append("\"" + (String)oldValueMap.get(string));
                } else {
                    fieldChangesResponse.append("\"Disabled");
                }
                if (newValueMap.containsKey(string)) {
                    fieldChangesResponse.append("\" => \"" + (String)newValueMap.get(string) + "\"");
                } else {
                    fieldChangesResponse.append("\" => \"Disabled");
                }
                if (string.length() <= 0 || i >= string.length()) continue;
                fieldChangesResponse.append(", ");
            }
            if (fieldChangesResponse.length() > 0) {
                fieldChangesResponse.replace(fieldChangesResponse.length() - 2, fieldChangesResponse.length(), "");
            }
            fieldChangesResponse.append("] ) ");
        } else if (fieldChangesResponse.length() > 0) {
            fieldChangesResponse.replace(fieldChangesResponse.length() - 1, fieldChangesResponse.length(), " ");
        }
        if (!existingBackupPolicyElement.getEmailsRestriction().equals(backupPolicyElement.getEmailsRestriction())) {
            Map<String, String> existingEmailsRestriction = existingBackupPolicyElement.getEmailsRestriction();
            Map<String, String> map = backupPolicyElement.getEmailsRestriction();
            ArrayList<String> emailKeys = new ArrayList<String>();
            fieldChangesResponse.append(" ( Email Alert Configurations ");
            fieldChangesResponse.append(" Values : [ ");
            emailKeys.add("createUser");
            emailKeys.add("userDeleted");
            emailKeys.add("userBlocked");
            emailKeys.add("deviceDeleted");
            emailKeys.add("deviceBlocked");
            emailKeys.add("deviceDecoupled");
            emailKeys.add("weeklyBkpreport");
            emailKeys.add("firstBkpCompleted");
            emailKeys.add("restoreInitiated");
            emailKeys.add("storageLimitReached");
            HashMap<String, String> oldValues = new HashMap<String, String>();
            HashMap<String, String> newValues = new HashMap<String, String>();
            if (!existingEmailsRestriction.isEmpty()) {
                for (String string : emailKeys) {
                    ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(existingEmailsRestriction.get(string).split(",")));
                    if (string.equalsIgnoreCase("createUser")) {
                        if (!StringUtils.isEmpty(oldValues.get(string))) {
                            if (arrayList.contains("users")) {
                                oldValues.put("User create", "Enabled");
                            } else {
                                oldValues.put("User create", "Disabled");
                            }
                        } else {
                            oldValues.put("User create", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("userDeleted")) {
                        if (!StringUtils.isEmpty((Object)existingEmailsRestriction.get(string))) {
                            if (arrayList.contains("users")) {
                                oldValues.put("User deleted", "Enabled");
                            } else {
                                oldValues.put("User deleted", "Disabled");
                            }
                        } else {
                            oldValues.put("User deleted", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("userBlocked")) {
                        if (!StringUtils.isEmpty((Object)existingEmailsRestriction.get(string))) {
                            if (arrayList.contains("users")) {
                                oldValues.put("User blocked", "Enabled");
                            } else {
                                oldValues.put("User blocked", "Disabled");
                            }
                        } else {
                            oldValues.put("User blocked", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("deviceDeleted")) {
                        if (!StringUtils.isEmpty((Object)existingEmailsRestriction.get(string))) {
                            if (arrayList.contains("users")) {
                                oldValues.put("Device deleted", "Enabled");
                            } else {
                                oldValues.put("Device deleted", "Disabled");
                            }
                        } else {
                            oldValues.put("Device deleted", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("deviceBlocked")) {
                        if (!StringUtils.isEmpty((Object)existingEmailsRestriction.get(string))) {
                            if (arrayList.contains("users")) {
                                oldValues.put("Device blocked", "Enabled");
                            } else {
                                oldValues.put("Device blocked", "Disabled");
                            }
                        } else {
                            oldValues.put("Device blocked", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("deviceDecoupled")) {
                        if (!StringUtils.isEmpty((Object)existingEmailsRestriction.get(string))) {
                            if (arrayList.contains("users")) {
                                oldValues.put("Device de-couple", "Enabled");
                            } else {
                                oldValues.put("Device de-couple", "Disabled");
                            }
                        } else {
                            oldValues.put("Device de-couple", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("weeklyBkpreport")) {
                        if (!StringUtils.isEmpty((Object)existingEmailsRestriction.get(string))) {
                            if (arrayList.contains("users")) {
                                oldValues.put("Weekly backup report", "Enabled");
                            } else {
                                oldValues.put("Weekly backup report", "Disabled");
                            }
                        } else {
                            oldValues.put("Weekly backup report", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("firstBkpCompleted")) {
                        if (!StringUtils.isEmpty((Object)existingEmailsRestriction.get(string))) {
                            if (arrayList.contains("users")) {
                                oldValues.put("First backup completed", "Enabled");
                            } else {
                                oldValues.put("First backup completed", "Disabled");
                            }
                        } else {
                            oldValues.put("First backup completed", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("restoreInitiated")) {
                        if (!StringUtils.isEmpty((Object)existingEmailsRestriction.get(string))) {
                            if (arrayList.contains("users")) {
                                oldValues.put("Restore initiated", "Enabled");
                            } else {
                                oldValues.put("Restore initiated", "Disabled");
                            }
                        } else {
                            oldValues.put("Restore initiated", "Disabled");
                        }
                    }
                    if (!string.equalsIgnoreCase("storageLimitReached")) continue;
                    if (!StringUtils.isEmpty((Object)existingEmailsRestriction.get(string))) {
                        if (arrayList.contains("users")) {
                            oldValues.put("Storage limit reached", "Enabled");
                            continue;
                        }
                        oldValues.put("Storage limit reached", "Disabled");
                        continue;
                    }
                    oldValues.put("Storage limit reached", "Disabled");
                }
            }
            if (!map.isEmpty()) {
                for (String string : emailKeys) {
                    ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(map.get(string).split(",")));
                    if (string.equalsIgnoreCase("createUser")) {
                        if (!StringUtils.isEmpty((Object)map.get(string))) {
                            if (arrayList.contains("users")) {
                                newValues.put("User create", "Enabled");
                            } else {
                                newValues.put("User create", "Disabled");
                            }
                        } else {
                            newValues.put("User create", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("userDeleted")) {
                        if (!StringUtils.isEmpty((Object)map.get(string))) {
                            if (arrayList.contains("users")) {
                                newValues.put("User deleted", "Enabled");
                            } else {
                                newValues.put("User deleted", "Disabled");
                            }
                        } else {
                            newValues.put("User deleted", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("userBlocked")) {
                        if (!StringUtils.isEmpty((Object)map.get(string))) {
                            if (arrayList.contains("users")) {
                                newValues.put("User blocked", "Enabled");
                            } else {
                                newValues.put("User blocked", "Disabled");
                            }
                        } else {
                            newValues.put("User blocked", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("deviceDeleted")) {
                        if (!StringUtils.isEmpty((Object)map.get(string))) {
                            if (arrayList.contains("users")) {
                                newValues.put("Device deleted", "Enabled");
                            } else {
                                newValues.put("Device deleted", "Disabled");
                            }
                        } else {
                            newValues.put("Device deleted", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("deviceBlocked")) {
                        if (!StringUtils.isEmpty((Object)map.get(string))) {
                            if (arrayList.contains("users")) {
                                newValues.put("Device blocked", "Enabled");
                            } else {
                                newValues.put("Device blocked", "Disabled");
                            }
                        } else {
                            newValues.put("Device blocked", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("deviceDecoupled")) {
                        if (!StringUtils.isEmpty((Object)map.get(string))) {
                            if (arrayList.contains("users")) {
                                newValues.put("Device de-couple", "Enabled");
                            } else {
                                newValues.put("Device de-couple", "Disabled");
                            }
                        } else {
                            newValues.put("Device de-couple", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("weeklyBkpreport")) {
                        if (!StringUtils.isEmpty((Object)map.get(string))) {
                            if (arrayList.contains("users")) {
                                newValues.put("Weekly backup report", "Enabled");
                            } else {
                                newValues.put("Weekly backup report", "Disabled");
                            }
                        } else {
                            newValues.put("Weekly backup report", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("firstBkpCompleted")) {
                        if (!StringUtils.isEmpty((Object)map.get(string))) {
                            if (arrayList.contains("users")) {
                                newValues.put("First backup completed", "Enabled");
                            } else {
                                newValues.put("First backup completed", "Disabled");
                            }
                        } else {
                            newValues.put("First backup completed", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("restoreInitiated")) {
                        if (!StringUtils.isEmpty((Object)map.get(string))) {
                            if (arrayList.contains("users")) {
                                newValues.put("Restore initiated", "Enabled");
                            } else {
                                newValues.put("Restore initiated", "Disabled");
                            }
                        } else {
                            newValues.put("Restore initiated", "Disabled");
                        }
                    }
                    if (!string.equalsIgnoreCase("storageLimitReached")) continue;
                    if (!StringUtils.isEmpty((Object)map.get(string))) {
                        if (arrayList.contains("users")) {
                            newValues.put("Storage limit reached", "Enabled");
                            continue;
                        }
                        newValues.put("Storage limit reached", "Disabled");
                        continue;
                    }
                    newValues.put("Storage limit reached", "Disabled");
                }
            }
            for (String string : oldValues.keySet()) {
                fieldChangesResponse.append("\"" + string + "\" : \"" + (String)oldValues.get(string) + "\"");
                fieldChangesResponse.append("\" => \"" + (String)newValues.get(string));
                fieldChangesResponse.append(", ");
            }
            if (fieldChangesResponse.length() > 0) {
                fieldChangesResponse.replace(fieldChangesResponse.length() - 2, fieldChangesResponse.length(), "");
            }
            fieldChangesResponse.append("\" ] ) ");
        } else if (fieldChangesResponse.length() > 0) {
            fieldChangesResponse.replace(fieldChangesResponse.length() - 1, fieldChangesResponse.length(), " ");
        }
        return fieldChangesResponse.toString();
    }
}

