/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.helper.utils;

import com.parablu.helper.utils.ObjectDiffFinder;
import com.parablu.paracloud.element.BackupPolicyElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.CollectionUtils;

public class BackupPolicyDiffFinder {
    private static Logger logger = LogManager.getLogger(BackupPolicyDiffFinder.class);

    /*
     * WARNING - void declaration
     */
    public String findDiff(BackupPolicyElement existingBackupPolicyElement, BackupPolicyElement backupPolicyElement) {
        Collection<Object> keys;
        if (!backupPolicyElement.isPftEnabled()) {
            backupPolicyElement.setPftSize(existingBackupPolicyElement.getPftSize());
            backupPolicyElement.setFileChunkableSize(existingBackupPolicyElement.getFileChunkableSize());
        }
        StringBuilder fieldChangesResponse = new StringBuilder();
        ObjectDiffFinder objectDiffFinder = new ObjectDiffFinder();
        objectDiffFinder.finder(existingBackupPolicyElement, backupPolicyElement);
        objectDiffFinder.visiter(objectDiffFinder);
        ArrayList<Map<String, Object>> changes = new ArrayList<Map<String, Object>>(objectDiffFinder.changes);
        HashMap<String, String> fieldChanges = new HashMap<String, String>();
        for (Map map : changes) {
            keys = map.keySet();
            String propertyName = "";
            String newValue = "";
            String oldValue = "";
            for (String string : keys) {
                if (!org.springframework.util.StringUtils.isEmpty(map.get(string)) && string.contains("newValue")) {
                    newValue = map.get(string).toString();
                }
                if (string.contains("propertyName")) {
                    propertyName = map.get(string).toString();
                }
                if (org.springframework.util.StringUtils.isEmpty(map.get(string)) || !string.contains("oldValue")) continue;
                oldValue = map.get(string).toString();
            }
            if (org.springframework.util.StringUtils.isEmpty((Object)propertyName) || propertyName.contains("lastModifiedTimestamp")) continue;
            fieldChanges.put(propertyName, "\"" + oldValue + "\" => \"" + newValue + "\"");
        }
        if (!existingBackupPolicyElement.getPrivacyGatewayMappingElement().getPrivacyGatewayNames().equals(backupPolicyElement.getPrivacyGatewayMappingElement().getPrivacyGatewayNames())) {
            fieldChanges.put("Preferred Blukrypt Hostnames", " \"" + existingBackupPolicyElement.getPrivacyGatewayMappingElement().getPrivacyGatewayNames().toString() + "\" => \"" + backupPolicyElement.getPrivacyGatewayMappingElement().getPrivacyGatewayNames().toString() + "\"");
        }
        if (!org.springframework.util.StringUtils.isEmpty(existingBackupPolicyElement.getScheduleNames())) {
            Collections.sort(existingBackupPolicyElement.getScheduleNames());
        }
        if (!org.springframework.util.StringUtils.isEmpty(backupPolicyElement.getScheduleNames())) {
            Collections.sort(backupPolicyElement.getScheduleNames());
        }
        if (!existingBackupPolicyElement.getScheduleNames().equals(backupPolicyElement.getScheduleNames())) {
            fieldChanges.put("Schedules", " \"" + existingBackupPolicyElement.getScheduleNames() + "\" => \"" + backupPolicyElement.getScheduleNames() + "\"");
        }
        if (!existingBackupPolicyElement.getBackupFolderPaths().equals(backupPolicyElement.getBackupFolderPaths())) {
            fieldChanges.put("Default Folders", " \"" + existingBackupPolicyElement.getBackupFolderPaths() + "\" => \"" + backupPolicyElement.getBackupFolderPaths() + "\"");
        }
        if (!CollectionUtils.isEmpty(existingBackupPolicyElement.getExcludedFolderpaths()) && !existingBackupPolicyElement.getExcludedFolderpaths().equals(backupPolicyElement.getExcludedFolderpaths())) {
            fieldChanges.put("Excluded Folders", " \"" + existingBackupPolicyElement.getExcludedFolderpaths() + "\" => \"" + backupPolicyElement.getExcludedFolderpaths() + "\"");
        }
        if (!existingBackupPolicyElement.getExceptionsToExclusions().equals(backupPolicyElement.getExceptionsToExclusions())) {
            fieldChanges.put("Exceptions to exclusions", " \"" + existingBackupPolicyElement.getExceptionsToExclusions() + "\" => \"" + backupPolicyElement.getExceptionsToExclusions() + "\"");
        }
        if (!existingBackupPolicyElement.getSqlBackupFolders().equals(backupPolicyElement.getSqlBackupFolders())) {
            fieldChanges.put("SQL Folders", " \"" + existingBackupPolicyElement.getSqlBackupFolders() + "\" => \"" + backupPolicyElement.getSqlBackupFolders() + "\"");
        }
        if (!String.valueOf(existingBackupPolicyElement.getNwFromClientToPGMB()).equals(String.valueOf(backupPolicyElement.getNwFromClientToPGMB()))) {
            if (String.valueOf(existingBackupPolicyElement.getNwFromClientToPGMB()).toString().contains("10000")) {
                fieldChanges.put("Network Throttle Setting from Client to BluKrypt (In Mbps)", " \"UNLIMITED\" => \"" + backupPolicyElement.getNwFromClientToPGMB() + "\"");
            } else if (String.valueOf(backupPolicyElement.getNwFromClientToPGMB()).toString().contains("10000")) {
                fieldChanges.put("Network Throttle Setting from Client to BluKrypt (In Mbps)", " \"" + existingBackupPolicyElement.getNwFromClientToPGMB() + "\" => \"UNLIMITED\"");
            } else {
                fieldChanges.put("Network Throttle Setting from Client to BluKrypt (In Mbps)", " \"" + existingBackupPolicyElement.getNwFromClientToPGMB() + "\" => \"" + backupPolicyElement.getNwFromClientToPGMB() + "\"");
            }
        }
        if (existingBackupPolicyElement.getUserSizeAllowed() != backupPolicyElement.getUserSizeAllowed()) {
            if (existingBackupPolicyElement.getUserSizeAllowed() == 102400) {
                fieldChanges.put("Per Device Backup Storage Limit (In GB)", " \"UNLIMITED\" => \"" + backupPolicyElement.getUserSizeAllowed() + "\"");
            } else if (backupPolicyElement.getUserSizeAllowed() == 102400) {
                fieldChanges.put("Per Device Backup Storage Limit (In GB)", " \"" + existingBackupPolicyElement.getUserSizeAllowed() + "\" => \"UNLIMITED\"");
            } else {
                fieldChanges.put("Per Device Backup Storage Limit (In GB)", " \"" + existingBackupPolicyElement.getUserSizeAllowed() + "\" => \"" + backupPolicyElement.getUserSizeAllowed() + "\"");
            }
        }
        if (existingBackupPolicyElement.getPolicyStorageSizeAllowed() != backupPolicyElement.getPolicyStorageSizeAllowed()) {
            fieldChanges.put("Maximum Backup Size(GB)", " \"" + existingBackupPolicyElement.getPolicyStorageSizeAllowed() + "\" => \"" + backupPolicyElement.getPolicyStorageSizeAllowed() + "\"");
        }
        if (existingBackupPolicyElement.getPolicyUsersAllowed() != backupPolicyElement.getPolicyUsersAllowed()) {
            fieldChanges.put("Number of Users Allowed", " \"" + existingBackupPolicyElement.getPolicyUsersAllowed() + "\" => \"" + backupPolicyElement.getPolicyUsersAllowed() + "\"");
        }
        if (existingBackupPolicyElement.getNoOfDaysToKeepDeletedFiles() != backupPolicyElement.getNoOfDaysToKeepDeletedFiles()) {
            if (existingBackupPolicyElement.getNoOfDaysToKeepDeletedFiles() == -1L) {
                fieldChanges.put("Purge deleted files from the catalogue after", " \"UNLIMITED\" => \"" + backupPolicyElement.getNoOfDaysToKeepDeletedFiles() + "\"");
            } else if (backupPolicyElement.getNoOfDaysToKeepDeletedFiles() == -1L) {
                fieldChanges.put("Purge deleted files from the catalogue after", " \"" + existingBackupPolicyElement.getNoOfDaysToKeepDeletedFiles() + "\" => \"UNLIMITED\"");
            } else {
                fieldChanges.put("Purge deleted files from the catalogue after", " \"" + existingBackupPolicyElement.getNoOfDaysToKeepDeletedFiles() + "\" => \"" + backupPolicyElement.getNoOfDaysToKeepDeletedFiles() + "\"");
            }
        }
        logger.debug("....existingBackupPolicyElement...." + existingBackupPolicyElement.getNoOfDaysToKeepDeviceNotHeard());
        logger.debug("....backupPolicyElement...." + backupPolicyElement.getNoOfDaysToKeepDeviceNotHeard());
        if (existingBackupPolicyElement.getNoOfDaysToKeepDeviceNotHeard() != backupPolicyElement.getNoOfDaysToKeepDeviceNotHeard()) {
            if (existingBackupPolicyElement.getNoOfDaysToKeepDeviceNotHeard() == -1L) {
                fieldChanges.put("Number Days to keep device not heard", " \"UNLIMITED\" => \"" + backupPolicyElement.getNoOfDaysToKeepDeviceNotHeard() + "\"");
            } else if (backupPolicyElement.getNoOfDaysToKeepDeviceNotHeard() == -1L) {
                fieldChanges.put("Number Days to keep device not heard", " \"" + existingBackupPolicyElement.getNoOfDaysToKeepDeviceNotHeard() + "\" => \"UNLIMITED\"");
            } else {
                fieldChanges.put("Number Days to keep device not heard", " \"" + existingBackupPolicyElement.getNoOfDaysToKeepDeviceNotHeard() + "\" => \"" + backupPolicyElement.getNoOfDaysToKeepDeviceNotHeard() + "\"");
            }
        }
        if (!existingBackupPolicyElement.getMaxFileSize().equals(backupPolicyElement.getMaxFileSize())) {
            if (existingBackupPolicyElement.getMaxFileSize().toString().equals("1048576")) {
                fieldChanges.put("Maximum Permissible File Size (In MB)", " \"UNLIMITED\" => \"" + backupPolicyElement.getMaxFileSize() + "\"");
            } else if (backupPolicyElement.getMaxFileSize().toString().equals("1048576")) {
                fieldChanges.put("Maximum Permissible File Size (In MB)", " \"" + existingBackupPolicyElement.getMaxFileSize() + "\" => \"UNLIMITED\"");
            } else {
                fieldChanges.put("Maximum Permissible File Size (In MB)", " \"" + existingBackupPolicyElement.getMaxFileSize() + "\" => \"" + backupPolicyElement.getMaxFileSize() + "\"");
            }
        }
        if (existingBackupPolicyElement.getMaxVersions() != backupPolicyElement.getMaxVersions()) {
            if (existingBackupPolicyElement.getMaxVersions() == -1) {
                fieldChanges.put("Maximum number of Versions Allowed", " \"UNLIMITED\" => \"" + backupPolicyElement.getMaxVersions() + "\"");
            } else if (backupPolicyElement.getMaxVersions() == -1) {
                fieldChanges.put("Maximum number of Versions Allowed", " \"" + existingBackupPolicyElement.getMaxVersions() + "\" => \"UNLIMITED\"");
            } else {
                fieldChanges.put("Maximum number of Versions Allowed", " \"" + existingBackupPolicyElement.getMaxVersions() + "\" => \"" + backupPolicyElement.getMaxVersions() + "\"");
            }
        }
        if (existingBackupPolicyElement.getNoOfDevicesAllowed() != backupPolicyElement.getNoOfDevicesAllowed()) {
            if (existingBackupPolicyElement.getNoOfDevicesAllowed() == -1) {
                fieldChanges.put("Maximum number of Devices Allowed", " \"UNLIMITED\" => \"" + backupPolicyElement.getNoOfDevicesAllowed() + "\"");
            } else if (backupPolicyElement.getNoOfDevicesAllowed() == -1) {
                fieldChanges.put("Maximum number of Devices Allowed", " \"" + existingBackupPolicyElement.getNoOfDevicesAllowed() + "\" => \"UNLIMITED\"");
            } else {
                fieldChanges.put("Maximum number of Devices Allowed", " \"" + existingBackupPolicyElement.getNoOfDevicesAllowed() + "\" => \"" + backupPolicyElement.getNoOfDevicesAllowed() + "\"");
            }
        }
        if (StringUtils.isNotEmpty((String)existingBackupPolicyElement.getDescription()) && !existingBackupPolicyElement.getDescription().equals(backupPolicyElement.getDescription())) {
            fieldChanges.put("Policy Description", " \"" + existingBackupPolicyElement.getDescription() + "\" => \"" + backupPolicyElement.getDescription() + "\"");
        }
        if (!existingBackupPolicyElement.getFilterInclusionName().equals(backupPolicyElement.getFilterInclusionName())) {
            fieldChanges.put("Filters", " \"" + existingBackupPolicyElement.getFilterInclusionName() + "\" => \"" + backupPolicyElement.getFilterInclusionName() + "\"");
        }
        if (!existingBackupPolicyElement.getFilterType().equals(backupPolicyElement.getFilterType())) {
            fieldChanges.put("Filter type", " \"" + existingBackupPolicyElement.getFilterType() + "\" => \"" + backupPolicyElement.getFilterType() + "\"");
        }
        if (existingBackupPolicyElement.isCanAdminRestore() != backupPolicyElement.isCanAdminRestore()) {
            logger.debug("..............inide audit history............");
            fieldChanges.put("Allow Administrator to view and restore data", " \"" + existingBackupPolicyElement.isCanAdminRestore() + "\" => \"" + backupPolicyElement.isCanAdminRestore() + "\"");
        }
        if (existingBackupPolicyElement.isCanAdminDelete() != backupPolicyElement.isCanAdminDelete()) {
            fieldChanges.put("Can Administrator Delete User Data", " \"" + existingBackupPolicyElement.isCanAdminDelete() + "\" => \"" + backupPolicyElement.isCanAdminDelete() + "\"");
        }
        if (existingBackupPolicyElement.isSwitchAgentPassword() != backupPolicyElement.isSwitchAgentPassword()) {
            fieldChanges.put("Agent uninstallation password", " \"" + existingBackupPolicyElement.isSwitchAgentPassword() + "\" => \"" + backupPolicyElement.isSwitchAgentPassword() + "\"");
        }
        if (existingBackupPolicyElement.isPreScanCommandEnabled() != backupPolicyElement.isPreScanCommandEnabled()) {
            fieldChanges.put("Enable Pre Scan Command", " \"" + existingBackupPolicyElement.isPreScanCommandEnabled() + "\" => \"" + backupPolicyElement.isPreScanCommandEnabled() + "\"");
        }
        if (existingBackupPolicyElement.isPreBackupCommandEnabled() != backupPolicyElement.isPreBackupCommandEnabled()) {
            fieldChanges.put("Enable Pre Backup Command", " \"" + existingBackupPolicyElement.isPreBackupCommandEnabled() + "\" => \"" + backupPolicyElement.isPreBackupCommandEnabled() + "\"");
        }
        if (existingBackupPolicyElement.isPostBackupCommandEnabled() != backupPolicyElement.isPostBackupCommandEnabled()) {
            fieldChanges.put("Enable Post Backup Command", " \"" + existingBackupPolicyElement.isPostBackupCommandEnabled() + "\" => \"" + backupPolicyElement.isPostBackupCommandEnabled() + "\"");
        }
        if (!existingBackupPolicyElement.getPreScanCommand().equals(backupPolicyElement.getPreScanCommand())) {
            fieldChanges.put("Pre Scan Command path", " \"" + existingBackupPolicyElement.getPreScanCommand() + "\" => \"" + backupPolicyElement.getPreScanCommand() + "\"");
        }
        if (!existingBackupPolicyElement.getPreBackupCommand().equals(backupPolicyElement.getPreBackupCommand())) {
            fieldChanges.put("Pre Backup Command path", " \"" + existingBackupPolicyElement.getPreBackupCommand() + "\" => \"" + backupPolicyElement.getPreBackupCommand() + "\"");
        }
        if (!existingBackupPolicyElement.getPostBackupCommand().equals(backupPolicyElement.getPostBackupCommand())) {
            fieldChanges.put("Post Backup Command path", " \"" + existingBackupPolicyElement.getPostBackupCommand() + "\" => \"" + backupPolicyElement.getPostBackupCommand() + "\"");
        }
        if (existingBackupPolicyElement.isContinueOnPostBkp() != backupPolicyElement.isContinueOnPostBkp()) {
            fieldChanges.put("Continue backup on post backup command-failure", " \"" + existingBackupPolicyElement.isContinueOnPostBkp() + "\" => \"" + backupPolicyElement.isContinueOnPostBkp() + "\"");
        }
        if (existingBackupPolicyElement.isContinueOnPreScan() != backupPolicyElement.isContinueOnPreScan()) {
            fieldChanges.put("Continue backup on pre scan command-failure", " \"" + existingBackupPolicyElement.isContinueOnPreScan() + "\" => \"" + backupPolicyElement.isContinueOnPreScan() + "\"");
        }
        if (existingBackupPolicyElement.isContinueOnPreBkp() != backupPolicyElement.isContinueOnPreBkp()) {
            fieldChanges.put("Continue backup on pre backup command-failure", " \"" + existingBackupPolicyElement.isContinueOnPreBkp() + "\" => \"" + backupPolicyElement.isContinueOnPreBkp() + "\"");
        }
        if (existingBackupPolicyElement.isAllowEndUserTocontrolRestore() != backupPolicyElement.isAllowEndUserTocontrolRestore()) {
            fieldChanges.put("Allow end-user over-ride view and restore data", " \"" + existingBackupPolicyElement.isAllowEndUserTocontrolRestore() + "\" => \"" + backupPolicyElement.isAllowEndUserTocontrolRestore() + "\"");
        }
        logger.debug(existingBackupPolicyElement.getShareDomainIncExclusions() + "..............getShareDomainIncExclusions..........." + backupPolicyElement.getShareDomainIncExclusions());
        if (!(CollectionUtils.isEmpty(existingBackupPolicyElement.getShareDomainIncExclusions()) || CollectionUtils.isEmpty(backupPolicyElement.getShareDomainIncExclusions()) || existingBackupPolicyElement.getShareDomainIncExclusions().equals(backupPolicyElement.getShareDomainIncExclusions()))) {
            fieldChanges.put("Share Domain Inclusions/Exclusions", " \"" + existingBackupPolicyElement.getShareDomainIncExclusions() + "\" => \"" + backupPolicyElement.getShareDomainIncExclusions() + "\"");
        }
        if (!(CollectionUtils.isEmpty(existingBackupPolicyElement.getShareDomainIncExclusionsException()) || CollectionUtils.isEmpty(backupPolicyElement.getShareDomainIncExclusionsException()) || existingBackupPolicyElement.getShareDomainIncExclusionsException().equals(backupPolicyElement.getShareDomainIncExclusionsException()))) {
            fieldChanges.put("Share Domain Inclusions/Exclusions Exception", " \"" + existingBackupPolicyElement.getShareDomainIncExclusionsException() + "\" => \"" + backupPolicyElement.getShareDomainIncExclusionsException() + "\"");
        }
        if (!existingBackupPolicyElement.getShareDomainType().equals(backupPolicyElement.getShareDomainType())) {
            fieldChanges.put("Share Domain Type", " \"" + existingBackupPolicyElement.getShareDomainType() + "\" => \"" + backupPolicyElement.getShareDomainType() + "\"");
        }
        if (existingBackupPolicyElement.isShareDomainsEnabled() != backupPolicyElement.isShareDomainsEnabled()) {
            fieldChanges.put("Enable Domain Control", " \"" + existingBackupPolicyElement.isShareDomainsEnabled() + "\" => \"" + backupPolicyElement.isShareDomainsEnabled() + "\"");
        }
        for (String string : fieldChanges.keySet()) {
            String key = string;
            if (key.contains("osType")) {
                key = "Operating System Type";
            } else if (key.contains("ftEnabled")) {
                key = "Partial File Transfer";
            } else if (key.contains("pftSize")) {
                key = "Minimum File Size to Enable Partial File Transfer (In MB)";
            } else if (key.contains("fileChunkableSize")) {
                key = "Partial File Transfer Chunk Size (In MB)";
            } else if (key.contains("legalHoldEnabled")) {
                key = "Enable Legal Hold";
            } else if (key.contains("dedup")) {
                key = "Dedup";
            } else if (key.contains("compressionEnabled")) {
                key = "Enable Compression";
            } else if (key.contains("vssEnabled")) {
                key = "Volume Shadow Service";
            } else if (key.contains("searchAlgoForPg")) {
                key = "Blukrypt Search Algorithm";
            } else if (key.contains("policyRefresh")) {
                key = "Policy Refresh Frequency (In Hours)";
            } else if (key.contains("highSecureShareEnabled")) {
                key = "Highly Secure Share";
            } else if (key.contains("complexPassword")) {
                key = "Complex Password";
            } else if (key.contains("allowDownload")) {
                key = "Allow Download";
            } else if (key.contains("shareExpireDateEnable")) {
                key = "Share Expiry Date Required";
            } else if (key.contains("backupSystemFilesEnabled")) {
                key = "Include System Folders";
            } else if (key.contains("canUserChangePassword")) {
                key = "Allow User To Change Password";
            } else if (key.contains("canAdminChangeUserPassword")) {
                key = "Allow Admin To Change User Password";
            } else if (key.contains("webBasedLogin")) {
                key = "Web based login";
            } else if (key.contains("endpointDomainCheck")) {
                key = "End point Domin check";
            } else if (key.contains("allowedDomains")) {
                key = "Allowed Domains";
            } else if (key.contains("canBackupHiddenFiles")) {
                key = "Backup Hidden Files";
            } else if (key.contains("cpuThrottling")) {
                key = "CPU Throttling";
            } else if (key.contains("downloadAgent")) {
                key = "Enable Download Agent";
            } else if (key.contains("googleAuth")) {
                key = "Google Auth code";
            } else if (key.contains("userConsentEnabled")) {
                key = "User Consent Enabled";
            } else if (key.contains("numberOfThreadsAllowedForBackup")) {
                key = "Number of threads allowed for Backup";
            } else if (key.contains("rwDetectionEnabled")) {
                key = "Ransomware Detection Enabled";
            } else if (key.contains("backupFilesWithoutExtension")) {
                key = " Backup files without an extension";
            } else if (key.contains("applyFilterToExceptionsToExclusion")) {
                key = "Apply Filter To ExceptionsToExclusion";
            } else if (key.contains("autoUpdateAgent")) {
                key = "Agent auto update";
            } else if (key.contains("serverUserName")) {
                key = "SQL Server User Name";
            } else if (!(key.contains("Preferred Blukrypt Hostnames") || key.contains("Schedules") || key.contains("Default Folders") || key.contains("Excluded Folders") || key.contains("Network Throttle Setting from Client to BluKrypt (In Mbps)") || key.contains("UI Settings For Agent") || key.contains("Per Device Backup Storage Limit (In GB)") || key.contains("Maximum Backup Size(GB)") || key.contains("Number of Users Allowed") || key.contains("Purge deleted files from the catalogue after") || key.contains("Maximum Permissible File Size (In MB)") || key.contains("Maximum number of Versions Allowed") || key.contains("Maximum number of Devices Allowed") || key.contains("Number Days to keep device not heard") || key.contains("Email Alert Configurations") || key.contains("Allow Administrator to view and restore data") || key.contains("Allow end-user over-ride view and restore data") || key.contains("Filters") || key.contains("Description") || key.contains("ExceptionsToExclusions") || key.contains("Share Domain Inclusions/Exclusions") || key.contains("Exceptions to exclusions") || key.contains("Policy Description") || key.contains("Share Domain Type") || key.contains("Enable Domain Control") || key.contains("Can Administrator Delete User Data") || key.contains("Agent uninstallation password") || key.contains("Enable Pre Scan Command") || key.contains("Enable Pre Scan Command") || key.contains("Enable Post Backup Command") || key.contains("Pre Scan Command path") || key.contains("Pre Backup Command path") || key.contains("Post Backup Command path") || key.contains("Continue backup on post backup command-failure") || key.contains("Continue backup on pre scan command-failure") || key.contains("Continue backup on pre scan command-failure") || key.contains("Filter type") || key.contains("SQL Folders"))) {
                key = "";
            }
            if (org.springframework.util.StringUtils.isEmpty((Object)key)) continue;
            fieldChanges.get(string);
            fieldChangesResponse.append(" (");
            fieldChangesResponse.append(key);
            fieldChangesResponse.append(" values ");
            fieldChangesResponse.append((String)fieldChanges.get(string));
            fieldChangesResponse.append(")");
            if (key.length() <= 1) continue;
            fieldChangesResponse.append(", ");
        }
        if (!existingBackupPolicyElement.getEndpointUiPreferences().equals(backupPolicyElement.getEndpointUiPreferences())) {
            fieldChangesResponse.append(" ( UI Settings For Agent ");
            fieldChangesResponse.append(" Values : [ ");
            String oldValue = "Enabled";
            String string = "Enabled";
            keys = new ArrayList();
            keys.add("Exit");
            keys.add("Decouple");
            keys.add("Support");
            keys.add("Initiate Backup");
            keys.add("Restore");
            keys.add("Stop Backup");
            keys.add("Backup Settings");
            keys.add("Backup Files");
            keys.add("Refresh Backup Policy");
            keys.add("Pause Backup");
            keys.add("Update Agent");
            keys.add("About");
            keys.add("systray Icon");
            List<String> existingEndpointUiValue = existingBackupPolicyElement.getEndpointUiPreferences();
            List<String> endpointUiValue = backupPolicyElement.getEndpointUiPreferences();
            HashMap oldValueMap = new HashMap();
            HashMap<void, void> hashMap = new HashMap<void, void>();
            if (!org.springframework.util.StringUtils.isEmpty(existingEndpointUiValue)) {
                String string2 = "";
                for (String string3 : existingEndpointUiValue) {
                    void var15_42;
                    logger.debug("......existingendpoint...." + string3);
                    if (string3.contains("EXIT")) {
                        String string4 = "Exit";
                    } else if (string3.contains("DECOUPLE")) {
                        String string5 = "Decouple";
                    } else if (string3.contains("SUPPORT")) {
                        String string6 = "Support";
                    } else if (string3.contains("INTIATE_BACKUP")) {
                        String string7 = "Initiate Backup";
                    } else if (string3.contains("RESTORE")) {
                        String string8 = "Restore";
                    } else if (string3.contains("STOP_BACKUP")) {
                        String string9 = "Stop Backup";
                    } else if (string3.contains("BACKUP_SETTINGS")) {
                        String string10 = "Backup Settings";
                    } else if (string3.contains("BACKUP_FILES")) {
                        String string11 = "Backup Files";
                    } else if (string3.contains("REFRESH_BACKUP_POLICY")) {
                        String string12 = "Refresh Backup Policy";
                    } else if (string3.contains("PAUSE_BACKUP")) {
                        String string13 = "Pause Backup";
                    } else if (string3.contains("UPDATE_AGENT")) {
                        String string14 = "Update Agent";
                    } else if (string3.contains("ABOUT")) {
                        String string15 = "About";
                    } else if (string3.contains("SYSTRAYICON")) {
                        String string16 = "systray Icon";
                    } else {
                        oldValue = "Disabled";
                    }
                    oldValueMap.put(var15_42, oldValue);
                }
            }
            if (!org.springframework.util.StringUtils.isEmpty(endpointUiValue)) {
                String string17 = "";
                for (String string18 : endpointUiValue) {
                    void var9_12;
                    void var15_58;
                    logger.debug("......newendpoint...." + string18);
                    if (string18.contains("EXIT")) {
                        String string19 = "Exit";
                    } else if (string18.contains("DISALLOW_ADMIN_RESTORES")) {
                        String string20 = "Disallow Admin Restores";
                    } else if (string18.contains("DECOUPLE")) {
                        String string21 = "Decouple";
                    } else if (string18.contains("SUPPORT")) {
                        String string22 = "Support";
                    } else if (string18.contains("INTIATE_BACKUP")) {
                        String string23 = "Initiate Backup";
                    } else if (string18.contains("RESTORE")) {
                        String string24 = "Restore";
                    } else if (string18.contains("STOP_BACKUP")) {
                        String string25 = "Stop Backup";
                    } else if (string18.contains("BACKUP_SETTINGS")) {
                        String string26 = "Backup Settings";
                    } else if (string18.contains("BACKUP_FILES")) {
                        String string27 = "Backup Files";
                    } else if (string18.contains("REFRESH_BACKUP_POLICY")) {
                        String string28 = "Refresh Backup Policy";
                    } else if (string18.contains("PAUSE_BACKUP")) {
                        String string29 = "Pause Backup";
                    } else if (string18.contains("UPDATE_AGENT")) {
                        String string30 = "Update Agent";
                    } else if (string18.contains("ABOUT")) {
                        String string31 = "About";
                    } else if (string18.contains("SYSTRAYICON")) {
                        String string32 = "systray Icon";
                    } else {
                        String string33 = "Disabled";
                    }
                    hashMap.put(var15_58, var9_12);
                }
            }
            boolean bl = false;
            for (String string34 : keys) {
                void var15_75;
                ++var15_75;
                fieldChangesResponse.append("\"" + string34 + "\" : ");
                if (oldValueMap.containsKey(string34)) {
                    fieldChangesResponse.append("\"" + (String)oldValueMap.get(string34));
                } else {
                    fieldChangesResponse.append("\"Disabled");
                }
                if (hashMap.containsKey(string34)) {
                    fieldChangesResponse.append("\" => \"" + (String)hashMap.get(string34));
                } else {
                    fieldChangesResponse.append("\" => \"Disabled");
                }
                if (string34.length() <= 0 || var15_75 >= string34.length()) continue;
                fieldChangesResponse.append(", ");
            }
            fieldChangesResponse.append("\" ] ) ");
        } else if (fieldChangesResponse.length() > 0) {
            fieldChangesResponse.replace(fieldChangesResponse.length() - 1, fieldChangesResponse.length(), " ");
        }
        if (!existingBackupPolicyElement.getMenuOptions().equals(backupPolicyElement.getMenuOptions())) {
            fieldChangesResponse.append(" ( My files user action preferences ");
            fieldChangesResponse.append(" Values : [ ");
            ArrayList<String> keys2 = new ArrayList<String>();
            Map<String, Boolean> map = existingBackupPolicyElement.getMenuOptions();
            Map<String, Boolean> menuOptionsValue = backupPolicyElement.getMenuOptions();
            HashMap<void, String> oldValueMap = new HashMap<void, String>();
            HashMap<void, String> newValueMap = new HashMap<void, String>();
            if (!org.springframework.util.StringUtils.isEmpty(map)) {
                for (String string : map.keySet()) {
                    void var15_83;
                    String string35 = "";
                    if (string.contains("open") && Boolean.compare(map.get(string), menuOptionsValue.get(string) == false) == 0) {
                        String string36 = "Open";
                        keys2.add(string36);
                    } else if (string.contains("view") && Boolean.compare(map.get(string), menuOptionsValue.get(string) == false) == 0) {
                        String string37 = "View";
                        keys2.add(string37);
                    } else if (string.contains("versions") && Boolean.compare(map.get(string), menuOptionsValue.get(string) == false) == 0) {
                        String string38 = "Versions";
                        keys2.add(string38);
                    } else if (string.contains("share") && Boolean.compare(map.get(string), menuOptionsValue.get(string) == false) == 0) {
                        String string39 = "Share";
                        keys2.add(string39);
                    } else if (string.contains("download") && Boolean.compare(map.get(string), menuOptionsValue.get(string) == false) == 0) {
                        String string40 = "Download";
                        keys2.add(string40);
                    } else if (string.contains("restore") && Boolean.compare(map.get(string), menuOptionsValue.get(string) == false) == 0) {
                        String string41 = "Restore";
                        keys2.add(string41);
                    }
                    oldValueMap.put(var15_83, map.get(string) == true ? "Enabled" : "Disabled");
                    newValueMap.put(var15_83, menuOptionsValue.get(string) == true ? "Enabled" : "Disabled");
                }
            }
            int i = 0;
            for (String string : keys2) {
                ++i;
                fieldChangesResponse.append("\"" + string + "\" : ");
                if (oldValueMap.containsKey(string)) {
                    fieldChangesResponse.append("\"" + (String)oldValueMap.get(string));
                } else {
                    fieldChangesResponse.append("\"Disabled");
                }
                if (newValueMap.containsKey(string)) {
                    fieldChangesResponse.append("\" => \"" + (String)newValueMap.get(string) + "\"");
                } else {
                    fieldChangesResponse.append("\" => \"Disabled");
                }
                if (string.length() <= 0 || i >= string.length()) continue;
                fieldChangesResponse.append(", ");
            }
            if (fieldChangesResponse.length() > 0) {
                fieldChangesResponse.replace(fieldChangesResponse.length() - 2, fieldChangesResponse.length(), "");
            }
            fieldChangesResponse.append("] ) ");
        } else if (fieldChangesResponse.length() > 0) {
            fieldChangesResponse.replace(fieldChangesResponse.length() - 1, fieldChangesResponse.length(), " ");
        }
        if (!existingBackupPolicyElement.getEmailsRestriction().equals(backupPolicyElement.getEmailsRestriction())) {
            Map<String, String> existingEmailsRestriction = existingBackupPolicyElement.getEmailsRestriction();
            Map<String, String> map = backupPolicyElement.getEmailsRestriction();
            ArrayList<String> emailKeys = new ArrayList<String>();
            fieldChangesResponse.append(" ( Email Alert Configurations ");
            fieldChangesResponse.append(" Values : [ ");
            emailKeys.add("createUser");
            emailKeys.add("userDeleted");
            emailKeys.add("userBlocked");
            emailKeys.add("deviceDeleted");
            emailKeys.add("deviceBlocked");
            emailKeys.add("deviceDecoupled");
            emailKeys.add("weeklyBkpreport");
            emailKeys.add("firstBkpCompleted");
            emailKeys.add("restoreInitiated");
            emailKeys.add("storageLimitReached");
            emailKeys.add("deviceLimitReached");
            emailKeys.add("userLimitReached");
            emailKeys.add("restoreCompleted");
            HashMap<String, String> oldValues = new HashMap<String, String>();
            HashMap<String, String> newValues = new HashMap<String, String>();
            if (existingEmailsRestriction != null && !existingEmailsRestriction.isEmpty()) {
                for (String string : emailKeys) {
                    ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(existingEmailsRestriction.get(string).split(",")));
                    if (string.equalsIgnoreCase("createUser")) {
                        if (!org.springframework.util.StringUtils.isEmpty((Object)existingEmailsRestriction.get(string))) {
                            if (arrayList.contains("users")) {
                                oldValues.put("User create", "Enabled");
                            } else {
                                oldValues.put("User create", "Disabled");
                            }
                        } else {
                            oldValues.put("User create", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("userDeleted")) {
                        if (!org.springframework.util.StringUtils.isEmpty((Object)existingEmailsRestriction.get(string))) {
                            if (arrayList.contains("users")) {
                                oldValues.put("User deleted", "Enabled");
                            } else {
                                oldValues.put("User deleted", "Disabled");
                            }
                        } else {
                            oldValues.put("User deleted", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("userBlocked")) {
                        if (!org.springframework.util.StringUtils.isEmpty((Object)existingEmailsRestriction.get(string))) {
                            if (arrayList.contains("users")) {
                                oldValues.put("User blocked", "Enabled");
                            } else {
                                oldValues.put("User blocked", "Disabled");
                            }
                        } else {
                            oldValues.put("User blocked", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("deviceDeleted")) {
                        if (!org.springframework.util.StringUtils.isEmpty((Object)existingEmailsRestriction.get(string))) {
                            if (arrayList.contains("users")) {
                                oldValues.put("Device deleted", "Enabled");
                            } else {
                                oldValues.put("Device deleted", "Disabled");
                            }
                        } else {
                            oldValues.put("Device deleted", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("deviceBlocked")) {
                        if (!org.springframework.util.StringUtils.isEmpty((Object)existingEmailsRestriction.get(string))) {
                            if (arrayList.contains("users")) {
                                oldValues.put("Device blocked", "Enabled");
                            } else {
                                oldValues.put("Device blocked", "Disabled");
                            }
                        } else {
                            oldValues.put("Device blocked", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("deviceDecoupled")) {
                        if (!org.springframework.util.StringUtils.isEmpty((Object)existingEmailsRestriction.get(string))) {
                            if (arrayList.contains("users")) {
                                oldValues.put("Device de-couple", "Enabled");
                            } else {
                                oldValues.put("Device de-couple", "Disabled");
                            }
                        } else {
                            oldValues.put("Device de-couple", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("weeklyBkpreport")) {
                        if (!org.springframework.util.StringUtils.isEmpty((Object)existingEmailsRestriction.get(string))) {
                            if (arrayList.contains("users")) {
                                oldValues.put("Weekly backup report", "Enabled");
                            } else {
                                oldValues.put("Weekly backup report", "Disabled");
                            }
                        } else {
                            oldValues.put("Weekly backup report", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("firstBkpCompleted")) {
                        if (!org.springframework.util.StringUtils.isEmpty((Object)existingEmailsRestriction.get(string))) {
                            if (arrayList.contains("users")) {
                                oldValues.put("First backup completed", "Enabled");
                            } else {
                                oldValues.put("First backup completed", "Disabled");
                            }
                        } else {
                            oldValues.put("First backup completed", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("restoreInitiated")) {
                        if (!org.springframework.util.StringUtils.isEmpty((Object)existingEmailsRestriction.get(string))) {
                            if (arrayList.contains("users")) {
                                oldValues.put("Restore initiated", "Enabled");
                            } else {
                                oldValues.put("Restore initiated", "Disabled");
                            }
                        } else {
                            oldValues.put("Restore initiated", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("restoreCompleted")) {
                        if (!org.springframework.util.StringUtils.isEmpty((Object)existingEmailsRestriction.get(string))) {
                            if (arrayList.contains("users")) {
                                oldValues.put("Restore completed", "Enabled");
                            } else {
                                oldValues.put("Restore completed", "Disabled");
                            }
                        } else {
                            oldValues.put("Restore completed", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("storageLimitReached")) {
                        if (!org.springframework.util.StringUtils.isEmpty((Object)existingEmailsRestriction.get(string))) {
                            if (arrayList.contains("users")) {
                                oldValues.put("Storage limit reached", "Enabled");
                            } else {
                                oldValues.put("Storage limit reached", "Disabled");
                            }
                        } else {
                            oldValues.put("Storage limit reached", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("deviceLimitReached")) {
                        if (!org.springframework.util.StringUtils.isEmpty((Object)existingEmailsRestriction.get(string))) {
                            if (arrayList.contains("users")) {
                                oldValues.put("Device limit reached", "Enabled");
                            } else {
                                oldValues.put("Device limit reached", "Disabled");
                            }
                        } else {
                            oldValues.put("Device limit reached", "Disabled");
                        }
                    }
                    if (!string.equalsIgnoreCase("userLimitReached")) continue;
                    if (!org.springframework.util.StringUtils.isEmpty((Object)existingEmailsRestriction.get(string))) {
                        if (arrayList.contains("users")) {
                            oldValues.put("User limit reached", "Enabled");
                            continue;
                        }
                        oldValues.put("User limit reached", "Disabled");
                        continue;
                    }
                    oldValues.put("User limit reached", "Disabled");
                }
            }
            if (map != null && !map.isEmpty()) {
                for (String string : emailKeys) {
                    ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(map.get(string).split(",")));
                    if (string.equalsIgnoreCase("createUser")) {
                        if (!org.springframework.util.StringUtils.isEmpty((Object)map.get(string))) {
                            if (arrayList.contains("users")) {
                                newValues.put("User create", "Enabled");
                            } else {
                                newValues.put("User create", "Disabled");
                            }
                        } else {
                            newValues.put("User create", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("userDeleted")) {
                        if (!org.springframework.util.StringUtils.isEmpty((Object)map.get(string))) {
                            if (arrayList.contains("users")) {
                                newValues.put("User deleted", "Enabled");
                            } else {
                                newValues.put("User deleted", "Disabled");
                            }
                        } else {
                            newValues.put("User deleted", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("userBlocked")) {
                        if (!org.springframework.util.StringUtils.isEmpty((Object)map.get(string))) {
                            if (arrayList.contains("users")) {
                                newValues.put("User blocked", "Enabled");
                            } else {
                                newValues.put("User blocked", "Disabled");
                            }
                        } else {
                            newValues.put("User blocked", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("deviceDeleted")) {
                        if (!org.springframework.util.StringUtils.isEmpty((Object)map.get(string))) {
                            if (arrayList.contains("users")) {
                                newValues.put("Device deleted", "Enabled");
                            } else {
                                newValues.put("Device deleted", "Disabled");
                            }
                        } else {
                            newValues.put("Device deleted", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("deviceBlocked")) {
                        if (!org.springframework.util.StringUtils.isEmpty((Object)map.get(string))) {
                            if (arrayList.contains("users")) {
                                newValues.put("Device blocked", "Enabled");
                            } else {
                                newValues.put("Device blocked", "Disabled");
                            }
                        } else {
                            newValues.put("Device blocked", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("deviceDecoupled")) {
                        if (!org.springframework.util.StringUtils.isEmpty((Object)map.get(string))) {
                            if (arrayList.contains("users")) {
                                newValues.put("Device de-couple", "Enabled");
                            } else {
                                newValues.put("Device de-couple", "Disabled");
                            }
                        } else {
                            newValues.put("Device de-couple", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("weeklyBkpreport")) {
                        if (!org.springframework.util.StringUtils.isEmpty((Object)map.get(string))) {
                            if (arrayList.contains("users")) {
                                newValues.put("Weekly backup report", "Enabled");
                            } else {
                                newValues.put("Weekly backup report", "Disabled");
                            }
                        } else {
                            newValues.put("Weekly backup report", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("firstBkpCompleted")) {
                        if (!org.springframework.util.StringUtils.isEmpty((Object)map.get(string))) {
                            if (arrayList.contains("users")) {
                                newValues.put("First backup completed", "Enabled");
                            } else {
                                newValues.put("First backup completed", "Disabled");
                            }
                        } else {
                            newValues.put("First backup completed", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("restoreInitiated")) {
                        if (!org.springframework.util.StringUtils.isEmpty((Object)map.get(string))) {
                            if (arrayList.contains("users")) {
                                newValues.put("Restore initiated", "Enabled");
                            } else {
                                newValues.put("Restore initiated", "Disabled");
                            }
                        } else {
                            newValues.put("Restore initiated", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("restoreCompleted")) {
                        if (!org.springframework.util.StringUtils.isEmpty((Object)map.get(string))) {
                            if (arrayList.contains("users")) {
                                newValues.put("Restore completed", "Enabled");
                            } else {
                                newValues.put("Restore completed", "Disabled");
                            }
                        } else {
                            newValues.put("Restore completed", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("storageLimitReached")) {
                        if (!org.springframework.util.StringUtils.isEmpty((Object)map.get(string))) {
                            if (arrayList.contains("users")) {
                                newValues.put("Storage limit reached", "Enabled");
                            } else {
                                newValues.put("Storage limit reached", "Disabled");
                            }
                        } else {
                            newValues.put("Storage limit reached", "Disabled");
                        }
                    }
                    if (string.equalsIgnoreCase("deviceLimitReached")) {
                        if (!org.springframework.util.StringUtils.isEmpty((Object)map.get(string))) {
                            if (arrayList.contains("users")) {
                                newValues.put("Device limit reached", "Enabled");
                            } else {
                                newValues.put("Device limit reached", "Disabled");
                            }
                        } else {
                            newValues.put("Devices limit reached", "Disabled");
                        }
                    }
                    if (!string.equalsIgnoreCase("userLimitReached")) continue;
                    if (!org.springframework.util.StringUtils.isEmpty((Object)map.get(string))) {
                        if (arrayList.contains("users")) {
                            newValues.put("User limit reached", "Enabled");
                            continue;
                        }
                        newValues.put("User limit reached", "Disabled");
                        continue;
                    }
                    newValues.put("User limit reached", "Disabled");
                }
            }
            for (String string : oldValues.keySet()) {
                fieldChangesResponse.append("\"" + string + "\" : \"" + (String)oldValues.get(string) + "\"");
                fieldChangesResponse.append("\" => \"" + (String)newValues.get(string));
                fieldChangesResponse.append(", ");
            }
            if (fieldChangesResponse.length() > 0) {
                fieldChangesResponse.replace(fieldChangesResponse.length() - 2, fieldChangesResponse.length(), "");
            }
            fieldChangesResponse.append("\" ] ) ");
        } else if (fieldChangesResponse.length() > 0) {
            fieldChangesResponse.replace(fieldChangesResponse.length() - 1, fieldChangesResponse.length(), " ");
        }
        String responseString = fieldChangesResponse.toString();
        responseString = responseString.replace("true", "Enabled");
        responseString = responseString.replace("false", "Disabled");
        responseString = responseString.replace("null", "");
        return responseString;
    }
}

