/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.helper.response;

import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class PropertyHandler {
    private static Logger logger = LogManager.getLogger(PropertyHandler.class);
    private static PropertyHandler instance = null;
    private Properties props = new Properties();

    private PropertyHandler() {
        try {
            ClassPathResource resource = new ClassPathResource("error-code.properties");
            this.props = PropertiesLoaderUtils.loadProperties((Resource)resource);
        }
        catch (Exception e) {
            logger.trace("Error Loading  Property file ......" + e);
            logger.error("Error Loading  Property file ......" + e.getMessage());
        }
    }

    public static synchronized PropertyHandler getInstance() {
        if (instance == null) {
            instance = new PropertyHandler();
        }
        return instance;
    }

    public String getProperty(String key) {
        if (!this.props.containsKey(key)) {
            return null;
        }
        String value = (String)this.props.get(key);
        return value;
    }
}

