/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.helper.decryption;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.Cipher;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Encryption {
    public static final String ALGORITHM = "RSA";
    private static Logger logger = LogManager.getLogger(Encryption.class);

    public static void generateKey(String privateKey, String publicKey) {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(ALGORITHM);
            keyGen.initialize(16384);
            KeyPair key = keyGen.generateKeyPair();
            File privateKeyFile = new File(privateKey);
            File publicKeyFile = new File(publicKey);
            if (privateKeyFile.getParentFile() != null) {
                privateKeyFile.getParentFile().mkdirs();
            }
            privateKeyFile.createNewFile();
            if (publicKeyFile.getParentFile() != null) {
                publicKeyFile.getParentFile().mkdirs();
            }
            publicKeyFile.createNewFile();
            ObjectOutputStream publicKeyOS = new ObjectOutputStream(new FileOutputStream(publicKeyFile));
            publicKeyOS.writeObject(key.getPublic());
            publicKeyOS.close();
            ObjectOutputStream privateKeyOS = new ObjectOutputStream(new FileOutputStream(privateKeyFile));
            privateKeyOS.writeObject(key.getPrivate());
            privateKeyOS.close();
        }
        catch (Exception e) {
            logger.error(".... exception......" + e.getMessage());
        }
    }

    public static byte[] encrypt(Path fileToEncrypt, PrivateKey key, File encFile) {
        byte[] cipherText = null;
        try {
            byte[] input = Files.readAllBytes(fileToEncrypt);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, key);
            cipher.update(input);
            cipherText = cipher.doFinal();
            System.out.println(new String(cipherText, "UTF8") + "enccccccc");
            FileOutputStream outputStream = new FileOutputStream(encFile);
            outputStream.write(cipherText);
            outputStream.close();
        }
        catch (Exception e) {
            logger.error(".... exception......" + e.getMessage());
        }
        return cipherText;
    }

    public static boolean decrypt(File encryptedFile, PublicKey key, File decryptedFile) {
        boolean result = false;
        byte[] dectyptedText = null;
        try {
            FileInputStream inputStream = new FileInputStream(encryptedFile);
            byte[] inputBytes = new byte[(int)encryptedFile.length()];
            inputStream.read(inputBytes);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, key);
            dectyptedText = cipher.doFinal(inputBytes);
            FileOutputStream outputStream = new FileOutputStream(decryptedFile);
            outputStream.write(dectyptedText);
            inputStream.close();
            outputStream.close();
            result = true;
        }
        catch (Exception ex) {
            logger.error("error to decrypt file" + ex.getMessage());
        }
        return result;
    }
}

