<?php
use \Core\View;
use Helpers\Form;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
                <li><?=$data['subTitle']?></li>
            </ol>
        </div>
        <div class="col-lg-6">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="UserController">
    <span class="hide currentPage"><?='createUserGroup'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11" block-ui="myBlockUI">
            <div class="panel">
                <div class="panel-heading">
                    <h4><?=Language::show('createUserGroup', 'user')?></h4>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <?=
                            Form::open(array(
                                'ng-submit' => '',
                                'class' => 'form-horizontal',
                                'csrf' => $data['csrf_token'],
                                'autocomplete' => 'off',
                                'data-parsley-validate' => true
                            ));
                            ?>
                            <div class="form-group">
                                <label for="groupName" class="col-sm-2 control-label">User Group Name</label>
                                <div class="col-sm-10">
                                    <input type="text" data-parsley-type="alphanum" class="form-control" name="groupName" id="groupName" placeholder="Enter a Name for you user group" required>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="inputPassword3" class="col-sm-2 control-label">Select Users</label>
                                <div class="col-lg-3">
                                    <input type="text" class="form-control" ng-change="getAllUnBlockedUsersForSelectionBySearch(unSelectedUsername)" ng-model="unSelectedUsername" name="unSelectedQueryString" placeholder="Enter a Name">
                                    <ul class="list-group" style="height: 200px;overflow-y: scroll;">
                                        <li class="list-group-item clickAble" ng-click="addToSelectedUsers($index, value.userName == 'anand')" ng-class="{selectedDisabled: value.userName == 'anand'}" style="padding: 5px 10px;" ng-repeat="value in unSelectedUsers track by $index">
                                            <img width="10%" src="{{ value.profilePic }}" />
                                            <span ng-cloak>{{value.userName}}</span>
                                        </li>
                                    </ul>
                                </div>
                                <div class="col-lg-1" align="center"><i class="fa fa-exchange"></i></div>
                                <div class="col-lg-3">
                                    <input type="text" class="form-control" name="selectedQueryString" placeholder="Enter a Name">
                                    <ul class="list-group" style="height: 200px;overflow-y: scroll;">
                                        <li class="list-group-item clickAble" ng-click="addToUnSelectedUsers($index, value.userName == 'anand')" ng-class="{selectedDisabled: value.userName == 'anand'}" style="padding: 5px 10px;" ng-repeat="value in selectedUsers track by $index">
                                            <img width="10%" src="{{ value.profilePic }}" />
                                            <span ng-cloak>{{value.userName}}</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="col-sm-offset-2 col-sm-10">
                                    <button type="submit" class="btn btn-default">Create User Group</button>
                                </div>
                            </div>
                            <?=
                            Form::close();
                            ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="panel">
                <div class="panel-heading">
                    <h4><?=Language::show('List of Groups', 'user')?></h4>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <?php if(!empty($data['groups'])){?>
                                <?php foreach($data['groups'] as $key => $group){ ?>
                                    <ul class="list-group">
                                        <li class="list-group-item">
                                            <span><?=$group->name;?></span>
                                            <a style="margin-top: -3px;" class="deleteGroup<?=md5($group->name)?> clickAble btn btn-small btn-danger pull-right" ng-click="removeUserGroup('<?=$group->name;?>', '<?=md5($group->name)?>')">Remove</a>
                                        </li>
                                    </ul>
                                <?php } ?>
                            <?php }else{ ?>
                                <h3 class="text-center">There are no groups to manage</h3>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>

</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/UserController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>