<?php
use Core\Language;
use Helpers\Assets;
use Helpers\Url;
use Helpers\Form; ?>
<div class="container">
    <div class="row">
        <div class="col-lg-6 col-lg-offset-3" align="center" style="margin-top: -25px;">
            <?php
            Assets::img(array(
                Url::templatePath() . 'images/logo_new.png',
            ));
            ?>
        </div>
    </div>
    <br/><br/><br/>
    <div class="row">
        <div class="col-lg-12">
            <div class="panel panel-default no-box-shadow">
                <div class="panel-heading text-center" style="margin-right: 8%; padding: 25px 7px 15px 15px;"></div>
                <div class="panel-body">
                    <div class="col-lg-6" style="margin-top: -60px;">
                        <img src="<?=Url::templatePath()?>images/portal_login.png" />
                    </div>
                    <div class="col-lg-6" style="margin-top: 10px;">
                        <div class="error" style="display: none; color: #f55753; margin-bottom: 10px;"></div>
                        <?=
                            Form::open(array(
                                'method' => 'post',
                                'class' => 'shareForm',
                                'csrf' => $data['csrf_token'],
                                'autocomplete' => 'off',
                                'data-parsley-validate' => true
                            ));
                        ?>
                        <div class="form-group hide">
                            <label for="cloudName"><?=Language::show('cloudName', 'keywords');?></label>
                            <input type="text" class="form-control" name="cloudName" id="cloudName" required autocomplete="off" value="<?=$data['file']->{'cloud-name'}?>">
                        </div>
                        <div class="form-group hide">
                            <label for="devicePath"><?=Language::show('devicePath', 'keywords');?></label>
                            <input type="text" class="form-control" name="devicePath" id="devicePath" required autocomplete="off" value="<?=$data['file']->{'device-path'}?>">
                        </div>
                        <div class="form-group hide">
                            <label for="filePath"><?=Language::show('filePath', 'keywords');?></label>
                            <input type="text" class="form-control" name="filePath" id="filePath" required autocomplete="off" value="<?=$data['filePath']?>">
                        </div>
                        <div class="form-group hide">
                            <label for="syncRevisionId"><?=Language::show('syncRevisionId', 'keywords');?></label>
                            <input type="text" class="form-control" name="syncRevisionId" id="syncRevisionId" required autocomplete="off" value="<?=$data['syncRevisionId']?>">
                        </div>
                        <div class="form-group hide">
                            <label for="fileSize"><?=Language::show('fileSize', 'keywords');?></label>
                            <input type="text" class="form-control" name="fileSize" id="fileSize" required autocomplete="off" value="<?=$data['fileSize']?>">
                        </div>
                        <div class="form-group hide">
                            <label for="fileName"><?=Language::show('fileName', 'keywords');?></label>
                            <input type="text" class="form-control" name="fileName" id="fileName" required autocomplete="off" value="<?=$data['file']->{'file-name'}?>">
                        </div>
                        <div class="form-group hide">
                            <label for="key12"><?=Language::show('key12', 'keywords');?></label>
                            <input type="text" class="form-control" name="key12" id="key12" required autocomplete="off" value="<?=$data['file']->{'key-12'}?>">
                        </div>
                        <div class="form-group hide">
                            <label for="key14"><?=Language::show('fileName', 'keywords');?></label>
                            <input type="text" class="form-control" name="key14" id="key14" required autocomplete="off" value="<?=$data['file']->{'key-14'}?>">
                        </div>
                        <div class="form-group hide">
                            <label for="key18"><?=Language::show('key18', 'keywords');?></label>
                            <input type="text" class="form-control" name="key18" id="key18" required autocomplete="off" value="<?=$data['file']->{'key-18'}?>">
                        </div>
                        <div class="form-group hide">
                            <label for="key20"><?=Language::show('key20', 'keywords');?></label>
                            <input type="text" class="form-control" name="key20" id="key20" required autocomplete="off" value="<?=$data['file']->{'key-20'}?>">
                        </div>
                        <div class="form-group hide">
                            <label for="passwordHash"><?=Language::show('passwordHash', 'keywords');?></label>
                            <input type="text" class="form-control" name="passwordHash" id="passwordHash" required autocomplete="off" value="<?=$data['file']->{'password-hash'}?>">
                        </div>
                        <div class="form-group hide">
                            <label for="userName"><?=Language::show('userName', 'keywords');?></label>
                            <input type="text" class="form-control" name="userName" id="userName" required autocomplete="off" value="<?=$data['file']->{'user-name'}?>">
                        </div>
                        <?php if($data['file']->{'is-password-protected'} == 'true'){ ?>
                            <div class="form-group">
                                <label for="password"><?=Language::show('password', 'keywords');?></label>
                                <input type="password" class="form-control" name="password" id="password" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('password', 'keywords');?>" required autocomplete="off">
                            </div>
                        <?php } ?>
                        <?php if($data['file']->{'is-download'} == 'true'){ ?>
                            <a type="button" class="download btn btn-primary" onclick="checkAndProceed(true)"><?=Language::show('download', 'share');?></a>
                        <?php } ?>
                        <?php if($data['file']->{'is-view'} == 'true'){ ?>
                            <a type="button" class="view btn btn-primary" onclick="checkAndProceed(false)"><?=Language::show('view', 'share');?></a>
                        <?php } ?>
                        <?php if($_SESSION['loggedIn']){ ?>
                            <a href="<?=DIR?>" class="view btn btn-primary"><?=Language::show('Go To Portal', 'share');?></a>
                        <?php } ?>
                        <?=
                            Form::close();
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal" id="paraviewContainer" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h5 class="modal-title">Loading ...</h5>
                </div>
                <br/><br/>
                <div class="modal-body">
                    <div class="pageContainer" style="display: none;"></div>
                    <div class="pdfContainer" style="display: none;"></div>
                    <div class="excelContainer" style="display: none;"></div>
                    <div class="content" style="display: none;"></div>
                    <div class="imageViewer" style="display: none;"></div>
                    <div class="paraviewLoading" style="margin-top: 15%">
                        <img width="5%" src="<?=Url::templatePath('default/images/gears.gif');?>" />
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary">Save changes</button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function checkAndProceed(type){
        $('.error').hide();
        var password = $('[name="password"]').val();
        var backupID = "<?=$data['backupID']?>"
        <?php if($data['file']->{'is-password-protected'} == 'true'){ ?>
            if(password.length <= 0){
                $('.error').html('Password Field cannot be empty');
                $('.error').show();
                return;
            }
        <?php } ?>
        $.ajax({
            url: '<?=DIR?>'+'share/checkPassword',
            method: 'POST',
            data: {password: password, type: type}
        }).success(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                var accessType;
                if(type){
                    accessType = 'download';
                }else{
                    accessType = 'view';
                }
                $.ajax({
                    url: '<?=DIR?>'+'share/checkIfFileShared',
                    method: 'POST',
                    data: {accessType: accessType}
                }).success(function(data){

                    var jData = JSON.parse(data);
                    if(jData.result == 'success'){
                        if(type){
                            if(backupID.length > 0){
                                window.open('<?=BLUKRYPT_URL?>'+'<?=CLOUD_NAME?>'+'/portal/download/files/?fileName=<?=urlencode($data['file']->{'file-name'})?>&filePath='+encodeURIComponent("<?=$data['filePath']?>")+'&token=<?=$_SESSION["token"]?>&userName=<?=$data['file']->{'user-name'}?>'+'&isSync=false'+'&deviceUUID='+'&backupID='+backupID, '_blank');
                            }else{
                                window.open('<?=BLUKRPT_URL_WITHOUT_IP?>'+'<?=CLOUD_NAME?>'+'/sync/portal/download/file/?fileName=<?=urlencode($data['file']->{'file-name'})?>&filePath='+encodeURIComponent("<?=$data['filePath']?>")+'&token=<?=$_SESSION["token"]?>&userName=<?=$data['file']->{'user-name'}?>&syncRevisionId=<?=$data['syncRevisionId']?>&path='+encodeURIComponent("<?=$data['filePath']?>")+'/'+encodeURIComponent("<?=urlencode($data['file']->{'file-name'})?>"), '_blank');
                            }
                        }else{
                            view(password, backupID);
                        }
                    }else{
                        window.location.href = '404';
                    }

                });

            }else if(jData.result == 'fail'){
                $('.error').html(jData.message);
                $('.error').show();
            }
        }).error(function(data){
            console.log(data);
        });
    }

    function view(password, backupID){
        $('#paraviewContainer .modal-title').html('Loading ...');
        $('.content').html('');
        $('.content').hide();
        $('.pageContainer').hide();
        $('.excelContainer').hide();
        $('.pdfContainer').hide();
        $('.imageViewer').hide();
        $('.paraviewLoading').show();

        $('#paraviewContainer').modal('show');
        var url = "";
        if(backupID.length > 0){
            url = '<?=DIR?>backup/share/view';
            isSync = false;
        }else{
            url = '<?=DIR?>share/view';
            isSync = true;
        }

        $.ajax({
            url: url,
            data: {path:'<?=$data['filePath']?>', fileName:'<?=urlencode($data['file']->{'file-name'})?>', syncRevisionId: '<?=$data['syncRevisionId']?>', userName:'<?=$data['file']->{'user-name'}?>', password:password, backupID: backupID, isSync: isSync},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            console.log(jData);
            if(jData.result == 'fail'){
                $('#paraviewContainer').modal('hide');
                $('.error').html(jData.message);
                $('.error').show();
                return;
            }

            if(jData.type == 'image') {

                $('#paraviewContainer .modal-title').html("<?=$data['file']->{'file-name'}?>");
                $('.imageViewer').html(jData.html);
                $('.imageViewer').show();
                $('.paraviewLoading').hide();

            }else if(jData.type == 'pdf') {

                $('#paraviewContainer .modal-title').html("<?=$data['file']->{'file-name'}?>");
                $('.paraviewLoading').hide();
                $('.pdfContainer').html(jData.html);
                $('.pdfContainer').show();

            }else if(jData.type == 'odt') {

                $('#paraviewContainer .modal-title').html("<?=$data['file']->{'file-name'}?>");
                $('.pageContainer').show();
                $('.paraviewLoading').hide();
                viewDoc(jData, 300, 100);

            }else if(jData.type == 'text') {

                $('#paraviewContainer .modal-title').html("<?=$data['file']->{'file-name'}?>");
                $('.content').html(jData.html);
                $('.paraviewLoading').hide();
                $('.content').show();

            }else if(jData.type == 'excel') {

                $('#paraviewContainer .modal-title').html("<?=$data['file']->{'file-name'}?>");
                $('.excelContainer').show();
                $('.paraviewLoading').hide();
                viewExcel(jData);

            }else{

                $('#paraviewContainer .modal-title').html("<?=$data['file']->{'file-name'}?>");
                $('.pageContainer').show();
                $('.paraviewLoading').hide();
                viewDoc(jData, 400, 100);

            }

        }).error(function(data){
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = '<?=DIR?>/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = '<?=DIR?>/serviceDown';
                }, 3000);
            }
        });

    }

    function addAPage(jsonData, pageNumber){
        pageNumber = pageNumber+1;
        $('.pageContainer').append('<div id="page'+pageNumber+'" class="page"></div>');
        $('.page').css(jsonData.pageStyle);
        $('#page'+pageNumber).append('<div class="pageContent"><div class="pageNumber"> Page '+pageNumber+'<br/></div></div>');
        $('.pageContent').css(jsonData.contentStyle);
        return pageNumber;
    }

    function checkHeight(contentHeight, pageNumber) {
        var div = '#page'+pageNumber+' .pageContent';
        var element = document.querySelector(div);
        var _hasScrollBar = false;
        if( (parseInt($(div).outerHeight(true) ) < parseInt(contentHeight))){
            _hasScrollBar = true;
        }
        return _hasScrollBar;
    }

    function viewDoc(jsonData, defaultHeight, minusDefaultSize){
        var pageNumber = 0;
        var pageHeight = parseInt(jsonData.pageStyle.height.replace("px", ""));
        var contentBottom = parseInt(jsonData.contentStyle.bottom.replace("px", ""));
        jsonData.html.forEach(function(row){
            var contentHeight = pageHeight - (contentBottom+defaultHeight);
            if ($('.page').length <= 0 ) {
                pageNumber = addAPage(jsonData, pageNumber);
            }
            if(checkHeight(contentHeight, pageNumber) == false) {
                pageNumber = addAPage(jsonData, pageNumber);
                defaultHeight = defaultHeight - minusDefaultSize;
            }
            $('#page'+pageNumber+' .pageContent').append(row);
        });

    }

    function viewExcel(jsonData){
        var html = '';
        var links = '';
        var htmlData = '';
        jsonData.html.forEach(function(row, key){
            var active = '';
            if(key == 0){
                active = 'active';
            }
            links += '<li role="presentation" class="'+active+'"><a href="#'+row.id+'" id="home-tab" role="tab" data-toggle="tab" aria-controls="home" aria-expanded="true">'+row.sheetName+'</a></li>';
            htmlData += '<div role="tabpanel" class="tab-pane fade '+active+' in" id="'+row.id+'" aria-labelledby="home-tab">'+row.html+'</div>';
        });
        html += '<div class="panel" style="background-color: #fff; padding: 20px 20px; overflow: auto; height: 550px">'+
            '<div class="bs-example bs-example-tabs" role="tabpanel" data-example-id="togglable-tabs">'+
            '<ul id="myTab" class="nav nav-tabs" role="tablist">'+links+'</ul>'+
            '<div id="myTabContent" class="tab-content">'
            +htmlData+
            '</div>'+
            '</div>'+
            '</div>';
        $('.excelContainer').html(html);
    }
</script>