<?php

use \Core\View;
use Helpers\Form;
use \Helpers\Url;
use Helpers\Auth;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='adCredentials'?></span>
            <div class="row">
                <div class="panel adPanel" style="display: none">
                    <div class="panel-heading">
                        <h4 style="padding: 0px 0px 0px 15px;">Active Directory Credentials</h4>
                    </div>
                    <div class="panel-body">
                        <div ng-repeat="value in adcS track by $index" class="col-lg-6 ng-scope block-ui block-ui-anim-fade" block-ui="myBlockUI" aria-busy="false">
                            <div class="panel panel-default no-box-shadow widget-success">
                                <div class="background">
                                    <i class="fa fa-language"></i>
                                </div>
                                <div class="panel-heading widget-header">
                                    <span ng-if="value.userDn.length > 0">
                                        <a>User Domain Name: </a><a class="pull-right">{{ value.userDn }}</a>
                                        <br/>
                                    </span>
                                    <span ng-if="value.adPassword.length > 0">
                                        <a>Active Directory Password: </a><a ng-cloak class="pull-right">**********</a>
                                        <br/>
                                    </span>
                                    <span ng-if="value.adUrl.length > 0">
                                        <a>Active Directory URL: </a><a ng-cloak class="pull-right">{{ value.adUrl }}</a>
                                        <br/>
                                    </span>
                                    <span ng-if="value.adBase.length > 0">
                                        <a>Active Directory Base: </a><a ng-cloak class="pull-right">{{ value.adBase }}</a>
                                        <br/>
                                    </span>
                                    <span ng-if="value.adGroupName.length > 0">
                                        <a>Active Directory Group Name: </a><a ng-cloak class="pull-right">{{ value.adGroupName }}</a>
                                        <br/>
                                    </span>
                                    <span ng-if="value.adProductType.length > 0">
                                        <a>Active Directory Product Type: </a><a ng-cloak class="pull-right">{{ value.adProductType }}</a>
                                        <br/>
                                    </span>
                                    <span ng-if="value.adBase.length > 0">
                                        <a>Active Directory Common Name: </a><a ng-cloak class="pull-right">{{ value.adCn }}</a>
                                        <br/>
                                    </span>
                                </div>
                                <div class="panel-footer">
                                    <a style="margin-top: 5px;" class="btn btn-primary btn-small" ng-click="getAdCredentials($index)">Edit</a>
                                    <a style="margin-top: 5px;" class="btn btn-danger btn-small removeCredentialsBtn{{$index}}" ng-click="removeAdCredentials($index)">Remove</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="panel">
                    <div class="panel-heading">
                        <h4 style="padding: 0px 0px 0px 15px;">Add your Active Directory Credentials</h4>
                    </div>
                    <?= Form::open(array(
                        'ng-submit' => 'saveAdCredentials("createAdCredentials")',
                        'class' => 'createAdCredentials',
                        'csrf' => $data['csrf_token'],
                        'autocomplete' => 'off',
                        'data-parsley-validate' => true
                    )); ?>
                    <div class="panel-body">
                        <div class="form-group col-lg-6">
                            <label for="userDn">User Domain</label>
                            <input type="text" class="form-control" name="userDn" id="userDn" value="" placeholder="Enter your User Domains" required autocomplete="off">
                        </div>
                        <div class="form-group col-lg-6">
                            <label for="adPassword">AD Password</label>
                            <input type="password" class="form-control" name="adPassword" id="adPassword" value="" placeholder="Enter your Active Directory Password" required autocomplete="off">
                        </div>
                        <div class="form-group col-lg-6">
                            <label for="adBase">AD Base</label>
                            <input type="text" class="form-control" name="adBase" id="adBase" value="" placeholder="Enter your Active Directory Base" required autocomplete="off">
                        </div>
                        <div class="form-group col-lg-6">
                            <label for="adCn">AD Common Name</label>
                            <input type="text" class="form-control" name="adCn" id="adCn" value="" placeholder="Enter your Active Directory Common Name" required autocomplete="off">
                        </div>
                        <div class="form-group col-lg-12 adUrl">
                            <label for="adUrl">AD Url</label>
                            <input type="text" class="form-control" name="adUrl" id="adUrl" value="" placeholder="Enter your Active Directory URL" autocomplete="off">
                        </div>
                        <div class="form-group col-lg-6">
                            <?php if(Auth::checkCloudPermission('sync') && Auth::checkCloudPermission('backup')){ ?>
                                <div class="form-group col-lg-6">
                                    <label for="adProductType">AD Product Type</label>
                                    <select class="form-control adProductType selectpicker" name="adProductType" id="adProductType" title='Select Product Type'>
                                        <option value="sync">BluSync</option>
                                        <option value="backup">BluVault</option>
                                    </select>
                                </div>
                            <?php }else{ ?>
                                <?php if(Auth::checkCloudPermission('sync')){ ?>
                                    <div class="form-group col-lg-12 adProductType">
                                        <label for="adProductType">AD Product Type</label>
                                        <input type="text" class="form-control" name="adProductType" id="adProductType" value="sync" autocomplete="off" readonly>
                                    </div>
                                <?php }else{ ?>
                                    <div class="form-group col-lg-12 adProductType">
                                        <label for="adProductType">AD Product Type</label>
                                        <input type="text" class="form-control" name="adProductType" id="adProductType" value="backup" autocomplete="off" readonly>
                                    </div>
                                <?php } ?>
                            <?php } ?>

                        </div>
                        <div class="form-group col-lg-6">
                            <label for="adGroupName">AD Group Name</label>
                            <input type="text" class="form-control" name="adGroupName" id="adGroupName" value="" placeholder="Enter your AD Group Name" autocomplete="off">
                        </div>
                    </div>
                    <div class="panel-footer">
                        <button type="submit" class="btn btn-success createCredentialsBtn">Save</button>
                    </div>
                    <?= Form::close(); ?>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="editAdCredentialsModal" tabindex="-1" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content">
                <?= Form::open(array(
                    'ng-submit' => 'saveAdCredentials("editAdCredentials")',
                    'class' => 'editAdCredentials',
                    'csrf' => $data['csrf_token'],
                    'autocomplete' => 'off',
                    'data-parsley-validate' => true
                )); ?>
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Edit Active Directory Credentials</h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="form-group col-lg-6">
                            <label for="userDn">User Domain</label>
                            <input type="text" class="form-control" name="userDn" id="editUserDn" placeholder="Enter your User Domains" required autocomplete="off" readonly>
                        </div>
                        <div class="form-group col-lg-6">
                            <label for="adPassword">AD Password</label>
                            <input type="password" class="form-control" name="adPassword" id="editAdPassword" placeholder="Enter your Active Directory Password" required autocomplete="off">
                        </div>
                        <div class="form-group col-lg-6">
                            <label for="adBase">AD Base</label>
                            <input type="text" class="form-control" name="adBase" id="editAdBase" placeholder="Enter your Active Directory Base" required autocomplete="off">
                        </div>
                        <div class="form-group col-lg-6">
                            <label for="adCn">AD Common Name</label>
                            <input type="text" class="form-control" name="adCn" id="editAdCn" placeholder="Enter your Active Directory Common Name" required autocomplete="off">
                        </div>
                        <div class="form-group col-lg-12 adUrl">
                            <label for="adUrl">AD Url</label>
                            <input type="text" class="form-control" name="adUrl" id="editAdUrl" placeholder="Enter your Active Directory URL" autocomplete="off">
                        </div>
                        <div class="form-group col-lg-6">
                            <label for="adProductType">AD Product Type</label>
                            <select class="form-control adProductType selectpicker" name="adProductType" id="editAdProductType" title='Select AD Product Type'>
                                <option value="sync">Sync</option>
                                <option value="backup">Backup</option>
                            </select>
                        </div>
                        <div class="form-group col-lg-6">
                            <label for="adGroupName">AD Group Name</label>
                            <input type="text" class="form-control" name="adGroupName" id="editAdGroupName" value="" placeholder="Enter your AD Group Name" autocomplete="off">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success editCredentialsBtn">Save</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
                <?= Form::close(); ?>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>