<?php

namespace Helpers;

/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* Api.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 8/4/15
* @time 11:50 AM
*
*/

class Paginator
{

    /**
     * set the number of items per page.
     *
     * @var numeric
     */
    private $perPage;

    /**
     * set get parameter for fetching the page number
     *
     * @var string
     */
    private $instance;

    /**
     * sets the page number.
     *
     * @var numeric
     */
    private $page;

    /**
     * set the limit for the data source
     *
     * @var string
     */
    private $limit;

    /**
     * set the total number of records/items.
     *
     * @var numeric
     */
    private $totalRows = 0;

    /**
     *  __construct
     *
     *  pass values when class is istantiated
     *
     * @param numeric  $perPage  sets the number of iteems per page
     * @param numeric  $instance sets the instance for the GET parameter
     */
    public function __construct($perPage, $instance)
    {
        $this->instance = $instance;
        $this->perPage = $perPage;
        $this->setInstance();
    }

    /**
     * getStart
     *
     * creates the starting point for limiting the dataset
     * @return numeric
     */
    public function getStart()
    {
        return ($this->page * $this->perPage) - $this->perPage;
    }

    /**
     *
     * getInstance
     *
     * gets the current page number if needed anywhere in your application.
     *
     * @return numeric
     */
    public function getInstance()
    {
        return $this->page;
    }

    /**
     * setInstance
     *
     * sets the instance parameter, if numeric value is 0 then set to 1
     *
     * @var numeric
     */
    private function setInstance()
    {
        $this->page = (int) (!isset($_GET[$this->instance]) ? 1 : $_GET[$this->instance]);
        $this->page = ($this->page == 0 ? 1 : $this->page);
    }

    /**
     * setTotal
     *
     * collect a numeric value and assigns it to the totalRows
     *
     * @var numeric
     */
    public function setTotal($totalRows)
    {
        $this->totalRows = $totalRows;
    }

    /**
     * getLimit
     *
     * returns the limit for the data source, calling the getStart method and passing in the number of items perp page
     *
     * @return string
     */
    public function getLimit()
    {
        return "LIMIT " . $this->getStart() . ", $this->perPage";
    }

    /**
     *
     * getLimit2 and getPerPage are used together
     * when using the Eloquent Query Builder
     * for the skip and take parameters.
     *
     * There are also other ORM's that need the skip and take
     * parameters separated.
     *
     * Example in controller method calling model method:
     *
     * $data['pets'] = $this->pet->getPets($pages->getLimit2(), $pages->getPerPage(), $petSearch);
     *
     * Example model method using Eloquent Query Builder:
     *
     * public function getPets($offset = "", $rowsPerPage = "", $petSearch = "")
     * {
     *     $petsearch = $petsearch . "%";
     *
     *     return Capsule::table('pets')
     *                     ->where('petName', 'like', $petsearch)
     *                     ->orderBy('petName', 'asc')
     *                     ->skip($offset)->take($rowsPerPage)->get();
     * }
     *
     * Also see the file in the helpers folder page_eloq.md for more help.
     *
     * @return numeric
     */
    public function getLimit2()
    {
        return $this->getStart();
    }

    public function getPerPage()
    {
        return $this->perPage;
    }

    /**
     *
     * pageLinks
     *
     * create the html links for navigating through the dataSet
     *
     * @param string $path optionally set the path for the link
     * @param null $ext optionally pass in extra parameters to the GET
     * @return string returns the html menu
     */
    public function pageLinks($path = '?', $ext = null)
    {
        $adjacents = "2";
        $prev = $this->page - 1;
        $next = $this->page + 1;
        $lastPage = ceil($this->totalRows / $this->perPage);
        $lpm1 = $lastPage - 1;

        $pagination = "";
        if ($lastPage > 1) {
            $pagination .= "<nav>";
            $pagination .= "<ul class='pagination'>";
            if ($this->page > 1) {
                $pagination.= "<li><a href='" . $path . "$this->instance=$prev" . "$ext' aria-label='Previous'><span aria-hidden='true'>&laquo;</span></a></li>";
            } else {
                $pagination.= "<li class='disabled'><a href='#' aria-label='Previous'><span aria-hidden='true'>&laquo;</span></a></li>";
            }

            if ($lastPage < 7 + ($adjacents * 2)) {
                for ($counter = 1; $counter <= $lastPage; $counter++) {
                    if ($counter == $this->page) {
                        $pagination.= "<li class='active'><span>$counter</span></li>";
                    } else {
                        $pagination.= "<li><a href='" . $path . "$this->instance=$counter" . "$ext'>$counter</a></li>";
                    }
                }
            } elseif ($lastPage > 5 + ($adjacents * 2)) {
                if ($this->page < 1 + ($adjacents * 2)) {
                    for ($counter = 1; $counter < 4 + ($adjacents * 2); $counter++) {
                        if ($counter == $this->page) {
                            $pagination.= "<li class='active'><span class='sr-only'>$counter</span></li>";
                        } else {
                            $pagination.= "<li><a href='" . $path . "$this->instance=$counter" . "$ext'>$counter</a></li>";
                        }
                    }

                    $pagination.= "<li><span style='border: none; background: none; padding: 8px;'>...</span></li>";
                    $pagination.= "<li><a href='" . $path . "$this->instance=$lpm1" . "$ext'>$lpm1</a></li>";
                    $pagination.= "<li><a href='" . $path . "$this->instance=$lastPage" . "$ext'>$lastPage</a></li>";
                } elseif ($lastPage - ($adjacents * 2) > $this->page && $this->page > ($adjacents * 2)) {
                    $pagination.= "<li><a href='" . $path . "$this->instance=1" . "$ext'>1</a></li>";
                    $pagination.= "<li><a href='" . $path . "$this->instance=2" . "$ext'>2</a></li>";
                    $pagination.= "<li><span style='border: none; background: none; padding: 8px;'>...</span></li>";

                    for ($counter = $this->page - $adjacents; $counter <= $this->page + $adjacents; $counter++) {
                        if ($counter == $this->page) {
                            $pagination.= "<li><span class='active'>$counter</span></li>";
                        } else {
                            $pagination.= "<li><a href='" . $path . "$this->instance=$counter" . "$ext'>$counter</a></li>";
                        }
                    }
                    $pagination.= "<li><span style='border: none; background: none; padding: 8px;'>..</span></li>";
                    $pagination.= "<li><a href='" . $path . "$this->instance=$lpm1" . "$ext'>$lpm1</a></li>";
                    $pagination.= "<li><a href='" . $path . "$this->instance=$lastPage" . "$ext'>$lastPage</a></li>";
                } else {
                    $pagination.= "<li><a href='" . $path . "$this->instance=1" . "$ext'>1</a></li>";
                    $pagination.= "<li><a href='" . $path . "$this->instance=2" . "$ext'>2</a></li>";
                    $pagination.= "<li><span style='border: none; background: none; padding: 8px;'>..</span></li>";

                    for ($counter = $lastPage - (2 + ($adjacents * 2)); $counter <= $lastPage; $counter++) {
                        if ($counter == $this->page) {
                            $pagination.= "<li><span class='active'>$counter</span></li>";
                        } else {
                            $pagination.= "<li><a href='" . $path . "$this->instance=$counter" . "$ext'>$counter</a></li>";
                        }
                    }
                }
            }

            if ($this->page < $counter - 1) {
                $pagination.= "<li><a href='" . $path . "$this->instance=$next" . "$ext' aria-label='Next'><span aria-hidden='true'>&raquo;</span></a></li>";
            } else {
                $pagination.= "<li class='disabled'><a href='#' aria-label='Next'><span aria-hidden='true'>&raquo;</span></a></li>";
            }
            $pagination.= "</ul>";
            $pagination.= "</nav>\n";
        }

        return $pagination;
    }

}
