/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public class BindMetadataToHeaders
implements Binder {
    private final String metadataPrefix;

    public BindMetadataToHeaders(String metadataPrefix) {
        this.metadataPrefix = (String)Preconditions.checkNotNull((Object)metadataPrefix, (Object)"metadataPrefix");
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkNotNull(request, (Object)"request");
        Preconditions.checkArgument((boolean)(input instanceof Map), (Object)"input must be a non-null java.util.Map!");
        Map metadata = (Map)Map.class.cast(input);
        ImmutableMultimap<String, String> headers = this.toHeaders(metadata);
        return (R)((HttpRequest.Builder)request.toBuilder().replaceHeaders(headers)).build();
    }

    protected void putMetadata(ImmutableMultimap.Builder<String, String> headers, String key, String value) {
        headers.put((Object)key, (Object)value);
    }

    public ImmutableMultimap<String, String> toHeaders(Map<String, String> metadata) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Map.Entry<String, String> keyVal : metadata.entrySet()) {
            String keyInLowercase = keyVal.getKey().toLowerCase();
            if (keyVal.getKey().startsWith(this.metadataPrefix)) {
                this.putMetadata((ImmutableMultimap.Builder<String, String>)builder, keyInLowercase, keyVal.getValue());
                continue;
            }
            this.putMetadata((ImmutableMultimap.Builder<String, String>)builder, String.format("%s%s", this.metadataPrefix, keyInLowercase), keyVal.getValue());
        }
        return builder.build();
    }

    public static abstract class ForRemoval
    extends BindMetadataToHeaders {
        ForRemoval(String metadataPrefix) {
            super(metadataPrefix);
        }

        @Override
        protected void putMetadata(ImmutableMultimap.Builder<String, String> headers, String key, String value) {
            headers.put((Object)String.format("x-remove%s", key.substring(1)), (Object)"ignored");
        }
    }

    public static class BindRemoveObjectMetadataToHeaders
    extends ForRemoval {
        BindRemoveObjectMetadataToHeaders() {
            super("X-Object-Meta-");
        }
    }

    public static class BindRawMetadataToHeaders
    extends BindMetadataToHeaders {
        BindRawMetadataToHeaders() {
            super("");
        }
    }

    public static class BindObjectMetadataToHeaders
    extends BindMetadataToHeaders {
        BindObjectMetadataToHeaders() {
            super("X-Object-Meta-");
        }
    }

    public static class BindRemoveContainerMetadataToHeaders
    extends ForRemoval {
        BindRemoveContainerMetadataToHeaders() {
            super("X-Container-Meta-");
        }
    }

    public static class BindContainerMetadataToHeaders
    extends BindMetadataToHeaders {
        BindContainerMetadataToHeaders() {
            super("X-Container-Meta-");
        }
    }

    public static class BindRemoveAccountMetadataToHeaders
    extends ForRemoval {
        BindRemoveAccountMetadataToHeaders() {
            super("X-Account-Meta-");
        }
    }

    public static class BindAccountMetadataToHeaders
    extends BindMetadataToHeaders {
        BindAccountMetadataToHeaders() {
            super("X-Account-Meta-");
        }
    }
}

